/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.android;

import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.AndroidException;
import com.huawei.hms.android.HwBuildEx;
import com.huawei.hms.support.log.HMSLog;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;

public class SystemUtils {
    public static final String UNKNOWN = "unknown";

    public static boolean isChinaROM() {
        String string2 = SystemUtils.b();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return "cn".equalsIgnoreCase(string2);
        }
        string2 = SystemUtils.a();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2.toLowerCase(Locale.US).contains("cn");
        }
        string2 = SystemUtils.getLocalCountry();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return "cn".equalsIgnoreCase(string2);
        }
        return false;
    }

    private static String b() {
        return SystemUtils.getSystemProperties("ro.product.locale.region", "");
    }

    private static String a() {
        return SystemUtils.getSystemProperties("ro.product.locale", "");
    }

    public static String getLocalCountry() {
        String string2 = "";
        Locale locale = Locale.getDefault();
        if (locale != null) {
            string2 = locale.getCountry();
        }
        return string2;
    }

    public static String getSystemProperties(String string2, String string3) {
        Class<?> clazz = Class.forName("android.os.SystemProperties");
        Class[] classArray = new Class[2];
        classArray[0] = String.class;
        try {
            classArray[1] = String.class;
            return (String)clazz.getDeclaredMethod("get", classArray).invoke(clazz, string2, string3);
        }
        catch (ClassCastException classCastException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        HMSLog.e("SystemUtils", "An exception occurred while reading: getSystemProperties:" + string2);
        return string3;
    }

    public static String getNetType(Context context) {
        String string2 = "";
        if (context != null && (context = (ConnectivityManager)context.getSystemService("connectivity")) != null && (context = context.getActiveNetworkInfo()) != null && context.isAvailable()) {
            string2 = context.getTypeName();
        }
        return string2;
    }

    public static boolean isEMUI() {
        StringBuilder stringBuilder = new StringBuilder().append("is Emui :");
        int n10 = HwBuildEx.VERSION.EMUI_SDK_INT;
        HMSLog.i("SystemUtils", stringBuilder.append(n10).toString());
        return n10 > 0;
    }

    public static boolean isSystemApp(Context context, String string2) {
        Context context2 = context;
        context = null;
        try {
            context = context2.getPackageManager().getPackageInfo(string2, 16384);
        }
        catch (RuntimeException runtimeException) {
            HMSLog.e("SystemUtils", "isSystemApp RuntimeException:" + runtimeException);
        }
        catch (AndroidException androidException) {
            HMSLog.e("SystemUtils", "isSystemApp Exception: " + (Object)((Object)androidException));
        }
        return context != null && (context.applicationInfo.flags & 1) > 0;
    }

    public static boolean isTVDevice() {
        return SystemUtils.getSystemProperties("ro.build.characteristics", "default").equalsIgnoreCase("tv");
    }

    public static String getPhoneModel() {
        return SystemUtils.getSystemProperties("ro.product.model", UNKNOWN);
    }

    public static String getAndoridVersion() {
        return SystemUtils.getSystemProperties("ro.build.version.release", UNKNOWN);
    }

    public static String getManufacturer() {
        return SystemUtils.getSystemProperties("ro.product.manufacturer", UNKNOWN);
    }

    public static long getMegabyte(double d10) {
        if (Build.VERSION.SDK_INT > 25) {
            return (long)(d10 * 1000.0 * 1000.0);
        }
        return (long)(d10 * 1024.0 * 1024.0);
    }
}

