/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Build;
import android.util.AndroidException;
import com.huawei.hms.android.HwBuildEx;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.support.common.ActivityMgr;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.Checker;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.PackageManagerHelper;
import com.huawei.hms.utils.ReadApkFileUtil;

public abstract class HuaweiMobileServicesUtil {
    private static final String TAG = "HuaweiMobileServicesUtil";
    public static final String HMS_ERROR_DIALOG = "HuaweiMobileServicesErrorDialog";
    private static final int HMS_VERSION_CODE_NOMDM = 20500000;

    public static int isHuaweiMobileServicesAvailable(Context object, int n10) {
        PackageManagerHelper packageManagerHelper;
        Checker.checkNonNull(object, "context must not be null.");
        if (Build.VERSION.SDK_INT < 16) {
            return 21;
        }
        if (HMSPackageManager.getInstance(object).isUseOldCertificate()) {
            HMSLog.e(TAG, "The CP uses the old certificate to terminate the connection.");
            return 13;
        }
        Context context = object;
        Object object2 = packageManagerHelper;
        packageManagerHelper = new PackageManagerHelper((Context)object);
        String string2 = HMSPackageManager.getInstance(context).getHMSPackageNameForMultiService();
        HMSLog.i(TAG, "hmsPackageName is " + string2);
        PackageManagerHelper.PackageStates packageStates = HMSPackageManager.getInstance(context).getHMSPackageStatesForMultiService();
        PackageManagerHelper.PackageStates packageStates2 = PackageManagerHelper.PackageStates.NOT_INSTALLED;
        if (packageStates2.equals((Object)packageStates)) {
            HMSLog.i(TAG, "HMS is not installed");
            return 1;
        }
        String string3 = ReadApkFileUtil.getHmsPath(object);
        if (HwBuildEx.VERSION.EMUI_SDK_INT < 5 && ((PackageManagerHelper)object2).getPackageVersionCode(string2) < 20500000 && ReadApkFileUtil.isCertFound(string3)) {
            object = ((PackageManagerHelper)object2).getPackageSignature(string2);
            if (!("B92825C2BD5D6D6D1E7F39EECD17843B7D9016F611136B75441BC6F4D3F00F05".equalsIgnoreCase((String)object) || "3517262215D8D3008CBF888750B6418EDC4D562AC33ED6874E0D73ABA667BC3C".equalsIgnoreCase((String)object) || "3517262215D8D3008CBF888750B6418EDC4D562AC33ED6874E0D73ABA667BC3C".equalsIgnoreCase((String)object))) {
                return 9;
            }
            return 2;
        }
        if (PackageManagerHelper.PackageStates.SPOOF.equals((Object)packageStates)) {
            HMSLog.i(TAG, "HMS is spoofed");
            return 9;
        }
        if (PackageManagerHelper.PackageStates.DISABLED.equals((Object)packageStates)) {
            HMSLog.i(TAG, "HMS is disabled");
            return 3;
        }
        if (packageStates2.equals((Object)packageStates) && !"B92825C2BD5D6D6D1E7F39EECD17843B7D9016F611136B75441BC6F4D3F00F05".equalsIgnoreCase((String)(object2 = ((PackageManagerHelper)object2).getPackageSignature(string2))) && !"3517262215D8D3008CBF888750B6418EDC4D562AC33ED6874E0D73ABA667BC3C".equalsIgnoreCase((String)object2) && !"3517262215D8D3008CBF888750B6418EDC4D562AC33ED6874E0D73ABA667BC3C".equalsIgnoreCase((String)object2)) {
            return 9;
        }
        Object object3 = object;
        HMSLog.i(TAG, "connect versionCode:" + HMSPackageManager.getInstance(object3).getHmsMultiServiceVersion());
        if (HMSPackageManager.getInstance(object3).isApkUpdateNecessary(n10)) {
            HMSLog.i(TAG, "The current version does not meet the minimum version requirements");
            return 2;
        }
        return 0;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(HMSPackageManager.getInstance(context).getHMSPackageName());
        }
        catch (AndroidException androidException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            Context context2 = context;
            return context2.createPackageContext(HMSPackageManager.getInstance(context2).getHMSPackageName(), 2);
        }
        catch (AndroidException androidException) {
            return null;
        }
    }

    public static Dialog getErrorDialog(int n10, Activity activity, int n11) {
        return HuaweiApiAvailability.getInstance().getErrorDialog(activity, n10, n11, null);
    }

    public static Dialog getErrorDialog(int n10, Activity activity, int n11, DialogInterface.OnCancelListener onCancelListener) {
        return HuaweiApiAvailability.getInstance().getErrorDialog(activity, n10, n11, onCancelListener);
    }

    public static String getErrorString(int n10) {
        return HuaweiApiAvailability.getInstance().getErrorString(n10);
    }

    public static int isHuaweiMobileServicesAvailable(Context context) {
        return HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable(context);
    }

    public static boolean isUserRecoverableError(int n10) {
        return HuaweiApiAvailability.getInstance().isUserResolvableError(n10);
    }

    public static boolean popupErrDlgFragment(int n10, Activity activity, int n11, DialogInterface.OnCancelListener onCancelListener) {
        return HuaweiApiAvailability.getInstance().showErrorDialogFragment(activity, n10, n11, onCancelListener);
    }

    public static boolean popupErrDlgFragment(int n10, Activity activity, Fragment fragment, int n11, DialogInterface.OnCancelListener onCancelListener) {
        return HuaweiApiAvailability.getInstance().showErrorDialogFragment(activity, n10, fragment, n11, onCancelListener);
    }

    public static boolean showErrorDialogFragment(int n10, Activity activity, int n11) {
        return HuaweiApiAvailability.getInstance().showErrorDialogFragment(activity, n10, n11, null);
    }

    public static void showErrorNotification(int n10, Context context) {
        HuaweiApiAvailability.getInstance().showErrorNotification(context, n10);
    }

    public static void setApplication(Application application) {
        ActivityMgr.INST.init(application);
    }

    @Deprecated
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        return "";
    }
}

