/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.KeyEvent;
import com.huawei.hms.activity.IBridgeActivityDelegate;
import com.huawei.hms.activity.internal.BusResponseCallback;
import com.huawei.hms.activity.internal.ForegroundBusResponseMgr;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.IntentUtil;
import java.lang.ref.WeakReference;

public class ResolutionDelegate
implements IBridgeActivityDelegate {
    public static final String CALLBACK_METHOD = "CALLBACK_METHOD";
    private static final String TAG = "ResolutionDelegate";
    private static final int REQUEST_CODE = 1002;
    private WeakReference<Activity> mThisWeakRef;

    private void finishBridgeActivity() {
        if ((this = this.getActivity()) != null && !this.isFinishing()) {
            this.finish();
            return;
        }
    }

    private Activity getActivity() {
        WeakReference<Activity> weakReference = ((ResolutionDelegate)((Object)weakReference)).mThisWeakRef;
        if (weakReference == null) {
            return null;
        }
        return (Activity)weakReference.get();
    }

    private BusResponseCallback getResponseCallback(String string2) {
        return ForegroundBusResponseMgr.getInstance().get(string2);
    }

    @Override
    public void onBridgeActivityCreate(Activity activity) {
        resolutionDelegate.mThisWeakRef = new WeakReference<Activity>(activity);
        ResolutionDelegate resolutionDelegate = null;
        try {
            resolutionDelegate = activity.getIntent().getExtras();
        }
        catch (Exception exception) {
            HMSLog.e(TAG, "getExtras exception:" + exception.getMessage());
        }
        if (resolutionDelegate != null) {
            activity.startActivityForResult(IntentUtil.modifyIntentBehaviorsSafe((Intent)resolutionDelegate.getParcelable("resolution")), 1002);
        }
    }

    @Override
    public void onBridgeActivityDestroy() {
        this.mThisWeakRef = null;
    }

    @Override
    public boolean onBridgeActivityResult(int n10, int n11, Intent intent) {
        if (n10 != this.getRequestCode()) {
            return false;
        }
        ResolutionDelegate resolutionDelegate = this;
        BusResponseCallback busResponseCallback = resolutionDelegate.getResponseCallback(CALLBACK_METHOD);
        int n12 = HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable((Context)((Activity)resolutionDelegate.mThisWeakRef.get()), 30000000);
        if (n11 == -1 && n12 == 0) {
            HMSLog.i(TAG, "Make service available success.");
        } else {
            busResponseCallback.innerError((Activity)this.mThisWeakRef.get(), n11, "Make service available failed.");
        }
        this.finishBridgeActivity();
        return true;
    }

    @Override
    public void onBridgeConfigurationChanged() {
    }

    @Override
    public int getRequestCode() {
        return 1002;
    }

    @Override
    public void onKeyUp(int n10, KeyEvent keyEvent) {
    }
}

