/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.common.data.DataHolderBuilderCreator;
import com.huawei.hms.common.data.DataHolderCreator;
import com.huawei.hms.common.internal.Preconditions;
import com.huawei.hms.common.internal.safeparcel.AbstractSafeParcelable;
import com.huawei.hms.common.internal.safeparcel.SafeParcelWriter;
import com.huawei.hms.common.sqlite.HMSCursorWrapper;
import com.huawei.hms.support.log.HMSLog;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    private static final String TAG = "DataHolder";
    public static final Parcelable.Creator<DataHolder> CREATOR = new DataHolderCreator();
    public static final String TYPE_INT = "type_int";
    public static final String TYPE_LONG = "type_long";
    public static final String TYPE_STRING = "type_string";
    public static final String TYPE_BOOLEAN = "type_boolean";
    public static final String TYPE_FLOAT = "type_float";
    public static final String TYPE_DOUBLE = "type_double";
    public static final String TYPE_BYTE_ARRAY = "type_byte_array";
    private static final Builder BUILDER = new DataHolderBuilderCreator(new String[0], null);
    private boolean mClosed;
    private int version;
    private String[] columns;
    private Bundle columnsBundle;
    private CursorWindow[] cursorWindows;
    private int statusCode;
    private Bundle metadata;
    private int[] perCursorCounts;
    private int dataCount;
    private boolean isInstance;

    public DataHolder(int n10, String[] stringArray, CursorWindow[] cursorWindowArray, int n11, Bundle bundle) {
        DataHolder dataHolder = this;
        dataHolder.mClosed = false;
        dataHolder.isInstance = true;
        dataHolder.version = n10;
        dataHolder.columns = stringArray;
        dataHolder.cursorWindows = cursorWindowArray;
        dataHolder.statusCode = n11;
        dataHolder.metadata = bundle;
        dataHolder.collectColumsAndCount();
    }

    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n10, Bundle bundle) {
        Preconditions.checkNotNull(stringArray, "columnsP cannot be null");
        Preconditions.checkNotNull(cursorWindowArray, "cursorWindowP cannot be null");
        this.mClosed = false;
        this.isInstance = true;
        this.version = 1;
        this.columns = stringArray;
        this.cursorWindows = cursorWindowArray;
        this.statusCode = n10;
        this.metadata = bundle;
        this.collectColumsAndCount();
    }

    private DataHolder(HMSCursorWrapper hMSCursorWrapper, int n10, Bundle bundle) {
        String[] stringArray = stringArray2;
        HMSCursorWrapper hMSCursorWrapper2 = hMSCursorWrapper;
        String[] stringArray2 = hMSCursorWrapper2.getColumnNames();
        super(stringArray2, DataHolder.getCursorWindows(hMSCursorWrapper2), n10, bundle);
    }

    public DataHolder(Cursor cursor, int n10, Bundle bundle) {
        HMSCursorWrapper hMSCursorWrapper;
        DataHolder dataHolder = object;
        Object object = hMSCursorWrapper;
        hMSCursorWrapper = new HMSCursorWrapper(cursor);
        dataHolder((HMSCursorWrapper)((Object)object), n10, bundle);
    }

    private DataHolder(Builder builder, int n10, Bundle bundle) {
        String[] stringArray = stringArray2;
        Builder builder2 = builder;
        String[] stringArray2 = builder2.a;
        super(stringArray2, DataHolder.getCursorWindows(builder2, -1), n10, null);
    }

    private DataHolder(Builder builder, int n10, Bundle bundle, int n11) {
        String[] stringArray = stringArray2;
        Builder builder2 = builder;
        String[] stringArray2 = builder2.a;
        super(stringArray2, DataHolder.getCursorWindows(builder2, -1), n10, bundle);
    }

    private static CursorWindow[] getCursorWindows(HMSCursorWrapper hMSCursorWrapper) {
        int n10;
        int n11;
        ArrayList<CursorWindow> arrayList;
        block10: {
            ArrayList<CursorWindow> arrayList2;
            HMSCursorWrapper hMSCursorWrapper2 = hMSCursorWrapper;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<CursorWindow>();
            n11 = 0;
            try {
                n10 = hMSCursorWrapper2.getCount();
            }
            catch (Throwable throwable) {
                CursorWindow[] cursorWindowArray;
                try {
                    HMSLog.e(TAG, "fail to getCursorWindows: " + throwable.getMessage());
                    cursorWindowArray = new CursorWindow[]{};
                }
                catch (Throwable throwable2) {
                    hMSCursorWrapper.close();
                    throw throwable2;
                }
                hMSCursorWrapper.close();
                return cursorWindowArray;
            }
            CursorWindow cursorWindow = hMSCursorWrapper2.getWindow();
            if (cursorWindow == null) break block10;
            if (cursorWindow.getStartPosition() != 0) break block10;
            CursorWindow cursorWindow2 = cursorWindow;
            cursorWindow.acquireReference();
            hMSCursorWrapper.setWindow(null);
            arrayList.add(cursorWindow);
            n11 = cursorWindow2.getNumRows();
        }
        ArrayList<CursorWindow> arrayList3 = arrayList;
        ArrayList<CursorWindow> arrayList4 = arrayList3;
        ArrayList<CursorWindow> arrayList5 = arrayList3;
        arrayList3.addAll(DataHolder.iterCursorWrapper(hMSCursorWrapper, n11, n10));
        CursorWindow[] cursorWindowArray = arrayList4.toArray(new CursorWindow[arrayList5.size()]);
        hMSCursorWrapper.close();
        return cursorWindowArray;
    }

    private static ArrayList<CursorWindow> iterCursorWrapper(HMSCursorWrapper hMSCursorWrapper, int n10, int n11) {
        ArrayList<CursorWindow> arrayList;
        ArrayList<CursorWindow> arrayList2 = arrayList;
        arrayList = new ArrayList<CursorWindow>();
        while (n10 < n11 && hMSCursorWrapper.moveToPosition(n10)) {
            CursorWindow cursorWindow = hMSCursorWrapper.getWindow();
            if (cursorWindow == null) {
                CursorWindow cursorWindow2;
                cursorWindow = cursorWindow2;
                new CursorWindow(null).setStartPosition(n10);
                hMSCursorWrapper.fillWindow(n10, cursorWindow);
            } else {
                cursorWindow.acquireReference();
                hMSCursorWrapper.setWindow(null);
            }
            if (cursorWindow.getNumRows() == 0) break;
            arrayList2.add(cursorWindow);
            n10 = cursorWindow.getNumRows() + cursorWindow.getStartPosition();
        }
        return arrayList2;
    }

    private static CursorWindow[] getCursorWindows(Builder builder, int n10) {
        if (builder.a.length == 0) {
            return new CursorWindow[0];
        }
        if (n10 < 0 || n10 >= builder.b.size()) {
            n10 = builder.b.size();
        }
        ArrayList<CursorWindow> arrayList = DataHolder.iterCursorWindow(builder, n10, builder.b.subList(0, n10));
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ArrayList<CursorWindow> iterCursorWindow(Builder builder, int n10, List list) {
        CursorWindow cursorWindow;
        ArrayList<CursorWindow> arrayList;
        ArrayList<CursorWindow> arrayList2 = arrayList;
        arrayList = new ArrayList<CursorWindow>();
        CursorWindow cursorWindow2 = cursorWindow;
        cursorWindow2(null);
        cursorWindow.setNumColumns(builder.a.length);
        arrayList.add(cursorWindow);
        for (int n11 = 0; n11 < n10; ++n11) {
            CursorWindow cursorWindow3;
            block12: {
                CursorWindow cursorWindow4;
                if (cursorWindow2.allocRow()) break block12;
                HMSLog.d(TAG, "Failed to allocate a row");
                cursorWindow2 = cursorWindow4;
                cursorWindow2(null);
                cursorWindow2.setStartPosition(n11);
                cursorWindow4.setNumColumns(builder.a.length);
                if (!cursorWindow4.allocRow()) {
                    HMSLog.e(TAG, "Failed to retry to allocate a row");
                    return arrayList2;
                }
                arrayList2.add(cursorWindow2);
            }
            try {
                HashMap hashMap = (HashMap)list.get(n11);
                boolean bl = true;
                for (int i10 = 0; i10 < builder.a.length && (bl = DataHolder.putValue(cursorWindow2, hashMap.get(builder.a[i10]), n11, i10)); ++i10) {
                }
                if (bl) continue;
            }
            catch (RuntimeException runtimeException) {
                Iterator<CursorWindow> iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    iterator.next().close();
                }
                throw runtimeException;
            }
            HMSLog.d(TAG, "fail to put data for row " + n11);
            cursorWindow2.freeLastRow();
            CursorWindow cursorWindow5 = cursorWindow3;
            cursorWindow5(null);
            cursorWindow5.setStartPosition(n11);
            cursorWindow3.setNumColumns(builder.a.length);
            arrayList2.add(cursorWindow3);
            break;
        }
        return arrayList2;
    }

    private static boolean putValue(CursorWindow cursorWindow, Object object, int n10, int n11) throws IllegalArgumentException {
        if (object == null) {
            return cursorWindow.putNull(n10, n11);
        }
        if (object instanceof Boolean) {
            long l10 = (Boolean)object != false ? 1L : 0L;
            return cursorWindow.putLong(l10, n10, n11);
        }
        if (object instanceof Integer) {
            return cursorWindow.putLong((long)((Integer)object).intValue(), n10, n11);
        }
        if (object instanceof Long) {
            return cursorWindow.putLong(((Long)object).longValue(), n10, n11);
        }
        if (object instanceof Float) {
            return cursorWindow.putDouble((double)((Float)object).floatValue(), n10, n11);
        }
        if (object instanceof Double) {
            return cursorWindow.putDouble(((Double)object).doubleValue(), n10, n11);
        }
        if (object instanceof String) {
            return cursorWindow.putString((String)object, n10, n11);
        }
        if (object instanceof byte[]) {
            return cursorWindow.putBlob((byte[])object, n10, n11);
        }
        throw new IllegalArgumentException("unsupported type for column: " + object);
    }

    private void checkAvailable(String string2, int n10) {
        String string3 = "";
        Bundle bundle = this.columnsBundle;
        if (bundle != null && bundle.containsKey(string2)) {
            if (this.isClosed()) {
                string3 = "buffer has been closed";
            } else if (n10 < 0 || n10 >= this.dataCount) {
                string3 = "row is out of index:" + n10;
            }
        } else {
            string3 = "cannot find column: " + string2;
        }
        Preconditions.checkArgument(string3.isEmpty(), string3);
    }

    public static Builder builder(String[] stringArray) {
        return new Builder(stringArray, null, null);
    }

    public static DataHolder empty(int n10) {
        return new DataHolder(BUILDER, n10, null);
    }

    public /* synthetic */ DataHolder(Builder builder, int n10, Bundle bundle, 1 var4_4) {
        this(builder, n10, bundle);
    }

    public /* synthetic */ DataHolder(Builder builder, int n10, Bundle bundle, int n11, 1 var5_5) {
        this(builder, n10, bundle, n11);
    }

    public final void collectColumsAndCount() {
        String[] stringArray;
        DataHolder dataHolder = this;
        String[] stringArray2 = stringArray;
        stringArray = new Bundle();
        dataHolder.columnsBundle = stringArray2;
        stringArray2 = dataHolder.columns;
        if (dataHolder.columns != null && stringArray2.length != 0) {
            String[] stringArray3;
            int n10 = 0;
            while (true) {
                stringArray3 = this.columns;
                if (n10 >= this.columns.length) break;
                this.columnsBundle.putInt(stringArray3[n10], n10);
                ++n10;
            }
            n10 = 0;
            stringArray3 = this.cursorWindows;
            if (this.cursorWindows != null && stringArray3.length != 0) {
                this.perCursorCounts = new int[stringArray3.length];
                int n11 = 0;
                while (true) {
                    CursorWindow[] cursorWindowArray = this.cursorWindows;
                    if (n11 >= this.cursorWindows.length) break;
                    this.perCursorCounts[n11] = n10;
                    n10 = cursorWindowArray[n11].getStartPosition() + this.cursorWindows[n11].getNumRows();
                    ++n11;
                }
                this.dataCount = n10;
                return;
            }
            this.dataCount = 0;
            return;
        }
        this.dataCount = 0;
    }

    public final void writeToParcel(Parcel parcel, int n10) {
        Parcel parcel2 = parcel;
        int n11 = SafeParcelWriter.beginObjectHeader(parcel);
        SafeParcelWriter.writeStringArray(parcel, 1, this.columns, false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel, (int)2, (Parcelable[])this.cursorWindows, (int)n10, (boolean)false);
        SafeParcelWriter.writeInt(parcel, 3, this.getStatusCode());
        SafeParcelWriter.writeBundle(parcel, 4, this.getMetadata(), false);
        SafeParcelWriter.writeInt(parcel2, 1000, this.version);
        SafeParcelWriter.finishObjectHeader(parcel2, n11);
        if ((n10 & 1) != 0) {
            this.close();
        }
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final Bundle getMetadata() {
        return this.metadata;
    }

    public final boolean hasColumn(String string2) {
        return this.columnsBundle.containsKey(string2);
    }

    public final Object getValue(String string2, int n10, int n11, String string3) {
        String string4 = string3;
        string4.hashCode();
        string4.hashCode();
        int n12 = -1;
        switch (string4.hashCode()) {
            default: {
                break;
            }
            case 1300508295: {
                if (!string3.equals(TYPE_BYTE_ARRAY)) break;
                n12 = 6;
                break;
            }
            case 878975158: {
                if (!string3.equals(TYPE_STRING)) break;
                n12 = 5;
                break;
            }
            case 519136353: {
                if (!string3.equals(TYPE_LONG)) break;
                n12 = 4;
                break;
            }
            case 445002870: {
                if (!string3.equals(TYPE_DOUBLE)) break;
                n12 = 3;
                break;
            }
            case -675993238: {
                if (!string3.equals(TYPE_INT)) break;
                n12 = 2;
                break;
            }
            case -870070237: {
                if (!string3.equals(TYPE_BOOLEAN)) break;
                n12 = 1;
                break;
            }
            case -1092271849: {
                if (!string3.equals(TYPE_FLOAT)) break;
                n12 = 0;
            }
        }
        switch (n12) {
            default: {
                return null;
            }
            case 6: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string2, n10);
                return dataHolder.cursorWindows[n11].getBlob(n10, this.columnsBundle.getInt(string2));
            }
            case 5: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string2, n10);
                return dataHolder.cursorWindows[n11].getString(n10, this.columnsBundle.getInt(string2));
            }
            case 4: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string2, n10);
                return dataHolder.cursorWindows[n11].getLong(n10, this.columnsBundle.getInt(string2));
            }
            case 3: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string2, n10);
                return dataHolder.cursorWindows[n11].getDouble(n10, this.columnsBundle.getInt(string2));
            }
            case 2: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string2, n10);
                return dataHolder.cursorWindows[n11].getInt(n10, this.columnsBundle.getInt(string2));
            }
            case 1: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string2, n10);
                return dataHolder.cursorWindows[n11].getLong(n10, this.columnsBundle.getInt(string2)) == 1L;
            }
            case 0: 
        }
        DataHolder dataHolder = this;
        dataHolder.checkAvailable(string2, n10);
        return Float.valueOf(dataHolder.cursorWindows[n11].getFloat(n10, this.columnsBundle.getInt(string2)));
    }

    public final void copyToBuffer(String string2, int n10, int n11, CharArrayBuffer charArrayBuffer) {
        DataHolder dataHolder = this;
        dataHolder.checkAvailable(string2, n10);
        dataHolder.cursorWindows[n11].copyStringToBuffer(n10, this.columnsBundle.getInt(string2), charArrayBuffer);
    }

    public final boolean hasNull(String string2, int n10, int n11) {
        DataHolder dataHolder = this;
        dataHolder.checkAvailable(string2, n10);
        return dataHolder.cursorWindows[n11].getType(n10, this.columnsBundle.getInt(string2)) == 0;
    }

    public final int getCount() {
        return this.dataCount;
    }

    public final int getWindowIndex(int n10) {
        int[] nArray;
        Preconditions.checkArgument(n10 >= 0 || n10 < this.dataCount, "rowIndex is out of index:" + n10);
        int n11 = 0;
        while (true) {
            nArray = this.perCursorCounts;
            if (n11 >= this.perCursorCounts.length) break;
            if (n10 < nArray[n11]) {
                --n11;
                break;
            }
            ++n11;
        }
        if (n11 == nArray.length) {
            --n11;
        }
        return n11;
    }

    public final synchronized boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public final synchronized void close() {
        if (!this.mClosed) {
            CursorWindow[] cursorWindowArray = this.cursorWindows;
            int n10 = this.cursorWindows.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                cursorWindowArray[i10].close();
            }
            this.mClosed = true;
        }
    }

    public final void finalize() throws Throwable {
        if (this.isInstance && this.cursorWindows.length > 0 && !this.isClosed()) {
            this.close();
        }
        super.finalize();
    }

    public static class DataHolderException
    extends RuntimeException {
        public DataHolderException(String string2) {
            super(string2);
        }
    }

    public static class Builder {
        private String[] a;
        private final ArrayList<HashMap<String, Object>> b;
        private final String c;
        private final HashMap<Object, Integer> d;

        private Builder(String[] stringArray, String string2) {
            HashMap hashMap;
            ArrayList arrayList;
            Builder builder = object;
            Preconditions.checkNotNull(stringArray, "builderColumnsP cannot be null");
            builder.a = stringArray;
            Object object = arrayList;
            arrayList = new ArrayList();
            builder.b = object;
            builder.c = string2;
            object = hashMap;
            hashMap = new HashMap();
            builder.d = object;
        }

        public Builder(String[] stringArray, String string2, DataHolderBuilderCreator dataHolderBuilderCreator) {
            this(stringArray, null);
        }

        public /* synthetic */ Builder(String[] stringArray, String string2, 1 var3_3) {
            this(stringArray, string2);
        }

        public Builder setDataForContentValuesHashMap(HashMap<String, Object> hashMap) {
            Preconditions.checkNotNull(hashMap, "contentValuesHashMap cannot be null");
            int n10 = 0;
            boolean bl = false;
            Object object = this.c;
            if (object != null && (object = hashMap.get(object)) != null) {
                Integer n11 = this.d.get(object);
                if (n11 != null) {
                    n10 = n11;
                    bl = true;
                } else {
                    this.d.put(object, this.b.size());
                }
            }
            if (bl) {
                Builder builder = this;
                builder.b.remove(n10);
                builder.b.add(n10, hashMap);
            } else {
                this.b.add(hashMap);
            }
            return this;
        }

        public Builder withRow(ContentValues object) {
            HashMap<String, Object> hashMap;
            ContentValues contentValues = object;
            Preconditions.checkNotNull(contentValues, "contentValues cannot be null");
            HashMap<String, Object> hashMap2 = hashMap;
            hashMap = new HashMap<String, Object>(object.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                Object k10 = entry.getKey();
                hashMap2.put((String)k10, entry.getValue());
            }
            return this.setDataForContentValuesHashMap(hashMap2);
        }

        public DataHolder build(int n10) {
            return new DataHolder(this, n10, null, null);
        }

        public DataHolder build(int n10, Bundle bundle) {
            return new DataHolder(this, n10, bundle, -1, null);
        }
    }
}

