/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.internal;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.huawei.hms.adapter.AvailableAdapter;
import com.huawei.hms.adapter.BinderAdapter;
import com.huawei.hms.adapter.InnerBinderAdapter;
import com.huawei.hms.adapter.OuterBinderAdapter;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.api.FailedBinderCallBack;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.api.IPCTransport;
import com.huawei.hms.common.HuaweiApi;
import com.huawei.hms.common.internal.ClientSettings;
import com.huawei.hms.common.internal.RequestManager;
import com.huawei.hms.core.aidl.IAIDLInvoke;
import com.huawei.hms.support.api.client.AidlApiClient;
import com.huawei.hms.support.api.client.SubAppInfo;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.Util;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseHmsClient
implements AidlApiClient {
    public static final int TIMEOUT_DISCONNECTED = 6;
    private static final Object i = new Object();
    private static final AtomicInteger j = new AtomicInteger(1);
    private static final AtomicInteger k = new AtomicInteger(1);
    private static BinderAdapter l;
    private static BinderAdapter m;
    private final Context a;
    private String b;
    private final ClientSettings c;
    private volatile IAIDLInvoke d;
    public String sessionId;
    private final ConnectionCallbacks e;
    private final OnConnectionFailedListener f;
    private Handler g = null;
    private HuaweiApi.RequestHandler h;

    public BaseHmsClient(Context context, ClientSettings clientSettings, OnConnectionFailedListener onConnectionFailedListener, ConnectionCallbacks connectionCallbacks) {
        this.a = context;
        this.c = clientSettings;
        this.b = clientSettings.getAppID();
        this.f = onConnectionFailedListener;
        this.e = connectionCallbacks;
    }

    private void a(String string2, String string3) {
        if (this.c.isUseInnerHms()) {
            BaseHmsClient baseHmsClient = this;
            m = InnerBinderAdapter.getInstance(baseHmsClient.a, string3, string2);
            if (baseHmsClient.isConnected()) {
                BaseHmsClient baseHmsClient2 = this;
                HMSLog.i("BaseHmsClient", "The binder is already connected.");
                baseHmsClient2.getAdapter().updateDelayTask();
                baseHmsClient2.connectedInternal(baseHmsClient2.getAdapter().getServiceBinder());
                return;
            }
            this.b(5);
            m.binder(this.c());
            return;
        }
        BaseHmsClient baseHmsClient = this;
        l = OuterBinderAdapter.getInstance(baseHmsClient.a, string3, string2);
        if (baseHmsClient.isConnected()) {
            BaseHmsClient baseHmsClient3 = this;
            HMSLog.i("BaseHmsClient", "The binder is already connected.");
            baseHmsClient3.getAdapter().updateDelayTask();
            baseHmsClient3.connectedInternal(baseHmsClient3.getAdapter().getServiceBinder());
            return;
        }
        this.b(5);
        l.binder(this.c());
    }

    private BinderAdapter.BinderCallBack c() {
        return new BinderAdapter.BinderCallBack(){

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                HMSLog.i("BaseHmsClient", "Enter onServiceConnected.");
                BaseHmsClient.this.connectedInternal(iBinder);
            }

            @Override
            public void onBinderFailed(int n10) {
                this.onBinderFailed(n10, null);
            }

            @Override
            public void onBinderFailed(int n10, Intent intent) {
                if (intent != null) {
                    Activity activity = Util.getActiveActivity(this_.BaseHmsClient.this.getClientSettings().getCpActivity(), this_.BaseHmsClient.this.getContext());
                    if (activity != null) {
                        Intent intent2 = intent;
                        HMSLog.i("BaseHmsClient", "onBinderFailed: SDK try to resolve and reConnect!");
                        long l10 = new Timestamp(System.currentTimeMillis()).getTime();
                        FailedBinderCallBack.getInstance().setCallBack(l10, new FailedBinderCallBack.BinderCallBack(){

                            @Override
                            public void binderCallBack(int n10) {
                                if (n10 != 0) {
                                    1 v02 = this;
                                    v02.BaseHmsClient.this.a(new ConnectionResult(10, null));
                                    BaseHmsClient.a(v02.BaseHmsClient.this, null);
                                }
                            }
                        });
                        intent2.putExtra("callId", l10);
                        activity.startActivity(intent2);
                    } else {
                        1 v12 = this_;
                        HMSLog.i("BaseHmsClient", "onBinderFailed: return pendingIntent to kit and cp");
                        1 this_ = PendingIntent.getActivity((Context)v12.BaseHmsClient.this.a, (int)11, (Intent)intent, (int)0x4000000);
                        v12.BaseHmsClient.this.a(new ConnectionResult(10, (PendingIntent)this_));
                        BaseHmsClient.a(v12.BaseHmsClient.this, null);
                    }
                } else {
                    1 v22 = this_;
                    HMSLog.i("BaseHmsClient", "onBinderFailed: intent is null!");
                    v22.BaseHmsClient.this.a(new ConnectionResult(10, null));
                    BaseHmsClient.a(v22.BaseHmsClient.this, null);
                }
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                1 v02 = this;
                HMSLog.i("BaseHmsClient", "Enter onServiceDisconnected.");
                v02.BaseHmsClient.this.b(1);
                RequestManager.getHandler().sendEmptyMessage(10013);
                if (v02.BaseHmsClient.this.e != null && !(BaseHmsClient.this.e instanceof HuaweiApi.RequestHandler)) {
                    BaseHmsClient.this.e.onConnectionSuspended(1);
                }
            }

            @Override
            public void onNullBinding(ComponentName componentName) {
                1 v02 = this;
                v02.BaseHmsClient.this.b(1);
                v02.BaseHmsClient.this.a(10);
            }

            @Override
            public void onTimedDisconnected() {
                1 v02 = this;
                v02.BaseHmsClient.this.b(6);
                if (v02.BaseHmsClient.this.e != null && !(BaseHmsClient.this.e instanceof HuaweiApi.RequestHandler)) {
                    BaseHmsClient.this.e.onConnectionSuspended(1);
                }
            }
        };
    }

    private void d() {
        HMSLog.w("BaseHmsClient", "Failed to get service as interface, trying to unbind.");
        if (this.c.isUseInnerHms()) {
            BinderAdapter binderAdapter = m;
            if (binderAdapter == null) {
                HMSLog.w("BaseHmsClient", "mInnerBinderAdapter is null.");
                return;
            }
            binderAdapter.unBind();
        } else {
            BinderAdapter binderAdapter = l;
            if (binderAdapter == null) {
                HMSLog.w("BaseHmsClient", "mOuterBinderAdapter is null.");
                return;
            }
            binderAdapter.unBind();
        }
        BaseHmsClient baseHmsClient = this;
        baseHmsClient.b(1);
        baseHmsClient.a(10);
    }

    private void e() {
        Object object;
        if (((BaseHmsClient)object).c.isUseInnerHms()) {
            object = m;
            if (object != null) {
                ((BinderAdapter)object).unBind();
            }
            return;
        }
        object = l;
        if (object != null) {
            ((BinderAdapter)object).unBind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b() {
        Object object = i;
        synchronized (object) {
            Handler handler = this.g;
            if (handler != null) {
                handler.removeMessages(2);
                this.g = null;
            }
            return;
        }
    }

    private void a(int n10, boolean bl) {
        HMSLog.i("BaseHmsClient", "====== HMSSDK version: 60900300 ======");
        int n11 = this.c.isUseInnerHms() ? k.get() : j.get();
        HMSLog.i("BaseHmsClient", "Enter connect, Connection Status: " + n11);
        if (!(bl || n11 != 3 && n11 != 5)) {
            return;
        }
        if (this.getMinApkVersion() > n10) {
            n10 = this.getMinApkVersion();
        }
        HMSLog.i("BaseHmsClient", "connect minVersion:" + n10 + " packageName:" + this.c.getInnerHmsPkg());
        if (this.a.getPackageName().equals(this.c.getInnerHmsPkg())) {
            HMSLog.i("BaseHmsClient", "service packageName is same, bind core service return");
            this.a();
            return;
        }
        if (Util.isAvailableLibExist(this.a)) {
            AvailableAdapter availableAdapter;
            AvailableAdapter availableAdapter2 = availableAdapter;
            availableAdapter2(n10);
            n10 = availableAdapter.isHuaweiMobileServicesAvailable(this.a);
            HMSLog.i("BaseHmsClient", "check available result: " + n10);
            if (n10 == 0) {
                this.a();
            } else if (availableAdapter2.isUserResolvableError(n10)) {
                HMSLog.i("BaseHmsClient", "bindCoreService3.0 fail, start resolution now.");
                this.b(availableAdapter2, n10);
            } else if (availableAdapter2.isUserNoticeError(n10)) {
                HMSLog.i("BaseHmsClient", "bindCoreService3.0 fail, start notice now.");
                this.a(availableAdapter2, n10);
            } else {
                HMSLog.i("BaseHmsClient", "bindCoreService3.0 fail: " + n10 + " is not resolvable.");
                this.a(n10);
            }
        } else {
            n10 = HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable(this.a, n10);
            HMSLog.i("BaseHmsClient", "HuaweiApiAvailability check available result: " + n10);
            if (n10 == 0) {
                this.a();
            } else {
                this.a(n10);
            }
        }
    }

    private void a(AvailableAdapter object, int n10) {
        HMSLog.i("BaseHmsClient", "enter notice");
        if (!baseHmsClient2.getClientSettings().isHasActivity()) {
            if (n10 == 29) {
                n10 = 9;
            }
            BaseHmsClient baseHmsClient = baseHmsClient2;
            BaseHmsClient baseHmsClient2 = HuaweiApiAvailability.getInstance().getErrPendingIntent(baseHmsClient2.a, n10, 0);
            baseHmsClient.a(new ConnectionResult(26, (PendingIntent)baseHmsClient2));
            return;
        }
        Activity activity = Util.getActiveActivity(baseHmsClient2.getClientSettings().getCpActivity(), baseHmsClient2.getContext());
        if (activity != null) {
            AvailableAdapter.AvailableCallBack availableCallBack;
            AvailableAdapter availableAdapter = object;
            object = availableCallBack;
            availableCallBack = new AvailableAdapter.AvailableCallBack(){

                @Override
                public void onComplete(int n10) {
                    BaseHmsClient.this.a(n10);
                }
            };
            availableAdapter.startNotice(activity, (AvailableAdapter.AvailableCallBack)object);
        } else {
            baseHmsClient2.a(26);
        }
    }

    private void b(AvailableAdapter object, int n10) {
        HMSLog.i("BaseHmsClient", "enter HmsCore resolution");
        if (!baseHmsClient2.getClientSettings().isHasActivity()) {
            BaseHmsClient baseHmsClient = baseHmsClient2;
            BaseHmsClient baseHmsClient2 = HuaweiApiAvailability.getInstance().getErrPendingIntent(baseHmsClient2.a, n10, 0);
            baseHmsClient.a(new ConnectionResult(26, (PendingIntent)baseHmsClient2));
            return;
        }
        Activity activity = Util.getActiveActivity(baseHmsClient2.getClientSettings().getCpActivity(), baseHmsClient2.getContext());
        if (activity != null) {
            AvailableAdapter.AvailableCallBack availableCallBack;
            AvailableAdapter availableAdapter = object;
            object = availableCallBack;
            availableCallBack = new AvailableAdapter.AvailableCallBack(){

                @Override
                public void onComplete(int n10) {
                    if (n10 == 0) {
                        BaseHmsClient.this.a();
                    } else {
                        BaseHmsClient.this.a(n10);
                    }
                }
            };
            availableAdapter.startResolution(activity, (AvailableAdapter.AvailableCallBack)object);
        } else {
            baseHmsClient2.a(26);
        }
    }

    private void a(int n10) {
        Message message;
        HMSLog.i("BaseHmsClient", "notifyFailed result: " + n10);
        Message message2 = message;
        new Message().what = 10012;
        new Message().obj = new ConnectionResultWrapper(((BaseHmsClient)object).h, new ConnectionResult(n10));
        RequestManager.getHandler().sendMessage(message2);
        Object object = ((BaseHmsClient)object).f;
        if (object != null && !(object instanceof HuaweiApi.RequestHandler)) {
            ConnectionResult connectionResult;
            Object object2 = object;
            object = connectionResult;
            connectionResult = new ConnectionResult(n10);
            object2.onConnectionFailed((ConnectionResult)object);
        }
    }

    private void a(ConnectionResult connectionResult) {
        Message message;
        BaseHmsClient baseHmsClient = object;
        HMSLog.i("BaseHmsClient", "notifyFailed result: " + connectionResult.getErrorCode());
        Message message2 = message;
        message2();
        message2.what = 10012;
        Object object = ((BaseHmsClient)object).h;
        v2.h = null;
        message.obj = new ConnectionResultWrapper((HuaweiApi.RequestHandler)object, connectionResult);
        RequestManager.getHandler().sendMessage(message2);
        object = baseHmsClient.f;
        if (object != null && !(object instanceof HuaweiApi.RequestHandler)) {
            object.onConnectionFailed(connectionResult);
        }
    }

    public static /* synthetic */ IAIDLInvoke a(BaseHmsClient baseHmsClient, IAIDLInvoke iAIDLInvoke) {
        baseHmsClient.d = iAIDLInvoke;
        return iAIDLInvoke;
    }

    public void onConnecting() {
        this.connectionConnected();
    }

    public final void connectionConnected() {
        BaseHmsClient baseHmsClient = connectionCallbacks;
        baseHmsClient.b(3);
        RequestManager.getHandler().sendEmptyMessage(10011);
        ConnectionCallbacks connectionCallbacks = baseHmsClient.e;
        if (connectionCallbacks != null && !(connectionCallbacks instanceof HuaweiApi.RequestHandler)) {
            connectionCallbacks.onConnected();
        }
    }

    public String getServiceAction() {
        BaseHmsClient baseHmsClient = hMSPackageManager;
        HMSPackageManager hMSPackageManager = HMSPackageManager.getInstance(baseHmsClient.a);
        return baseHmsClient.c.isUseInnerHms() ? hMSPackageManager.getInnerServiceAction() : hMSPackageManager.getServiceAction();
    }

    public void a() {
        BaseHmsClient baseHmsClient = string2;
        String string2 = baseHmsClient.c.getInnerHmsPkg();
        String string3 = baseHmsClient.getServiceAction();
        HMSLog.i("BaseHmsClient", "enter bindCoreService, packageName is " + (String)string2 + ", serviceAction is " + string3);
        baseHmsClient.a(string2, string3);
    }

    public void connectedInternal(IBinder iBinder) {
        this.d = IAIDLInvoke.Stub.asInterface(iBinder);
        if (this.d == null) {
            HMSLog.e("BaseHmsClient", "mService is null, try to unBind.");
            this.d();
            return;
        }
        this.onConnecting();
    }

    @Override
    public String getAppID() {
        return this.b;
    }

    @Override
    public boolean isConnected() {
        return this.c.isUseInnerHms() ? k.get() == 3 : j.get() == 3;
    }

    public int getRequestHmsVersionCode() {
        return this.getMinApkVersion();
    }

    public int getConnectionStatus() {
        return this.c.isUseInnerHms() ? k.get() : j.get();
    }

    public boolean isConnecting() {
        return (this.c.isUseInnerHms() ? k.get() : j.get()) == 5;
    }

    public BinderAdapter getAdapter() {
        HMSLog.i("BaseHmsClient", "getAdapter:isInner:" + this.c.isUseInnerHms() + ", mInnerBinderAdapter:" + m + ", mOuterBinderAdapter:" + l);
        return this.c.isUseInnerHms() ? m : l;
    }

    public void disconnect() {
        int n10 = this.c.isUseInnerHms() ? k.get() : j.get();
        HMSLog.i("BaseHmsClient", "Enter disconnect, Connection Status: " + n10);
        if (n10 != 3) {
            if (n10 == 5) {
                BaseHmsClient baseHmsClient = this;
                baseHmsClient.b();
                baseHmsClient.b(1);
            }
        } else {
            BaseHmsClient baseHmsClient = this;
            baseHmsClient.e();
            baseHmsClient.b(1);
        }
    }

    public void b(int n10) {
        if (this.c.isUseInnerHms()) {
            k.set(n10);
        } else {
            j.set(n10);
        }
    }

    public void connect(int n10) {
        this.a(n10, false);
    }

    public void connect(int n10, boolean bl) {
        this.a(n10, bl);
    }

    @Override
    public IAIDLInvoke getService() {
        return this.d;
    }

    public void setService(IAIDLInvoke iAIDLInvoke) {
        this.d = iAIDLInvoke;
    }

    public final void checkConnected() {
        if (this.isConnected()) {
            return;
        }
        throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Deprecated
    public int getMinApkVersion() {
        return 30000000;
    }

    @Override
    public Context getContext() {
        return this.a;
    }

    @Override
    public SubAppInfo getSubAppInfo() {
        return this.c.getSubAppID();
    }

    @Override
    public String getPackageName() {
        return this.c.getClientPackageName();
    }

    @Override
    public String getCpID() {
        return this.c.getCpID();
    }

    @Override
    public String getTransportName() {
        return IPCTransport.class.getName();
    }

    @Override
    public List<String> getApiNameList() {
        return this.c.getApiName();
    }

    public ClientSettings getClientSettings() {
        return this.c;
    }

    public final void setInternalRequest(HuaweiApi.RequestHandler requestHandler) {
        this.h = requestHandler;
    }

    public static final class ConnectionResultWrapper {
        private HuaweiApi.RequestHandler a;
        private ConnectionResult b;

        public ConnectionResultWrapper(HuaweiApi.RequestHandler requestHandler, ConnectionResult connectionResult) {
            this.a = requestHandler;
            this.b = connectionResult;
        }

        public HuaweiApi.RequestHandler getRequest() {
            return this.a;
        }

        public ConnectionResult getConnectionResult() {
            return this.b;
        }
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;
        public static final int CAUSE_API_CLIENT_EXPIRED = 3;

        public void onConnected();

        public void onConnectionSuspended(int var1);
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }
}

