/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.hms.framework.common.ContextCompat;
import com.huawei.hms.framework.common.EmuiUtil;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.ReflectionUtils;
import com.huawei.libcore.io.ExternalStorageFile;
import com.huawei.libcore.io.ExternalStorageFileInputStream;
import com.huawei.libcore.io.ExternalStorageFileOutputStream;
import com.huawei.libcore.io.ExternalStorageRandomAccessFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CreateFileUtil {
    private static final String TAG = "CreateFileUtil";
    private static final String EXTERNAL_FILE_NAME = "com.huawei.libcore.io.ExternalStorageFile";
    private static final String EXTERNAL_INPUTSTREAM_NAME = "com.huawei.libcore.io.ExternalStorageFileInputStream";
    private static final String EXTERNAL_OUTPUTSTREAM_NAME = "com.huawei.libcore.io.ExternalStorageFileOutputStream";
    private static final String RANDOM_ACCESS_FILE_NAME = "com.huawei.libcore.io.ExternalStorageRandomAccessFile";

    public static String getCacheDirPath(Context context) {
        if (context == null) {
            return "";
        }
        return ContextCompat.getProtectedStorageContext(context).getCacheDir().getPath();
    }

    public static File newFile(String string2) {
        if (string2 == null) {
            return null;
        }
        if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible(EXTERNAL_FILE_NAME)) {
            return new ExternalStorageFile(string2);
        }
        return new File(string2);
    }

    public static String getCanonicalPath(String string2) {
        try {
            string2 = CreateFileUtil.newFile(string2).getCanonicalPath();
        }
        catch (Exception exception) {
            Logger.w(TAG, "the canonicalPath has other Exception", exception);
        }
        catch (SecurityException securityException) {
            Logger.w(TAG, "the canonicalPath has securityException", securityException);
        }
        catch (IOException iOException) {
            Logger.w(TAG, "the canonicalPath has IOException", iOException);
        }
        return string2;
    }

    public static FileInputStream newFileInputStream(String string2) throws FileNotFoundException {
        if (string2 != null) {
            if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible(EXTERNAL_INPUTSTREAM_NAME)) {
                return new ExternalStorageFileInputStream(string2);
            }
            return new FileInputStream(string2);
        }
        Logger.w(TAG, "newFileInputStream  file is null");
        throw new FileNotFoundException("file is null");
    }

    public static FileOutputStream newFileOutputStream(File file) throws FileNotFoundException {
        if (file != null) {
            if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible(EXTERNAL_OUTPUTSTREAM_NAME)) {
                return new ExternalStorageFileOutputStream(file);
            }
            return new FileOutputStream(file);
        }
        Logger.e(TAG, "newFileOutputStream  file is null");
        throw new FileNotFoundException("file is null");
    }

    public static RandomAccessFile newRandomAccessFile(String string2, String string3) throws FileNotFoundException {
        if (string2 != null) {
            if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible(RANDOM_ACCESS_FILE_NAME)) {
                return new ExternalStorageRandomAccessFile(string2, string3);
            }
            return new RandomAccessFile(string2, string3);
        }
        Logger.w(TAG, "newFileOutputStream  file is null");
        throw new FileNotFoundException("file is null");
    }

    public static void deleteSecure(File file) {
        if (file != null && file.exists() && !file.delete()) {
            Logger.w(TAG, "deleteSecure exception");
        }
    }

    public static void deleteSecure(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            CreateFileUtil.deleteSecure(CreateFileUtil.newFile(string2));
        }
    }

    @Deprecated
    public static boolean isPVersion() {
        return EmuiUtil.isUpPVersion();
    }
}

