/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Log;
import com.huawei.hms.framework.common.ExtLogger;
import com.huawei.hms.framework.common.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.IllegalFormatException;
import org.json.JSONException;

public class Logger {
    private static final boolean DEBUG = false;
    private static final String TAG = "NetworkKit_Logger";
    private static final String SPLIT = "|";
    private static final int MAX_STACK_DEEP_LENGTH_NORMAL = 8;
    private static final int MAX_STACK_DEEP_LENGTH = 20;
    private static final String TAG_NETWORKKIT_PRE = "NetworkKit_";
    private static final String TAG_NETWORK_SDK_PRE = "NetworkSdk_";
    private static ExtLogger extLogger;
    private static boolean kitPrint = true;

    public static void setExtLogger(ExtLogger extLogger, boolean bl) {
        Logger.extLogger = extLogger;
        kitPrint = bl;
        Logger.i(TAG, "logger = " + extLogger + bl);
    }

    public static void v(String string2, String string3, Object ... objectArray) {
        Logger.println(2, string2, string3, objectArray);
    }

    public static void v(String string2, Object object) {
        Logger.println(2, string2, object);
    }

    @SuppressLint(value={"LogTagMismatch"})
    public static void d(String string2, Object object) {
        Logger.println(3, string2, object);
    }

    @SuppressLint(value={"LogTagMismatch"})
    public static void d(String string2, String string3, Object ... objectArray) {
        Logger.println(3, string2, string3, objectArray);
    }

    @SuppressLint(value={"LogTagMismatch"})
    public static void i(String string2, Object object) {
        Logger.println(4, string2, object);
    }

    @SuppressLint(value={"LogTagMismatch"})
    public static void i(String string2, String string3, Object ... objectArray) {
        Logger.println(4, string2, string3, objectArray);
    }

    public static void w(String string2, Object object) {
        Logger.println(5, string2, object);
    }

    public static void w(String string2, String string3, Object ... objectArray) {
        Logger.println(5, string2, string3, objectArray);
    }

    public static void w(String string2, String string3, Throwable throwable) {
        if (Logger.isAPPLoggable(5)) {
            String string4 = Logger.complexAppTag(string2);
            String string5 = Logger.complexMsg(string3, 5);
            Throwable throwable2 = Logger.getNewThrowable(throwable);
            extLogger.w(string4, string5, throwable2);
        }
        if (kitPrint) {
            Logger.complexTag(string2);
            Logger.complexMsg(string3, 5);
            Logger.getNewThrowable(throwable);
        }
    }

    public static void e(String string2, Object object) {
        Logger.println(6, string2, object);
    }

    public static void e(String string2, String string3, Object ... objectArray) {
        Logger.println(6, string2, string3, objectArray);
    }

    public static void e(String string2, String string3, Throwable throwable) {
        if (Logger.isAPPLoggable(6)) {
            String string4 = Logger.complexAppTag(string2);
            String string5 = Logger.complexMsg(string3, 5);
            Throwable throwable2 = Logger.getNewThrowable(throwable);
            extLogger.e(string4, string5, throwable2);
        }
        if (kitPrint) {
            String string6 = Logger.complexTag(string2);
            string2 = Logger.complexMsg(string3, 5);
            Log.e((String)string6, (String)string2, (Throwable)Logger.getNewThrowable(throwable));
        }
    }

    private static boolean isKitLoggable(int n10) {
        return kitPrint && Logger.isLoggable(n10);
    }

    private static Throwable getNewThrowable(Throwable throwable) {
        ThrowableWrapper throwableWrapper;
        if (Logger.isLoggable(3)) {
            return throwable;
        }
        if (throwable == null) {
            return null;
        }
        ThrowableWrapper throwableWrapper2 = throwableWrapper;
        throwableWrapper = new ThrowableWrapper(throwable, null);
        ThrowableWrapper throwableWrapper3 = throwableWrapper2;
        for (throwable = throwable.getCause(); throwable != null; throwable = throwable.getCause()) {
            ThrowableWrapper throwableWrapper4;
            ThrowableWrapper throwableWrapper5 = throwableWrapper3;
            throwableWrapper3 = throwableWrapper4;
            throwableWrapper4 = new ThrowableWrapper(throwable, null);
            throwableWrapper5.setCause(throwableWrapper3);
        }
        return throwableWrapper2;
    }

    private static String complexTag(String string2) {
        return TAG_NETWORKKIT_PRE + string2;
    }

    private static String complexAppTag(String string2) {
        return TAG_NETWORK_SDK_PRE + string2;
    }

    private static String complexMsg(String string2, int n10) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return Logger.getCallMethodInfo(n10) + SPLIT + string2;
        }
        return Logger.getCallMethodInfo(n10);
    }

    public static boolean isLoggable(int n10) {
        return Log.isLoggable((String)TAG_NETWORKKIT_PRE, (int)n10);
    }

    private static boolean isAPPLoggable(int n10) {
        return extLogger != null && n10 >= 3;
    }

    private static String getCallMethodInfo(int n10) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > n10) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n10];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Thread.currentThread().getName()).append(SPLIT).append(stackTraceElement.getFileName()).append(SPLIT).append(stackTraceElement.getClassName()).append(SPLIT).append(stackTraceElement.getMethodName()).append(SPLIT).append(stackTraceElement.getLineNumber());
            return stringBuilder.toString();
        }
        return "";
    }

    private static int logPrintln(int n10, String string2, String string3) {
        if (Logger.isAPPLoggable(n10)) {
            String string4 = Logger.complexAppTag(string2);
            Logger.extLogPrintln(n10, string4, Logger.complexMsg(string3, 7));
        }
        if (Logger.isKitLoggable(n10)) {
            String string5 = Logger.complexTag(string2);
            return Log.println((int)n10, (String)string5, (String)Logger.complexMsg(string3, 7));
        }
        return 1;
    }

    public static void println(int n10, String string2, Object object) {
        if (n10 < 3) {
            return;
        }
        object = object == null ? "null" : object.toString();
        Logger.logPrintln(n10, string2, (String)object);
    }

    private static void extLogPrintln(int n10, String string2, String string3) {
        switch (n10) {
            default: {
                break;
            }
            case 6: {
                extLogger.e(string2, string3);
                break;
            }
            case 5: {
                extLogger.w(string2, string3);
                break;
            }
            case 4: {
                extLogger.i(string2, string3);
                break;
            }
            case 3: {
                extLogger.d(string2, string3);
                break;
            }
            case 2: {
                extLogger.v(string2, string3);
            }
        }
    }

    public static void println(int n10, String string2, String string3, Object ... objectArray) {
        if (n10 < 3) {
            return;
        }
        if (string3 == null) {
            return;
        }
        try {
            Logger.logPrintln(n10, string2, StringUtils.format(string3, objectArray));
        }
        catch (IllegalFormatException illegalFormatException) {
            Logger.w(TAG, "log format error" + string3, illegalFormatException);
        }
    }

    public static class ThrowableWrapper
    extends Throwable {
        private static final long serialVersionUID = 7129050843360571879L;
        private String message;
        private Throwable thisCause;
        private Throwable ownerThrowable;

        private ThrowableWrapper(Throwable throwable) {
            Throwable throwable2 = throwable;
            this.ownerThrowable = throwable;
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            int n10 = 20;
            if (throwable2 instanceof IOException || throwable instanceof JSONException) {
                n10 = 8;
            }
            if (stackTraceElementArray.length > n10) {
                this.setStackTrace(Arrays.copyOf(stackTraceElementArray, n10));
            } else {
                this.setStackTrace(stackTraceElementArray);
            }
            this.setMessage(StringUtils.anonymizeMessage(throwable.getMessage()));
        }

        private void setCause(Throwable throwable) {
            this.thisCause = throwable;
        }

        public /* synthetic */ ThrowableWrapper(Throwable throwable, 1 var2_2) {
            this(throwable);
        }

        @Override
        public Throwable getCause() {
            Throwable throwable = this.thisCause;
            if (throwable == this) {
                throwable = null;
            }
            return throwable;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String string2) {
            this.message = string2;
        }

        @Override
        public String toString() {
            Object object = this.ownerThrowable;
            if (object == null) {
                return "";
            }
            object = object.getClass().getName();
            if (this.message != null) {
                if (this.message.startsWith((String)(object = (String)object + ": "))) {
                    return this.message;
                }
                return (String)object + this.message;
            }
            return object;
        }
    }
}

