/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.Logger;
import java.util.HashMap;
import java.util.Map;

public class PackageManagerCompat {
    private static final String TAG = "PackageUtils";
    private static final String VERSION = "6.0.2.300";
    private static String sAppVersion = "";

    public static String getAppPackageName(Context context) {
        String string2;
        block5: {
            if (ContextHolder.getAppContext() != null) {
                context = ContextHolder.getAppContext();
            }
            string2 = "";
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return string2;
            }
            try {
                string2 = packageManager.getPackageInfo((String)context.getPackageName(), (int)16384).packageName;
                break block5;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            Logger.w(TAG, "Failed to get Package managers Package Info");
        }
        return string2;
    }

    public static String getAppVersion(Context context) {
        block6: {
            if (!TextUtils.isEmpty((CharSequence)sAppVersion)) {
                return sAppVersion;
            }
            if (ContextHolder.getAppContext() != null) {
                context = ContextHolder.getAppContext();
            }
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return sAppVersion;
            }
            try {
                sAppVersion = String.valueOf(packageManager.getPackageInfo((String)context.getPackageName(), (int)16384).versionCode);
                break block6;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            Logger.w(TAG, "Failed to get Package managers Package Info");
        }
        return sAppVersion;
    }

    private static Bundle getBundleFromApp(Context context) {
        block9: {
            Bundle bundle;
            block10: {
                block8: {
                    bundle = Bundle.EMPTY;
                    if (ContextHolder.getAppContext() != null) {
                        context = ContextHolder.getAppContext();
                    }
                    if (context == null) {
                        return bundle;
                    }
                    PackageManager packageManager = context.getPackageManager();
                    if (packageManager == null) {
                        return bundle;
                    }
                    context = packageManager.getApplicationInfo(context.getPackageName(), 128);
                    if (context == null) break block8;
                    try {
                        context = context.metaData;
                        if (context != null) break block9;
                    }
                    catch (RuntimeException runtimeException) {
                        break block10;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
                context = bundle;
                {
                    break block9;
                }
            }
            Logger.w(TAG, "NameNotFoundException:", (Throwable)context);
            context = bundle;
        }
        return context;
    }

    public static String getMetaDataFromApp(Context context, String string2, String string3) {
        if ((context = PackageManagerCompat.getBundleFromApp(context)) != null) {
            return context.getString(string2, string3);
        }
        return string3;
    }

    private static Bundle getBundleFromKit(Context context) {
        if (ContextHolder.getKitContext() != null) {
            context = ContextHolder.getKitContext();
        }
        if (context == null) {
            Logger.v(TAG, "the kitContext is null");
            return Bundle.EMPTY;
        }
        if (context.getApplicationInfo() == null) {
            Logger.v(TAG, "the kit applicationInfo is null");
            return Bundle.EMPTY;
        }
        context = context.getApplicationInfo().metaData;
        if (context == null) {
            context = Bundle.EMPTY;
        }
        return context;
    }

    public static String getMetaDataFromKit(Context context, String string2, String string3) {
        block3: {
            try {
                context = PackageManagerCompat.getBundleFromKit(context);
                if (context != null) break block3;
                return string3;
            }
            catch (RuntimeException runtimeException) {
                Logger.v(TAG, "the kit metaData is runtimeException");
                return string3;
            }
        }
        return context.getString(string2, string3);
    }

    private static Bundle getBundleFromKitOrAPP(Context context) {
        Bundle bundle = PackageManagerCompat.getBundleFromKit(context);
        if (bundle == null || bundle.isEmpty()) {
            bundle = PackageManagerCompat.getBundleFromApp(context);
        }
        return bundle;
    }

    public static String getMetaDataFromKitOrApp(Context context, String string2, String string3) {
        return PackageManagerCompat.getBundleFromKitOrAPP(context).getString(string2, string3);
    }

    public static Map<String, String> getMetaDataMapFromKitOrApp(Context object, String string2) {
        HashMap hashMap;
        Context context = object;
        object = hashMap;
        hashMap = new HashMap();
        Bundle bundle = PackageManagerCompat.getBundleFromKitOrAPP(context);
        for (String string3 : PackageManagerCompat.getBundleFromKitOrAPP(context).keySet()) {
            String string4;
            if (!string3.startsWith(string2) || TextUtils.isEmpty((CharSequence)(string4 = bundle.getString(string3)))) continue;
            ((HashMap)object).put(string3.substring(string2.length()), string4);
        }
        return object;
    }
}

