/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.text.TextUtils;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.SecurityBase64Utils;
import com.huawei.secure.android.common.util.SafeString;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public class StringUtils {
    private static final String SAFE_STRING_PATH = "com.huawei.secure.android.common.util.SafeString";
    private static boolean IS_AEGIS_STRING_LIBRARY_LOADED = false;
    private static final String TAG = "StringUtils";
    private static final int INIT_CAPACITY = 1024;

    public static boolean strEquals(String string2, String string3) {
        return string2 == string3 || string2 != null && string2.equals(string3);
    }

    public static String byte2Str(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.w("StringUtils.byte2str error: UnsupportedEncodingException", StringUtils.anonymizeMessage(unsupportedEncodingException.getMessage()));
            return "";
        }
    }

    public static byte[] str2Byte(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return new byte[0];
        }
        try {
            return string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.w("StringUtils.str2Byte error: UnsupportedEncodingException", StringUtils.anonymizeMessage(unsupportedEncodingException.getMessage()));
            return new byte[0];
        }
    }

    public static String anonymizeMessage(String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return object;
        }
        object = ((String)object).toCharArray();
        for (int i10 = 0; i10 < ((Object)object).length; ++i10) {
            if (i10 % 2 == 0) continue;
            object[i10] = 42;
        }
        return new String((char[])object);
    }

    public static byte[] getBytes(long l10) {
        return StringUtils.getBytes(String.valueOf(l10));
    }

    public static byte[] getBytes(String string2) {
        byte[] byArray = new byte[]{};
        if (string2 == null) {
            return byArray;
        }
        try {
            byArray = string2.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.w(TAG, "the content has error while it is converted to bytes");
        }
        return byArray;
    }

    public static String format(String string2, Object ... objectArray) {
        if (string2 == null) {
            return "";
        }
        return String.format(Locale.ROOT, string2, objectArray);
    }

    public static String toLowerCase(String string2) {
        if (string2 == null) {
            return "";
        }
        return string2.toLowerCase(Locale.ROOT);
    }

    public static String getTraceInfo(Throwable stackTraceElementArray) {
        StringBuilder stringBuilder;
        stackTraceElementArray = stackTraceElementArray.getStackTrace();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(1024);
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            stringBuilder2.append("at ").append(stackTraceElement.toString()).append(";");
        }
        return stringBuilder2.toString();
    }

    public static String substring(String string2, int n10) {
        if (StringUtils.checkCompatible(SAFE_STRING_PATH)) {
            try {
                return SafeString.substring(string2, n10);
            }
            catch (Throwable throwable) {
                Logger.w(TAG, "SafeString.substring error");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && string2.length() >= n10 && n10 >= 0) {
            try {
                return string2.substring(n10);
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public static String substring(String string2, int n10, int n11) {
        if (IS_AEGIS_STRING_LIBRARY_LOADED || StringUtils.checkCompatible(SAFE_STRING_PATH)) {
            try {
                return SafeString.substring(string2, n10, n11);
            }
            catch (Throwable throwable) {
                Logger.w(TAG, "SafeString.substring error");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && n10 >= 0 && n11 <= string2.length() && n11 >= n10) {
            try {
                return string2.substring(n10, n11);
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public static String replace(String string2, CharSequence charSequence, CharSequence charSequence2) {
        if (IS_AEGIS_STRING_LIBRARY_LOADED || StringUtils.checkCompatible(SAFE_STRING_PATH)) {
            try {
                return SafeString.replace(string2, charSequence, charSequence2);
            }
            catch (Throwable throwable) {
                Logger.w(TAG, "SafeString.substring error");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)charSequence)) {
            try {
                return string2.replace(charSequence, charSequence2);
            }
            catch (Exception exception) {
                return string2;
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static boolean checkCompatible(String clazz) {
        ClassLoader classLoader = SecurityBase64Utils.class.getClassLoader();
        if (classLoader == null) {
            return false;
        }
        classLoader.loadClass((String)((Object)clazz));
        {
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        Class<StringUtils> clazz2 = StringUtils.class;
        clazz = StringUtils.class;
        Class<StringUtils> clazz3 = clazz;
        IS_AEGIS_STRING_LIBRARY_LOADED = true;
        // MONITOREXIT : clazz2
        return true;
    }

    public static long stringToLong(String string2, long l10) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return l10;
        }
        try {
            l10 = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logger.w(TAG, "String to Long catch NumberFormatException." + StringUtils.anonymizeMessage(numberFormatException.getMessage()));
        }
        return l10;
    }

    public static int stringToInteger(String string2, int n10) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return n10;
        }
        try {
            n10 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logger.w(TAG, "String to Integer catch NumberFormatException." + StringUtils.anonymizeMessage(numberFormatException.getMessage()));
        }
        return n10;
    }

    public static boolean stringToBoolean(String string2, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return bl;
        }
        try {
            return Boolean.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logger.w(TAG, "String to Integer catch NumberFormatException." + StringUtils.anonymizeMessage(numberFormatException.getMessage()));
            return bl;
        }
    }

    public static String collection2String(Collection<String> object) {
        if (object != null && !object.isEmpty()) {
            StringBuilder stringBuilder;
            Collection<String> collection = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)object).append(iterator.next()).append(";");
            }
            return ((StringBuilder)object).toString().substring(0, ((StringBuilder)object).length() - 1);
        }
        return null;
    }
}

