/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common.hianalytics;

import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.hianalytics.HianalyticsHelper;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;

public class InitReport {
    private static final String TAG = "HaReport";
    private static boolean hasConnectNet = false;
    private static final int EVENT_LIMIT = 10;
    private static List<Runnable> eventsToReport = new CopyOnWriteArrayList<Runnable>();

    public static void reportWhenInit(Runnable runnable) {
        if (hasConnectNet) {
            try {
                HianalyticsHelper.getInstance().getReportExecutor().execute(runnable);
            }
            catch (Throwable throwable) {
                Logger.e(TAG, "the thread submit has fatal error!");
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                Logger.e(TAG, "the thread submit has rejectedExecutionException!");
            }
            return;
        }
        if (eventsToReport.size() > 10) {
            Logger.e("TAG", "the event to be report when init exceed the limit!");
            return;
        }
        eventsToReport.add(runnable);
    }

    public static void enableConnectNet() {
        hasConnectNet = true;
        try {
            HianalyticsHelper.getInstance().getReportExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    InitReport.submitAllEvents();
                }
            });
        }
        catch (Throwable throwable) {
            Logger.e(TAG, "the thread submit has fatal error!");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Logger.e(TAG, "the thread submit has rejectedExecutionException!");
        }
    }

    private static void submitAllEvents() {
        Iterator<Runnable> iterator = eventsToReport.iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            HianalyticsHelper.getInstance().getReportExecutor().submit(iterator.next());
        }
        try {
            eventsToReport.clear();
        }
        catch (Exception exception) {
            Logger.e(TAG, "submit failed because of some exception");
        }
        catch (NullPointerException nullPointerException) {
            Logger.e(TAG, "event is null occured");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Logger.e(TAG, "submit failed of rejected execution exception");
        }
    }
}

