/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.network.grs.local.model;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.huawei.hms.framework.common.EmuiUtil;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.SystemPropUtils;
import java.util.Locale;

public class CountryCodeBean {
    private static final String TAG = "CountryCodeBean";
    private static final String VENDORCOUNTRY_SYSTEMPROP = "ro.hw.country";
    private static final String LOCALE_REGION_COUNTRYSYSTEMPROP = "ro.product.locale.region";
    private static final String LOCALE_COUNTRYSYSTEMPROP = "ro.product.locale";
    private static final String SPECIAL_COUNTRYCODE_EU = "eu";
    private static final String SPECIAL_COUNTRYCODE_LA = "la";
    private static final String SPECIAL_COUNTRYCODE_UK = "uk";
    private static final String SPECIAL_COUNTRYCODE_GB = "gb";
    private static final String SPECIAL_COUNTRYCODE_CN = "cn";
    private static final String ANDRIOD_SYSTEMPROP = "android.os.SystemProperties";
    private static final int COUNTRYCODE_SIZE = 2;
    private static final String KEY_VERSION_EMUI = "ro.build.version.emui";
    private static final int ANDROID_9_API_LEVEL = 28;
    private String countrySource;
    private String countryCode;

    public CountryCodeBean(Context context, boolean bl) {
        CountryCodeBean countryCodeBean = this;
        this.countrySource = "UNKNOWN";
        this.countryCode = "UNKNOWN";
        countryCodeBean.init(context, bl);
        countryCodeBean.countryCode = countryCodeBean.countryCode.toUpperCase(Locale.ENGLISH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(Context context, boolean bl) {
        if (context == null) throw new NullPointerException("context must be not null.Please provide app's Context");
        try {
            CountryCodeBean countryCodeBean = this;
            countryCodeBean.getVendorCountryCode();
            if (countryCodeBean.isCodeValidate()) {
                Logger.i(TAG, "get issue_country code from VENDOR_COUNTRY");
                return;
            }
            CountryCodeBean countryCodeBean2 = this;
            countryCodeBean2.getSimCountryCode(context);
            if (countryCodeBean2.isCodeValidate()) {
                Logger.i(TAG, "get issue_country code from SIM_COUNTRY");
                return;
            }
            CountryCodeBean countryCodeBean3 = this;
            countryCodeBean3.getLocaleCountryCode();
            if (!countryCodeBean3.isCodeValidate()) return;
            Logger.i(TAG, "get issue_country code from LOCALE_INFO");
            return;
        }
        catch (Exception exception) {
            Logger.w(TAG, "get CountryCode error");
        }
    }

    private boolean isCodeValidate() {
        return "UNKNOWN".equals(this.countryCode) ^ true;
    }

    private void checkCodeLenth() {
        String string2 = this.countryCode;
        if (string2 == null || string2.length() != 2) {
            CountryCodeBean countryCodeBean = this;
            countryCodeBean.countryCode = "UNKNOWN";
            countryCodeBean.countrySource = "UNKNOWN";
        }
    }

    private void getVendorCountryCode() {
        this.countrySource = "VENDOR_COUNTRY";
        this.countryCode = SystemPropUtils.getProperty("get", VENDORCOUNTRY_SYSTEMPROP, ANDRIOD_SYSTEMPROP, "UNKNOWN");
        String string2 = TAG;
        Logger.i(string2, "countryCode by ro.hw.country is: " + this.countryCode);
        if (!SPECIAL_COUNTRYCODE_EU.equalsIgnoreCase(this.countryCode) && !SPECIAL_COUNTRYCODE_LA.equalsIgnoreCase(this.countryCode)) {
            if (SPECIAL_COUNTRYCODE_UK.equalsIgnoreCase(this.countryCode)) {
                CountryCodeBean countryCodeBean = this;
                Logger.i(string2, "special country of UK to map GB.");
                countryCodeBean.countryCode = SPECIAL_COUNTRYCODE_GB;
                countryCodeBean.countrySource = "VENDOR_COUNTRY";
            } else {
                this.checkCodeLenth();
            }
        } else {
            CountryCodeBean countryCodeBean = this;
            countryCodeBean.countryCode = "UNKNOWN";
            countryCodeBean.countrySource = "UNKNOWN";
        }
    }

    private void getSimCountryCode(Context context) {
        this.getSimCountryCode(context, false);
    }

    private void getSimCountryCode(Context context, boolean bl) {
        if ((context = (TelephonyManager)context.getApplicationContext().getSystemService("phone")) != null) {
            if (bl && context.getPhoneType() != 2) {
                CountryCodeBean countryCodeBean = this;
                countryCodeBean.countryCode = context.getNetworkCountryIso();
                countryCodeBean.countrySource = "NETWORK_COUNTRY";
                Logger.i(TAG, "countryCode by NetworkCountryIso is: " + this.countryCode);
            } else {
                CountryCodeBean countryCodeBean = this;
                countryCodeBean.countryCode = context.getSimCountryIso();
                countryCodeBean.countrySource = "SIM_COUNTRY";
                Logger.i(TAG, "countryCode by SimCountryIso is: " + this.countryCode);
            }
        }
        this.checkCodeLenth();
    }

    private void getLocaleCountryCode() {
        if (!SystemPropUtils.getProperty("get", KEY_VERSION_EMUI, ANDRIOD_SYSTEMPROP, "").isEmpty()) {
            if (EmuiUtil.isUpPVersion()) {
                this.getRegionSettingCountryCode();
                Logger.i(TAG, "EMUI 9.0 upper System, get countryCode form Locale.getDefault().getCountry()");
            } else {
                this.getProductCountryCode();
                Logger.i(TAG, "EMUI 9.0 lower System, get countryCode form ro.product.locale.region or locale");
            }
        } else if (Build.VERSION.SDK_INT < 28 && Build.VERSION.RELEASE.charAt(0) < '9') {
            this.getProductCountryCode();
            Logger.i(TAG, "other Android 9.0 lower, get countryCode form ro.product.locale.region or locale");
        } else {
            this.getRegionSettingCountryCode();
            Logger.i(TAG, "other Android 9.0 upper\uff0c get countryCode form Locale.getDefault().getCountry()");
        }
        this.countrySource = "LOCALE_INFO";
    }

    private void getRegionSettingCountryCode() {
        this.countryCode = Locale.getDefault().getCountry();
        Logger.i(TAG, "countryCode by system's region setting is: " + this.countryCode);
        if (TextUtils.isEmpty((CharSequence)this.countryCode)) {
            this.countryCode = "UNKNOWN";
        }
    }

    private void getProductCountryCode() {
        int n10;
        String string2;
        this.countryCode = SystemPropUtils.getProperty("get", LOCALE_REGION_COUNTRYSYSTEMPROP, ANDRIOD_SYSTEMPROP, "UNKNOWN");
        String string3 = TAG;
        Logger.i(string3, "countryCode by ro.product.locale.region is: " + this.countryCode);
        if ((TextUtils.isEmpty((CharSequence)this.countryCode) || "UNKNOWN".equals(this.countryCode)) && !TextUtils.isEmpty((CharSequence)(string2 = SystemPropUtils.getProperty("get", LOCALE_COUNTRYSYSTEMPROP, ANDRIOD_SYSTEMPROP, "UNKNOWN"))) && (n10 = string2.lastIndexOf("-")) != -1) {
            this.countryCode = string2.substring(n10 + 1);
            Logger.i(string3, "countryCode by ro.product.locale is: " + this.countryCode);
        }
        if (!SPECIAL_COUNTRYCODE_CN.equalsIgnoreCase(this.countryCode)) {
            this.countryCode = "UNKNOWN";
        }
    }

    public String getCountrySource() {
        return this.countrySource;
    }

    public String getCountryCode() {
        return this.countryCode;
    }
}

