/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.push.utils;

import android.os.Bundle;
import android.text.TextUtils;
import com.huawei.hms.support.log.HMSLog;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtil {
    private JsonUtil() {
    }

    public static String getString(JSONObject jSONObject, String string2, String string3) {
        block5: {
            if (jSONObject != null) {
                if (!jSONObject.has(string2)) break block5;
                if (jSONObject.get(string2) == null) break block5;
                try {
                    string3 = String.valueOf(jSONObject.get(string2));
                }
                catch (JSONException jSONException) {
                    HMSLog.w("JsonUtil", "JSONException: get " + string2 + " error.");
                }
            }
        }
        return string3;
    }

    public static int getInt(JSONObject jSONObject, String string2, int n10) {
        block4: {
            if (jSONObject != null) {
                if (!jSONObject.has(string2)) break block4;
                try {
                    n10 = jSONObject.getInt(string2);
                }
                catch (JSONException jSONException) {
                    HMSLog.w("JsonUtil", "JSONException: get " + string2 + " error.");
                }
            }
        }
        return n10;
    }

    public static String[] getStringArray(JSONObject jSONObject, String string2, String[] stringArray) {
        block8: {
            stringArray = null;
            if (jSONObject != null) {
                int n10;
                if (!jSONObject.has(string2)) break block8;
                jSONObject = jSONObject.getJSONArray(string2);
                try {
                    stringArray = new String[jSONObject.length()];
                    n10 = 0;
                }
                catch (JSONException jSONException) {
                    HMSLog.w("JsonUtil", "JSONException: get " + string2 + " error.");
                }
                while (true) {
                    if (n10 >= jSONObject.length()) break;
                    stringArray[n10] = (String)jSONObject.get(n10);
                    ++n10;
                    continue;
                    break;
                }
            }
        }
        return stringArray;
    }

    public static int[] getIntArray(JSONObject jSONObject, String string2, int[] nArray) {
        int[] nArray2;
        block9: {
            nArray2 = null;
            if (jSONObject != null) {
                int n10;
                if (!jSONObject.has(string2)) break block9;
                jSONObject = jSONObject.getJSONArray(string2);
                try {
                    nArray2 = new int[jSONObject.length()];
                    n10 = 0;
                }
                catch (JSONException jSONException) {
                    HMSLog.w("JsonUtil", "JSONException: get " + string2 + " error.");
                }
                while (true) {
                    if (n10 >= jSONObject.length()) break;
                    nArray2[n10] = (Integer)jSONObject.get(n10);
                    ++n10;
                    continue;
                    break;
                }
            }
        }
        if (nArray2 == null) {
            nArray2 = nArray;
        }
        return nArray2;
    }

    public static long[] getLongArray(JSONObject jSONObject, String string2, long[] lArray) {
        long[] lArray2;
        block9: {
            lArray2 = null;
            if (jSONObject != null) {
                int n10;
                if (!jSONObject.has(string2)) break block9;
                jSONObject = jSONObject.getJSONArray(string2);
                try {
                    lArray2 = new long[jSONObject.length()];
                    n10 = 0;
                }
                catch (JSONException jSONException) {
                    HMSLog.w("JsonUtil", "JSONException: get " + string2 + " error.");
                }
                while (true) {
                    if (n10 >= jSONObject.length()) break;
                    lArray2[n10] = jSONObject.getLong(n10);
                    ++n10;
                    continue;
                    break;
                }
            }
        }
        if (lArray2 == null) {
            lArray2 = lArray;
        }
        return lArray2;
    }

    public static void transferJsonObjectToBundle(JSONObject jSONObject, Bundle bundle, HashMap<String, Object> object) {
        for (Map.Entry entry : ((HashMap)((Object)object)).entrySet()) {
            String string2 = (String)entry.getKey();
            JsonUtil.a(jSONObject, string2, entry.getValue(), bundle);
        }
    }

    private static void a(JSONObject jSONObject, String string2, Object stringArray, Bundle bundle) {
        if (stringArray == null) {
            HMSLog.w("JsonUtil", "transfer jsonObject to bundle failed, defaultValue is null.");
            return;
        }
        if (stringArray instanceof String) {
            if (TextUtils.isEmpty((CharSequence)(stringArray = (String)stringArray))) {
                stringArray = null;
            }
            bundle.putString(string2, JsonUtil.getString(jSONObject, string2, (String)stringArray));
        } else if (stringArray instanceof Integer) {
            bundle.putInt(string2, JsonUtil.getInt(jSONObject, string2, (Integer)stringArray));
        } else if (stringArray instanceof int[]) {
            int[] nArray = (int[])stringArray;
            stringArray = (String[])nArray;
            if (nArray.length == 0) {
                stringArray = null;
            }
            bundle.putIntArray(string2, JsonUtil.getIntArray(jSONObject, string2, (int[])stringArray));
        } else if (stringArray instanceof long[]) {
            long[] lArray = (long[])stringArray;
            stringArray = (String[])lArray;
            if (lArray.length == 0) {
                stringArray = null;
            }
            bundle.putLongArray(string2, JsonUtil.getLongArray(jSONObject, string2, (long[])stringArray));
        } else if (stringArray instanceof String[]) {
            if ((stringArray = (String[])stringArray).length == 0) {
                stringArray = null;
            }
            bundle.putStringArray(string2, JsonUtil.getStringArray(jSONObject, string2, stringArray));
        } else {
            HMSLog.w("JsonUtil", "transfer jsonObject to bundle failed, invalid data type.");
        }
    }

    public static JSONArray getIntJsonArray(int[] nArray) {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        if (nArray != null && nArray.length != 0) {
            int n10 = nArray.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                jSONArray2.put(nArray[i10]);
            }
            return jSONArray2;
        }
        return jSONArray2;
    }

    public static JSONArray getLongJsonArray(long[] lArray) {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        if (lArray != null && lArray.length != 0) {
            int n10 = lArray.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                jSONArray2.put(lArray[i10]);
            }
            return jSONArray2;
        }
        return jSONArray2;
    }

    public static JSONArray getStringJsonArray(String[] stringArray) {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        if (stringArray != null && stringArray.length != 0) {
            int n10 = stringArray.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                jSONArray2.put((Object)stringArray[i10]);
            }
            return jSONArray2;
        }
        return jSONArray2;
    }
}

