/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api.client;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.core.aidl.annotation.Packed;
import com.huawei.hms.support.api.client.Result;
import java.util.Arrays;

public final class Status
extends Result
implements Parcelable {
    public static final Status SUCCESS = new Status(0);
    public static final Status FAILURE = new Status(1);
    @Deprecated
    public static final Status RESULT_CANCELED = new Status(16);
    @Deprecated
    public static final Status RESULT_DEAD_CLIENT = new Status(18);
    @Deprecated
    public static final Status RESULT_INTERNAL_ERROR = new Status(8);
    @Deprecated
    public static final Status RESULT_INTERRUPTED = new Status(14);
    @Deprecated
    public static final Status RESULT_TIMEOUT = new Status(15);
    public static final Status MessageNotFound = new Status(404);
    public static final Status CoreException = new Status(500);
    public static final Parcelable.Creator<Status> CREATOR = new Parcelable.Creator(){

        public Status a(Parcel object) {
            Parcel parcel = object;
            int n10 = parcel.readInt();
            object = parcel.readString();
            PendingIntent pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel((Parcel)parcel);
            return new Status(n10, (String)object, pendingIntent);
        }

        public Status[] a(int n10) {
            return new Status[n10];
        }
    };
    @Packed
    private PendingIntent pendingIntent;
    @Packed
    private Intent intent;
    @Packed
    private int statusCode;
    @Packed
    private String statusMessage;

    public Status(int n10) {
        this(n10, null);
    }

    public Status(int n10, String string2) {
        this.statusCode = n10;
        this.statusMessage = string2;
    }

    public Status(int n10, String string2, PendingIntent pendingIntent) {
        this.statusCode = n10;
        this.statusMessage = string2;
        this.pendingIntent = pendingIntent;
    }

    public Status(int n10, String string2, Intent intent) {
        this.statusCode = n10;
        this.statusMessage = string2;
        this.intent = intent;
    }

    private static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public boolean hasResolution() {
        return this.pendingIntent != null || this.intent != null;
    }

    public void startResolutionForResult(Activity activity, int n10) throws IntentSender.SendIntentException {
        if (this.hasResolution()) {
            PendingIntent pendingIntent = this.pendingIntent;
            if (pendingIntent != null) {
                activity.startIntentSenderForResult(pendingIntent.getIntentSender(), n10, null, 0, 0, 0);
            } else {
                activity.startActivityForResult(this.intent, n10);
            }
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Intent getResolutionIntent() {
        return this.intent;
    }

    public PendingIntent getResolution() {
        return this.pendingIntent;
    }

    public boolean isSuccess() {
        return this.statusCode <= 0;
    }

    public void setPendingIntent(PendingIntent pendingIntent) {
        this.pendingIntent = pendingIntent;
    }

    public void setIntent(Intent intent) {
        this.intent = intent;
    }

    public int hashCode() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.statusCode;
        objectArray2[1] = this.statusMessage;
        objectArray2[2] = this.pendingIntent;
        objectArray[3] = this.intent;
        return Arrays.hashCode(objectArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Status) {
            object = (Status)object;
            return this.statusCode == ((Status)object).statusCode && Status.equal(this.statusMessage, ((Status)object).statusMessage) && Status.equal(this.pendingIntent, ((Status)object).pendingIntent) && Status.equal(this.intent, ((Status)object).intent);
        }
        return false;
    }

    public String toString() {
        return "{statusCode: " + this.statusCode + ", statusMessage: " + this.statusMessage + ", pendingIntent: " + this.pendingIntent + ", intent: " + this.intent + ",}";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n10) {
        parcel.writeInt(status2.statusCode);
        parcel.writeString(status2.statusMessage);
        PendingIntent pendingIntent = status2.pendingIntent;
        if (pendingIntent != null) {
            pendingIntent.writeToParcel(parcel, n10);
        }
        Status status = status2;
        PendingIntent.writePendingIntentOrNullToParcel((PendingIntent)status.pendingIntent, (Parcel)parcel);
        Status status2 = status.intent;
        if (status2 != null) {
            status2.writeToParcel(parcel, n10);
        }
    }

    @Override
    public Status getStatus() {
        return this;
    }

    public String getErrorString() {
        return this.getStatusMessage();
    }

    public boolean isCanceled() {
        return false;
    }

    public boolean isInterrupted() {
        return false;
    }
}

