/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.text.TextUtils;
import android.util.AndroidException;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.HEX;
import com.huawei.hms.utils.IOUtils;
import com.huawei.hms.utils.SHA256;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class PackageManagerHelper {
    private final PackageManager a;

    public PackageManagerHelper(Context context) {
        this.a = context.getPackageManager();
    }

    private byte[] a(String string2) {
        block6: {
            Signature[] signatureArray = signatureArray.a.getPackageInfo(string2, 64);
            if (signatureArray == null) break block6;
            signatureArray = signatureArray.signatures;
            if (signatureArray.signatures == null) break block6;
            if (signatureArray.length <= 0) break block6;
            try {
                return signatureArray[0].toByteArray();
            }
            catch (RuntimeException runtimeException) {
                HMSLog.e("PackageManagerHelper", "Failed to get application signature certificate fingerprint.", runtimeException);
            }
            catch (AndroidException androidException) {
                HMSLog.e("PackageManagerHelper", "Failed to get application signature certificate fingerprint." + androidException.getMessage());
            }
        }
        HMSLog.e("PackageManagerHelper", "Failed to get application signature certificate fingerprint.");
        return new byte[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PackageStates getPackageStates(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return PackageStates.NOT_INSTALLED;
        }
        if (!this.a.getApplicationInfo((String)string2, (int)128).enabled) return PackageStates.DISABLED;
        try {
            return PackageStates.ENABLED;
        }
        catch (RuntimeException runtimeException) {
        }
        catch (AndroidException androidException) {}
        HMSLog.e("PackageManagerHelper", "in getPackageStates, getApplicationInfo threw an exception");
        return PackageStates.NOT_INSTALLED;
    }

    public int getPackageVersionCode(String string2) {
        block4: {
            PackageManagerHelper packageManagerHelper = packageManagerHelper.a.getPackageInfo(string2, 16);
            if (packageManagerHelper == null) break block4;
            try {
                return ((PackageInfo)packageManagerHelper).versionCode;
            }
            catch (RuntimeException runtimeException) {
                HMSLog.e("PackageManagerHelper", "get PackageVersionCode failed", runtimeException);
                return 0;
            }
            catch (AndroidException androidException) {
                HMSLog.e("PackageManagerHelper", "get PackageVersionCode failed " + (Object)((Object)androidException));
                return 0;
            }
        }
        return 0;
    }

    public String getPackageVersionName(String string2) {
        block4: {
            Object object = ((PackageManagerHelper)object).a.getPackageInfo(string2, 16);
            if (object == null) break block4;
            try {
                object = ((PackageInfo)object).versionName;
                if (object == null) break block4;
                return object;
            }
            catch (RuntimeException runtimeException) {
                HMSLog.e("PackageManagerHelper", "get getPackageVersionName failed", runtimeException);
                return "";
            }
            catch (AndroidException androidException) {
                return "";
            }
        }
        return "";
    }

    public String getPackageSignature(String string2) {
        byte[] byArray = ((PackageManagerHelper)object).a(string2);
        Object object = byArray;
        if (byArray != null && ((Object)object).length != 0) {
            return HEX.encodeHexString(SHA256.digest((byte[])object), true);
        }
        return null;
    }

    public boolean hasProvider(String string2, String string3) {
        block7: {
            int n10;
            ProviderInfo[] providerInfoArray = providerInfoArray.a.getPackageInfo(string2, 8);
            if (providerInfoArray == null) break block7;
            providerInfoArray = providerInfoArray.providers;
            if (providerInfoArray.providers == null) break block7;
            try {
                n10 = providerInfoArray.length;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
            catch (AndroidException androidException) {
                return false;
            }
            for (int i10 = 0; i10 < n10; ++i10) {
                if (!string3.equals(providerInfoArray[i10].authority)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyPackageArchive(String string2, String string3, String string4) {
        Throwable throwable2;
        block8: {
            boolean bl;
            PackageManagerHelper packageManagerHelper = object;
            Object object = null;
            try {
                object = packageManagerHelper.a.getPackageArchiveInfo(string2, 64);
            }
            catch (Exception exception) {
                HMSLog.e("PackageManagerHelper", "getPackageArchiveInfo Exception. " + exception.getMessage());
            }
            if (object == null) return false;
            if (((PackageInfo)object).signatures.length <= 0) return false;
            if (!string3.equals(((PackageInfo)object).packageName)) {
                return false;
            }
            PackageManagerHelper packageManagerHelper2 = object;
            object = null;
            try {
                object = IOUtils.toInputStream(((PackageInfo)packageManagerHelper2).signatures[0].toByteArray());
                bl = string4.equalsIgnoreCase(HEX.encodeHexString(SHA256.digest(CertificateFactory.getInstance("X.509").generateCertificate((InputStream)object).getEncoded()), true));
            }
            catch (Throwable throwable2) {
                break block8;
            }
            catch (CertificateException certificateException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IOUtils.closeQuietly((InputStream)object);
            return bl;
            {
                HMSLog.e("PackageManagerHelper", "Failed to get application signature certificate fingerprint." + ((Throwable)((Object)string2)).getMessage());
            }
            IOUtils.closeQuietly((InputStream)object);
            return false;
        }
        IOUtils.closeQuietly((InputStream)object);
        throw throwable2;
    }

    public String getApplicationName(String string2) {
        PackageManagerHelper packageManagerHelper = packageManagerHelper3;
        PackageManagerHelper packageManagerHelper2 = packageManagerHelper;
        PackageManagerHelper packageManagerHelper3 = packageManagerHelper.a.getApplicationInfo(string2, 128);
        try {
            return packageManagerHelper2.a.getApplicationLabel((ApplicationInfo)packageManagerHelper3).toString();
        }
        catch (RuntimeException runtimeException) {
        }
        catch (AndroidException androidException) {}
        HMSLog.e("PackageManagerHelper", "Failed to get application name for " + string2);
        return null;
    }

    public long getPackageFirstInstallTime(String string2) {
        block4: {
            PackageManagerHelper packageManagerHelper = packageManagerHelper.a.getPackageInfo(string2, 128);
            if (packageManagerHelper == null) break block4;
            try {
                return ((PackageInfo)packageManagerHelper).firstInstallTime;
            }
            catch (RuntimeException runtimeException) {
                return 0L;
            }
            catch (AndroidException androidException) {
                return 0L;
            }
        }
        return 0L;
    }

    public boolean isPackageFreshInstall(String string2) {
        block4: {
            PackageManagerHelper packageManagerHelper = packageManagerHelper.a.getPackageInfo(string2, 128);
            if (packageManagerHelper == null) break block4;
            try {
                return ((PackageInfo)packageManagerHelper).firstInstallTime == ((PackageInfo)packageManagerHelper).lastUpdateTime;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
            catch (AndroidException androidException) {
                return false;
            }
        }
        return false;
    }

    public static final class PackageStates
    extends Enum<PackageStates> {
        public static final /* enum */ PackageStates ENABLED;
        public static final /* enum */ PackageStates DISABLED;
        public static final /* enum */ PackageStates NOT_INSTALLED;
        public static final /* enum */ PackageStates SPOOF;
        private static final /* synthetic */ PackageStates[] a;

        public static PackageStates[] values() {
            return (PackageStates[])a.clone();
        }

        public static PackageStates valueOf(String string2) {
            return Enum.valueOf(PackageStates.class, string2);
        }

        static {
            PackageStates packageStates;
            PackageStates packageStates2;
            PackageStates packageStates3;
            PackageStates packageStates4;
            PackageStates packageStates5 = packageStates4;
            ENABLED = new PackageStates();
            PackageStates packageStates6 = packageStates3;
            DISABLED = new PackageStates();
            PackageStates packageStates7 = packageStates2;
            NOT_INSTALLED = new PackageStates();
            PackageStates packageStates8 = packageStates;
            SPOOF = new PackageStates();
            a = new PackageStates[]{packageStates5, packageStates6, packageStates7, packageStates8};
        }
    }
}

