/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.huawei.hms.activity.BridgeActivity;
import com.huawei.hms.adapter.AvailableUtil;
import com.huawei.hms.adapter.sysobs.SystemManager;
import com.huawei.hms.adapter.sysobs.SystemObserver;
import com.huawei.hms.adapter.ui.NotInstalledHmsAdapter;
import com.huawei.hms.adapter.ui.UpdateAdapter;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.update.note.AppSpoofResolution;
import com.huawei.hms.utils.Checker;
import com.huawei.hms.utils.HMSBIInitializer;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.PackageManagerHelper;
import com.huawei.hms.utils.UIUtil;

public class AvailableAdapter {
    private final int a;
    private AvailableCallBack b;
    private boolean c;
    private SystemObserver d;

    public AvailableAdapter(int n10) {
        SystemObserver systemObserver;
        SystemObserver systemObserver2 = systemObserver;
        systemObserver = new SystemObserver(){

            @Override
            public boolean onUpdateResult(int n10) {
                AvailableCallBack availableCallBack = availableCallBack.AvailableAdapter.this.a();
                if (availableCallBack == null) {
                    HMSLog.e("AvailableAdapter", "onUpdateResult baseCallBack null");
                    return true;
                }
                availableCallBack.onComplete(n10);
                return true;
            }

            @Override
            public boolean onNoticeResult(int n10) {
                AvailableCallBack availableCallBack = availableCallBack.AvailableAdapter.this.a();
                if (availableCallBack == null) {
                    HMSLog.e("AvailableAdapter", "onNoticeResult baseCallBack null");
                    return true;
                }
                availableCallBack.onComplete(n10);
                return true;
            }

            @Override
            public boolean onSolutionResult(Intent intent, String string) {
                return false;
            }
        };
        this.d = systemObserver2;
        this.a = n10;
        this.c = false;
    }

    private int a(Context context) {
        if (Build.VERSION.SDK_INT < 16) {
            HMSLog.i("AvailableAdapter", "HMS can not be supported under android 4.1");
            return 21;
        }
        if (HMSPackageManager.getInstance(context).isUseOldCertificate()) {
            HMSLog.e("AvailableAdapter", "The CP uses the old certificate to terminate the connection.");
            return 13;
        }
        Object object = HMSPackageManager.getInstance(context).getHMSPackageStatesForMultiService();
        if (PackageManagerHelper.PackageStates.NOT_INSTALLED.equals(object)) {
            HMSLog.i("AvailableAdapter", "HMS is not installed");
            return 1;
        }
        if (PackageManagerHelper.PackageStates.SPOOF.equals(object)) {
            HMSLog.i("AvailableAdapter", "HMS is spoofed");
            return 29;
        }
        if (PackageManagerHelper.PackageStates.DISABLED.equals(object)) {
            HMSLog.i("AvailableAdapter", "HMS is disabled");
            return 3;
        }
        return 0;
    }

    private void b(Context context) {
        HMSBIInitializer.getInstance(context).initBI();
    }

    private void a(Activity activity, AvailableCallBack availableCallBack) {
        HMSLog.i("AvailableAdapter", "<showHmsApkNotInstalledDialog> startResolution");
        if (NotInstalledHmsAdapter.getShowLock()) {
            Activity activity2 = activity;
            this.b = availableCallBack;
            SystemManager.getSystemNotifier().registerObserver(this.d);
            activity2.startActivity(BridgeActivity.getIntentStartBridgeActivity(activity2, NotInstalledHmsAdapter.class.getName()));
        } else {
            availableCallBack.onComplete(31);
        }
    }

    private boolean a(Activity activity) {
        boolean bl = false;
        if (HMSPackageManager.getInstance((Context)activity).getHmsVersionCode() >= 40000000) {
            HMSLog.i("AvailableAdapter", "enter 4.0 HmsCore upgrade process");
            bl = true;
        }
        return bl;
    }

    private AvailableCallBack a() {
        return this.b;
    }

    public void setCalledBySolutionInstallHms(boolean bl) {
        this.c = bl;
    }

    public int isHuaweiMobileServicesAvailable(Context context) {
        Checker.checkNonNull(context, "context must not be null.");
        int n10 = this.a(context);
        if (n10 != 0) {
            return n10;
        }
        if (HMSPackageManager.getInstance(context).isApkUpdateNecessary(this.a)) {
            HMSLog.i("AvailableAdapter", "The current version does not meet the minimum version requirements");
            n10 = 2;
        }
        return n10;
    }

    public int checkHuaweiMobileServicesForUpdate(Context context) {
        Checker.checkNonNull(context, "context must not be null.");
        int n10 = this.a(context);
        if (n10 != 0) {
            return n10;
        }
        if (HMSPackageManager.getInstance(context).isApkNeedUpdate(this.a)) {
            HMSLog.i("AvailableAdapter", "The current version does not meet the target version requirements");
            n10 = 2;
        }
        return n10;
    }

    public boolean isUserResolvableError(int n10) {
        return n10 == 1 || n10 == 2;
    }

    public boolean isUserNoticeError(int n10) {
        return n10 == 29;
    }

    public void startResolution(Activity activity, AvailableCallBack availableCallBack) {
        if (activity != null && availableCallBack != null) {
            this.b((Context)activity);
            if (UIUtil.isBackground((Context)activity)) {
                HMSLog.i("AvailableAdapter", "current app is in Background");
                availableCallBack.onComplete(28);
                return;
            }
            boolean bl = this.a(activity);
            if (!AvailableUtil.isInstallerLibExist((Context)activity) && !bl) {
                this.a(activity, availableCallBack);
                return;
            }
            HMSLog.i("AvailableAdapter", "startResolution");
            this.b = availableCallBack;
            SystemManager.getSystemNotifier().registerObserver(this.d);
            availableCallBack = BridgeActivity.getIntentStartBridgeActivity(activity, UpdateAdapter.class.getName());
            availableCallBack.putExtra("update_version", this.a);
            if (this.c) {
                availableCallBack.putExtra("installHMS", "installHMS");
            }
            availableCallBack.putExtra("new_update", bl);
            activity.startActivity((Intent)availableCallBack);
            return;
        }
    }

    public void startNotice(Activity activity, AvailableCallBack availableCallBack) {
        if (activity != null && availableCallBack != null) {
            if (UIUtil.isBackground((Context)activity)) {
                HMSLog.i("AvailableAdapter", "current app is in Background");
                availableCallBack.onComplete(28);
                return;
            }
            Activity activity2 = activity;
            HMSLog.i("AvailableAdapter", "startNotice");
            this.b = availableCallBack;
            SystemManager.getSystemNotifier().registerObserver(this.d);
            activity2.startActivity(BridgeActivity.getIntentStartBridgeActivity(activity2, AppSpoofResolution.class.getName()));
            return;
        }
    }

    public static interface AvailableCallBack {
        public void onComplete(int var1);
    }
}

