/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.api;

import com.huawei.hms.api.Api;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.common.HuaweiApi;
import com.huawei.hms.common.api.HuaweiApiCallable;
import com.huawei.hms.support.log.HMSLog;

public class AvailabilityException
extends Exception {
    private static final String TAG = "AvailabilityException";
    private String message = null;

    private void setMessage(int n10) {
        if (n10 != 21) {
            switch (n10) {
                default: {
                    this.message = "INTERNAL_ERROR";
                    break;
                }
                case 3: {
                    this.message = "SERVICE_DISABLED";
                    break;
                }
                case 2: {
                    this.message = "SERVICE_VERSION_UPDATE_REQUIRED";
                    break;
                }
                case 1: {
                    this.message = "SERVICE_MISSING";
                    break;
                }
                case 0: {
                    this.message = "success";
                    break;
                }
            }
        } else {
            this.message = "ANDROID_VERSION_UNSUPPORT";
        }
    }

    private ConnectionResult generateConnectionResult(int n10) {
        HMSLog.i(TAG, "The availability check result is: " + n10);
        this.setMessage(n10);
        return new ConnectionResult(n10);
    }

    public ConnectionResult getConnectionResult(HuaweiApiCallable huaweiApiCallable) {
        if (huaweiApiCallable != null && huaweiApiCallable.getHuaweiApi() != null) {
            return this.generateConnectionResult(HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable(huaweiApiCallable.getHuaweiApi().getContext(), 30000000));
        }
        HMSLog.e(TAG, "The huaweiApi is null.");
        return this.generateConnectionResult(8);
    }

    public ConnectionResult getConnectionResult(HuaweiApi<? extends Api.ApiOptions> huaweiApi) {
        if (huaweiApi == null) {
            HMSLog.e(TAG, "The huaweiApi is null.");
            return this.generateConnectionResult(8);
        }
        return this.generateConnectionResult(HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable(huaweiApi.getContext(), 30000000));
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

