/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.internal;

import android.os.Handler;
import android.os.Looper;

public final class Preconditions {
    public static <O> O checkNotNull(O o10) {
        if (o10 != null) {
            return o10;
        }
        throw new NullPointerException("must not refer to a null object");
    }

    public static <O> O checkNotNull(O o10, Object object) {
        if (o10 != null) {
            return o10;
        }
        throw new NullPointerException(String.valueOf(object));
    }

    public static void checkState(boolean bl, Object object) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(String.valueOf(object));
    }

    public static void checkArgument(boolean bl, Object object) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    private Preconditions() {
        throw new AssertionError((Object)"Cannot use constructor to make a new instance");
    }

    public static void checkMainThread(String string2) {
        if (Preconditions.a()) {
            return;
        }
        throw new IllegalStateException(string2);
    }

    public static void checkNotMainThread() {
        if (!Preconditions.a()) {
            return;
        }
        throw new IllegalStateException("Must not be called on the main application thread");
    }

    public static void checkHandlerThread(Handler handler) {
        Preconditions.checkHandlerThread(handler, "Must be called on the handler thread");
    }

    public static void checkHandlerThread(Handler handler, String string2) {
        if (Looper.myLooper() == handler.getLooper()) {
            return;
        }
        throw new IllegalStateException(string2);
    }

    private static boolean a() {
        return Looper.getMainLooper() == Looper.myLooper();
    }
}

