/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import com.huawei.hms.framework.common.ContextCompat;
import com.huawei.hms.framework.common.Logger;

public class ActivityUtil {
    private static final String TAG = "ActivityUtil";

    public static boolean isForeground(Context context) {
        Object object;
        if (context != null && (object = (ActivityManager)ContextCompat.getSystemService(context, "activity")) != null) {
            ActivityManager activityManager = object;
            object = null;
            try {
                object = activityManager.getRunningAppProcesses();
            }
            catch (RuntimeException runtimeException) {
                Logger.w(TAG, "activityManager getRunningAppProcesses occur exception: ", runtimeException);
            }
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                    String string2 = runningAppProcessInfo.processName;
                    if (string2 == null || !string2.equals(context.getPackageName()) || runningAppProcessInfo.importance != 100) continue;
                    Logger.v(TAG, "isForeground true");
                    return true;
                }
            }
        }
        return false;
    }

    public static PendingIntent getActivities(Context context, int n10, Intent[] intentArray, int n11) {
        if (context == null) {
            Logger.w(TAG, "context is null");
            return null;
        }
        Context context2 = context;
        context = null;
        try {
            context = PendingIntent.getActivities((Context)context2, (int)n10, (Intent[])intentArray, (int)n11);
        }
        catch (RuntimeException runtimeException) {
            Logger.e(TAG, "dealType rethrowFromSystemServer:", runtimeException);
        }
        return context;
    }
}

