/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Process;
import com.huawei.hms.framework.common.Logger;

public class ContextCompat {
    private static final String TAG = "ContextCompat";

    public static boolean checkSelfPermission(Context context, String string2) {
        if (context != null && string2 != null) {
            boolean bl = false;
            try {
                bl = context.checkPermission(string2, Process.myPid(), Process.myUid()) == 0;
            }
            catch (RuntimeException runtimeException) {
                Logger.e(TAG, "dealType rethrowFromSystemServer:", runtimeException);
            }
            return bl;
        }
        Logger.w(TAG, "param is null");
        return false;
    }

    public static Context getProtectedStorageContext(Context context) {
        if (context == null) {
            Logger.w(TAG, "context is null");
            return null;
        }
        if (Build.VERSION.SDK_INT < 24) {
            return context;
        }
        return context.createDeviceProtectedStorageContext();
    }

    public static Intent registerReceiver(Context context, BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        if (context == null) {
            Logger.w(TAG, "context is null");
            return null;
        }
        Context context2 = context;
        context = null;
        try {
            context = context2.registerReceiver(broadcastReceiver, intentFilter);
        }
        catch (RuntimeException runtimeException) {
            Logger.e(TAG, "dealType rethrowFromSystemServer:", runtimeException);
        }
        return context;
    }

    public static Intent registerReceiver(Context context, BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler) {
        if (context == null) {
            Logger.w(TAG, "context is null");
            return null;
        }
        Context context2 = context;
        context = null;
        try {
            context = context2.registerReceiver(broadcastReceiver, intentFilter, string2, handler);
        }
        catch (RuntimeException runtimeException) {
            Logger.e(TAG, "dealType rethrowFromSystemServer:", runtimeException);
        }
        return context;
    }

    public static void unregisterReceiver(Context context, BroadcastReceiver broadcastReceiver) {
        if (context == null) {
            Logger.w(TAG, "context is null");
            return;
        }
        try {
            context.unregisterReceiver(broadcastReceiver);
        }
        catch (RuntimeException runtimeException) {
            Logger.e(TAG, "SystemServer error:", runtimeException);
        }
    }

    public static ComponentName startService(Context context, Intent intent) {
        if (context == null) {
            Logger.w(TAG, "context is null");
            return null;
        }
        Context context2 = context;
        context = null;
        try {
            context = context2.startService(intent);
        }
        catch (RuntimeException runtimeException) {
            Logger.e(TAG, "SystemServer error:", runtimeException);
        }
        return context;
    }

    public static Object getSystemService(Context object, String string2) {
        if (object == null) {
            Logger.w(TAG, "context is null");
            return null;
        }
        Context context = object;
        object = null;
        try {
            object = context.getSystemService(string2);
        }
        catch (RuntimeException runtimeException) {
            Logger.e(TAG, "SystemServer error:", runtimeException);
        }
        return object;
    }
}

