/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import com.huawei.hms.framework.common.Logger;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LimitQueue<E>
extends ConcurrentLinkedQueue<E> {
    private static final String TAG = "LimitQueue";
    private static final long serialVersionUID = -4636313759149307798L;
    private int limit;
    private boolean deduplication = false;

    public LimitQueue(int n10) {
        this.limit = n10;
    }

    public LimitQueue(int n10, boolean bl) {
        this.limit = n10;
        this.deduplication = bl;
    }

    public LimitQueue(Collection<? extends E> collection, boolean bl) {
        this(collection.size(), bl);
        this.addAll(collection);
    }

    @Override
    public boolean offer(E e10) {
        if (this.deduplication) {
            super.remove(e10);
        }
        if (super.size() >= this.limit) {
            super.poll();
        }
        return super.offer(e10);
    }

    @Override
    public boolean add(E e10) {
        if (this.deduplication) {
            super.remove(e10);
        }
        if (super.size() >= this.limit) {
            super.poll();
        }
        return super.add(e10);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public E poll() {
        return super.poll();
    }

    @Override
    public E remove() {
        try {
            return super.remove();
        }
        catch (NoSuchElementException noSuchElementException) {
            Logger.w(TAG, "remove failed, limitQueue is empty");
            return null;
        }
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.size() > this.limit) {
            return false;
        }
        if (this.deduplication) {
            super.removeAll(collection);
        }
        for (int i10 = collection.size() + super.size() - this.limit; i10 > 0; --i10) {
            super.poll();
        }
        return super.addAll(collection);
    }

    public E get(int n10) {
        Iterator iterator = ((ConcurrentLinkedQueue)((Object)iterator)).iterator();
        E e10 = null;
        for (int i10 = 0; i10 <= n10 && iterator.hasNext(); ++i10) {
            e10 = iterator.next();
        }
        return e10;
    }

    public E peekLast() {
        LimitQueue limitQueue = limitQueue22;
        LimitQueue<E> limitQueue22 = null;
        for (LimitQueue<E> limitQueue22 : limitQueue) {
        }
        return (E)limitQueue22;
    }
}

