/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.text.TextUtils;
import com.huawei.hms.framework.common.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ReflectionUtils {
    private static final String TAG = "ReflectionUtils";

    private static Object invoke(Object object, Method method, Object ... objectArray) throws UnsupportedOperationException {
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            Logger.e(TAG, "Exception in invoke:", exception);
        }
        catch (RuntimeException runtimeException) {
            Logger.e(TAG, "RuntimeException in invoke:", runtimeException);
        }
        return null;
    }

    public static Method getMethod(Class<?> clazz, String string2, Class<?> ... classArray) {
        if (clazz != null && string2 != null) {
            try {
                return clazz.getDeclaredMethod(string2, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logger.e(TAG, "NoSuchMethodException:", noSuchMethodException);
            }
            catch (SecurityException securityException) {
                Logger.e(TAG, "SecurityException:", securityException);
            }
            return null;
        }
        Logger.w(TAG, "targetClass is  null pr name is null:");
        return null;
    }

    private static void setClassType(Class<?>[] classArray, Object object, int n10) {
        classArray[n10] = object instanceof Integer ? Integer.TYPE : (object instanceof Long ? Long.TYPE : (object instanceof Double ? Double.TYPE : (object instanceof Float ? Float.TYPE : (object instanceof Boolean ? Boolean.TYPE : (object instanceof Character ? Character.TYPE : (object instanceof Byte ? Byte.TYPE : (object instanceof Void ? Void.TYPE : (object instanceof Short ? Short.TYPE : object.getClass()))))))));
    }

    public static Object invokeStaticMethod(String object, String string2, Object ... objectArray) {
        Class[] classArray;
        Class[] classArray2 = null;
        if (object == null) {
            return null;
        }
        if (objectArray != null) {
            int n10 = objectArray.length;
            classArray = new Class[n10];
            for (int i10 = 0; i10 < n10; ++i10) {
                ReflectionUtils.setClassType(classArray, objectArray[i10], i10);
            }
        } else {
            classArray = classArray2;
        }
        if ((object = ReflectionUtils.getMethod(ReflectionUtils.getClass((String)object), string2, classArray)) == null) {
            return null;
        }
        return ReflectionUtils.invoke(null, (Method)object, objectArray);
    }

    public static Object invokeStaticMethod(String object, String string2, Class<?>[] classArray, Object ... objectArray) {
        if ((object = ReflectionUtils.getMethod(ReflectionUtils.getClass((String)object), string2, classArray)) == null) {
            return null;
        }
        return ReflectionUtils.invoke(null, (Method)object, objectArray);
    }

    public static Object getFieldObj(Object object, String object2) {
        if (object != null && !TextUtils.isEmpty((CharSequence)object2)) {
            Object object3 = null;
            object2 = object.getClass().getDeclaredField((String)object2);
            Object object4 = object;
            AccessController.doPrivileged(new PrivilegedAction((Field)object2){
                public final /* synthetic */ Field val$field;
                {
                    this.val$field = field;
                }

                public Object run() {
                    this.val$field.setAccessible(true);
                    return null;
                }
            });
            try {
                object3 = ((Field)object2).get(object4);
            }
            catch (SecurityException securityException) {
                Logger.e(TAG, "not security int method getFieldObj,SecurityException:", securityException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Logger.e(TAG, "Exception in getFieldObj :: NoSuchFieldException:", noSuchFieldException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.e(TAG, "Exception in getFieldObj :: IllegalArgumentException:", illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.e(TAG, "Exception in getFieldObj :: IllegalAccessException:", illegalAccessException);
            }
            return object3;
        }
        return null;
    }

    public static Field getField(Object object, String string2) {
        if (object != null && !TextUtils.isEmpty((CharSequence)string2)) {
            block6: {
                object = object.getClass().getDeclaredField(string2);
                try {
                    AccessController.doPrivileged(new PrivilegedAction((Field)object){
                        public final /* synthetic */ Field val$field;
                        {
                            this.val$field = field;
                        }

                        public Object run() {
                            this.val$field.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (SecurityException securityException) {
                    Logger.e(TAG, "not security int method getField,SecurityException:", securityException);
                    break block6;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Logger.e(TAG, "Exception in getField :: NoSuchFieldException:", noSuchFieldException);
                    break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.e(TAG, "Exception in getField :: IllegalArgumentException:", illegalArgumentException);
                }
                return object;
            }
            return null;
        }
        return null;
    }

    public static Object getStaticFieldObj(String object, String object2) {
        Object object3 = null;
        if (object == null) {
            return null;
        }
        if ((object = ReflectionUtils.getClass((String)object)) != null && !TextUtils.isEmpty((CharSequence)object2)) {
            object2 = ((Class)object).getDeclaredField((String)object2);
            Object object4 = object;
            AccessController.doPrivileged(new PrivilegedAction((Field)object2){
                public final /* synthetic */ Field val$field;
                {
                    this.val$field = field;
                }

                public Object run() {
                    this.val$field.setAccessible(true);
                    return null;
                }
            });
            try {
                object3 = ((Field)object2).get(object4);
            }
            catch (SecurityException securityException) {
                Logger.e(TAG, "not security int method getStaticFieldObj,SecurityException:", securityException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Logger.e(TAG, "Exception in getFieldObj :: NoSuchFieldException:", noSuchFieldException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.e(TAG, "Exception in getFieldObj :: IllegalArgumentException:", illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.e(TAG, "Exception in getFieldObj :: IllegalAccessException:", illegalAccessException);
            }
            return object3;
        }
        return null;
    }

    public static boolean checkCompatible(String string2) {
        try {
            ReflectionUtils.tryLoadClass(string2);
            return true;
        }
        catch (Exception exception) {
            Logger.w(TAG, string2 + "ClassNotFoundException");
            return false;
        }
    }

    public static boolean checkCompatible(String string2, String string3, Class<?> ... classArray) {
        if (string2 != null && string3 != null) {
            Class.forName(string2).getDeclaredMethod(string3, classArray);
            Logger.v(TAG, "has method : " + string3);
            return true;
        }
        try {
            Logger.w(TAG, "targetClass is  null or name is null:");
            return false;
        }
        catch (Exception exception) {
            Logger.w(TAG, string3 + " NoSuchMethodException");
        }
        catch (RuntimeException runtimeException) {
            Logger.w(TAG, string2 + " RuntimeException");
        }
        return false;
    }

    private static void tryLoadClass(String string2) throws ClassNotFoundException {
        ClassLoader classLoader = ReflectionUtils.class.getClassLoader();
        if (classLoader != null) {
            classLoader.loadClass(string2);
            return;
        }
        throw new ClassNotFoundException("not found classloader");
    }

    private static Class<?> getClass(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

