/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common.hianalytics;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import com.huawei.hianalytics.process.HiAnalyticsInstance;
import com.huawei.hianalytics.process.HiAnalyticsManager;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.ExecutorsUtils;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.StringUtils;
import com.huawei.hms.framework.common.hianalytics.CrashHianalyticsData;
import com.huawei.hms.framework.common.hianalytics.HianalyticsBaseData;
import com.huawei.hms.support.hianalytics.HiAnalyticsUtils;
import com.huawei.hms.utils.HMSBIInitializer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public class HianalyticsHelper {
    private static final String TAG = "HianalyticsHelper";
    private static final String HWID_HA_SERVICE_TAG = "hms_hwid";
    private static final String DEAULT_HA_SERVICE_TAG = "_default_config_tag";
    private static final String USER_EXPERIENCE_INVOLVED = "user_experience_involved";
    private static final int USER_EXPERIENCE_ON = 1;
    private static final int TYPE_MAINTF = 1;
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile HianalyticsHelper instance;
    private boolean hasHianalytics;
    private boolean hasHMSBI;
    private String haTag = "hms_hwid";
    private HiAnalyticsInstance hInstance = null;
    private HiAnalyticsInstance defaultInstance = null;
    private boolean isEnablePrivacyPolicy = false;
    private ExecutorService reportExecutor = ExecutorsUtils.newSingleThreadExecutor("report_ha");

    private HianalyticsHelper() {
        HiAnalyticsManager.getInitFlag((String)DEAULT_HA_SERVICE_TAG);
        try {
            this.hasHianalytics = true;
        }
        catch (Throwable throwable) {
            Logger.i(TAG, "Hianalytics sdk not found");
            this.hasHianalytics = false;
        }
        if (!this.hasHianalytics) {
            this.tryHMSBIInit(ContextHolder.getAppContext());
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.hasHianalytics;
        objectArray[1] = this.hasHMSBI;
        Logger.v(TAG, "this time the ha %s, mini %s", objectArray2);
    }

    private void tryHMSBIInit(Context context) {
        if (context == null) {
            Logger.i(TAG, "the appContext hasn't init");
            return;
        }
        try {
            HMSBIInitializer.getInstance(context).initBI();
            this.hasHMSBI = true;
        }
        catch (Throwable throwable) {
            Logger.w(TAG, "the hms base has other error!");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Logger.w(TAG, "maybe you need add base sdk!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HianalyticsHelper getInstance() {
        if (instance != null) return instance;
        Class<HianalyticsHelper> clazz = HianalyticsHelper.class;
        synchronized (HianalyticsHelper.class) {
            if (instance != null) return instance;
            instance = new HianalyticsHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private boolean isHianalyticsOk() {
        if (HiAnalyticsManager.getInitFlag((String)DEAULT_HA_SERVICE_TAG)) {
            if (this.defaultInstance == null) {
                this.defaultInstance = HiAnalyticsManager.getInstanceByTag((String)DEAULT_HA_SERVICE_TAG);
            }
            return this.defaultInstance != null;
        }
        if (this.hInstance == null) {
            this.hInstance = HiAnalyticsManager.getInstanceByTag((String)this.haTag);
        }
        return this.hInstance != null;
    }

    private void onNewEvent(Context context, String string2, Map map, int n10) {
        if (context != null && map != null) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = map;
            Logger.v(TAG, "data = %s", objectArray2);
            try {
                HiAnalyticsUtils.getInstance().onNewEvent(context, string2, map, n10);
            }
            catch (Throwable throwable) {
                Logger.i(TAG, "the stats has other error,pls check it");
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Logger.w(TAG, "may be you need upgrade stats sdk");
            }
            return;
        }
    }

    public void setHaTag(String string2) {
        this.haTag = string2;
    }

    public void enablePrivacyPolicy(boolean bl) {
        this.isEnablePrivacyPolicy = bl;
    }

    public boolean isEnableReport(Context context) {
        if (this.hasHMSBI) {
            return true;
        }
        if (!this.hasHianalytics) {
            return false;
        }
        return this.isEnableReportNoSeed(context);
    }

    public boolean isEnableReportNoSeed(Context context) {
        block8: {
            if (this.hasHMSBI) {
                return true;
            }
            if (!this.hasHianalytics) {
                Logger.i(TAG, "Hianalytics sdk need to be initialized");
                return false;
            }
            if (context == null) {
                Logger.i(TAG, "HianalyticsHelper context can't be null");
                return false;
            }
            if (this.isEnablePrivacyPolicy) {
                return this.isHianalyticsOk();
            }
            if (Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)USER_EXPERIENCE_INVOLVED, (int)-1) != 1) break block8;
            try {
                return this.isHianalyticsOk();
            }
            catch (Throwable throwable) {
                Logger.w(TAG, "the setting has other error");
            }
            catch (IllegalStateException illegalStateException) {
                Logger.w(TAG, "the setting has illegalStateException");
            }
        }
        Logger.i(TAG, "user experience involved needs to be opened");
        return false;
    }

    public void onEvent(LinkedHashMap<String, String> linkedHashMap, String string2) {
        this.onEvent(linkedHashMap, string2, 1);
    }

    public void onEvent(LinkedHashMap<String, String> linkedHashMap, String string2, int n10) {
        HiAnalyticsInstance hiAnalyticsInstance;
        if (hiAnalyticsInstance.hasHMSBI) {
            hiAnalyticsInstance.onNewEvent(ContextHolder.getAppContext(), string2, linkedHashMap, n10);
        } else if (n10 == 0) {
            HiAnalyticsInstance hiAnalyticsInstance2 = new Object[1];
            hiAnalyticsInstance = hiAnalyticsInstance2;
            hiAnalyticsInstance2[0] = n10;
            Logger.v(TAG, "the base sdk isn't exsit, and reportType is %s", (Object[])hiAnalyticsInstance);
            return;
        }
        if (!hiAnalyticsInstance.hasHianalytics) {
            return;
        }
        if (linkedHashMap == null) {
            return;
        }
        HiAnalyticsInstance hiAnalyticsInstance3 = new Object[1];
        HiAnalyticsInstance hiAnalyticsInstance4 = hiAnalyticsInstance3;
        hiAnalyticsInstance3[0] = linkedHashMap;
        Logger.v(TAG, "data = %s", (Object[])hiAnalyticsInstance4);
        if (HiAnalyticsManager.getInitFlag((String)DEAULT_HA_SERVICE_TAG) && (hiAnalyticsInstance4 = hiAnalyticsInstance.defaultInstance) != null) {
            hiAnalyticsInstance4.onEvent(1, string2, linkedHashMap);
        } else {
            hiAnalyticsInstance = hiAnalyticsInstance.hInstance;
            if (hiAnalyticsInstance != null) {
                hiAnalyticsInstance.onEvent(1, string2, linkedHashMap);
            } else {
                Logger.e(TAG, "the ha has error,has init but is null!");
            }
        }
    }

    public void onEvent(LinkedHashMap<String, String> linkedHashMap) {
        this.onEvent(linkedHashMap, "url_request");
    }

    public ExecutorService getReportExecutor() {
        return this.reportExecutor;
    }

    public void executeReportHa(HianalyticsBaseData hianalyticsBaseData, String string2) {
        this.getReportExecutor().execute(new HianalyticsRunnable(hianalyticsBaseData, string2));
    }

    public void reportException(final Throwable throwable, final String string2) {
        if (!HianalyticsHelper.getInstance().isEnableReport(ContextHolder.getAppContext())) {
            return;
        }
        final String string3 = Thread.currentThread().getName();
        try {
            objectArray2.reportExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    CrashHianalyticsData crashHianalyticsData;
                    CrashHianalyticsData crashHianalyticsData2;
                    CrashHianalyticsData crashHianalyticsData3 = crashHianalyticsData2 = crashHianalyticsData;
                    crashHianalyticsData3();
                    crashHianalyticsData3.put("sdk_version", "6.0.2.300");
                    crashHianalyticsData3.put("crash_type", "exception");
                    crashHianalyticsData2.put("thread_name", linkedHashMap.string3);
                    crashHianalyticsData2.put("exception_name", linkedHashMap.throwable.getClass().getName());
                    crashHianalyticsData2.put("message", StringUtils.anonymizeMessage(linkedHashMap.throwable.getMessage()));
                    crashHianalyticsData.put("stack_trace", StringUtils.getTraceInfo(linkedHashMap.throwable));
                    1 v22 = linkedHashMap;
                    LinkedHashMap<String, String> linkedHashMap = crashHianalyticsData2.get();
                    HianalyticsHelper.getInstance().onEvent(linkedHashMap, v22.string2);
                }
            });
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = throwable;
            Logger.i(TAG, "reportException error!", objectArray2);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Logger.i(TAG, "reportException error RejectedExecutionException");
        }
    }

    public void reportData(Context context, LinkedHashMap<String, String> linkedHashMap, String string2, int n10) {
        if (!this.isEnableReportNoSeed(context)) {
            return;
        }
        this.onEvent(linkedHashMap, string2, n10);
    }

    public static class HianalyticsRunnable
    implements Runnable {
        private final HianalyticsBaseData data;
        private final String event;

        public HianalyticsRunnable(HianalyticsBaseData hianalyticsBaseData, String string2) {
            this.data = hianalyticsBaseData;
            this.event = string2;
        }

        @Override
        public void run() {
            HianalyticsRunnable hianalyticsRunnable = linkedHashMap;
            LinkedHashMap<String, String> linkedHashMap = hianalyticsRunnable.data.get();
            HianalyticsHelper.getInstance().onEvent(linkedHashMap, hianalyticsRunnable.event);
        }
    }
}

