/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.push;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import com.huawei.hms.aaid.constant.ErrorEnum;
import com.huawei.hms.aaid.threads.AsyncExec;
import com.huawei.hms.aaid.utils.BaseUtils;
import com.huawei.hms.push.BaseException;
import com.huawei.hms.push.RemoteMessage;
import com.huawei.hms.push.SendException;
import com.huawei.hms.push.e;
import com.huawei.hms.push.utils.PushBiUtil;
import com.huawei.hms.support.log.HMSLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HmsMessageService
extends Service {
    public static final String SUBJECT_ID = "subject_id";
    public static final String PROXY_TYPE = "proxy_type";
    private final Messenger a;

    public HmsMessageService() {
        b b10;
        e e10;
        Messenger messenger;
        Messenger messenger2 = messenger;
        e e11 = e10;
        b b11 = b10;
        b10 = new b(null);
        e10 = new e(b11);
        messenger = new Messenger((Handler)e11);
        this.a = messenger2;
    }

    private void a(final String string2, final String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        AsyncExec.submitSeqIO(new Runnable(){

            @Override
            public void run() {
                a a10 = string32;
                Context context = a10.HmsMessageService.this.getApplicationContext();
                String string22 = BaseUtils.getLocalToken(context, string32.string3);
                if (!a10.string2.equals(string22)) {
                    a a11 = string32;
                    HMSLog.i("HmsMessageService", "receive a new token, refresh the local token");
                    String string32 = a11.string3;
                    BaseUtils.saveToken(context, string32, a11.string2);
                }
            }
        });
    }

    private Bundle a(Intent intent) {
        Bundle bundle;
        HmsMessageService hmsMessageService = bundle;
        hmsMessageService();
        hmsMessageService.putString("message_id", intent.getStringExtra("message_id"));
        hmsMessageService.putByteArray("message_body", intent.getByteArrayExtra("message_body"));
        bundle.putString("device_token", intent.getStringExtra("device_token"));
        if (intent.getIntExtra("inputType", -1) == 1) {
            hmsMessageService.putInt("inputType", 1);
        }
        return hmsMessageService;
    }

    private void a(Intent intent, String string2) {
        Bundle bundle;
        Intent intent2 = intent;
        ErrorEnum errorEnum = ErrorEnum.SUCCESS;
        int n10 = intent.getIntExtra("error", errorEnum.getInternalCode());
        this.a("push.onNewToken", string2, n10);
        String string3 = intent2.getStringExtra("subjectId");
        String string4 = intent2.getStringExtra("message_proxy_type");
        HMSLog.i("HmsMessageService", "doOnNewToken:transactionId = " + string2 + " , internalCode = " + n10 + ",subjectId:" + string3 + ",proxyType:" + string4);
        string2 = bundle;
        bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            string2.putString(SUBJECT_ID, string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            string2.putString(PROXY_TYPE, string4);
        }
        if (n10 == errorEnum.getInternalCode()) {
            HMSLog.i("HmsMessageService", "Apply token OnNewToken, subId: " + string3);
            this.a(intent, (Bundle)string2, string3);
        } else {
            HMSLog.i("HmsMessageService", "Apply token failed, subId: " + string3);
            this.a(intent, (Bundle)string2, string3, n10);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void a(Intent intent, Bundle bundle, String stringArray, int n10) {
        BaseException baseException;
        intent = baseException2.getApplicationContext();
        boolean bl = TextUtils.isEmpty((CharSequence)BaseUtils.getCacheData((Context)intent, intent.getPackageName(), false)) ^ true;
        if (bundle.isEmpty() && bl) {
            Intent intent2 = intent;
            HMSLog.i("HmsMessageService", "onTokenError to host app.");
            ((HmsMessageService)((Object)baseException2)).onTokenError(new BaseException(n10));
            BaseUtils.deleteCacheData((Context)intent2, intent2.getPackageName());
        }
        if (!TextUtils.isEmpty((CharSequence)stringArray)) {
            HMSLog.i("HmsMessageService", "onTokenError to sub app, subjectId:" + (String)stringArray);
            ((HmsMessageService)((Object)baseException2)).onTokenError(new BaseException(n10), bundle);
            return;
        }
        stringArray = BaseUtils.getSubjectIds((Context)intent);
        if (stringArray != null && stringArray.length != 0) {
            int n11 = 0;
            while (true) {
                Bundle bundle2;
                if (n11 >= stringArray.length) {
                    BaseUtils.clearSubjectIds((Context)intent);
                    return;
                }
                Bundle bundle3 = bundle2;
                bundle3();
                bundle2.putString(SUBJECT_ID, stringArray[n11]);
                HMSLog.i("HmsMessageService", "onTokenError to sub app, subjectId:" + stringArray[n11]);
                ((HmsMessageService)((Object)baseException2)).onTokenError(new BaseException(n10), bundle3);
                ++n11;
            }
        }
        HmsMessageService hmsMessageService = baseException2;
        HMSLog.i("HmsMessageService", "onTokenError to host app with bundle.");
        BaseException baseException2 = baseException;
        baseException = new BaseException(n10);
        hmsMessageService.onTokenError(baseException2, bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void a(Intent intent, Bundle bundle, String stringArray) {
        HmsMessageService hmsMessageService = this;
        String string2 = intent.getStringExtra("device_token");
        hmsMessageService.a(string2, (String)stringArray);
        Context context = hmsMessageService.getApplicationContext();
        boolean bl = TextUtils.isEmpty((CharSequence)BaseUtils.getCacheData(context, context.getPackageName(), false)) ^ true;
        if (bundle.isEmpty() && bl) {
            Context context2 = context;
            HMSLog.i("HmsMessageService", "onNewToken to host app.");
            this.onNewToken(string2);
            BaseUtils.deleteCacheData(context2, context2.getPackageName());
        }
        if (!TextUtils.isEmpty((CharSequence)stringArray)) {
            HMSLog.i("HmsMessageService", "onNewToken to sub app, subjectId:" + (String)stringArray);
            this.onNewToken(string2, bundle);
            return;
        }
        stringArray = BaseUtils.getSubjectIds(context);
        if (stringArray != null && stringArray.length != 0) {
            int n10 = 0;
            while (true) {
                Bundle bundle2;
                if (n10 >= stringArray.length) {
                    BaseUtils.clearSubjectIds(context);
                    return;
                }
                bundle = bundle2;
                bundle();
                bundle2.putString(SUBJECT_ID, stringArray[n10]);
                HMSLog.i("HmsMessageService", "onNewToken to sub app, subjectId:" + stringArray[n10]);
                this.onNewToken(string2, bundle2);
                this.a(string2, stringArray[n10]);
                ++n10;
            }
        }
        HMSLog.i("HmsMessageService", "onNewToken to host app with bundle.");
        bundle.putString("belongId", intent.getStringExtra("belongId"));
        this.onNewToken(string2, bundle);
    }

    private void a(String string2, String string3, int n10) {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = "null";
        }
        PushBiUtil.reportExit(this.getApplicationContext(), string2, string3, n10);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b(Intent object) {
        JSONArray jSONArray;
        HMSLog.i("HmsMessageService", "parse batch response.");
        String string2 = object.getStringExtra("batchMsgbody");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        JSONArray jSONArray2 = jSONArray;
        try {
            void var1_4;
            jSONArray = new JSONArray(string2);
            boolean bl = false;
            while (var1_4 < jSONArray2.length()) {
                JSONObject jSONObject = jSONArray2.getJSONObject((int)var1_4);
                String string3 = jSONObject.optString("transactionId");
                String string4 = jSONObject.optString("msgId");
                int n10 = jSONObject.optInt("ret", ErrorEnum.ERROR_UNKNOWN.getInternalCode());
                if (ErrorEnum.SUCCESS.getInternalCode() == n10) {
                    this.b(string3, string4);
                } else {
                    this.b(string3, string4, n10);
                }
                ++var1_4;
            }
            return;
        }
        catch (JSONException jSONException) {
            HMSLog.w("HmsMessageService", "parse batch response failed.");
        }
    }

    private void b(String string2, String string3) {
        HMSLog.i("HmsMessageService", "onMessageSent, message id:" + string3 + ", transactionId: " + string2);
        int n10 = ErrorEnum.SUCCESS.getInternalCode();
        this.a("push.sendMessageRet", string2, n10);
        this.onMessageSent(string3);
    }

    private void b(String string2, String string3, int n10) {
        SendException sendException;
        HmsMessageService hmsMessageService = object;
        HMSLog.i("HmsMessageService", "onSendError, message id:" + string3 + " error:" + n10 + ", transactionId: " + string2);
        object.a("push.sendMessageRet", string2, n10);
        Object object = sendException;
        sendException = new SendException(n10);
        hmsMessageService.onSendError(string3, (Exception)object);
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
    }

    public void onDeletedMessages() {
    }

    public void onMessageSent(String string2) {
    }

    public void onMessageDelivered(String string2, Exception exception) {
    }

    public void onSendError(String string2, Exception exception) {
    }

    public void onNewToken(String string2) {
    }

    public void onNewToken(String string2, Bundle bundle) {
    }

    public void onTokenError(Exception exception) {
    }

    public void onTokenError(Exception exception, Bundle bundle) {
    }

    public IBinder onBind(Intent intent) {
        HMSLog.i("HmsMessageService", "start to bind");
        return this.a.getBinder();
    }

    public int onStartCommand(Intent intent, int n10, int n11) {
        HMSLog.i("HmsMessageService", "start to command , startId = " + n11);
        this.handleIntentMessage(intent);
        return 2;
    }

    public void onDestroy() {
        HMSLog.i("HmsMessageService", "start to destroy");
        super.onDestroy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleIntentMessage(Intent intent) {
        if (intent == null) {
            HMSLog.e("HmsMessageService", "receive message is null");
            return;
        }
        try {
            Intent intent2 = intent;
            String string2 = intent2.getStringExtra("message_id");
            String string3 = intent2.getStringExtra("message_type");
            String string4 = intent2.getStringExtra("transaction_id");
            if ("new_token".equals(string3)) {
                HMSLog.i("HmsMessageService", "onNewToken");
                this.a(intent, string4);
                return;
            }
            if ("received_message".equals(string3)) {
                HMSLog.i("HmsMessageService", "onMessageReceived, message id:" + string2);
                this.a("push.receiveMessage", string2, ErrorEnum.SUCCESS.getInternalCode());
                this.doMsgReceived(intent);
                return;
            }
            if ("sent_message".equals(string3)) {
                this.b(string4, string2);
                return;
            }
            if ("send_error".equals(string3)) {
                this.b(string4, string2, intent.getIntExtra("error", ErrorEnum.ERROR_UNKNOWN.getInternalCode()));
                return;
            }
            if ("delivery".equals(string3)) {
                int n10 = intent.getIntExtra("error", ErrorEnum.ERROR_APP_SERVER_NOT_ONLINE.getInternalCode());
                HMSLog.i("HmsMessageService", "onMessageDelivery, message id:" + string2 + ", status:" + n10 + ", transactionId: " + string4);
                this.a("push.deliveryMessage", string4, n10);
                this.onMessageDelivered(string2, new SendException(n10));
                return;
            }
            if ("server_deleted_message".equals(string3)) {
                HMSLog.i("HmsMessageService", "delete message, message id:" + string2);
                this.onDeletedMessages();
                return;
            }
            if ("batchSent".equals(string3)) {
                this.b(intent);
                return;
            }
            HMSLog.e("HmsMessageService", "Receive unknown message: " + string3);
            return;
        }
        catch (Exception exception) {
            HMSLog.e("HmsMessageService", "handle intent exception: " + exception.getMessage());
            return;
        }
        catch (RuntimeException runtimeException) {
            HMSLog.e("HmsMessageService", "handle intent RuntimeException: " + runtimeException.getMessage());
        }
    }

    public void doMsgReceived(Intent object) {
        RemoteMessage remoteMessage;
        HmsMessageService hmsMessageService = hmsMessageService2;
        HmsMessageService hmsMessageService2 = hmsMessageService.a((Intent)object);
        object = remoteMessage;
        remoteMessage = new RemoteMessage((Bundle)hmsMessageService2);
        hmsMessageService.onMessageReceived((RemoteMessage)object);
    }

    public class b
    implements e.a {
        private b() {
        }

        public /* synthetic */ b(a a10) {
            this();
        }

        @Override
        public void a(Message message) {
            if (message == null) {
                HMSLog.e("HmsMessageService", "receive message is null");
                return;
            }
            HMSLog.i("HmsMessageService", "handle message start...");
            message = Message.obtain((Message)message).getData();
            if (message != null) {
                Intent intent;
                b b10 = b11;
                b b11 = intent;
                b11();
                b11.putExtras((Bundle)message);
                intent.putExtra("inputType", message.getInt("inputType", -1));
                b10.HmsMessageService.this.handleIntentMessage((Intent)b11);
            }
        }
    }
}

