/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.push;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.huawei.hms.push.c;
import com.huawei.hms.push.k;
import com.huawei.hms.push.utils.DateUtil;
import com.huawei.hms.push.utils.JsonUtil;
import com.huawei.hms.support.api.push.PushException;
import com.huawei.hms.support.log.HMSLog;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteMessage
implements Parcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    private static final String[] c;
    private static final int[] d;
    private static final long[] e;
    private static final HashMap<String, Object> f;
    private static final HashMap<String, Object> g;
    private static final HashMap<String, Object> h;
    private static final HashMap<String, Object> i;
    private static final HashMap<String, Object> j;
    public static final Parcelable.Creator<RemoteMessage> CREATOR;
    private Bundle a;
    private Notification b;

    public RemoteMessage(Bundle bundle) {
        this.a = this.a(bundle);
    }

    public RemoteMessage(Parcel parcel) {
        this.a = parcel.readBundle();
        this.b = (Notification)parcel.readSerializable();
    }

    private Bundle a(Bundle object) {
        JSONObject jSONObject;
        Bundle bundle;
        Bundle bundle2 = object;
        Bundle bundle3 = bundle;
        bundle = new Bundle();
        JSONObject jSONObject2 = RemoteMessage.b(bundle2);
        JSONObject jSONObject3 = jSONObject = RemoteMessage.a(jSONObject2);
        String string2 = JsonUtil.getString(jSONObject3, "data", null);
        bundle3.putString("analyticInfo", JsonUtil.getString(jSONObject3, "analyticInfo", null));
        bundle3.putString("device_token", object.getString("device_token"));
        JSONObject jSONObject4 = RemoteMessage.d(jSONObject);
        JSONObject jSONObject5 = RemoteMessage.b(jSONObject4);
        JSONObject jSONObject6 = RemoteMessage.c(jSONObject4);
        if (bundle2.getInt("inputType") == 1 && com.huawei.hms.push.c.a(jSONObject, jSONObject4, string2)) {
            Bundle bundle4 = bundle3;
            bundle4.putString("data", com.huawei.hms.push.a.a(object.getByteArray("message_body")));
            return bundle4;
        }
        Bundle bundle5 = bundle3;
        RemoteMessage remoteMessage = string3;
        Bundle bundle6 = bundle3;
        Bundle bundle7 = object;
        String string3 = bundle7.getString("to");
        object = bundle7.getString("message_type");
        String string4 = JsonUtil.getString(jSONObject, "msgId", null);
        bundle6.putString("to", string3);
        bundle6.putString("data", string2);
        bundle6.putString("msgId", string4);
        bundle6.putString("message_type", (String)object);
        JsonUtil.transferJsonObjectToBundle(jSONObject2, bundle3, f);
        bundle5.putBundle("notification", remoteMessage.a(jSONObject2, jSONObject, jSONObject4, jSONObject5, jSONObject6));
        return bundle5;
    }

    private Bundle a(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, JSONObject jSONObject5) {
        Bundle bundle;
        RemoteMessage remoteMessage = bundle;
        remoteMessage();
        JsonUtil.transferJsonObjectToBundle(jSONObject3, (Bundle)remoteMessage, g);
        JsonUtil.transferJsonObjectToBundle(jSONObject4, (Bundle)remoteMessage, h);
        JsonUtil.transferJsonObjectToBundle(jSONObject, (Bundle)remoteMessage, i);
        JsonUtil.transferJsonObjectToBundle(jSONObject5, (Bundle)remoteMessage, j);
        bundle.putInt("notifyId", JsonUtil.getInt(jSONObject2, "notifyId", 0));
        return bundle;
    }

    private static JSONObject b(Bundle object) {
        try {
            object = com.huawei.hms.push.a.a(object.getByteArray("message_body"));
        }
        catch (JSONException jSONException) {
            HMSLog.w("RemoteMessage", "JSONException:parse message body failed.");
            return null;
        }
        return new JSONObject((String)object);
    }

    private static JSONObject a(JSONObject jSONObject) {
        if (jSONObject != null) {
            return jSONObject.optJSONObject("msgContent");
        }
        return null;
    }

    private static JSONObject d(JSONObject jSONObject) {
        if (jSONObject != null) {
            return jSONObject.optJSONObject("psContent");
        }
        return null;
    }

    private static JSONObject b(JSONObject jSONObject) {
        if (jSONObject != null) {
            return jSONObject.optJSONObject("notifyDetail");
        }
        return null;
    }

    private static JSONObject c(JSONObject jSONObject) {
        if (jSONObject != null) {
            return jSONObject.optJSONObject("param");
        }
        return null;
    }

    static {
        String[] stringArray = new String[]{};
        c = stringArray;
        int[] nArray = new int[]{};
        d = nArray;
        long[] lArray = new long[]{};
        e = lArray;
        f = new HashMap<String, Object>(8);
        f.put("from", "");
        f.put("collapseKey", "");
        f.put("sendTime", "");
        f.put("ttl", 86400);
        f.put("urgency", 2);
        f.put("oriUrgency", 2);
        f.put("sendMode", 0);
        f.put("receiptMode", 0);
        g = new HashMap<String, Object>(8);
        g.put("title_loc_key", "");
        g.put("body_loc_key", "");
        g.put("notifyIcon", "");
        g.put("title_loc_args", stringArray);
        g.put("body_loc_args", stringArray);
        g.put("ticker", "");
        g.put("notifyTitle", "");
        g.put("content", "");
        h = new HashMap<String, Object>(8);
        h.put("icon", "");
        h.put("color", "");
        h.put("sound", "");
        h.put("defaultLightSettings", 1);
        h.put("lightSettings", nArray);
        h.put("defaultSound", 1);
        h.put("defaultVibrateTimings", 1);
        h.put("vibrateTimings", lArray);
        i = new HashMap<String, Object>(8);
        i.put("tag", "");
        i.put("when", "");
        i.put("localOnly", 1);
        i.put("badgeSetNum", "");
        i.put("priority", "");
        i.put("autoCancel", 1);
        i.put("visibility", "");
        i.put("channelId", "");
        j = new HashMap<String, String>(3);
        j.put("acn", "");
        j.put("intentUri", "");
        j.put("url", "");
        CREATOR = new Parcelable.Creator<RemoteMessage>(){

            public RemoteMessage a(Parcel parcel) {
                return new RemoteMessage(parcel);
            }

            public RemoteMessage[] a(int n10) {
                return new RemoteMessage[n10];
            }
        };
    }

    public String getFrom() {
        return this.a.getString("from");
    }

    public String getTo() {
        return this.a.getString("to");
    }

    public String getAnalyticInfo() {
        return this.a.getString("analyticInfo");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> getAnalyticInfoMap() {
        JSONObject jSONObject;
        HashMap hashMap;
        RemoteMessage remoteMessage = hashMap2;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        Object object = remoteMessage.a.getString("analyticInfo");
        if (object == null || ((String)object).trim().isEmpty()) return hashMap2;
        JSONObject jSONObject2 = jSONObject;
        try {
            object = new JSONObject((String)object).keys();
        }
        catch (JSONException jSONException) {
            HMSLog.w("RemoteMessage", "JSONException: get analyticInfo from map failed.");
        }
        while (true) {
            if (!object.hasNext()) return hashMap2;
            HashMap hashMap3 = hashMap2;
            JSONObject jSONObject3 = jSONObject2;
            String string2 = String.valueOf(object.next());
            hashMap3.put(string2, String.valueOf(jSONObject3.get(string2)));
        }
        return hashMap2;
    }

    public String getData() {
        return this.a.getString("data");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> getDataOfMap() {
        JSONObject jSONObject;
        HashMap hashMap;
        RemoteMessage remoteMessage = hashMap2;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        Object object = remoteMessage.a.getString("data");
        if (object == null || ((String)object).trim().isEmpty()) return hashMap2;
        JSONObject jSONObject2 = jSONObject;
        try {
            object = new JSONObject((String)object).keys();
        }
        catch (JSONException jSONException) {
            HMSLog.w("RemoteMessage", "JSONException: get data from map failed");
        }
        while (true) {
            if (!object.hasNext()) return hashMap2;
            HashMap hashMap3 = hashMap2;
            JSONObject jSONObject3 = jSONObject2;
            String string2 = String.valueOf(object.next());
            hashMap3.put(string2, String.valueOf(jSONObject3.get(string2)));
        }
        return hashMap2;
    }

    public String getCollapseKey() {
        return this.a.getString("collapseKey");
    }

    public String getMessageId() {
        return this.a.getString("msgId");
    }

    public String getMessageType() {
        return this.a.getString("message_type");
    }

    public long getSentTime() {
        long l10;
        block4: {
            l10 = 0L;
            try {
                String string2 = ((RemoteMessage)((Object)string2)).a.getString("sendTime");
            }
            catch (NumberFormatException numberFormatException) {
                HMSLog.w("RemoteMessage", "NumberFormatException: get sendTime error.");
                return l10;
            }
            if (TextUtils.isEmpty((CharSequence)string2)) break block4;
            l10 = Long.parseLong(string2);
        }
        return l10;
    }

    public int getTtl() {
        return this.a.getInt("ttl");
    }

    public int getSendMode() {
        return this.a.getInt("sendMode");
    }

    public int getReceiptMode() {
        return this.a.getInt("receiptMode");
    }

    public int getOriginalUrgency() {
        int n10 = this.a.getInt("oriUrgency");
        if (n10 != 1 && n10 != 2) {
            return 0;
        }
        return n10;
    }

    public int getUrgency() {
        int n10 = this.a.getInt("urgency");
        if (n10 != 1 && n10 != 2) {
            return 0;
        }
        return n10;
    }

    public String getToken() {
        return this.a.getString("device_token");
    }

    public Notification getNotification() {
        Notification notification;
        RemoteMessage remoteMessage = this;
        Object object = remoteMessage.a.getBundle("notification");
        if (remoteMessage.b == null && object != null) {
            Notification notification2;
            notification = notification2;
            notification2 = new Notification((Bundle)object, null);
            this.b = notification;
        }
        if (this.b == null) {
            Bundle bundle;
            Notification notification3;
            object = notification3;
            notification = bundle;
            bundle = new Bundle();
            notification3 = new Notification((Bundle)notification, null);
            this.b = object;
        }
        return this.b;
    }

    public final int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n10) {
        parcel.writeBundle(this.a);
        parcel.writeSerializable((Serializable)this.b);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }

    public static class Builder {
        private final Bundle a;
        private final Map<String, String> b;

        public Builder(String string2) {
            HashMap hashMap;
            Bundle bundle;
            Bundle bundle2 = bundle;
            Builder builder = hashMap2;
            bundle2();
            builder.a = bundle2;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            builder.b = hashMap2;
            bundle.putString("to", string2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RemoteMessage build() {
            String string2;
            JSONObject jSONObject;
            Bundle bundle;
            block14: {
                JSONObject jSONObject2;
                JSONObject jSONObject3;
                JSONObject jSONObject4;
                JSONObject jSONObject5;
                Bundle bundle2;
                bundle = bundle2;
                bundle2 = new Bundle();
                Object object = jSONObject5;
                jSONObject5 = new JSONObject();
                try {
                    jSONObject = this.b.entrySet().iterator();
                }
                catch (JSONException jSONException) {
                    HMSLog.w("RemoteMessage", "JSONException: parse data to json failed.");
                    throw new PushException("send message failed");
                }
                while (jSONObject.hasNext()) {
                    Map.Entry<String, String> entry = jSONObject.next();
                    string2 = entry.getKey();
                    object.put(string2, (Object)entry.getValue());
                }
                try {
                    JSONObject jSONObject6 = object;
                    jSONObject4 = jSONObject6;
                    object = jSONObject6.toString();
                }
                catch (JSONException jSONException) {
                    HMSLog.w("RemoteMessage", "JSONException: parse message body failed.");
                    throw new PushException("send message failed");
                }
                jSONObject = jSONObject3;
                new JSONObject().put("collapseKey", (Object)this.a.getString("collapseKey"));
                jSONObject.put("ttl", this.a.getInt("ttl"));
                jSONObject.put("sendMode", this.a.getInt("sendMode"));
                jSONObject.put("receiptMode", this.a.getInt("receiptMode"));
                string2 = jSONObject2;
                jSONObject2 = new JSONObject();
                if (jSONObject4.length() == 0) break block14;
                string2.put("data", object);
            }
            Bundle bundle3 = bundle;
            Builder builder = this;
            Bundle bundle4 = bundle;
            Builder builder2 = this;
            Bundle bundle5 = bundle;
            JSONObject jSONObject7 = jSONObject;
            JSONObject jSONObject8 = jSONObject7;
            JSONObject jSONObject9 = jSONObject7;
            string2.put("msgId", (Object)this.a.getString("msgId"));
            jSONObject8.put("msgContent", (Object)string2);
            bundle5.putByteArray("message_body", jSONObject9.toString().getBytes(k.a));
            bundle4.putString("to", builder2.a.getString("to"));
            bundle3.putString("message_type", builder.a.getString("message_type"));
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            if (string2 != null) {
                Builder builder = this;
                builder.b.put(string2, string3);
                return builder;
            }
            throw new IllegalArgumentException("add data failed, key is null.");
        }

        public Builder setData(Map<String, String> object) {
            this.b.clear();
            object = object.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)object.next();
                entry = entry2.getKey();
                this.b.put((String)((Object)entry), (String)entry2.getValue());
            }
            return this;
        }

        public Builder clearData() {
            Builder builder = this;
            builder.b.clear();
            return builder;
        }

        public Builder setMessageId(String string2) {
            Builder builder = this;
            builder.a.putString("msgId", string2);
            return builder;
        }

        public Builder setMessageType(String string2) {
            Builder builder = this;
            builder.a.putString("message_type", string2);
            return builder;
        }

        public Builder setTtl(int n10) {
            if (n10 >= 1 && n10 <= 1296000) {
                Builder builder = this;
                builder.a.putInt("ttl", n10);
                return builder;
            }
            throw new IllegalArgumentException("ttl must be greater than or equal to 1 and less than or equal to 1296000");
        }

        public Builder setCollapseKey(String string2) {
            Builder builder = this;
            builder.a.putString("collapseKey", string2);
            return builder;
        }

        public Builder setSendMode(int n10) {
            if (n10 != 0 && n10 != 1) {
                throw new IllegalArgumentException("send mode can only be 0 or 1.");
            }
            Builder builder = this;
            builder.a.putInt("sendMode", n10);
            return builder;
        }

        public Builder setReceiptMode(int n10) {
            if (n10 != 1 && n10 != 0) {
                throw new IllegalArgumentException("receipt mode can only be 0 or 1.");
            }
            Builder builder = this;
            builder.a.putInt("receiptMode", n10);
            return builder;
        }
    }

    public static class Notification
    implements Serializable {
        private final String a;
        private final String b;
        private final String[] c;
        private final String d;
        private final String e;
        private final String[] f;
        private final String g;
        private final String h;
        private final String i;
        private final String j;
        private final String k;
        private final String l;
        private final String m;
        private final Uri n;
        private final int o;
        private final String p;
        private final int q;
        private final int r;
        private final int s;
        private final int[] t;
        private final String u;
        private final int v;
        private final String w;
        private final int x;
        private final String y;
        private final String z;
        private final long[] A;
        private final String B;

        private Notification(Bundle bundle) {
            this.a = bundle.getString("notifyTitle");
            this.d = bundle.getString("content");
            this.b = bundle.getString("title_loc_key");
            this.e = bundle.getString("body_loc_key");
            this.c = bundle.getStringArray("title_loc_args");
            this.f = bundle.getStringArray("body_loc_args");
            this.g = bundle.getString("icon");
            this.j = bundle.getString("color");
            this.h = bundle.getString("sound");
            this.i = bundle.getString("tag");
            this.m = bundle.getString("channelId");
            this.k = bundle.getString("acn");
            this.l = bundle.getString("intentUri");
            this.o = bundle.getInt("notifyId");
            String string2 = bundle.getString("url");
            string2 = !TextUtils.isEmpty((CharSequence)string2) ? Uri.parse((String)string2) : null;
            this.n = string2;
            this.p = bundle.getString("notifyIcon");
            this.q = bundle.getInt("defaultLightSettings");
            this.r = bundle.getInt("defaultSound");
            this.s = bundle.getInt("defaultVibrateTimings");
            this.t = bundle.getIntArray("lightSettings");
            this.u = bundle.getString("when");
            this.v = bundle.getInt("localOnly");
            this.w = bundle.getString("badgeSetNum", null);
            this.x = bundle.getInt("autoCancel");
            this.y = bundle.getString("priority", null);
            this.z = bundle.getString("ticker");
            this.A = bundle.getLongArray("vibrateTimings");
            this.B = bundle.getString("visibility", null);
        }

        private Integer a(String string2) {
            Serializable serializable = null;
            if (string2 != null) {
                try {
                    serializable = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    HMSLog.w("RemoteMessage", "NumberFormatException: get " + string2 + " failed.");
                }
            }
            return serializable;
        }

        public /* synthetic */ Notification(Bundle bundle, a a10) {
            this(bundle);
        }

        public String getTitle() {
            return this.a;
        }

        public String getTitleLocalizationKey() {
            return this.b;
        }

        public String[] getTitleLocalizationArgs() {
            String[] stringArray = stringArray.c;
            return stringArray.c == null ? new String[]{} : (String[])stringArray.clone();
        }

        public String getBody() {
            return this.d;
        }

        public String getBodyLocalizationKey() {
            return this.e;
        }

        public String[] getBodyLocalizationArgs() {
            String[] stringArray = stringArray.f;
            return stringArray.f == null ? new String[]{} : (String[])stringArray.clone();
        }

        public String getIcon() {
            return this.g;
        }

        public Uri getImageUrl() {
            String string2 = ((Notification)((Object)string2)).p;
            return string2 == null ? null : Uri.parse((String)string2);
        }

        public String getSound() {
            return this.h;
        }

        public String getTag() {
            return this.i;
        }

        public String getColor() {
            return this.j;
        }

        public String getClickAction() {
            return this.k;
        }

        public String getIntentUri() {
            return this.l;
        }

        public String getChannelId() {
            return this.m;
        }

        public Uri getLink() {
            return this.n;
        }

        public int getNotifyId() {
            return this.o;
        }

        public boolean isDefaultLight() {
            return this.q == 1;
        }

        public boolean isDefaultSound() {
            return this.r == 1;
        }

        public boolean isDefaultVibrate() {
            return this.s == 1;
        }

        public Long getWhen() {
            Long l10 = null;
            if (!TextUtils.isEmpty((CharSequence)this.u)) {
                try {
                    l10 = DateUtil.parseUtcToMillisecond(this.u);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    HMSLog.w("RemoteMessage", "StringIndexOutOfBoundsException: parse when failed.");
                }
                catch (ParseException parseException) {
                    HMSLog.w("RemoteMessage", "ParseException: parse when failed.");
                }
            }
            return l10;
        }

        public int[] getLightSettings() {
            Object object = ((Notification)object).t;
            return ((Notification)object).t == null ? new int[]{} : (int[])object.clone();
        }

        public boolean isLocalOnly() {
            return this.v == 1;
        }

        public Integer getBadgeNumber() {
            Notification notification = this;
            return notification.a(notification.w);
        }

        public boolean isAutoCancel() {
            return this.x == 1;
        }

        public Integer getImportance() {
            Notification notification = this;
            return notification.a(notification.y);
        }

        public String getTicker() {
            return this.z;
        }

        public long[] getVibrateConfig() {
            Object object = ((Notification)object).A;
            return ((Notification)object).A == null ? new long[]{} : (long[])object.clone();
        }

        public Integer getVisibility() {
            Notification notification = this;
            return notification.a(notification.B);
        }
    }
}

