/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.msp.push.encrypt;

import com.heytap.msp.push.encrypt.BaseNCodec;
import d.a.a.a.n.p;
import java.math.BigInteger;

public class Base64
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    public static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int MASK_6BITS = 63;
    private final byte[] encodeTable;
    private final byte[] decodeTable;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;
    private int bitWorkArea;

    public Base64() {
        this(0);
    }

    public Base64(boolean bl) {
        this(76, CHUNK_SEPARATOR, bl);
    }

    public Base64(int n10) {
        this(n10, CHUNK_SEPARATOR);
    }

    public Base64(int n10, byte[] byArray) {
        this(n10, byArray, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Base64(int n10, byte[] byArray, boolean bl) {
        int n11 = 3;
        int n12 = 4;
        int n13 = byArray == null ? 0 : byArray.length;
        super(n11, n12, n10, n13);
        ((Base64)((Object)string2)).decodeTable = DECODE_TABLE;
        if (byArray != null) {
            if (((BaseNCodec)((Object)string2)).containsAlphabetOrPad(byArray)) {
                String string2 = p.f(byArray);
                throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + (String)string2 + "]");
            }
            if (n10 > 0) {
                ((Base64)((Object)string2)).encodeSize = byArray.length + 4;
                byte[] byArray2 = new byte[byArray.length];
                ((Base64)((Object)string2)).lineSeparator = byArray2;
                int n14 = byArray.length;
                System.arraycopy(byArray, 0, byArray2, 0, n14);
            } else {
                Base64 base64 = string2;
                base64.encodeSize = 4;
                base64.lineSeparator = null;
            }
        } else {
            Base64 base64 = string2;
            base64.encodeSize = 4;
            base64.lineSeparator = null;
        }
        ((Base64)((Object)string2)).decodeSize = ((Base64)((Object)string2)).encodeSize - 1;
        byte[] byArray3 = bl ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
        ((Base64)((Object)string2)).encodeTable = byArray3;
    }

    public static boolean isArrayByteBase64(byte[] byArray) {
        return Base64.isBase64(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isBase64(byte by) {
        if (by == 61) return true;
        if (by < 0) return false;
        byte[] byArray = DECODE_TABLE;
        if (by >= DECODE_TABLE.length) return false;
        if (byArray[by] == -1) return false;
        return true;
    }

    public static boolean isBase64(String string2) {
        return Base64.isBase64(p.g(string2));
    }

    public static boolean isBase64(byte[] byArray) {
        for (int i10 = 0; i10 < byArray.length; ++i10) {
            if (Base64.isBase64(byArray[i10]) || BaseNCodec.isWhiteSpace(byArray[i10])) continue;
            return false;
        }
        return true;
    }

    public static byte[] encodeBase64(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    public static String encodeBase64String(byte[] byArray) {
        return p.f(Base64.encodeBase64(byArray, false));
    }

    public static byte[] encodeBase64URLSafe(byte[] byArray) {
        return Base64.encodeBase64(byArray, false, true);
    }

    public static String encodeBase64URLSafeString(byte[] byArray) {
        return p.f(Base64.encodeBase64(byArray, false, true));
    }

    public static byte[] encodeBase64Chunked(byte[] byArray) {
        return Base64.encodeBase64(byArray, true);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl) {
        return Base64.encodeBase64(byArray, bl, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2) {
        return Base64.encodeBase64(byArray, bl, bl2, Integer.MAX_VALUE);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2, int n10) {
        if (byArray != null && byArray.length != 0) {
            Base64 base64;
            if (bl) {
                Base64 base642;
                base64 = base642;
                base642 = new Base64(bl2);
            } else {
                Base64 base643;
                base64 = base643;
                base643 = new Base64(0, CHUNK_SEPARATOR, bl2);
            }
            long l10 = base64.getEncodedLength(byArray);
            if (l10 <= (long)n10) {
                return base64.encode(byArray);
            }
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + l10 + ") than the specified maximum size of " + n10);
        }
        return byArray;
    }

    public static byte[] decodeBase64(String string2) {
        return new Base64().decode(string2);
    }

    public static byte[] decodeBase64(byte[] byArray) {
        return new Base64().decode(byArray);
    }

    public static BigInteger decodeInteger(byte[] byArray) {
        return new BigInteger(1, Base64.decodeBase64(byArray));
    }

    public static byte[] encodeInteger(BigInteger bigInteger) {
        if (bigInteger != null) {
            return Base64.encodeBase64(Base64.toIntegerBytes(bigInteger), false);
        }
        throw new NullPointerException("encodeInteger called with null parameter");
    }

    public static byte[] toIntegerBytes(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger;
        int n10 = bigInteger2.bitLength() + 7 >> 3 << 3;
        byte[] byArray = bigInteger2.toByteArray();
        if (bigInteger2.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n10 / 8) {
            return byArray;
        }
        int n11 = 0;
        int n12 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n11 = 1;
            --n12;
        }
        int n13 = n10 / 8;
        n10 = n13 - n12;
        byte[] byArray2 = new byte[n13];
        System.arraycopy(byArray, n11, byArray2, n10, n12);
        return byArray2;
    }

    public boolean isUrlSafe() {
        return this.encodeTable == URL_SAFE_ENCODE_TABLE;
    }

    @Override
    public void encode(byte[] byArray, int n10, int n11) {
        if (this.eof) {
            return;
        }
        if (n11 < 0) {
            this.eof = true;
            if (this.modulus == 0 && this.lineLength == 0) {
                return;
            }
            Base64 base64 = this;
            base64.ensureBufferSize(base64.encodeSize);
            int n12 = base64.pos;
            n10 = base64.modulus;
            if (n10 != 1) {
                if (n10 == 2) {
                    int n13;
                    Base64 base642 = this;
                    byte[] byArray2 = base642.buffer;
                    base642.pos = n11 = n12 + 1;
                    byte[] byArray3 = base642.encodeTable;
                    int n14 = this.bitWorkArea;
                    byArray2[n12] = byArray3[n14 >> 10 & 0x3F];
                    this.pos = n11;
                    byArray2[n11++] = byArray3[n14 >> 4 & 0x3F];
                    this.pos = n13 = n11 + 1;
                    byArray2[n11] = byArray3[n14 << 2 & 0x3F];
                    if (base642.encodeTable == STANDARD_ENCODE_TABLE) {
                        this.pos = n13 + 1;
                        byArray2[n13] = 61;
                    }
                }
            } else {
                Base64 base643 = this;
                byte[] byArray4 = base643.buffer;
                base643.pos = n11 = n12 + 1;
                byte[] byArray5 = base643.encodeTable;
                int n15 = this.bitWorkArea;
                byArray4[n12] = byArray5[n15 >> 2 & 0x3F];
                this.pos = n11;
                byArray4[n11++] = byArray5[n15 << 4 & 0x3F];
                if (base643.encodeTable == STANDARD_ENCODE_TABLE) {
                    int n16;
                    this.pos = n16 = n11 + 1;
                    byArray4[n11] = 61;
                    this.pos = n16 + 1;
                    byArray4[n16] = 61;
                }
            }
            Base64 base644 = this;
            int n17 = this.pos;
            base644.currentLinePos = n12 = base644.currentLinePos + (n17 - n12);
            if (base644.lineLength > 0 && n12 > 0) {
                Base64 base645 = this;
                byte[] byArray6 = this.buffer;
                n11 = base645.lineSeparator.length;
                System.arraycopy(base645.lineSeparator, 0, byArray6, n17, n11);
                base645.pos += this.lineSeparator.length;
            }
        } else {
            for (int i10 = 0; i10 < n11; ++i10) {
                int n18;
                int n19;
                Base64 base64 = this;
                base64.ensureBufferSize(base64.encodeSize);
                base64.modulus = n19 = (base64.modulus + 1) % 3;
                int n20 = byArray[n10++];
                if (n20 < 0) {
                    n20 += 256;
                }
                int n21 = n19;
                this.bitWorkArea = n19 = (this.bitWorkArea << 8) + n20;
                if (n21 != 0) continue;
                Base64 base646 = this;
                byte[] byArray7 = base646.buffer;
                Base64 base647 = this;
                int n22 = base647.pos;
                base647.pos = n18 = n22 + 1;
                byte[] byArray8 = base647.encodeTable;
                int n23 = n19;
                int n24 = n19;
                int n25 = n19;
                byArray7[n22] = byArray8[n19 >> 18 & 0x3F];
                this.pos = n19 = n18 + 1;
                byArray7[n18] = byArray8[n25 >> 12 & 0x3F];
                this.pos = n22 = n19 + 1;
                byArray7[n19] = byArray8[n24 >> 6 & 0x3F];
                this.pos = n19 = n22 + 1;
                base646.buffer[n22] = base647.encodeTable[n23 & 0x3F];
                base646.currentLinePos = n22 = base646.currentLinePos + 4;
                n18 = base646.lineLength;
                if (n18 <= 0 || n18 > n22) continue;
                Base64 base648 = this;
                n22 = base648.lineSeparator.length;
                System.arraycopy(base648.lineSeparator, 0, byArray7, n19, n22);
                base648.pos += this.lineSeparator.length;
                base648.currentLinePos = 0;
            }
        }
    }

    @Override
    public void decode(byte[] byArray, int n10, int n11) {
        int n12;
        if (this.eof) {
            return;
        }
        if (n11 < 0) {
            this.eof = true;
        }
        for (n12 = 0; n12 < n11; ++n12) {
            int n13;
            int n14;
            Base64 base64 = this;
            base64.ensureBufferSize(base64.decodeSize);
            int n15 = byArray[n10++];
            if (n15 == 61) {
                this.eof = true;
                break;
            }
            if (n15 < 0) continue;
            byte[] byArray2 = DECODE_TABLE;
            if (n15 >= DECODE_TABLE.length || (n15 = byArray2[n15]) < 0) continue;
            this.modulus = n14 = (this.modulus + 1) % 4;
            this.bitWorkArea = n15 = (this.bitWorkArea << 6) + n15;
            if (n14 != 0) continue;
            byte[] byArray3 = this.buffer;
            int n16 = this.pos;
            this.pos = n13 = n16 + 1;
            byArray3[n16] = (byte)(n15 >> 16 & 0xFF);
            this.pos = n16 = n13 + 1;
            byArray3[n13] = (byte)(n15 >> 8 & 0xFF);
            this.pos = n16 + 1;
            this.buffer[n16] = (byte)(n15 & 0xFF);
        }
        if (this.eof && this.modulus != 0) {
            Base64 base64 = this;
            base64.ensureBufferSize(base64.decodeSize);
            int n17 = base64.modulus;
            if (n17 != 2) {
                if (n17 == 3) {
                    Base64 base642 = this;
                    base642.bitWorkArea = n17 = base642.bitWorkArea >> 2;
                    byte[] byArray4 = base642.buffer;
                    n11 = this.pos;
                    this.pos = n12 = n11 + 1;
                    byArray4[n11] = (byte)(n17 >> 8 & 0xFF);
                    this.pos = n12 + 1;
                    base642.buffer[n12] = (byte)(n17 & 0xFF);
                }
            } else {
                Base64 base643 = this;
                base643.bitWorkArea = n17 = base643.bitWorkArea >> 4;
                int n18 = this.pos;
                this.pos = n18 + 1;
                base643.buffer[n18] = (byte)(n17 & 0xFF);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInAlphabet(byte by) {
        if (by < 0) return false;
        Object object = ((Base64)object).decodeTable;
        if (by >= ((Base64)object).decodeTable.length) return false;
        if (object[by] == -1) return false;
        return true;
    }
}

