/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.view.KeyEvent;
import com.huawei.hms.activity.IBridgeActivityDelegate;
import com.huawei.hms.api.BindingFailedResolveMgr;
import com.huawei.hms.api.FailedBinderCallBack;
import com.huawei.hms.common.internal.BindResolveClients;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.ui.AbstractDialog;
import com.huawei.hms.ui.AbstractPromptDialog;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.ResourceLoaderUtil;
import com.huawei.hms.utils.UIUtil;
import com.huawei.hms.utils.Util;

public class BindingFailedResolution
implements IBridgeActivityDelegate,
ServiceConnection {
    private static final String TAG = "BindingFailedResolution";
    private static final int REQUEST_CODE = 2003;
    private static final int MSG_CONN_TIMEOUT = 2;
    private static final int MSG_SELF_DESTROY_TIMEOUT = 3;
    private static final Object LOCK_CONNECT_TIMEOUT_HANDLER = new Object();
    private Activity curActivity;
    private boolean isStarting = true;
    private d promptdlg;
    private FailedBinderCallBack.BinderCallBack callBack;
    private Handler mConnectTimeoutHandler = null;
    private Handler selfDestroyHandler = null;

    private void selfDestroyHandle() {
        Handler handler = this.selfDestroyHandler;
        if (handler != null) {
            handler.removeMessages(3);
        } else {
            Handler.Callback callback;
            Handler handler2;
            handler = handler2;
            Looper looper = Looper.getMainLooper();
            Handler.Callback callback2 = callback;
            callback = new Handler.Callback(){

                public boolean handleMessage(Message message) {
                    if (message != null && message.what == 3) {
                        a a10 = this;
                        HMSLog.i(BindingFailedResolution.TAG, "selfDestroyHandle\uff1aMSG_SELF_DESTROY_TIMEOUT");
                        a10.BindingFailedResolution.this.noticeBindFailed();
                        a10.BindingFailedResolution.this.finishBridgeActivity(8);
                        return true;
                    }
                    return false;
                }
            };
            handler2 = new Handler(looper, callback2);
            this.selfDestroyHandler = handler;
        }
        this.selfDestroyHandler.sendEmptyMessageDelayed(3, 4000L);
    }

    private void tryStartHmsActivity(Activity activity) {
        Intent intent;
        Intent intent2 = intent;
        intent2();
        intent2.putExtra("intent.extra.isfullscreen", UIUtil.isActivityFullscreen(activity));
        intent.setClassName(HMSPackageManager.getInstance(activity.getApplicationContext()).getHMSPackageNameForMultiService(), "com.huawei.hms.core.activity.JumpActivity");
        HMSLog.i(TAG, "onBridgeActivityCreate\uff1atry to start HMS");
        try {
            activity.startActivityForResult(intent2, this.getRequestCode());
        }
        catch (Throwable throwable) {
            HMSLog.e(TAG, "ActivityNotFoundException\uff1a" + throwable.getMessage());
            Handler handler = this.selfDestroyHandler;
            if (handler != null) {
                handler.removeMessages(3);
                this.selfDestroyHandler = null;
            }
            this.bindCoreService(false);
        }
    }

    private void fireStartResult(boolean bl) {
        if (this.isStarting) {
            this.isStarting = false;
            this.onStartResult(bl);
        }
    }

    private void noticeBindFailed() {
        FailedBinderCallBack.BinderCallBack binderCallBack = ((BindingFailedResolution)((Object)binderCallBack)).callBack;
        if (binderCallBack != null) {
            binderCallBack.binderCallBack(8);
        }
    }

    private void noticeBindResult(boolean bl, int n10) {
        if (bl && (this = ((BindingFailedResolution)this).callBack) != null) {
            this.binderCallBack(n10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bindCoreService(boolean bl) {
        BindingFailedResolution bindingFailedResolution;
        BindingFailedResolution bindingFailedResolution2;
        Intent intent;
        Activity activity = this.getActivity();
        if (activity == null) {
            BindingFailedResolution bindingFailedResolution3 = this;
            HMSLog.e(TAG, "In connect, bind core try fail");
            bindingFailedResolution3.fireStartResult(false);
            bindingFailedResolution3.noticeBindResult(bl, 8);
            return;
        }
        Intent intent2 = intent;
        intent2(HMSPackageManager.getInstance(activity.getApplicationContext()).getServiceAction());
        try {
            intent2.setPackage(HMSPackageManager.getInstance(activity.getApplicationContext()).getHMSPackageNameForMultiService());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BindingFailedResolution bindingFailedResolution4 = this;
            HMSLog.e(TAG, "IllegalArgumentException when bindCoreService intent.setPackage");
            bindingFailedResolution4.fireStartResult(false);
            bindingFailedResolution4.noticeBindResult(bl, 8);
            return;
        }
        Object object = LOCK_CONNECT_TIMEOUT_HANDLER;
        synchronized (object) {
            if (activity.bindService(intent, (ServiceConnection)this, 1)) {
                this.postConnDelayHandle();
                return;
            }
            BindingFailedResolution bindingFailedResolution5 = this;
            bindingFailedResolution2 = bindingFailedResolution5;
            bindingFailedResolution = bindingFailedResolution5;
        }
        HMSLog.e(TAG, "In connect, bind core try fail");
        bindingFailedResolution2.fireStartResult(false);
        bindingFailedResolution.noticeBindResult(bl, 8);
    }

    private void finishBridgeActivity(int n10) {
        Activity activity = bindingFailedResolution2.getActivity();
        if (activity != null && !activity.isFinishing()) {
            Intent intent;
            Activity activity2 = activity;
            BindingFailedResolution bindingFailedResolution = bindingFailedResolution2;
            HMSLog.i(TAG, "finishBridgeActivity\uff1a" + n10);
            BindingFailedResolution bindingFailedResolution2 = intent;
            new Intent().putExtra("intent.extra.RESULT", n10);
            activity.setResult(-1, (Intent)bindingFailedResolution2);
            Util.unBindServiceCatchException((Context)activity2, bindingFailedResolution);
            activity2.finish();
            return;
        }
    }

    private void postConnDelayHandle() {
        Handler handler = this.mConnectTimeoutHandler;
        if (handler != null) {
            handler.removeMessages(2);
        } else {
            Handler.Callback callback;
            Handler handler2;
            handler = handler2;
            Looper looper = Looper.getMainLooper();
            Handler.Callback callback2 = callback;
            callback = new Handler.Callback(){

                public boolean handleMessage(Message message) {
                    if (message != null && message.what == 2) {
                        HMSLog.e(BindingFailedResolution.TAG, "In connect, bind core try timeout");
                        BindingFailedResolution.this.fireStartResult(false);
                        return true;
                    }
                    return false;
                }
            };
            handler2 = new Handler(looper, callback2);
            this.mConnectTimeoutHandler = handler;
        }
        this.mConnectTimeoutHandler.sendEmptyMessageDelayed(2, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelConnDelayHandle() {
        Object object = LOCK_CONNECT_TIMEOUT_HANDLER;
        synchronized (object) {
            Handler handler = this.mConnectTimeoutHandler;
            if (handler != null) {
                handler.removeMessages(2);
                this.mConnectTimeoutHandler = null;
            }
            return;
        }
    }

    private void showPromptdlg() {
        Object object = this.getActivity();
        if (object != null && !object.isFinishing()) {
            AbstractDialog.Callback callback;
            d d10 = this.promptdlg;
            if (d10 == null) {
                d d11;
                d10 = d11;
                d11 = new d(null);
                this.promptdlg = d10;
            } else {
                d10.dismiss();
            }
            HMSLog.i(TAG, "showPromptdlg to resolve conn error");
            Activity activity = object;
            object = callback;
            callback = new AbstractDialog.Callback(){

                @Override
                public void onDoWork(AbstractDialog abstractDialog) {
                    c c10 = this;
                    BindingFailedResolution.access$402(c10.BindingFailedResolution.this, null);
                    BindResolveClients.getInstance().unRegisterAll();
                    c10.BindingFailedResolution.this.finishBridgeActivity(8);
                }

                @Override
                public void onCancel(AbstractDialog abstractDialog) {
                    c c10 = this;
                    BindingFailedResolution.access$402(c10.BindingFailedResolution.this, null);
                    BindResolveClients.getInstance().unRegisterAll();
                    c10.BindingFailedResolution.this.finishBridgeActivity(8);
                }
            };
            this.promptdlg.show(activity, (AbstractDialog.Callback)object);
            return;
        }
    }

    public static /* synthetic */ d access$402(BindingFailedResolution bindingFailedResolution, d d10) {
        bindingFailedResolution.promptdlg = d10;
        return d10;
    }

    @Override
    public void onBridgeActivityCreate(Activity activity) {
        Intent intent = activity.getIntent();
        if (intent != null && intent.hasExtra("callId")) {
            long l10 = 0L;
            try {
                l10 = intent.getLongExtra("callId", 0L);
            }
            catch (Exception exception) {
                HMSLog.e(TAG, "getExtras for callId exception:" + exception.getMessage());
            }
            this.callBack = FailedBinderCallBack.getInstance().getCallBack(l10);
        }
        this.curActivity = activity;
        BindingFailedResolveMgr.b.a(activity);
        this.selfDestroyHandle();
        this.tryStartHmsActivity(activity);
    }

    @Override
    public void onBridgeActivityDestroy() {
        this.cancelConnDelayHandle();
        BindingFailedResolveMgr.b.b(this.curActivity);
        this.curActivity = null;
    }

    @Override
    public boolean onBridgeActivityResult(int n10, int n11, Intent intent) {
        if (n10 != this.getRequestCode()) {
            return false;
        }
        HMSLog.i(TAG, "onBridgeActivityResult");
        Handler handler = this.selfDestroyHandler;
        if (handler != null) {
            handler.removeMessages(3);
            this.selfDestroyHandler = null;
        }
        this.bindCoreService(true);
        return true;
    }

    @Override
    public void onBridgeConfigurationChanged() {
        if (this.promptdlg == null) {
            return;
        }
        HMSLog.i(TAG, "re show prompt dialog");
        this.showPromptdlg();
    }

    @Override
    public int getRequestCode() {
        return 2003;
    }

    @Override
    public void onKeyUp(int n10, KeyEvent keyEvent) {
        HMSLog.i(TAG, "On key up when resolve conn error");
    }

    public Activity getActivity() {
        return this.curActivity;
    }

    public void onStartResult(boolean bl) {
        if (this.getActivity() == null) {
            return;
        }
        if (bl) {
            this.finishBridgeActivity(0);
            return;
        }
        this.showPromptdlg();
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        BindingFailedResolution bindingFailedResolution = this;
        bindingFailedResolution.cancelConnDelayHandle();
        bindingFailedResolution.fireStartResult(true);
        if (bindingFailedResolution.getActivity() == null) {
            return;
        }
        HMSLog.i(TAG, "test connect success, try to reConnect and reply message");
        BindResolveClients.getInstance().notifyClientReconnect();
    }

    public void onServiceDisconnected(ComponentName componentName) {
    }

    public static class d
    extends AbstractPromptDialog {
        private d() {
        }

        public /* synthetic */ d(a a10) {
            this();
        }

        @Override
        public String onGetMessageString(Context object) {
            Context context = object;
            String string2 = Util.getAppName(context, null);
            object = Util.getAppName(context, HMSPackageManager.getInstance(context).getHMSPackageNameForMultiService());
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = object;
            return ResourceLoaderUtil.getString("hms_bindfaildlg_message", objectArray2);
        }

        @Override
        public String onGetPositiveButtonString(Context context) {
            return ResourceLoaderUtil.getString("hms_confirm");
        }
    }
}

