/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.data;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.huawei.hms.common.data.DataHolder;
import com.huawei.hms.common.internal.Objects;
import com.huawei.hms.common.internal.Preconditions;

public class DataBufferRef {
    public final DataHolder mDataHolder;
    public int mDataRow;
    private int a;

    public DataBufferRef(DataHolder dataHolder, int n10) {
        Preconditions.checkNotNull(dataHolder, "dataHolder cannot be null");
        this.mDataHolder = dataHolder;
        this.getWindowIndex(n10);
    }

    public int getDataRow() {
        return this.mDataRow;
    }

    public final void getWindowIndex(int n10) {
        Preconditions.checkArgument(n10 >= 0 && n10 < this.mDataHolder.getCount(), "rowNum is out of index");
        this.mDataRow = n10;
        this.a = this.mDataHolder.getWindowIndex(n10);
    }

    public boolean isDataValid() {
        return this.mDataHolder.isClosed() ^ true;
    }

    public boolean hasColumn(String string2) {
        return this.mDataHolder.hasColumn(string2);
    }

    public long getLong(String string2) {
        DataBufferRef dataBufferRef = this;
        int n10 = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string2, n10, dataBufferRef.a, "type_long");
        if (object != null) {
            return (Long)object;
        }
        return -1L;
    }

    public int getInteger(String string2) {
        DataBufferRef dataBufferRef = this;
        int n10 = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string2, n10, dataBufferRef.a, "type_int");
        if (object != null) {
            return (Integer)object;
        }
        return -1;
    }

    public boolean getBoolean(String string2) {
        DataBufferRef dataBufferRef = this;
        int n10 = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string2, n10, dataBufferRef.a, "type_boolean");
        if (object != null) {
            return (Boolean)object;
        }
        return false;
    }

    public String getString(String string2) {
        DataBufferRef dataBufferRef = this;
        int n10 = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string2, n10, dataBufferRef.a, "type_string");
        if (object != null) {
            return (String)object;
        }
        return "";
    }

    public float getFloat(String string2) {
        DataBufferRef dataBufferRef = this;
        int n10 = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string2, n10, dataBufferRef.a, "type_float");
        if (object != null) {
            return ((Float)object).floatValue();
        }
        return -1.0f;
    }

    public double getDouble(String string2) {
        DataBufferRef dataBufferRef = this;
        int n10 = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string2, n10, dataBufferRef.a, "type_double");
        if (object != null) {
            return (Double)object;
        }
        return -1.0;
    }

    public byte[] getByteArray(String string2) {
        DataBufferRef dataBufferRef = this;
        int n10 = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string2, n10, dataBufferRef.a, "type_byte_array");
        if (object != null) {
            return (byte[])object;
        }
        return null;
    }

    public Uri parseUri(String string2) {
        DataBufferRef dataBufferRef = this;
        int n10 = dataBufferRef.mDataRow;
        String string3 = (String)this.mDataHolder.getValue(string2, n10, dataBufferRef.a, "type_string");
        if (string3 == null) {
            return null;
        }
        return Uri.parse((String)string3);
    }

    public void copyToBuffer(String string2, CharArrayBuffer charArrayBuffer) {
        DataBufferRef dataBufferRef = this;
        int n10 = dataBufferRef.mDataRow;
        this.mDataHolder.copyToBuffer(string2, n10, dataBufferRef.a, charArrayBuffer);
    }

    public boolean hasNull(String string2) {
        DataBufferRef dataBufferRef = this;
        int n10 = dataBufferRef.mDataRow;
        return this.mDataHolder.hasNull(string2, n10, dataBufferRef.a);
    }

    public int hashCode() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mDataRow;
        objectArray2[1] = this.a;
        objectArray[2] = this.mDataHolder;
        return Objects.hashCode(objectArray);
    }

    public boolean equals(Object object) {
        if (object instanceof DataBufferRef) {
            object = (DataBufferRef)object;
            return ((DataBufferRef)object).mDataRow == this.mDataRow && ((DataBufferRef)object).a == this.a && ((DataBufferRef)object).mDataHolder == this.mDataHolder;
        }
        return false;
    }
}

