/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.text.TextUtils;
import com.huawei.hms.framework.common.StringUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;

public class ExceptionCode {
    public static final int CRASH_EXCEPTION = 10000000;
    public static final int CANCEL = 10000100;
    public static final int NETWORK_TIMEOUT = 10000101;
    public static final int NETWORK_UNSUPPORTED = 10000102;
    public static final int NETWORK_UNREACHABLE = 10000200;
    public static final int NETWORK_CHANGED = 10000201;
    public static final int SHUTDOWN_EXCEPTION = 10000202;
    public static final int UNABLE_TO_RESOLVE_HOST = 10000300;
    public static final int ROUTE_FAILED = 10000301;
    public static final int SOCKET_CONNECT_TIMEOUT = 10000400;
    public static final int CONNECTION_RESET = 0x989811;
    public static final int CONNECTION_ABORT = 10000402;
    public static final int CONNECT_FAILED = 10000403;
    public static final int CONNECTION_REFUSED = 10000404;
    public static final int INTERRUPT_CONNECT_CLOSE = 10000405;
    public static final int SOCKET_CLOSE = 10000406;
    public static final int SSL_PROTOCOL_EXCEPTION = 10000500;
    public static final int SSL_HANDSHAKE_EXCEPTION = 10000501;
    public static final int SSL_PEERUNVERIFIED_EXCEPTION = 10000502;
    public static final int SOCKET_READ_TIMEOUT = 0x9898D8;
    public static final int READ_ERROR = 0x9898D9;
    public static final int SOCKET_WRITE_TIMEOUT = 10000700;
    public static final int UNEXPECTED_EOF = 10000800;
    public static final int PROTOCOL_ERROR = 10000801;
    public static final int NETWORK_IO_EXCEPTION = 10000802;
    public static final int SOCKET_TIMEOUT = 10000803;
    public static final int INTERRUPT_EXCEPTION = 10000804;
    private static final String CONNECT = "connect";
    private static final String READ = "read";
    private static final String WRITE = "write";

    public static int getErrorCodeFromException(Exception exception) {
        if (exception == null) {
            return 10000802;
        }
        if (!(exception instanceof IOException)) {
            return 10000000;
        }
        String string = exception.getMessage();
        if (string == null) {
            return 10000802;
        }
        int n10 = ExceptionCode.getErrorCodeFromMsg(string = StringUtils.toLowerCase(string));
        if (n10 != 10000802) {
            return n10;
        }
        if (exception instanceof SocketTimeoutException) {
            return ExceptionCode.getErrorCodeSocketTimeout(exception);
        }
        if (exception instanceof ConnectException) {
            return 10000403;
        }
        if (exception instanceof NoRouteToHostException) {
            return 10000301;
        }
        if (exception instanceof SSLProtocolException) {
            return 10000500;
        }
        if (exception instanceof SSLHandshakeException) {
            return 10000501;
        }
        if (exception instanceof SSLPeerUnverifiedException) {
            return 10000502;
        }
        if (exception instanceof UnknownHostException) {
            return 10000300;
        }
        if (exception instanceof InterruptedIOException) {
            if (string.contains("connection has been shut down")) {
                return 10000405;
            }
            return 10000804;
        }
        if (exception instanceof ProtocolException) {
            return 10000801;
        }
        return n10;
    }

    private static int getErrorCodeSocketTimeout(Exception object) {
        object = ExceptionCode.checkExceptionContainsKey((Exception)object, CONNECT, READ, WRITE);
        ((String)object).hashCode();
        int n10 = -1;
        switch (((String)object).hashCode()) {
            default: {
                break;
            }
            case 951351530: {
                if (!((String)object).equals(CONNECT)) break;
                n10 = 2;
                break;
            }
            case 113399775: {
                if (!((String)object).equals(WRITE)) break;
                n10 = 1;
                break;
            }
            case 3496342: {
                if (!((String)object).equals(READ)) break;
                n10 = 0;
            }
        }
        switch (n10) {
            default: {
                return 10000803;
            }
            case 2: {
                return 10000400;
            }
            case 1: {
                return 10000700;
            }
            case 0: 
        }
        return 0x9898D8;
    }

    private static int getErrorCodeFromMsg(String string) {
        int n10;
        if (string.contains("unexpected end of stream")) {
            n10 = 10000800;
        } else if (string.contains("unable to resolve host")) {
            n10 = 10000300;
        } else if (string.contains("read error")) {
            n10 = 0x9898D9;
        } else if (string.contains("connection reset")) {
            n10 = 0x989811;
        } else if (string.contains("software caused connection abort")) {
            n10 = 10000402;
        } else if (string.contains("failed to connect to")) {
            n10 = 10000403;
        } else if (string.contains("connection refused")) {
            n10 = 10000404;
        } else {
            if (string.contains("connection timed out")) {
                return 10000400;
            }
            n10 = string.contains("no route to host") ? 10000301 : (string.contains("network is unreachable") ? 10000200 : (string.contains("socket closed") ? 10000406 : 10000802));
        }
        return n10;
    }

    private static String checkExceptionContainsKey(Exception exception, String ... stringArray) {
        return ExceptionCode.checkStrContainsKey(StringUtils.toLowerCase(exception.getMessage()), stringArray);
    }

    private static String checkStrContainsKey(String string, String ... stringArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        for (String string2 : stringArray) {
            if (!string.contains(string2)) continue;
            return string2;
        }
        return "";
    }
}

