/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.database.Cursor;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.Logger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class IoUtils {
    private static final int BUFF_SIZE = 4096;
    private static final int MAX_SIZE = 0x1000000;

    private IoUtils() {
    }

    public static void close(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }

    public static void closeSecure(Reader reader) {
        IoUtils.closeSecure((Closeable)reader);
    }

    public static void closeSecure(Writer writer) {
        IoUtils.closeSecure((Closeable)writer);
    }

    public static void closeSecure(InputStream inputStream) {
        IoUtils.closeSecure((Closeable)inputStream);
    }

    public static void closeSecure(OutputStream outputStream) {
        IoUtils.closeSecure((Closeable)outputStream);
    }

    public static void closeSecure(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                Logger.w("IOUtil", "closeSecure IOException", iOException);
            }
        } else {
            Logger.w("IOUtil", "closeable is null");
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n10;
        String string2 = "";
        if (ContextHolder.getAppContext() != null) {
            string2 = ContextHolder.getAppContext().getPackageName();
        }
        byte[] byArray = new byte[4096];
        long l10 = 0L;
        while (-1 != (n10 = inputStream.read(byArray))) {
            if (l10 > 0x1000000L && !"com.huawei.health".equals(string2)) {
                throw new IOException("input data too large for byte.");
            }
            outputStream.write(byArray, 0, n10);
            l10 += (long)n10;
        }
        return l10;
    }

    public static byte[] toByteArray(InputStream closeable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = closeable;
        closeable = byteArrayOutputStream;
        IoUtils.copy(inputStream, new ByteArrayOutputStream());
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }
}

