/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.UserManager;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthNr;
import android.telephony.CellSignalStrengthTdscdma;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.HwTelephonyManager;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.huawei.android.os.BuildEx;
import com.huawei.android.telephony.ServiceStateEx;
import com.huawei.hms.framework.common.ActivityUtil;
import com.huawei.hms.framework.common.ContextCompat;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NetworkUtil {
    private static final String TAG = "NetworkUtil";
    private static final int TYPE_WIFI_P2P = 13;
    private static final int INVALID_RSSI = -127;
    private static final String STR_NSA = "5G_NSA";
    private static final String STR_SA = "5G_SA";
    public static final int UNAVAILABLE = Integer.MAX_VALUE;

    @SuppressLint(value={"MissingPermission"})
    public static NetworkInfo getNetworkInfo(Context context) {
        if (ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            Context context2 = context;
            context = null;
            ConnectivityManager connectivityManager = (ConnectivityManager)ContextCompat.getSystemService(context2, "connectivity");
            if (connectivityManager != null) {
                try {
                    context = connectivityManager.getActiveNetworkInfo();
                }
                catch (RuntimeException runtimeException) {
                    Logger.i(TAG, "getActiveNetworkInfo failed, exception:" + runtimeException.getClass().getSimpleName() + runtimeException.getMessage());
                }
            }
            return context;
        }
        return null;
    }

    public static boolean isNetworkAvailable(Context context) {
        if (ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return (context = NetworkUtil.getNetworkInfo(context)) != null && context.isConnected();
        }
        return true;
    }

    public static int netWork(Context context) {
        int n10 = NetworkUtil.getNetworkType(context);
        Logger.v(TAG, "newWorkType " + n10);
        if (n10 == 4) {
            if (TextUtils.equals((CharSequence)STR_NSA, (CharSequence)NetworkUtil.getNetWorkNSAorSA())) {
                return 7;
            }
            return n10;
        }
        if (n10 == 5) {
            if (TextUtils.equals((CharSequence)STR_SA, (CharSequence)NetworkUtil.getNetWorkNSAorSA())) {
                return 8;
            }
            return n10;
        }
        return n10;
    }

    public static String getNetWorkNSAorSA() {
        String string2 = null;
        HwTelephonyManager hwTelephonyManager = HwTelephonyManager.getDefault();
        HwTelephonyManager hwTelephonyManager2 = hwTelephonyManager;
        int bl = hwTelephonyManager.getDefault4GSlotId();
        String string3 = TAG;
        Logger.v(string3, "phoneId " + bl);
        boolean bl2 = hwTelephonyManager2.isNsaState(bl);
        try {
            Logger.v(string3, "isNsa " + bl2);
            string2 = bl2 ? STR_NSA : STR_SA;
        }
        catch (Throwable throwable) {
            Logger.v(TAG, "isNsaState error");
        }
        return string2;
    }

    public static int getNetworkType(Context context) {
        int n10 = 0;
        if (context != null) {
            n10 = NetworkUtil.getNetworkType(NetworkUtil.getNetworkInfo(context), context);
        }
        return n10;
    }

    @SuppressLint(value={"MissingPermission", "NewApi"})
    private static int getHwNetworkType(Context context) {
        int n10;
        block8: {
            n10 = 0;
            if (!ReflectionUtils.checkCompatible("com.huawei.android.os.BuildEx$VERSION")) {
                return n10;
            }
            if (context != null && (context = (TelephonyManager)ContextCompat.getSystemService(context, "phone")) != null) {
                if (BuildEx.VERSION.EMUI_SDK_INT < 21) break block8;
                context = context.getServiceState();
                if (context == null) break block8;
                try {
                    n10 = ServiceStateEx.getConfigRadioTechnology((ServiceState)context);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    Logger.w(TAG, "NoClassDefFoundError occur in method getHwNetworkType.");
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    Logger.w(TAG, "NoSuchMethodError occur in method getHwNetworkType.");
                }
                catch (SecurityException securityException) {
                    Logger.w(TAG, "requires permission maybe missing.");
                }
            }
        }
        return n10;
    }

    public static int getNetworkType(NetworkInfo networkInfo, Context context) {
        int n10;
        block11: {
            int n11;
            block8: {
                block9: {
                    block10: {
                        block12: {
                            n11 = -1;
                            if (networkInfo == null || !networkInfo.isConnected()) break block8;
                            n11 = networkInfo.getType();
                            if (1 == n11 || 13 == n11) break block9;
                            if (n11 != 0) break block10;
                            int n12 = NetworkUtil.getHwNetworkType(context);
                            Logger.v(TAG, "getHwNetworkType return is: " + n12);
                            if (n12 == 0) {
                                n12 = networkInfo.getSubtype();
                            }
                            if (n12 != 20) {
                                switch (n12) {
                                    default: {
                                        n10 = 0;
                                        break;
                                    }
                                    case 13: {
                                        n10 = 4;
                                        break;
                                    }
                                    case 3: 
                                    case 5: 
                                    case 6: 
                                    case 8: 
                                    case 9: 
                                    case 10: 
                                    case 12: 
                                    case 14: 
                                    case 15: {
                                        n10 = 3;
                                        break;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 4: 
                                    case 7: 
                                    case 11: {
                                        n10 = 2;
                                        break;
                                    }
                                }
                            } else {
                                n10 = 5;
                            }
                            if (n10 != 0 || Build.VERSION.SDK_INT < 25) break block11;
                            if (n12 == 16) break block12;
                            if (n12 != 17) break block10;
                            n10 = 3;
                            break block11;
                        }
                        n10 = 2;
                        break block11;
                    }
                    n10 = 0;
                    break block11;
                }
                n10 = 1;
                break block11;
            }
            n10 = n11;
        }
        return n10;
    }

    public static int getNetworkType(NetworkInfo networkInfo) {
        return NetworkUtil.getNetworkType(networkInfo, null);
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"MissingPermission"})
    private static String[] getDnsServerIpsFromConnectionManager(Context var0) {
        var1_3 = v0;
        v0 = new LinkedList<String>();
        if (Build.VERSION.SDK_INT >= 21 && var0 != null && (var0 = (ConnectivityManager)ContextCompat.getSystemService(var0, "connectivity")) != null) {
            var2_4 = var0.getActiveNetworkInfo();
            ** if (var2_4 == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                var3_5 = var0.getAllNetworks();
                var4_6 = var3_5.length;
                block12: for (var5_7 = 0; var5_7 < var4_6; ++var5_7) {
                    var6_8 = var3_5[var5_7];
                    if (var6_8 == null) continue;
                    var7_9 = var0.getNetworkInfo((Network)var6_8);
                    if (var7_9 == null) continue;
                    if (var7_9.getType() != var2_4.getType()) continue;
                    var6_8 = var0.getLinkProperties((Network)var6_8);
                    if (var6_8 == null) continue;
                    var6_8 = var6_8.getDnsServers().iterator();
                    while (true) {
                        if (!var6_8.hasNext()) continue block12;
                        var1_3.add(((InetAddress)var6_8.next()).getHostAddress());
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
            }
            {
                catch (RuntimeException var0_1) {
                    Logger.i(NetworkUtil.TAG, "getActiveNetworkInfo failed, exception:" + var0_1.getClass().getSimpleName());
                    break;
                }
                catch (SecurityException var0_2) {
                    Logger.i(NetworkUtil.TAG, "getActiveNetworkInfo failed, exception:" + var0_2.getClass().getSimpleName());
                    break;
                }
            }
        }
        if (var1_3.isEmpty()) {
            v1 = new String[]{};
        } else {
            v2 = var1_3;
            v1 = v2.toArray(new String[v2.size()]);
        }
        return v1;
    }

    public static String getDnsServerIps(Context context) {
        return Arrays.toString(NetworkUtil.getDnsServerIpsFromConnectionManager(context));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getMobileRsrp(Context context) {
        int n10 = Integer.MAX_VALUE;
        SignalStrength signalStrength = NetworkUtil.getSignalStrength(context);
        if (signalStrength == null) {
            return n10;
        }
        try {
            if (Build.VERSION.SDK_INT <= 28) return NetworkUtil.getInfoWithReflect(signalStrength, "getDbm");
        }
        catch (Throwable throwable) {
            Logger.i(TAG, "getDbm: throwable:" + throwable.getClass());
            return n10;
        }
        return NetworkUtil.getMobileSingalStrengthUpPPlatfrom(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getLteRsrq(Context context) {
        int n10 = Integer.MAX_VALUE;
        Object object = NetworkUtil.getSignalStrength(context);
        if (object == null) {
            return n10;
        }
        if (Build.VERSION.SDK_INT <= 28) return NetworkUtil.getInfoWithReflect((SignalStrength)object, "getLteRsrq");
        object = object.getCellSignalStrengths(CellSignalStrengthLte.class);
        if (object.size() <= 0) return n10;
        try {
            return ((CellSignalStrengthLte)object.get(0)).getRsrq();
        }
        catch (Throwable throwable) {
            Logger.i(TAG, "getLteRsrq: throwable:" + throwable.getClass());
        }
        return n10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getLteRssnr(Context context) {
        int n10 = Integer.MAX_VALUE;
        Object object = NetworkUtil.getSignalStrength(context);
        if (object == null) {
            return n10;
        }
        if (Build.VERSION.SDK_INT <= 28) return NetworkUtil.getInfoWithReflect((SignalStrength)object, "getLteRssnr");
        object = object.getCellSignalStrengths(CellSignalStrengthLte.class);
        if (object.size() <= 0) return n10;
        try {
            return ((CellSignalStrengthLte)object.get(0)).getRssnr();
        }
        catch (Throwable throwable) {
            Logger.i(TAG, "getLteRssnr: throwable:" + throwable.getClass());
        }
        return n10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getLteRsrp(Context context) {
        int n10 = Integer.MAX_VALUE;
        Object object = NetworkUtil.getSignalStrength(context);
        if (object == null) {
            return n10;
        }
        if (Build.VERSION.SDK_INT <= 28) return NetworkUtil.getInfoWithReflect((SignalStrength)object, "getLteRsrp");
        object = object.getCellSignalStrengths(CellSignalStrengthLte.class);
        if (object.size() <= 0) return n10;
        try {
            return ((CellSignalStrengthLte)object.get(0)).getRsrp();
        }
        catch (Throwable throwable) {
            Logger.i(TAG, "getLteRsrp: throwable:" + throwable.getClass());
        }
        return n10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getLteCqi(Context context) {
        int n10 = Integer.MAX_VALUE;
        Object object = NetworkUtil.getSignalStrength(context);
        if (object == null) {
            return n10;
        }
        if (Build.VERSION.SDK_INT <= 28) return NetworkUtil.getInfoWithReflect((SignalStrength)object, "getLteCqi");
        object = object.getCellSignalStrengths(CellSignalStrengthLte.class);
        if (object.size() <= 0) return n10;
        try {
            return ((CellSignalStrengthLte)object.get(0)).getCqi();
        }
        catch (Throwable throwable) {
            Logger.i(TAG, "getLteCqi: throwable:" + throwable.getClass());
        }
        return n10;
    }

    public static int getLteRssi(Context context) {
        int n10;
        block6: {
            n10 = Integer.MAX_VALUE;
            Object object = NetworkUtil.getSignalStrength(context);
            if (object == null) {
                return n10;
            }
            if (Build.VERSION.SDK_INT <= 28) break block6;
            object = object.getCellSignalStrengths(CellSignalStrengthLte.class);
            if (object.size() <= 0) break block6;
            try {
                return ((CellSignalStrengthLte)object.get(0)).getRssi();
            }
            catch (Throwable throwable) {
                Logger.i(TAG, "getLteRssi: throwable:" + throwable.getClass());
            }
        }
        return n10;
    }

    public static int getInfoWithReflect(SignalStrength signalStrength, String string2) {
        block8: {
            if (Build.VERSION.SDK_INT > 28) break block8;
            final Method method = SignalStrength.class.getDeclaredMethod(string2, new Class[0]);
            SignalStrength signalStrength2 = signalStrength;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    method.setAccessible(true);
                    return null;
                }
            });
            try {
                return (Integer)method.invoke((Object)signalStrength2, new Object[0]);
            }
            catch (Throwable throwable) {
                Logger.i(TAG, string2 + " : throwable:" + throwable.getClass());
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.i(TAG, string2 + " : InvocationTargetException");
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.i(TAG, string2 + " : cannot access");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logger.i(TAG, string2 + " : function not found");
            }
        }
        return Integer.MAX_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Integer> getLteSignalInfo(Context object) {
        Integer n10;
        SignalStrength signalStrength;
        block17: {
            HashMap hashMap;
            Object object2 = object;
            object = hashMap;
            hashMap = new HashMap();
            signalStrength = NetworkUtil.getSignalStrength((Context)object2);
            if (signalStrength == null) {
                return object;
            }
            if (Build.VERSION.SDK_INT <= 28) break block17;
            List list = signalStrength.getCellSignalStrengths(CellSignalStrengthLte.class);
            if (list.size() <= 0) return object;
            String string2 = "lteDbm";
            object.put(string2, ((CellSignalStrengthLte)list.get(0)).getDbm());
            String string3 = "lteRsrp";
            object.put(string3, ((CellSignalStrengthLte)list.get(0)).getRsrp());
            String string4 = "lteRsrq";
            object.put(string4, ((CellSignalStrengthLte)list.get(0)).getRsrq());
            String string5 = "lteRssnr";
            object.put(string5, ((CellSignalStrengthLte)list.get(0)).getRssnr());
            String string6 = "lteCqi";
            object.put(string6, ((CellSignalStrengthLte)list.get(0)).getCqi());
            String string7 = "lteRssi";
            n10 = object.put(string7, ((CellSignalStrengthLte)list.get(0)).getRssi());
            return object;
        }
        String string8 = "lteDbm";
        object.put(string8, NetworkUtil.getInfoWithReflect(signalStrength, "getDbm"));
        String string9 = "lteRsrp";
        object.put(string9, NetworkUtil.getInfoWithReflect(signalStrength, "getLteRsrp"));
        String string10 = "lteRsrq";
        object.put(string10, NetworkUtil.getInfoWithReflect(signalStrength, "getLteRsrq"));
        String string11 = "lteRssnr";
        object.put(string11, NetworkUtil.getInfoWithReflect(signalStrength, "getLteRssnr"));
        String string12 = "lteCqi";
        try {
            n10 = object.put(string12, NetworkUtil.getInfoWithReflect(signalStrength, "getLteCqi"));
            return object;
        }
        catch (Throwable throwable) {
            Logger.i(TAG, "getLteRssi: throwable:" + throwable.getClass());
        }
        return object;
    }

    public static Map<String, Integer> getNrSignalInfo(Context object) {
        block12: {
            HashMap hashMap;
            Context context = object;
            object = hashMap;
            hashMap = new HashMap();
            Object object2 = NetworkUtil.getSignalStrength(context);
            if (object2 == null) {
                return object;
            }
            if (Build.VERSION.SDK_INT <= 28) break block12;
            object2 = object2.getCellSignalStrengths(CellSignalStrengthNr.class);
            if (object2.size() <= 0) break block12;
            SignalStrength signalStrength = object2;
            SignalStrength signalStrength2 = object2;
            SignalStrength signalStrength3 = object2;
            SignalStrength signalStrength4 = object2;
            SignalStrength signalStrength5 = object2;
            SignalStrength signalStrength6 = object2;
            SignalStrength signalStrength7 = object2;
            object2 = "nrDbm";
            object.put(object2, ((CellSignalStrengthNr)signalStrength7.get(0)).getDbm());
            object2 = "nrCSIRsrp";
            object.put(object2, ((CellSignalStrengthNr)signalStrength6.get(0)).getCsiRsrp());
            object2 = "nrCSIRsrq";
            object.put(object2, ((CellSignalStrengthNr)signalStrength5.get(0)).getCsiRsrq());
            object2 = "nrCSISinr";
            object.put(object2, ((CellSignalStrengthNr)signalStrength4.get(0)).getCsiSinr());
            object2 = "nrSSRsrp";
            object.put(object2, ((CellSignalStrengthNr)signalStrength3.get(0)).getSsRsrp());
            object2 = "nrSSRsrq";
            object.put(object2, ((CellSignalStrengthNr)signalStrength2.get(0)).getSsRsrq());
            object2 = "nrSSSinr";
            try {
                object.put(object2, ((CellSignalStrengthNr)signalStrength.get(0)).getSsSinr());
            }
            catch (Throwable throwable) {
                Logger.i(TAG, "getLteRssi: throwable:" + throwable.getClass());
            }
        }
        return object;
    }

    public static int getNrSsRsrp(Context object) {
        int n10;
        block6: {
            block7: {
                n10 = Integer.MAX_VALUE;
                if (Build.VERSION.SDK_INT <= 28) break block6;
                object = NetworkUtil.getSignalStrength((Context)object);
                if (object != null) break block7;
                return n10;
            }
            object = object.getCellSignalStrengths(CellSignalStrengthNr.class);
            if (object.size() <= 0) break block6;
            try {
                return ((CellSignalStrengthNr)object.get(0)).getSsRsrp();
            }
            catch (Throwable throwable) {
                Logger.i(TAG, "getNrSsRsrp: throwable:" + throwable.getClass());
            }
        }
        return n10;
    }

    public static int getNrCsiRsrp(Context object) {
        int n10;
        block6: {
            block7: {
                n10 = Integer.MAX_VALUE;
                if (Build.VERSION.SDK_INT <= 28) break block6;
                object = NetworkUtil.getSignalStrength((Context)object);
                if (object != null) break block7;
                return n10;
            }
            object = object.getCellSignalStrengths(CellSignalStrengthNr.class);
            if (object.size() <= 0) break block6;
            try {
                return ((CellSignalStrengthNr)object.get(0)).getCsiRsrp();
            }
            catch (Throwable throwable) {
                Logger.i(TAG, "getNrCsiRsrp: throwable:" + throwable.getClass());
            }
        }
        return n10;
    }

    public static int getNrSsRsrq(Context object) {
        int n10;
        block6: {
            block7: {
                n10 = Integer.MAX_VALUE;
                if (Build.VERSION.SDK_INT <= 28) break block6;
                object = NetworkUtil.getSignalStrength((Context)object);
                if (object != null) break block7;
                return n10;
            }
            object = object.getCellSignalStrengths(CellSignalStrengthNr.class);
            if (object.size() <= 0) break block6;
            try {
                return ((CellSignalStrengthNr)object.get(0)).getSsRsrq();
            }
            catch (Throwable throwable) {
                Logger.i(TAG, "getNrSsRsrq: throwable:" + throwable.getClass());
            }
        }
        return n10;
    }

    public static int getNrCsiRsrq(Context object) {
        int n10;
        block6: {
            block7: {
                n10 = Integer.MAX_VALUE;
                if (Build.VERSION.SDK_INT <= 28) break block6;
                object = NetworkUtil.getSignalStrength((Context)object);
                if (object != null) break block7;
                return n10;
            }
            object = object.getCellSignalStrengths(CellSignalStrengthNr.class);
            if (object.size() <= 0) break block6;
            try {
                return ((CellSignalStrengthNr)object.get(0)).getCsiRsrq();
            }
            catch (Throwable throwable) {
                Logger.i(TAG, "getNrCsiRsrq: throwable:" + throwable.getClass());
            }
        }
        return n10;
    }

    public static int getNrSsSinr(Context object) {
        int n10;
        block6: {
            block7: {
                n10 = Integer.MAX_VALUE;
                if (Build.VERSION.SDK_INT <= 28) break block6;
                object = NetworkUtil.getSignalStrength((Context)object);
                if (object != null) break block7;
                return n10;
            }
            object = object.getCellSignalStrengths(CellSignalStrengthNr.class);
            if (object.size() <= 0) break block6;
            try {
                return ((CellSignalStrengthNr)object.get(0)).getSsSinr();
            }
            catch (Throwable throwable) {
                Logger.i(TAG, "getNrSsSinr: throwable:" + throwable.getClass());
            }
        }
        return n10;
    }

    public static int getNrCsiSinr(Context object) {
        int n10;
        block6: {
            block7: {
                n10 = Integer.MAX_VALUE;
                if (Build.VERSION.SDK_INT <= 28) break block6;
                object = NetworkUtil.getSignalStrength((Context)object);
                if (object != null) break block7;
                return n10;
            }
            object = object.getCellSignalStrengths(CellSignalStrengthNr.class);
            if (object.size() <= 0) break block6;
            try {
                return ((CellSignalStrengthNr)object.get(0)).getCsiSinr();
            }
            catch (Throwable throwable) {
                Logger.i(TAG, "getNrCsiSinr: throwable:" + throwable.getClass());
            }
        }
        return n10;
    }

    private static SignalStrength getSignalStrength(Context object) {
        if (object != null && Build.VERSION.SDK_INT >= 28 && (object = ContextCompat.getSystemService(object, "phone")) instanceof TelephonyManager) {
            return ((TelephonyManager)object).createForSubscriptionId(SubscriptionManager.getDefaultDataSubscriptionId()).getSignalStrength();
        }
        return null;
    }

    public static int getWifiRssi(Context object) {
        int n10;
        block5: {
            n10 = -127;
            if (object != null && (object = ContextCompat.getSystemService(object.getApplicationContext(), "wifi")) instanceof WifiManager) {
                object = ((WifiManager)object).getConnectionInfo();
                if (object == null) break block5;
                if (object.getBSSID() == null) break block5;
                try {
                    n10 = object.getRssi();
                }
                catch (RuntimeException runtimeException) {
                    Logger.i(TAG, "getWifiRssiLevel did not has permission!" + runtimeException.getClass().getSimpleName() + runtimeException.getMessage());
                }
            }
        }
        return n10;
    }

    public static int getWifiRssiLevel(Context context) {
        return WifiManager.calculateSignalLevel((int)NetworkUtil.getWifiRssi(context), (int)5);
    }

    /*
     * WARNING - void declaration
     */
    public static String getWifiGatewayIp(Context object) {
        String string2;
        block9: {
            string2 = " ";
            if (object != null && (object = ContextCompat.getSystemService(object.getApplicationContext(), "wifi")) instanceof WifiManager) {
                void var0_4;
                int n10 = ((WifiManager)object).getDhcpInfo().gateway;
                byte[] byArray = new byte[4];
                byte[] byArray2 = byArray;
                byArray2[0] = (byte)(n10 & 0xFF);
                byArray2[1] = (byte)(n10 >> 8 & 0xFF);
                byArray2[2] = (byte)(n10 >> 16 & 0xFF);
                try {
                    byArray[3] = (byte)(n10 >> 24 & 0xFF);
                    string2 = InetAddress.getByAddress(byArray).getHostAddress();
                    break block9;
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                Logger.i(TAG, "getWifiGatewayIp error!" + var0_4.getClass().getSimpleName() + var0_4.getMessage());
                return string2;
            }
        }
        return string2;
    }

    @SuppressLint(value={"MissingPermission"})
    public static NetworkInfo.DetailedState getNetworkStatus(Context context) {
        NetworkInfo.DetailedState detailedState = NetworkInfo.DetailedState.IDLE;
        if (context != null) {
            Object object = ContextCompat.getSystemService(context, "connectivity");
            if (object instanceof ConnectivityManager) {
                block9: {
                    block8: {
                        if (ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) break block8;
                        return detailedState;
                    }
                    context = ((ConnectivityManager)object).getActiveNetworkInfo();
                    if (context == null) break block9;
                    detailedState = context.getDetailedState();
                }
                try {
                    Logger.i(TAG, "getNetworkStatus networkIsConnected netInfo is null!");
                }
                catch (RuntimeException runtimeException) {
                    Logger.i(TAG, "getNetworkStatus exception" + runtimeException.getClass().getSimpleName() + runtimeException.getMessage());
                }
            } else {
                Logger.i(TAG, "getNetworkStatus ConnectivityManager is null!");
            }
        }
        return detailedState;
    }

    @SuppressLint(value={"MissingPermission"})
    public static int readDataSaverMode(Context object) {
        int n10 = 0;
        if (object != null && Build.VERSION.SDK_INT >= 24 && ContextCompat.checkSelfPermission(object, "android.permission.ACCESS_NETWORK_STATE") && (object = ContextCompat.getSystemService(object, "connectivity")) instanceof ConnectivityManager) {
            block5: {
                object = (ConnectivityManager)object;
                if (!object.isActiveNetworkMetered()) break block5;
                n10 = object.getRestrictBackgroundStatus();
            }
            try {
                Logger.v(TAG, "ConnectType is not Mobile Network!");
            }
            catch (RuntimeException runtimeException) {
                Logger.e(TAG, "SystemServer error:", runtimeException);
            }
        }
        return n10;
    }

    public static boolean isSimReady(Context context) {
        Context context2 = context;
        context = null;
        Object object = ContextCompat.getSystemService(context2, "phone");
        if (object instanceof TelephonyManager) {
            context = (TelephonyManager)object;
        }
        return context != null && context.getSimState() == 5;
    }

    public static String getMNC(Context object) {
        String string2 = "unknown";
        if (object == null) {
            return string2;
        }
        if (!NetworkUtil.isSimReady(object)) {
            return string2;
        }
        Context context = object;
        object = null;
        Object object2 = ContextCompat.getSystemService(context, "phone");
        if (object2 instanceof TelephonyManager) {
            object = (TelephonyManager)object2;
        }
        if (object == null) {
            Logger.e(TAG, "getSubscriptionOperatorType: other error!");
            return string2;
        }
        return !("46001".equals(object = object.getNetworkOperator()) || "46006".equals(object) || "46009".equals(object)) ? (!("46000".equals(object) || "46002".equals(object) || "46004".equals(object) || "46007".equals(object)) ? (!("46003".equals(object) || "46005".equals(object) || "46011".equals(object)) ? "other" : "China_Telecom") : "China_Mobile") : "China_Unicom";
    }

    public static String getHost(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        try {
            return new URI(string2).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.w(TAG, uRISyntaxException.getClass().getSimpleName());
            return "";
        }
    }

    public static boolean isUserUnlocked(Context context) {
        if (Build.VERSION.SDK_INT >= 24 && (context = (UserManager)ContextCompat.getSystemService(context, "user")) != null) {
            try {
                return context.isUserUnlocked();
            }
            catch (RuntimeException runtimeException) {
                Logger.e(TAG, "dealType rethrowFromSystemServer:", runtimeException);
            }
        }
        return true;
    }

    @Deprecated
    public static boolean isForeground(Context context) {
        return ActivityUtil.isForeground(context);
    }

    @Deprecated
    public static NetworkInfo.DetailedState networkStatus(Context context) {
        return NetworkUtil.getNetworkStatus(context);
    }

    public static boolean isConnectTypeChange(NetworkInfo networkInfo, NetworkInfo networkInfo2) {
        if (networkInfo != null && networkInfo.isConnected() && networkInfo2.isConnected() && NetworkUtil.getPrimaryNetworkType(networkInfo) != NetworkUtil.getPrimaryNetworkType(networkInfo2)) {
            Logger.v(TAG, "Find activity network changed");
            return true;
        }
        return false;
    }

    public static boolean isChangeToConnected(NetworkInfo networkInfo, NetworkInfo networkInfo2) {
        if ((networkInfo == null || !networkInfo.isConnected()) && networkInfo2.isConnected()) {
            Logger.v(TAG, "Find network state changed to connected");
            return true;
        }
        return false;
    }

    public static int getPrimaryNetworkType(Context context) {
        return NetworkUtil.groupNetworkType(NetworkUtil.getNetworkType(NetworkUtil.getNetworkInfo(context), context));
    }

    public static int getPrimaryNetworkType(NetworkInfo networkInfo) {
        return NetworkUtil.groupNetworkType(NetworkUtil.getNetworkType(networkInfo));
    }

    private static int groupNetworkType(int n10) {
        int n11;
        switch (n10) {
            default: {
                n11 = 0;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n11 = 6;
                break;
            }
            case 1: {
                n11 = 1;
                break;
            }
            case -1: {
                n11 = -1;
            }
        }
        return n11;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMobileSingalStrengthUpPPlatfrom(Context var0) {
        block17: {
            block18: {
                if (Build.VERSION.SDK_INT <= 28) {
                    return 0x7FFFFFFF;
                }
                var1_4 = NetworkUtil.getSignalStrength(var0);
                if (var1_4 == null) {
                    return 0x7FFFFFFF;
                }
                var0_1 = NetworkUtil.getNetworkType(var0);
                var2_5 = 0x7FFFFFFF;
                if (var0_1 == 3) ** GOTO lbl29
                if (var0_1 == 4) break block18;
                if (var0_1 != 5) break block17;
                var0_2 = var1_4.getCellSignalStrengths(CellSignalStrengthNr.class);
                ** if (var0_2.size() <= 0) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    v0 = ((CellSignalStrengthNr)var0_2.get(0)).getDbm();
lbl17:
                    // 5 sources

                    while (true) {
                        var2_5 = v0;
                        ** GOTO lbl49
                        break;
                    }
                }
lbl-1000:
                // 1 sources

                {
                }
            }
            var0_2 = var1_4.getCellSignalStrengths(CellSignalStrengthLte.class);
            if (var0_2.size() <= 0) break block17;
            v0 = ((CellSignalStrengthLte)var0_2.get(0)).getDbm();
            ** GOTO lbl17
lbl29:
            // 1 sources

            var0_2 = var1_4.getCellSignalStrengths(CellSignalStrengthCdma.class);
            if (var0_2.size() <= 0) ** GOTO lbl35
            v0 = ((CellSignalStrengthCdma)var0_2.get(0)).getDbm();
            ** GOTO lbl17
lbl35:
            // 1 sources

            var0_2 = var1_4.getCellSignalStrengths(CellSignalStrengthTdscdma.class);
            if (var0_2.size() <= 0) ** GOTO lbl41
            v0 = ((CellSignalStrengthTdscdma)var0_2.get(0)).getDbm();
            ** GOTO lbl17
lbl41:
            // 1 sources

            var0_2 = var1_4.getCellSignalStrengths(CellSignalStrengthWcdma.class);
            if (var0_2.size() <= 0) break block17;
            try {
                v0 = ((CellSignalStrengthWcdma)var0_2.get(0)).getDbm();
                ** continue;
            }
            catch (Throwable var0_3) {
                Logger.i(NetworkUtil.TAG, "getMobileSingalStrength: throwable:" + var0_3.getClass());
            }
        }
        return var2_5;
    }

    public static final class SignalType {
        public static final String LTE_RSRP = "lteRsrp";
        public static final String LTE_RSRQ = "lteRsrq";
        public static final String LTE_RSSI = "lteRssi";
        public static final String LTE_RSSNR = "lteRssnr";
        public static final String LTE_DBM = "lteDbm";
        public static final String LTE_CQI = "lteCqi";
        public static final String NR_DBM = "nrDbm";
        public static final String NR_SSRSRP = "nrSSRsrp";
        public static final String NR_CSIRSRP = "nrCSIRsrp";
        public static final String NR_SSRSRQ = "nrSSRsrq";
        public static final String NR_CSIRSRQ = "nrCSIRsrq";
        public static final String NR_SSSINR = "nrSSSinr";
        public static final String NR_CSISINR = "nrCSISinr";
    }

    public static final class NetType {
        public static final int TYPE_NO_NETWORK = -1;
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WIFI = 1;
        public static final int TYPE_2G = 2;
        public static final int TYPE_3G = 3;
        public static final int TYPE_4G = 4;
        public static final int TYPE_4G_NSA = 7;
        public static final int TYPE_5G = 5;
        public static final int TYPE_5G_SA = 8;
        public static final int TYPE_MOBILE = 6;
    }
}

