/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.annotation.SuppressLint;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.PowerManager;
import com.huawei.hms.framework.common.ContextCompat;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.SettingUtil;

public class PowerUtils {
    private static final String TAG = "PowerUtils";

    public static boolean isInteractive(Context object) {
        boolean bl = false;
        if (object != null && (object = ContextCompat.getSystemService(object, "power")) instanceof PowerManager) {
            object = (PowerManager)object;
            if (Build.VERSION.SDK_INT >= 20) {
                try {
                    bl = object.isInteractive();
                }
                catch (RuntimeException runtimeException) {
                    Logger.i(TAG, "getActiveNetworkInfo failed, exception:" + runtimeException.getClass().getSimpleName() + runtimeException.getMessage());
                }
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int readPowerSaverMode(Context context) {
        int n10 = 0;
        if (context != null) {
            n10 = SettingUtil.getSystemInt(context.getContentResolver(), PowerMode.SMART_MODE_STATUS, PowerMode.POWER_MODE_DEFAULT_RETURN_VALUE);
            if (n10 != PowerMode.POWER_MODE_DEFAULT_RETURN_VALUE) return n10;
            Context context2 = context;
            context = null;
            Object object = ContextCompat.getSystemService(context2, "power");
            if (object instanceof PowerManager) {
                context = (PowerManager)object;
            }
            if (context == null) return n10;
            if (Build.VERSION.SDK_INT >= 21) {
                int n11;
                block8: {
                    try {
                        if (!context.isPowerSaveMode()) break block8;
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.e(TAG, "dealType rethrowFromSystemServer:", runtimeException);
                        return n10;
                    }
                    n11 = PowerMode.POWER_SAVER_MODE;
                    return n11;
                }
                n11 = PowerMode.POWER_MODE_DEFAULT_RETURN_VALUE;
                return n11;
            }
            Logger.i(TAG, "readPowerSaverMode is control by version!");
            return n10;
        }
        Logger.i(TAG, "readPowerSaverMode Context is null!");
        return n10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAppIdleMode(Context object) {
        boolean bl = false;
        if (object != null) {
            String string2 = object.getPackageName();
            UsageStatsManager usageStatsManager = null;
            int n10 = Build.VERSION.SDK_INT;
            if (n10 >= 21) {
                if (n10 >= 22) {
                    if (!((object = object.getSystemService("usagestats")) instanceof UsageStatsManager)) return bl;
                    usageStatsManager = (UsageStatsManager)object;
                }
            } else {
                Logger.i(TAG, "isAppIdleMode statsManager is null!");
            }
            if (usageStatsManager != null) {
                if (n10 < 23) return bl;
                return usageStatsManager.isAppInactive(string2);
            }
            Logger.i(TAG, "isAppIdleMode statsManager is null!");
            return false;
        }
        Logger.i(TAG, "isAppIdleMode Context is null!");
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"MissingPermission"})
    public static int readDataSaverMode(Context context) {
        int n10 = 0;
        ConnectivityManager connectivityManager = null;
        if (context == null) {
            Logger.i(TAG, "readDataSaverMode manager is null!");
            return n10;
        }
        Object object = context.getSystemService("connectivity");
        if (object instanceof ConnectivityManager) {
            connectivityManager = (ConnectivityManager)object;
        }
        if (connectivityManager == null) {
            Logger.i(TAG, "readDataSaverMode Context is null!");
            return n10;
        }
        int n11 = Build.VERSION.SDK_INT;
        if (n11 < 16) return n10;
        if (ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return n10;
        }
        if (connectivityManager.isActiveNetworkMetered()) {
            if (n11 < 24) return n10;
            return connectivityManager.getRestrictBackgroundStatus();
        }
        Logger.v(TAG, "ConnectType is not Mobile Network!");
        return n10;
    }

    public static boolean isWhilteList(Context object) {
        PowerManager powerManager = null;
        boolean bl = false;
        if (object != null) {
            Object object2 = ContextCompat.getSystemService(object, "power");
            if (object2 instanceof PowerManager) {
                powerManager = (PowerManager)object2;
            }
            object = object.getPackageName();
            if (powerManager != null && Build.VERSION.SDK_INT >= 23) {
                try {
                    bl = powerManager.isIgnoringBatteryOptimizations((String)object);
                }
                catch (RuntimeException runtimeException) {
                    Logger.e(TAG, "dealType rethrowFromSystemServer:", runtimeException);
                }
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDozeIdleMode(Context object) {
        boolean bl = false;
        PowerManager powerManager = null;
        if (object == null) {
            Logger.i(TAG, "isDozeIdleMode Context is null!");
            return bl;
        }
        Object object2 = ContextCompat.getSystemService(object, "power");
        if (object2 instanceof PowerManager) {
            powerManager = (PowerManager)object2;
        }
        if (powerManager == null) {
            Logger.i(TAG, "isDozeIdleMode powerManager is null!");
            return false;
        }
        if (Build.VERSION.SDK_INT < 23) {
            Logger.i(TAG, "isDozeIdleMode is version control state!");
            return false;
        }
        try {
            return powerManager.isDeviceIdleMode();
        }
        catch (RuntimeException runtimeException) {
            Logger.e(TAG, "dealType rethrowFromSystemServer:", runtimeException);
            return bl;
        }
    }

    public static final class PowerMode {
        public static String SMART_MODE_STATUS = "SmartModeStatus";
        public static int POWER_SAVER_MODE = 4;
        public static int POWER_MODE_DEFAULT_RETURN_VALUE = 0;
    }
}

