/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.droid.rtc;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Process;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.qiniu.droid.rtc.qos.HISPj7KHQ7;
import com.qiniu.droid.rtc.utils.BsUTWEAMAI;
import com.qiniu.droid.rtc.utils.DxDJysLV5r;
import com.qiniu.droid.rtc.utils.HISPj7KHQ7;
import com.qiniu.droid.rtc.utils.OyIbF7L6XB;
import com.qiniu.droid.rtc.utils.R7N8DF4OVS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;

@Deprecated
public class QNFileLogHelper {
    private static final String TAG = "QNFileLogHelper";
    private static final int LOG_MAX_NUM = 3;
    private static final int LOG_FILE_MAX_SIZE = 0x300000;
    private static final SimpleDateFormat LOG_FILE_DATE_FORMAT = new SimpleDateFormat("MM-dd-HH-mm-ss");
    private static final SimpleDateFormat LOG_TIME_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
    private static final String LOG_FORMAT = "%s %d %d %s %s: %s";
    private static final String LOG_DIR = "QNRTCLog";
    private static final String LOG_INFO_POSTFIX = "qnloginfo";
    private static final String NAME_CONNECTOR = "-";
    private static final String LOG_FILE_SUFFIX = ".log";
    private static QNFileLogHelper mInstance = null;
    private Context mContext;
    private Handler mLogHelperHandler;
    private boolean mInit;
    private int mPid;
    private String mLogDirPath;
    private File mLogDirPathFile;
    private File mCurrentLogFile;
    private FileOutputStream mCurrentOutputStream;
    private File mCurrentLogInfoFile;
    private FileOutputStream mCurrentInfoOutputStream;
    private int mLogFileMaxCount = 3;
    private boolean mIsLogFileEnabled = true;
    private String mUserPathPrefix;

    public static synchronized QNFileLogHelper getInstance() {
        if (mInstance == null) {
            mInstance = new QNFileLogHelper();
        }
        return mInstance;
    }

    private QNFileLogHelper() {
        HandlerThread handlerThread = new HandlerThread("logHelper");
        handlerThread.start();
        this.mLogHelperHandler = new Handler(handlerThread.getLooper());
    }

    /*
     * WARNING - void declaration
     */
    public void init(Context context) {
        void var1_1;
        if (context == null) {
            R7N8DF4OVS.d("Error: context is null!");
            return;
        }
        if (this.mInit) {
            R7N8DF4OVS.c("Not allow repeat init!");
            return;
        }
        this.mContext = var1_1.getApplicationContext();
        this.mPid = Process.myPid();
        this.mLogDirPath = this.mContext.getFilesDir().getAbsolutePath() + File.separator + LOG_DIR;
        R7N8DF4OVS.a("QNFileLogHelper init, log file directory: " + this.mLogDirPath);
        this.mLogDirPathFile = new File(this.mLogDirPath);
        this.mInit = true;
    }

    @VisibleForTesting
    String getLogDir() {
        return this.mLogDirPath;
    }

    public void release() {
        this.mInit = false;
    }

    private void releaseStream() {
        try {
            if (this.mCurrentOutputStream != null) {
                this.mCurrentOutputStream.close();
            }
            if (this.mCurrentInfoOutputStream != null) {
                this.mCurrentInfoOutputStream.close();
            }
        }
        catch (IOException iOException) {
            Log.e((String)"QRTCDroid", (String)("QNFileLogHelper release: " + iOException.getMessage()));
        }
        this.mCurrentLogFile = null;
        this.mCurrentLogInfoFile = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setLogFileEnabled(boolean isEnabled, String prefix) {
        void var2_2;
        void var1_1;
        this.mIsLogFileEnabled = var1_1;
        this.mUserPathPrefix = var2_2;
        R7N8DF4OVS.a("Log file is " + (this.mIsLogFileEnabled ? "enabled" : "disabled") + "; prefix " + this.mUserPathPrefix);
    }

    /*
     * WARNING - void declaration
     */
    public void setLogFileMaxCount(int maxCount) {
        void var1_1;
        this.mLogFileMaxCount = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRoomInfoAndSave(String userId, String roomName, String appId) {
        void var3_3;
        void var2_2;
        void var1_1;
        JSONObject jSONObject = new JSONObject();
        BsUTWEAMAI.a(jSONObject, "user_id", var1_1);
        BsUTWEAMAI.a(jSONObject, "room_name", var2_2);
        BsUTWEAMAI.a(jSONObject, "app_id", var3_3);
        this.mLogHelperHandler.post(() -> {
            void var1_1;
            QNFileLogHelper qNFileLogHelper = this;
            qNFileLogHelper.saveOutputStream(qNFileLogHelper.mCurrentInfoOutputStream, var1_1.toString());
        });
    }

    public List<String> getLogFiles() {
        Object object = this.mLogDirPathFile;
        object = object == null || !object.isDirectory() ? null : object.listFiles();
        if (object != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object = Arrays.asList(object);
            Collections.sort(object, new FileComparator());
            for (File file : object) {
                if (file.getName().contains(LOG_INFO_POSTFIX)) continue;
                arrayList.add(file.getName());
            }
            return arrayList;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public void reportLogFile(String logName, LogReportCallback callback) {
        void var2_2;
        void var1_1;
        if (logName == null || logName.isEmpty()) {
            R7N8DF4OVS.c("Bad report path!");
            return;
        }
        this.mLogHelperHandler.post(() -> this.lambda$reportLogFile$1((String)var1_1, (LogReportCallback)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public void reportLogFileByPath(String logFilePath, LogReportCallback callback) {
        void var2_2;
        void var1_1;
        if (logFilePath == null || logFilePath.isEmpty()) {
            R7N8DF4OVS.c("Bad report path!");
            return;
        }
        this.mLogHelperHandler.post(() -> this.lambda$reportLogFileByPath$2((String)var1_1, (LogReportCallback)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private boolean reportFileToPandora(File file, String baseInfo, LogReportCallback callback) {
        Object object;
        if (!file.exists()) {
            if (callback != null) {
                callback.onReportError(file.getName(), "File not exist");
            }
            return false;
        }
        R7N8DF4OVS.a("reportLogFileByPath " + file.getName());
        if (!file.isFile()) {
            R7N8DF4OVS.c("Invalid log file path!");
            if (callback != null) {
                callback.onReportError(file.getName(), "Invalid log file path!");
            }
            return false;
        }
        com.qiniu.droid.rtc.qos.HISPj7KHQ7.a();
        object = com.qiniu.droid.rtc.qos.HISPj7KHQ7.a(file, (String)object);
        if (object == null) {
            R7N8DF4OVS.c("Invalid log file!");
            if (callback != null) {
                callback.onReportError(file.getName(), "Invalid log file!");
            }
            return false;
        }
        Object object2 = com.qiniu.droid.rtc.qos.HISPj7KHQ7.a();
        StringBuilder stringBuilder = new StringBuilder("https://pandora-express-sdk.qiniu.com/api/v1/data?host=rtc_sdk_log&sourcetype=json&repo=rtc_sdk_log&token=");
        object2 = ((com.qiniu.droid.rtc.qos.HISPj7KHQ7)object2).a;
        ((HISPj7KHQ7.HISPj7KHQ7)object2).a();
        object = new DxDJysLV5r("POST", stringBuilder.append(((HISPj7KHQ7.HISPj7KHQ7)object2).c).toString(), (String)object);
        v1.a = "application/json";
        ((DxDJysLV5r)object).b = "gzip";
        object2 = ((DxDJysLV5r)object).a(true);
        if (object2 != null) {
            if (callback != null) {
                callback.onReportSuccess(file.getName());
            }
        } else {
            R7N8DF4OVS.c("Upload error for " + file.getName() + " : " + ((DxDJysLV5r)object).c);
            if (callback != null) {
                void var1_1;
                void var3_3;
                var3_3.onReportError(var1_1.getName(), "Upload error : " + ((DxDJysLV5r)object).c);
            }
        }
        return object2 != null;
    }

    /*
     * WARNING - void declaration
     */
    public void onLogMessage(String level, String tag, String message, int tid) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.mIsLogFileEnabled) {
            return;
        }
        String string = LOG_TIME_FORMAT.format(new Date());
        this.mLogHelperHandler.post(() -> this.lambda$onLogMessage$3((String)var1_1, (String)var2_2, (String)var3_3, tid, string));
    }

    /*
     * WARNING - void declaration
     */
    private void checkAndSaveFile(String level, String tag, String message, int tid, String logTime) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.mCurrentLogFile == null || this.mCurrentLogFile.length() >= 0x300000L) {
            File[] fileArray = this.mUserPathPrefix != null ? this.mUserPathPrefix + NAME_CONNECTOR + LOG_FILE_DATE_FORMAT.format(new Date()) : LOG_FILE_DATE_FORMAT.format(new Date());
            this.mCurrentLogFile = new File(this.mLogDirPath, (String)fileArray + LOG_FILE_SUFFIX);
            this.mCurrentLogInfoFile = new File(this.mLogDirPath, (String)fileArray + "-qnloginfo.log");
            R7N8DF4OVS.a("new log file path: " + this.mCurrentLogFile.getAbsolutePath());
            try {
                this.mCurrentOutputStream = new FileOutputStream(this.mCurrentLogFile);
                this.mCurrentInfoOutputStream = new FileOutputStream(this.mCurrentLogInfoFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.e((String)"QRTCDroid", (String)("QNFileLogHelper e: " + fileNotFoundException.getMessage()));
                return;
            }
            this.saveCurrentBaseInfo();
            fileArray = this.mLogDirPathFile.listFiles();
            ArrayList<File> arrayList = new ArrayList<File>();
            int n = fileArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                File file = fileArray[i2];
                if (file.getName().contains(LOG_INFO_POSTFIX)) continue;
                arrayList.add(file);
            }
            if (arrayList.size() > this.mLogFileMaxCount) {
                Collections.sort(arrayList, new FileComparator());
                int n2 = arrayList.size() - this.mLogFileMaxCount;
                for (n = 0; n < n2; ++n) {
                    if (this.getInfoFileName(((File)arrayList.get(n)).getName()) != null) {
                        new File(this.mLogDirPath, this.getInfoFileName(((File)arrayList.get(n)).getName())).delete();
                    }
                    ((File)arrayList.get(n)).delete();
                }
            }
        }
        String string = String.format(LOG_FORMAT, logTime, this.mPid, tid, var1_1, var2_2, var3_3.replace("\n", ""));
        QNFileLogHelper qNFileLogHelper = this;
        qNFileLogHelper.saveOutputStream(qNFileLogHelper.mCurrentOutputStream, string);
    }

    private void saveCurrentBaseInfo() {
        JSONObject jSONObject = new JSONObject();
        BsUTWEAMAI.a(jSONObject, "bundle_id", OyIbF7L6XB.b(this.mContext));
        BsUTWEAMAI.a(jSONObject, "app_version", OyIbF7L6XB.c(this.mContext));
        BsUTWEAMAI.a(jSONObject, "sdk_version", "5.2.6-e2fbcf2");
        BsUTWEAMAI.a(jSONObject, "device_model", OyIbF7L6XB.b());
        BsUTWEAMAI.a(jSONObject, "os_platform", "Android");
        BsUTWEAMAI.a(jSONObject, "os_version", OyIbF7L6XB.a());
        this.mLogHelperHandler.post(() -> {
            void var1_1;
            QNFileLogHelper qNFileLogHelper = this;
            qNFileLogHelper.saveOutputStream(qNFileLogHelper.mCurrentInfoOutputStream, var1_1.toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    private void saveOutputStream(FileOutputStream stream, String content) {
        if (stream == null || content == null) {
            return;
        }
        try {
            void var2_3;
            void var1_1;
            var1_1.write(((String)var2_3 + "\n").getBytes());
            return;
        }
        catch (IOException iOException) {
            Log.e((String)"QRTCDroid", (String)("QNFileLogHelper e: " + iOException.getMessage()));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getInfoFileName(String logName) {
        String string = null;
        if (logName != null && logName.contains(LOG_FILE_SUFFIX)) {
            void var1_1;
            int n = logName.indexOf(LOG_FILE_SUFFIX);
            string = var1_1.substring(0, n) + "-qnloginfo.log";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$onLogMessage$3(String level, String tag, String message, int tid, String logTime) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.mLogDirPathFile.exists() && !this.mLogDirPathFile.mkdir()) {
            Log.e((String)"QRTCDroid", (String)("QNFileLogHelper Can not create dir " + this.mLogDirPath));
            return;
        }
        this.checkAndSaveFile((String)var1_1, (String)var2_2, (String)var3_3, tid, logTime);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$reportLogFileByPath$2(String logFilePath, LogReportCallback callback) {
        void var2_2;
        File file;
        file = new File((String)((Object)file));
        this.reportFileToPandora(file, null, (LogReportCallback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$reportLogFile$1(String logName, LogReportCallback callback) {
        void var2_2;
        String string;
        File file = new File(this.mLogDirPath, logName);
        File file2 = this.getInfoFileName(logName) == null ? null : new File(this.mLogDirPath, this.getInfoFileName(logName));
        String string2 = string = file2 != null ? HISPj7KHQ7.a(file2) : null;
        if (this.reportFileToPandora(file, string, (LogReportCallback)var2_2)) {
            void var1_1;
            this.releaseStream();
            file.delete();
            if (file2 != null) {
                file2.delete();
            }
            R7N8DF4OVS.a("After report, delete ".concat(String.valueOf(var1_1)));
        }
    }

    class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(File file1, File file2) {
            void var2_2;
            if (file1.lastModified() < var2_2.lastModified()) {
                return -1;
            }
            return 1;
        }
    }

    public static interface LogReportCallback {
        public void onReportSuccess(String var1);

        public void onReportError(String var1, String var2);
    }
}

