/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.droid.rtc;

import android.os.Handler;
import android.os.Looper;
import com.qiniu.droid.rtc.QNAudioFrameListener;
import com.qiniu.droid.rtc.QNClientRole;
import com.qiniu.droid.rtc.QNClientRoleResultCallback;
import com.qiniu.droid.rtc.QNConnectionState;
import com.qiniu.droid.rtc.QNDirectLiveStreamingConfig;
import com.qiniu.droid.rtc.QNLiveStreamingErrorInfo;
import com.qiniu.droid.rtc.QNLiveStreamingListener;
import com.qiniu.droid.rtc.QNLocalAudioTrackStats;
import com.qiniu.droid.rtc.QNLocalTrack;
import com.qiniu.droid.rtc.QNLocalVideoTrackStats;
import com.qiniu.droid.rtc.QNMediaRelayConfiguration;
import com.qiniu.droid.rtc.QNMediaRelayResultCallback;
import com.qiniu.droid.rtc.QNNetworkQuality;
import com.qiniu.droid.rtc.QNNetworkQualityListener;
import com.qiniu.droid.rtc.QNPublishResultCallback;
import com.qiniu.droid.rtc.QNRemoteAudioTrackStats;
import com.qiniu.droid.rtc.QNRemoteTrack;
import com.qiniu.droid.rtc.QNRemoteUser;
import com.qiniu.droid.rtc.QNRemoteVideoTrackStats;
import com.qiniu.droid.rtc.QNTrack;
import com.qiniu.droid.rtc.QNTranscodingLiveStreamingConfig;
import com.qiniu.droid.rtc.QNTranscodingLiveStreamingTrack;
import com.qiniu.droid.rtc.core.HISPj7KHQ7;
import com.qiniu.droid.rtc.utils.R7N8DF4OVS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QNRTCClient {
    private static final String TAG = "QNRTCClient";
    private long nativeClient;
    private long nativeLiveStreamingListener;
    private long nativeNetworkQualityListener;
    private QNLiveStreamingListenerWrapper mLiveStreamingListener;

    /*
     * WARNING - void declaration
     */
    QNRTCClient(long nativeClient) {
        void var1_1;
        if (nativeClient == 0L) {
            throw new RuntimeException("Failed to create nativeClient!");
        }
        this.nativeClient = nativeClient;
        R7N8DF4OVS.a("QNRTCClient ".concat(String.valueOf((long)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoSubscribe(boolean autoSubscribe) {
        if (this.checkNativeHandle()) {
            void var1_1;
            QNRTCClient.nativeSetAutoSubscribe(this.nativeClient, (boolean)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setClientRole(QNClientRole clientRole, QNClientRoleResultCallback callback) {
        if (this.checkNativeHandle()) {
            void var2_2;
            void var1_1;
            QNRTCClient.nativeSetClientRole(this.nativeClient, (QNClientRole)var1_1, (QNClientRoleResultCallback)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void join(String token) {
        void var1_1;
        this.join((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void join(String token, String userData) {
        if (this.checkNativeHandle()) {
            void var2_2;
            void var1_1;
            QNRTCClient.nativeJoin(this.nativeClient, (String)var1_1, (String)var2_2);
        }
    }

    public void leave() {
        if (this.checkNativeHandle()) {
            QNRTCClient.nativeLeave(this.nativeClient);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void publish(QNLocalTrack ... tracks) {
        void var1_1;
        this.publish(null, new ArrayList<QNLocalTrack>(Arrays.asList(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public void publish(List<QNLocalTrack> trackList) {
        void var1_1;
        this.publish(null, (List<QNLocalTrack>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void publish(QNPublishResultCallback callback, QNLocalTrack ... tracks) {
        void var2_2;
        void var1_1;
        this.publish((QNPublishResultCallback)var1_1, new ArrayList<QNLocalTrack>(Arrays.asList(var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public void publish(QNPublishResultCallback callback, List<QNLocalTrack> trackList) {
        if (this.checkNativeHandle()) {
            void var1_1;
            void var2_2;
            QNRTCClient.nativePublish(this.nativeClient, (List<QNLocalTrack>)var2_2, (QNPublishResultCallback)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unpublish(QNLocalTrack ... tracks) {
        void var1_1;
        this.unpublish(new ArrayList<QNLocalTrack>(Arrays.asList(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public void unpublish(List<QNLocalTrack> trackList) {
        if (this.checkNativeHandle()) {
            void var1_1;
            QNRTCClient.nativeUnPublish(this.nativeClient, (List<QNLocalTrack>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void subscribe(QNRemoteTrack ... tracks) {
        void var1_1;
        this.subscribe(new ArrayList<QNRemoteTrack>(Arrays.asList(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public void subscribe(List<QNRemoteTrack> trackList) {
        if (this.checkNativeHandle()) {
            void var1_1;
            QNRTCClient.nativeSubscribe(this.nativeClient, (List<QNRemoteTrack>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribe(QNRemoteTrack ... tracks) {
        void var1_1;
        this.unsubscribe(new ArrayList<QNRemoteTrack>(Arrays.asList(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribe(List<QNRemoteTrack> trackList) {
        if (this.checkNativeHandle()) {
            void var1_1;
            QNRTCClient.nativeUnSubscribe(this.nativeClient, (List<QNRemoteTrack>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendMessage(String messageId, String message) {
        void var2_2;
        void var1_1;
        this.sendMessage(null, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void sendMessage(List<String> users, String messageId, String message) {
        if (this.checkNativeHandle()) {
            void var3_3;
            void var2_2;
            void var1_1;
            QNRTCClient.nativeSendMessage(this.nativeClient, (List<String>)var1_1, (String)var2_2, (String)var3_3);
        }
    }

    public QNConnectionState getConnectionState() {
        if (this.checkNativeHandle()) {
            return QNRTCClient.nativeGetConnectionState(this.nativeClient);
        }
        return QNConnectionState.DISCONNECTED;
    }

    /*
     * WARNING - void declaration
     */
    public void setLiveStreamingListener(QNLiveStreamingListener listener) {
        if (this.checkNativeHandle()) {
            void var1_1;
            if (this.mLiveStreamingListener == null) {
                this.mLiveStreamingListener = new QNLiveStreamingListenerWrapper(new Handler(Looper.getMainLooper()));
                this.nativeLiveStreamingListener = QNRTCClient.nativeSetLiveStreamingListener(this.nativeClient, this.mLiveStreamingListener);
            }
            this.mLiveStreamingListener.setListener((QNLiveStreamingListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void startLiveStreaming(QNDirectLiveStreamingConfig config) {
        if (config == null) {
            R7N8DF4OVS.c("QNDirectLiveStreamingConfig can not be null");
            if (this.mLiveStreamingListener != null) {
                QNLiveStreamingErrorInfo qNLiveStreamingErrorInfo = new QNLiveStreamingErrorInfo(QNLiveStreamingErrorInfo.Type.START, 10053, "Start live streaming failed because config is null.");
                this.mLiveStreamingListener.onError("", qNLiveStreamingErrorInfo);
            }
            return;
        }
        if (config.getAudioTrack() == null && config.getVideoTrack() == null) {
            R7N8DF4OVS.c("skip startLiveStreaming, QNDirectLiveStreamingConfig must contain one track at least");
            if (this.mLiveStreamingListener != null) {
                QNLiveStreamingErrorInfo qNLiveStreamingErrorInfo = new QNLiveStreamingErrorInfo(QNLiveStreamingErrorInfo.Type.START, 10053, "Start live streaming failed because audio and video tracks are both null.");
                this.mLiveStreamingListener.onError(config.getStreamID(), qNLiveStreamingErrorInfo);
            }
            return;
        }
        if (this.checkNativeHandle()) {
            void var1_1;
            QNRTCClient.nativeStartDirectStreaming(this.nativeClient, (QNDirectLiveStreamingConfig)var1_1);
        }
    }

    public void startLiveStreaming(QNTranscodingLiveStreamingConfig config) {
        QNLiveStreamingErrorInfo qNLiveStreamingErrorInfo;
        if (config == null) {
            R7N8DF4OVS.c("QNTranscodingLiveStreamingConfig can not be null");
            if (this.mLiveStreamingListener != null) {
                qNLiveStreamingErrorInfo = new QNLiveStreamingErrorInfo(QNLiveStreamingErrorInfo.Type.START, 10053, "Start live streaming failed because config is null.");
                this.mLiveStreamingListener.onError("", qNLiveStreamingErrorInfo);
            }
            return;
        }
        if (this.checkNativeHandle()) {
            QNRTCClient.nativeStartTranscodingStreaming(this.nativeClient, (QNTranscodingLiveStreamingConfig)((Object)qNLiveStreamingErrorInfo));
        }
    }

    public void stopLiveStreaming(QNDirectLiveStreamingConfig config) {
        QNLiveStreamingErrorInfo qNLiveStreamingErrorInfo;
        if (config == null) {
            R7N8DF4OVS.c("QNDirectLiveStreamingConfig can not be null");
            if (this.mLiveStreamingListener != null) {
                qNLiveStreamingErrorInfo = new QNLiveStreamingErrorInfo(QNLiveStreamingErrorInfo.Type.STOP, 10053, "Stop live streaming failed because config is null.");
                this.mLiveStreamingListener.onError("", qNLiveStreamingErrorInfo);
            }
            return;
        }
        if (this.checkNativeHandle()) {
            QNRTCClient.nativeStopDirectStreaming(this.nativeClient, (QNDirectLiveStreamingConfig)((Object)qNLiveStreamingErrorInfo));
        }
    }

    public void stopLiveStreaming(QNTranscodingLiveStreamingConfig config) {
        QNLiveStreamingErrorInfo qNLiveStreamingErrorInfo;
        if (config == null) {
            R7N8DF4OVS.c("QNTranscodingLiveStreamingConfig can not be null");
            if (this.mLiveStreamingListener != null) {
                qNLiveStreamingErrorInfo = new QNLiveStreamingErrorInfo(QNLiveStreamingErrorInfo.Type.STOP, 10053, "Stop live streaming failed because config is null.");
                this.mLiveStreamingListener.onError("", qNLiveStreamingErrorInfo);
            }
            return;
        }
        if (this.checkNativeHandle()) {
            QNRTCClient.nativeStopTranscodingStreaming(this.nativeClient, (QNTranscodingLiveStreamingConfig)((Object)qNLiveStreamingErrorInfo));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTranscodingLiveStreamingTracks(String streamID, List<QNTranscodingLiveStreamingTrack> transcodingTracks) {
        QNLiveStreamingErrorInfo qNLiveStreamingErrorInfo;
        if (transcodingTracks == null || transcodingTracks.isEmpty()) {
            if (this.mLiveStreamingListener != null) {
                qNLiveStreamingErrorInfo = new QNLiveStreamingErrorInfo(QNLiveStreamingErrorInfo.Type.UPDATE, 10053, "Update live streaming tracks failed because transcodingTracks is invalid.");
                this.mLiveStreamingListener.onError(streamID, qNLiveStreamingErrorInfo);
            }
            return;
        }
        if (this.checkNativeHandle()) {
            void var1_1;
            QNRTCClient.nativeSetTranscodingTracks(this.nativeClient, (String)var1_1, (List<QNTranscodingLiveStreamingTrack>)((Object)qNLiveStreamingErrorInfo));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeTranscodingLiveStreamingTracks(String streamID, List<QNTranscodingLiveStreamingTrack> transcodingTracks) {
        QNLiveStreamingErrorInfo qNLiveStreamingErrorInfo;
        if (transcodingTracks == null || transcodingTracks.isEmpty()) {
            R7N8DF4OVS.c("skip removeTranscodingLiveStreamingTracks, dummy parameters");
            if (this.mLiveStreamingListener != null) {
                qNLiveStreamingErrorInfo = new QNLiveStreamingErrorInfo(QNLiveStreamingErrorInfo.Type.UPDATE, 10053, "Update live streaming tracks failed because transcodingTracks is invalid.");
                this.mLiveStreamingListener.onError(streamID, qNLiveStreamingErrorInfo);
            }
            return;
        }
        if (this.checkNativeHandle()) {
            void var1_1;
            QNRTCClient.nativeRemoveTranscodingTracks(this.nativeClient, (String)var1_1, (List<QNTranscodingLiveStreamingTrack>)((Object)qNLiveStreamingErrorInfo));
        }
    }

    public void setRemoteTracksMixedAudioListener(QNAudioFrameListener listener) {
        HISPj7KHQ7.a(listener);
    }

    public List<QNTrack> getPublishedTracks() {
        if (this.checkNativeHandle()) {
            return QNRTCClient.nativeGetPublishedTracks(this.nativeClient);
        }
        return new ArrayList<QNTrack>();
    }

    /*
     * WARNING - void declaration
     */
    public QNRemoteUser getRemoteUser(String userID) {
        if (this.checkNativeHandle()) {
            void var1_1;
            return QNRTCClient.nativeGetRemoteUser(this.nativeClient, (String)var1_1);
        }
        return null;
    }

    public List<QNRemoteUser> getRemoteUsers() {
        if (this.checkNativeHandle()) {
            return QNRTCClient.nativeGetRemoteUsers(this.nativeClient);
        }
        return new ArrayList<QNRemoteUser>();
    }

    /*
     * WARNING - void declaration
     */
    public void setNetworkQualityListener(QNNetworkQualityListener listener) {
        if (this.checkNativeHandle()) {
            if (this.nativeNetworkQualityListener != 0L) {
                QNRTCClient.nativeUnSetNetworkQualityListener(this.nativeClient, this.nativeNetworkQualityListener);
                this.nativeNetworkQualityListener = 0L;
            }
            if (listener != null) {
                void var1_1;
                this.nativeNetworkQualityListener = QNRTCClient.nativeSetNetworkQualityListener(this.nativeClient, (QNNetworkQualityListener)var1_1);
            }
        }
    }

    public Map<String, QNNetworkQuality> getUserNetworkQuality() {
        if (this.checkNativeHandle()) {
            return QNRTCClient.nativeGetUserNetworkQuality(this.nativeClient);
        }
        return new HashMap<String, QNNetworkQuality>();
    }

    public Map<String, QNRemoteVideoTrackStats> getRemoteVideoTrackStats() {
        if (this.checkNativeHandle()) {
            return QNRTCClient.nativeGetRemoteVideoTrackStats(this.nativeClient);
        }
        return new HashMap<String, QNRemoteVideoTrackStats>();
    }

    public Map<String, QNRemoteAudioTrackStats> getRemoteAudioTrackStats() {
        if (this.checkNativeHandle()) {
            return QNRTCClient.nativeGetRemoteAudioTrackStats(this.nativeClient);
        }
        return new HashMap<String, QNRemoteAudioTrackStats>();
    }

    public Map<String, List<QNLocalVideoTrackStats>> getLocalVideoTrackStats() {
        if (this.checkNativeHandle()) {
            return QNRTCClient.nativeGetLocalVideoTrackStats(this.nativeClient);
        }
        return new HashMap<String, List<QNLocalVideoTrackStats>>();
    }

    public Map<String, QNLocalAudioTrackStats> getLocalAudioTrackStats() {
        if (this.checkNativeHandle()) {
            return QNRTCClient.nativeGetLocalAudioTrackStats(this.nativeClient);
        }
        return new HashMap<String, QNLocalAudioTrackStats>();
    }

    /*
     * WARNING - void declaration
     */
    public void startMediaRelay(QNMediaRelayConfiguration configuration, QNMediaRelayResultCallback callback) {
        if (this.checkNativeHandle()) {
            void var2_2;
            void var1_1;
            QNRTCClient.nativeStartMediaRelay(this.nativeClient, (QNMediaRelayConfiguration)var1_1, (QNMediaRelayResultCallback)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateMediaRelay(QNMediaRelayConfiguration configuration, QNMediaRelayResultCallback callback) {
        if (this.checkNativeHandle()) {
            void var2_2;
            void var1_1;
            QNRTCClient.nativeUpdateMediaRelay(this.nativeClient, (QNMediaRelayConfiguration)var1_1, (QNMediaRelayResultCallback)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void stopMediaRelay(QNMediaRelayResultCallback callback) {
        if (this.checkNativeHandle()) {
            void var1_1;
            QNRTCClient.nativeStopMediaRelay(this.nativeClient, (QNMediaRelayResultCallback)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void enableAudioVolumeIndication(int intervalMs) {
        if (this.checkNativeHandle()) {
            void var1_1;
            QNRTCClient.nativeEnableAudioVolumeIndication(this.nativeClient, (int)var1_1);
        }
    }

    private boolean checkNativeHandle() {
        if (this.nativeClient != 0L) {
            return true;
        }
        R7N8DF4OVS.c("Invalid native handle " + this + "; check !!!");
        return false;
    }

    void destroy() {
        if (this.checkNativeHandle()) {
            if (this.nativeLiveStreamingListener != 0L) {
                QNRTCClient.nativeUnSetLiveStreamingListener(this.nativeClient, this.nativeLiveStreamingListener);
                this.nativeLiveStreamingListener = 0L;
            }
            this.mLiveStreamingListener = null;
            if (this.nativeNetworkQualityListener != 0L) {
                QNRTCClient.nativeUnSetNetworkQualityListener(this.nativeClient, this.nativeNetworkQualityListener);
                this.nativeNetworkQualityListener = 0L;
            }
            QNRTCClient.nativeDestroy(this.nativeClient);
            this.nativeClient = 0L;
        }
        R7N8DF4OVS.a("destroy");
    }

    private static native void nativeSetClientRole(long var0, QNClientRole var2, QNClientRoleResultCallback var3);

    private static native void nativeJoin(long var0, String var2, String var3);

    private static native void nativeLeave(long var0);

    private static native QNConnectionState nativeGetConnectionState(long var0);

    private static native void nativeSetAutoSubscribe(long var0, boolean var2);

    private static native void nativePublish(long var0, List<QNLocalTrack> var2, QNPublishResultCallback var3);

    private static native void nativeUnPublish(long var0, List<QNLocalTrack> var2);

    private static native void nativeSubscribe(long var0, List<QNRemoteTrack> var2);

    private static native void nativeUnSubscribe(long var0, List<QNRemoteTrack> var2);

    private static native void nativeSendMessage(long var0, List<String> var2, String var3, String var4);

    private static native long nativeSetLiveStreamingListener(long var0, QNLiveStreamingListener var2);

    private static native void nativeUnSetLiveStreamingListener(long var0, long var2);

    private static native void nativeStartDirectStreaming(long var0, QNDirectLiveStreamingConfig var2);

    private static native void nativeStopDirectStreaming(long var0, QNDirectLiveStreamingConfig var2);

    private static native void nativeStartTranscodingStreaming(long var0, QNTranscodingLiveStreamingConfig var2);

    private static native void nativeStopTranscodingStreaming(long var0, QNTranscodingLiveStreamingConfig var2);

    private static native void nativeSetTranscodingTracks(long var0, String var2, List<QNTranscodingLiveStreamingTrack> var3);

    private static native void nativeRemoveTranscodingTracks(long var0, String var2, List<QNTranscodingLiveStreamingTrack> var3);

    private static native void nativeStartMediaRelay(long var0, QNMediaRelayConfiguration var2, QNMediaRelayResultCallback var3);

    private static native void nativeUpdateMediaRelay(long var0, QNMediaRelayConfiguration var2, QNMediaRelayResultCallback var3);

    private static native void nativeStopMediaRelay(long var0, QNMediaRelayResultCallback var2);

    private static native void nativeEnableAudioVolumeIndication(long var0, int var2);

    private static native QNRemoteUser nativeGetRemoteUser(long var0, String var2);

    private static native List<QNRemoteUser> nativeGetRemoteUsers(long var0);

    private static native List<QNTrack> nativeGetPublishedTracks(long var0);

    private static native long nativeSetNetworkQualityListener(long var0, QNNetworkQualityListener var2);

    private static native void nativeUnSetNetworkQualityListener(long var0, long var2);

    private static native Map nativeGetUserNetworkQuality(long var0);

    private static native Map nativeGetRemoteVideoTrackStats(long var0);

    private static native Map nativeGetRemoteAudioTrackStats(long var0);

    private static native Map nativeGetLocalVideoTrackStats(long var0);

    private static native Map nativeGetLocalAudioTrackStats(long var0);

    private static native void nativeDestroy(long var0);

    static class QNLiveStreamingListenerWrapper
    implements QNLiveStreamingListener {
        private QNLiveStreamingListener mUserListener;
        private final Handler mMainHandler;

        /*
         * WARNING - void declaration
         */
        QNLiveStreamingListenerWrapper(Handler mainHandler) {
            void var1_1;
            this.mMainHandler = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        void setListener(QNLiveStreamingListener userListener) {
            void var1_1;
            this.mUserListener = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onStarted(String streamID) {
            void var1_1;
            this.mMainHandler.post(() -> this.lambda$onStarted$0((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onStopped(String streamID) {
            void var1_1;
            this.mMainHandler.post(() -> this.lambda$onStopped$1((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onTranscodingTracksUpdated(String streamID) {
            void var1_1;
            this.mMainHandler.post(() -> this.lambda$onTranscodingTracksUpdated$2((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onError(String streamID, QNLiveStreamingErrorInfo errorInfo) {
            void var2_2;
            void var1_1;
            this.mMainHandler.post(() -> this.lambda$onError$3((String)var1_1, (QNLiveStreamingErrorInfo)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$onError$3(String streamID, QNLiveStreamingErrorInfo errorInfo) {
            if (this.mUserListener != null) {
                void var2_2;
                void var1_1;
                this.mUserListener.onError((String)var1_1, (QNLiveStreamingErrorInfo)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$onTranscodingTracksUpdated$2(String streamID) {
            if (this.mUserListener != null) {
                void var1_1;
                this.mUserListener.onTranscodingTracksUpdated((String)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$onStopped$1(String streamID) {
            if (this.mUserListener != null) {
                void var1_1;
                this.mUserListener.onStopped((String)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$onStarted$0(String streamID) {
            if (this.mUserListener != null) {
                void var1_1;
                this.mUserListener.onStarted((String)var1_1);
            }
        }
    }
}

