/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.droid.rtc.model;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import com.qiniu.droid.rtc.model.QNImage;
import com.qiniu.droid.rtc.utils.OyIbF7L6XB;
import org.json.JSONException;
import org.json.JSONObject;

public class QNVideoWaterMark
extends QNImage {
    private static final String TAG = "QNVideoWaterMark";
    private int mAlpha = 255;
    private float mRelativeSize = 0.0f;
    private float mWaterMarkX = 0.0f;
    private float mWaterMarkY = 0.0f;

    /*
     * WARNING - void declaration
     */
    public QNVideoWaterMark(Context ctx) {
        super((Context)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QNVideoWaterMark setRelativeSize(SIZE size) {
        void var1_1;
        this.setRelativeSize(var1_1.getValue());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QNVideoWaterMark setRelativeSize(float size) {
        void var1_1;
        if (size <= 0.0f || size > 1.0f) {
            throw new IllegalArgumentException("size values MUST be (0.0f-1.0f]");
        }
        this.mRelativeSize = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public QNVideoWaterMark setResourcePath(String absoluteResPath) {
        void var1_1;
        if (absoluteResPath == null) {
            throw new IllegalArgumentException("Illegal resource path.");
        }
        this.mResourcePath = var1_1;
        this.mResourceId = -1;
        this.mResourceBitmap = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public QNVideoWaterMark setResourceID(int resID) {
        void var1_1;
        if (resID < 0) {
            throw new IllegalArgumentException("Illegal resource id.");
        }
        this.mResourceId = var1_1;
        this.mResourcePath = null;
        this.mResourceBitmap = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public QNVideoWaterMark setResourceBitmap(Bitmap resBitmap) {
        void var1_1;
        if (resBitmap == null) {
            throw new IllegalArgumentException("Illegal resource bitmap");
        }
        this.mResourceBitmap = var1_1;
        this.mResourceId = -1;
        this.mResourcePath = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QNVideoWaterMark setRelativePosition(float x, float y) {
        void var2_2;
        void var1_1;
        if (x < 0.0f || x > 1.0f || y < 0.0f || y > 1.0f) {
            throw new IllegalArgumentException("position values MUST be [0.0f-1.0f]");
        }
        this.mWaterMarkX = var1_1;
        this.mWaterMarkY = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QNVideoWaterMark setAlpha(int alpha) {
        void var1_1;
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("alpha value should be [0...255]:".concat(String.valueOf(alpha)));
        }
        this.mAlpha = var1_1;
        return this;
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public float getX() {
        return this.mWaterMarkX;
    }

    public float getY() {
        return this.mWaterMarkY;
    }

    public float getRelativeSize() {
        return this.mRelativeSize;
    }

    /*
     * WARNING - void declaration
     */
    public Bitmap getWatermarkBitmap(int bgWidth, int bgHeight) {
        void var2_2;
        void var1_1;
        this.checkAndSetResolution((int)var1_1, (int)var2_2);
        if (this.mResourceBitmap != null) {
            return OyIbF7L6XB.a(this.mResourceBitmap, this.mImageWidth, this.mImageHeight);
        }
        if (this.mResourceId != -1) {
            return OyIbF7L6XB.a(this.mContext.getResources(), this.mResourceId, this.mImageWidth, this.mImageHeight);
        }
        if (this.mResourcePath != null) {
            return OyIbF7L6XB.a(this.mResourcePath, this.mImageWidth, this.mImageHeight);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void checkAndSetResolution(int bgWidth, int bgHeight) {
        int n = 0;
        int n2 = 0;
        if (this.mImageWidth > 0 && this.mImageHeight > 0) {
            n = this.mImageWidth;
            n2 = this.mImageHeight;
        } else if (this.mResourceBitmap != null) {
            n = this.mResourceBitmap.getWidth();
            n2 = this.mResourceBitmap.getHeight();
        } else if (this.mResourceId != -1) {
            n2 = this.mResourceId;
            Resources resources = this.mContext.getResources();
            BitmapFactory.Options options = new BitmapFactory.Options();
            new BitmapFactory.Options().inJustDecodeBounds = true;
            BitmapFactory.decodeResource((Resources)resources, (int)n2, (BitmapFactory.Options)options);
            Point point = new Point(options.outWidth, options.outHeight);
            n = point.x;
            n2 = point.y;
        } else if (this.mResourcePath != null) {
            String string = this.mResourcePath;
            BitmapFactory.Options options = new BitmapFactory.Options();
            new BitmapFactory.Options().inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
            options = new Point(options.outWidth, options.outHeight);
            n = options.x;
            n2 = options.y;
        }
        if (n > bgWidth || n2 > bgHeight) {
            void var1_1;
            int n3;
            n = n > bgWidth ? bgWidth : (int)((float)bgHeight / (float)n2 * (float)n);
            n2 = n2 > bgHeight ? n3 : (int)((float)var1_1 / (float)n * (float)n2);
        }
        this.mImageWidth = n;
        this.mImageHeight = n2;
    }

    public String toString() {
        Object object = new JSONObject();
        try {
            object.put("PositionX", (double)this.mWaterMarkX);
            object.put("PositionY", (double)this.mWaterMarkY);
            object.put("Alpha", this.mAlpha);
            return object.toString();
        }
        catch (JSONException jSONException) {
            object = jSONException;
            jSONException.printStackTrace();
            return object.toString();
        }
    }

    public static enum SIZE {
        LARGE(0.4f),
        MEDIUM(0.3f),
        SMALL(0.2f);

        private float mValue;

        /*
         * WARNING - void declaration
         */
        private SIZE(float value) {
            void var3_3;
            this.mValue = var3_3;
        }

        public final float getValue() {
            return this.mValue;
        }
    }
}

