/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.droid.rtc.utils;

import org.qnwebrtc.CalledByNative;

public class RTCSdkConfig {
    VideoEncoderType encoderType;
    VideoDecoderType decoderType;
    AudioRecordSampleRate sampleRate;
    AudioRecordChannel audioChannel;
    AudioAECMode aecMode;
    AudioSoftAECConfig aecConfig;
    boolean autoUploadLog;
    boolean hardwareEncoderUseNV12;
    boolean useLowLatencyOutput;

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    RTCSdkConfig(VideoEncoderType etype, VideoDecoderType dtype, AudioRecordSampleRate sample, AudioRecordChannel channel, AudioAECMode aec, AudioSoftAECConfig config, boolean autoUploadLog, boolean useNV12, boolean useLowLatencyOutput) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.encoderType = var1_1;
        this.decoderType = var2_2;
        this.sampleRate = var3_3;
        this.audioChannel = channel;
        this.aecMode = aec;
        this.aecConfig = config;
        this.autoUploadLog = autoUploadLog;
        this.hardwareEncoderUseNV12 = useNV12;
        this.useLowLatencyOutput = useLowLatencyOutput;
    }

    public AudioRecordSampleRate getAudioRecordSampleRate() {
        return this.sampleRate;
    }

    public AudioRecordChannel getAudioRecordChannel() {
        return this.audioChannel;
    }

    public AudioAECMode getAudioAECMode() {
        return this.aecMode;
    }

    public boolean isAudioAECSoft() {
        return this.aecMode == AudioAECMode.HardwareSoftAEC || this.aecMode == AudioAECMode.SoftAEC;
    }

    public boolean isAudioAECHardware() {
        return this.aecMode == AudioAECMode.HardwareSoftAEC || this.aecMode == AudioAECMode.Hardware;
    }

    public boolean isAutoUploadLog() {
        return this.autoUploadLog;
    }

    public boolean isUseLowLatencyOutput() {
        return this.useLowLatencyOutput;
    }

    public AudioSoftAECConfig getAudioSoftAECConfig() {
        return this.aecConfig;
    }

    public String toString() {
        return "{ encoder: " + this.encoderType.name() + ", decoder: " + this.decoderType.name() + ", samplerate: " + this.sampleRate.name() + ", channel: " + this.audioChannel.name() + ", aecmode: " + this.aecMode.name() + ", aecconfig: " + this.aecConfig.toString() + ", autouploadlog: " + this.autoUploadLog + ", useLowLatencyOutput: " + this.useLowLatencyOutput + " }";
    }

    public static class AudioSoftAECConfig {
        public boolean enableQiniu;
        public boolean enablePaoPao;
        public boolean enableDenoise;
        public boolean enableHowl;
        public boolean enableRtcDenoise;
        public boolean enableDenoiseByScene;
        public float nlpTarget;
        public float reverbCoef;

        /*
         * WARNING - void declaration
         */
        @CalledByNative(value="AudioSoftAECConfig")
        AudioSoftAECConfig(boolean enableQiniu, boolean enablePaoPao, boolean enableDenoise, boolean enableHowl, boolean enableRtcDenoise, boolean enableDenoiseByScene, float nlpTarget, float reverbCoef) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.enableQiniu = var1_1;
            this.enablePaoPao = var2_2;
            this.enableDenoise = var3_3;
            this.enableHowl = enableHowl;
            this.enableRtcDenoise = enableRtcDenoise;
            this.enableDenoiseByScene = enableDenoiseByScene;
            this.nlpTarget = nlpTarget;
            this.reverbCoef = reverbCoef;
        }

        public String toString() {
            return "{ enableqiniu: " + this.enableQiniu + ", panpao: " + this.enablePaoPao + ", denoise: " + this.enableDenoise + ", howl: " + this.enableHowl + ", rtcdenoise: " + this.enableRtcDenoise + ", scenedenoise: " + this.enableDenoiseByScene + ", nlp: " + this.nlpTarget + ", reverb: " + this.reverbCoef;
        }
    }

    public static enum AudioAECMode {
        Invalid,
        Hardware,
        SoftAEC,
        HardwareSoftAEC,
        None;


        @CalledByNative(value="AudioAECMode")
        static AudioAECMode fromNativeIndex(int nativeIndex) {
            int n;
            return AudioAECMode.values()[n + 1];
        }
    }

    public static enum AudioRecordChannel {
        Invalid,
        Mono,
        Stereo;


        @CalledByNative(value="AudioRecordChannel")
        static AudioRecordChannel fromNativeIndex(int nativeIndex) {
            int n;
            return AudioRecordChannel.values()[n + 1];
        }
    }

    public static enum AudioRecordSampleRate {
        Invalid,
        SampleRate16k,
        SampleRate48k;


        @CalledByNative(value="AudioRecordSampleRate")
        static AudioRecordSampleRate fromNativeIndex(int nativeIndex) {
            int n;
            return AudioRecordSampleRate.values()[n + 1];
        }
    }

    public static enum VideoDecoderType {
        Invalid,
        HardwareH264,
        SoftwareH264;


        @CalledByNative(value="VideoDecoderType")
        static VideoDecoderType fromNativeIndex(int nativeIndex) {
            int n;
            return VideoDecoderType.values()[n + 1];
        }
    }

    public static enum VideoEncoderType {
        Invalid,
        HardwareH264,
        SoftwareH264,
        SoftwareH264WithFallback;


        @CalledByNative(value="VideoEncoderType")
        static VideoEncoderType fromNativeIndex(int nativeIndex) {
            int n;
            return VideoEncoderType.values()[n + 1];
        }
    }
}

