/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.EncodedImage;
import org.qnwebrtc.JavaI420Buffer;
import org.qnwebrtc.Logging;
import org.qnwebrtc.MediaCodecUtils;
import org.qnwebrtc.MediaCodecWrapper;
import org.qnwebrtc.MediaCodecWrapperFactory;
import org.qnwebrtc.NV12Buffer;
import org.qnwebrtc.SurfaceTextureHelper;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoCodecStatus;
import org.qnwebrtc.VideoCodecType;
import org.qnwebrtc.VideoDecoder;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoSink;
import org.qnwebrtc.YuvHelper;

class AndroidVideoDecoder
implements VideoDecoder,
VideoSink {
    private static final String TAG = "AndroidVideoDecoder";
    private static final String MEDIA_FORMAT_KEY_STRIDE = "stride";
    private static final String MEDIA_FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String MEDIA_FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String MEDIA_FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String MEDIA_FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String MEDIA_FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_INPUT_TIMEOUT_US = 500000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private static final int DECODE_TIMEMS_WARNING_THRESHOLD = 200;
    private static final int DECODE_REINIT_FOR_IDLE_MS = 2000;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final VideoCodecType codecType;
    private final BlockingDeque<FrameInfo> frameInfos;
    private int colorFormat;
    @Nullable
    private Thread outputThread;
    private ThreadUtils.ThreadChecker outputThreadChecker;
    private ThreadUtils.ThreadChecker decoderThreadChecker;
    private volatile boolean running;
    @Nullable
    private volatile Exception shutdownException;
    private final Object dimensionLock = new Object();
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private boolean keyFrameRequired;
    private long lastDecodedFrameMs;
    @Nullable
    private final EglBase.Context sharedContext;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private Surface surface;
    private final Object renderedTextureMetadataLock = new Object();
    @Nullable
    private DecodedTextureMetadata renderedTextureMetadata;
    @Nullable
    private VideoDecoder.Callback callback;
    @Nullable
    private MediaCodecWrapper codec;

    /*
     * WARNING - void declaration
     */
    AndroidVideoDecoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String codecName, VideoCodecType codecType, int colorFormat, @Nullable EglBase.Context sharedContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.isSupportedColorFormat(colorFormat)) {
            throw new IllegalArgumentException("Unsupported color format: ".concat(String.valueOf(colorFormat)));
        }
        Logging.d(TAG, "ctor name: " + codecName + " type: " + (Object)((Object)codecType) + " color format: " + colorFormat + " context: " + sharedContext);
        this.mediaCodecWrapperFactory = var1_1;
        this.codecName = var2_2;
        this.codecType = var3_3;
        this.colorFormat = colorFormat;
        this.sharedContext = sharedContext;
        this.frameInfos = new LinkedBlockingDeque<FrameInfo>();
        this.lastDecodedFrameMs = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public VideoCodecStatus initDecode(VideoDecoder.Settings settings, VideoDecoder.Callback callback) {
        void var1_1;
        void var2_2;
        this.decoderThreadChecker = new ThreadUtils.ThreadChecker();
        this.callback = var2_2;
        if (this.sharedContext != null) {
            this.surfaceTextureHelper = this.createSurfaceTextureHelper();
            this.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
            this.surfaceTextureHelper.startListening(this);
        }
        return this.initDecodeInternal(settings.width, var1_1.height);
    }

    /*
     * WARNING - void declaration
     */
    private VideoCodecStatus initDecodeInternal(int width, int height) {
        this.decoderThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "initDecodeInternal name: " + this.codecName + " type: " + (Object)((Object)this.codecType) + " width: " + width + " height: " + height);
        if (this.outputThread != null) {
            Logging.e(TAG, "initDecodeInternal called while the codec is already running");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.width = width;
        this.height = height;
        this.stride = width;
        this.sliceHeight = height;
        this.hasDecodedFirstFrame = false;
        this.keyFrameRequired = true;
        try {
            this.codec = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            Logging.e(TAG, "Cannot create media decoder " + this.codecName);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        try {
            void var2_4;
            void var1_1;
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)var1_1, (int)var2_4);
            if (this.sharedContext == null) {
                mediaFormat.setInteger("color-format", this.colorFormat);
            }
            this.codec.configure(mediaFormat, this.surface, null, 0);
            this.codec.start();
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.running = true;
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        Logging.d(TAG, "initDecodeInternal done");
        return VideoCodecStatus.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public VideoCodecStatus decode(EncodedImage frame, VideoDecoder.DecodeInfo info) {
        void var1_1;
        ByteBuffer byteBuffer;
        int n;
        int n2;
        int n3;
        this.decoderThreadChecker.checkIsOnValidThread();
        if (this.codec == null || this.callback == null) {
            Logging.d(TAG, "decode uninitalized, codec: " + (this.codec != null) + ", callback: " + this.callback);
            return VideoCodecStatus.UNINITIALIZED;
        }
        if (frame.buffer == null) {
            Logging.e(TAG, "decode() - no input data");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        int n4 = frame.buffer.remaining();
        if (n4 == 0) {
            Logging.e(TAG, "decode() - input buffer empty");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            n3 = this.width;
            n2 = this.height;
        }
        if (frame.encodedWidth * frame.encodedHeight > 0 && (frame.encodedWidth != n3 || frame.encodedHeight != n2) && (object = this.reinitDecode(frame.encodedWidth, frame.encodedHeight)) != VideoCodecStatus.OK) {
            return object;
        }
        if (frame.frameType == EncodedImage.FrameType.VideoFrameKey && System.currentTimeMillis() - this.lastDecodedFrameMs > 2000L) {
            Logging.i(TAG, "reinit for idle time " + (System.currentTimeMillis() - this.lastDecodedFrameMs));
            object = this.reinitDecode(n3, n2);
            if (object != VideoCodecStatus.OK) {
                return object;
            }
        }
        if (this.keyFrameRequired) {
            if (frame.frameType != EncodedImage.FrameType.VideoFrameKey) {
                Logging.e(TAG, "decode() - key frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
            if (!frame.completeFrame) {
                Logging.e(TAG, "decode() - complete frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
        }
        try {
            n = this.codec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueInputBuffer failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        if (n < 0) {
            Logging.e(TAG, "decode() - no HW buffers available; decoder falling behind");
            return VideoCodecStatus.ERROR;
        }
        try {
            byteBuffer = this.codec.getInputBuffers()[n];
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "getInputBuffers failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        if (byteBuffer.capacity() < n4) {
            Logging.e(TAG, "decode() - HW buffer too small");
            return VideoCodecStatus.ERROR;
        }
        byteBuffer.put(var1_1.buffer);
        this.frameInfos.offer(new FrameInfo(SystemClock.elapsedRealtime(), var1_1.rotation));
        try {
            this.codec.queueInputBuffer(n, 0, n4, TimeUnit.NANOSECONDS.toMicros(var1_1.captureTimeNs), 0);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "queueInputBuffer failed", illegalStateException);
            this.frameInfos.pollLast();
            return VideoCodecStatus.ERROR;
        }
        if (this.keyFrameRequired) {
            this.keyFrameRequired = false;
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public boolean getPrefersLateDecoding() {
        return true;
    }

    @Override
    public String getImplementationName() {
        return this.codecName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus release() {
        Logging.d(TAG, "release");
        VideoCodecStatus videoCodecStatus = this.releaseInternal();
        if (this.surface != null) {
            this.releaseSurface();
            this.surface = null;
            this.surfaceTextureHelper.stopListening();
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        Object object = this.renderedTextureMetadataLock;
        synchronized (object) {
            this.renderedTextureMetadata = null;
        }
        this.callback = null;
        this.frameInfos.clear();
        return videoCodecStatus;
    }

    private VideoCodecStatus releaseInternal() {
        if (!this.running) {
            Logging.d(TAG, "release: Decoder is not running.");
            return VideoCodecStatus.OK;
        }
        try {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e(TAG, "Media decoder release timeout", new RuntimeException());
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.TIMEOUT;
                return videoCodecStatus;
            }
            if (this.shutdownException != null) {
                Logging.e(TAG, "Media decoder release error", new RuntimeException(this.shutdownException));
                this.shutdownException = null;
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.ERROR;
                return videoCodecStatus;
            }
        }
        finally {
            this.codec = null;
            this.outputThread = null;
            this.frameInfos.clear();
        }
        return VideoCodecStatus.OK;
    }

    /*
     * WARNING - void declaration
     */
    private VideoCodecStatus reinitDecode(int newWidth, int newHeight) {
        void var2_2;
        void var1_1;
        Logging.d(TAG, "reinitDecode");
        this.decoderThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = this.releaseInternal();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        return this.initDecodeInternal((int)var1_1, (int)var2_2);
    }

    private Thread createOutputThread() {
        return new Thread(this, "AndroidVideoDecoder.outputThread"){
            final /* synthetic */ AndroidVideoDecoder this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((String)var2_2);
            }

            @Override
            public void run() {
                AndroidVideoDecoder.access$002(this.this$0, new ThreadUtils.ThreadChecker());
                while (this.this$0.running) {
                    this.this$0.deliverDecodedFrame();
                }
                this.this$0.releaseCodecOnOutputThread();
            }
        };
    }

    protected void deliverDecodedFrame() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n = this.codec.dequeueOutputBuffer(bufferInfo, 100000L);
            if (n == -2) {
                AndroidVideoDecoder androidVideoDecoder = this;
                androidVideoDecoder.reformat(androidVideoDecoder.codec.getOutputFormat());
                return;
            }
            if (n < 0) {
                Logging.v(TAG, "dequeueOutputBuffer returned ".concat(String.valueOf(n)));
                return;
            }
            FrameInfo frameInfo = this.frameInfos.poll();
            Integer n2 = null;
            int n3 = 0;
            if (frameInfo != null) {
                n2 = (int)(SystemClock.elapsedRealtime() - frameInfo.decodeStartTimeMs);
                n3 = frameInfo.rotation;
            }
            if (n2 > 200) {
                Logging.w(TAG, "warning large decode " + n2 + "ms, start " + frameInfo.decodeStartTimeMs);
            }
            this.hasDecodedFirstFrame = true;
            if (this.surfaceTextureHelper != null) {
                this.deliverTextureFrame(n, bufferInfo, n3, n2);
                return;
            }
            this.deliverByteFrame(n, bufferInfo, n3, n2);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "deliverDecodedFrame failed", illegalStateException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void deliverTextureFrame(int index, MediaCodec.BufferInfo info, int rotation, Integer decodeTimeMs) {
        int n;
        int n2;
        Object object = this.dimensionLock;
        synchronized (object) {
            n2 = this.width;
            n = this.height;
        }
        object = this.renderedTextureMetadataLock;
        synchronized (object) {
            void var1_1;
            void var2_4;
            void var3_5;
            if (this.renderedTextureMetadata != null) {
                this.codec.releaseOutputBuffer(index, false);
                return;
            }
            this.surfaceTextureHelper.setTextureSize(n2, n);
            this.surfaceTextureHelper.setFrameRotation((int)var3_5);
            this.renderedTextureMetadata = new DecodedTextureMetadata(var2_4.presentationTimeUs, decodeTimeMs);
            this.codec.releaseOutputBuffer((int)var1_1, true);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onFrame(VideoFrame frame) {
        void var1_1;
        Integer n;
        long l2;
        Object object = this.renderedTextureMetadataLock;
        synchronized (object) {
            if (this.renderedTextureMetadata == null) {
                throw new IllegalStateException("Rendered texture metadata was null in onTextureFrameAvailable.");
            }
            l2 = this.renderedTextureMetadata.presentationTimestampUs * 1000L;
            n = this.renderedTextureMetadata.decodeTimeMs;
            this.renderedTextureMetadata = null;
        }
        object = new VideoFrame(frame.getBuffer(), var1_1.getRotation(), l2);
        this.lastDecodedFrameMs = System.currentTimeMillis();
        this.callback.onDecodedFrame((VideoFrame)object, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void deliverByteFrame(int result, MediaCodec.BufferInfo info, int rotation, Integer decodeTimeMs) {
        void var3_4;
        void var2_3;
        void var1_1;
        int n;
        int n2;
        int n3;
        int n4;
        Object object = this.dimensionLock;
        synchronized (object) {
            n4 = this.width;
            n3 = this.height;
            n2 = this.stride;
            n = this.sliceHeight;
        }
        if (info.size < n4 * n3 * 3 / 2) {
            Logging.e(TAG, "Insufficient output buffer size: " + info.size);
            return;
        }
        if (info.size < n2 * n3 * 3 / 2 && n == n3 && n2 > n4) {
            n2 = info.size * 2 / (n3 * 3);
        }
        object = this.codec.getOutputBuffers()[result];
        ((ByteBuffer)object).position(info.offset);
        ((ByteBuffer)object).limit(info.offset + info.size);
        object = ((ByteBuffer)object).slice();
        VideoFrame.Buffer buffer = this.colorFormat == 19 ? this.copyI420Buffer((ByteBuffer)object, n2, n, n4, n3) : this.copyNV12ToI420Buffer((ByteBuffer)object, n2, n, n4, n3);
        this.codec.releaseOutputBuffer((int)var1_1, false);
        long l2 = var2_3.presentationTimeUs * 1000L;
        VideoFrame videoFrame = new VideoFrame(buffer, (int)var3_4, l2);
        this.callback.onDecodedFrame(videoFrame, decodeTimeMs, null);
        this.lastDecodedFrameMs = System.currentTimeMillis();
        videoFrame.release();
    }

    /*
     * WARNING - void declaration
     */
    private VideoFrame.Buffer copyNV12ToI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        void var1_1;
        void var3_3;
        void var2_2;
        return new NV12Buffer(width, height, (int)var2_2, (int)var3_3, (ByteBuffer)var1_1, null).toI420();
    }

    /*
     * WARNING - void declaration
     */
    private VideoFrame.Buffer copyI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        void var3_5;
        void var2_2;
        if (stride % 2 != 0) {
            throw new AssertionError((Object)"Stride is not divisible by two: ".concat(String.valueOf(stride)));
        }
        int n = (width + 1) / 2;
        int n2 = sliceHeight % 2 == 0 ? (height + 1) / 2 : height / 2;
        int n3 = stride / 2;
        int n4 = 0 + stride * height;
        int n5 = 0 + stride * sliceHeight;
        int n6 = n5 + n3 * n2;
        int n7 = n5 + n3 * sliceHeight / 2;
        int n8 = n7 + n3 * n2;
        VideoFrame.I420Buffer i420Buffer = this.allocateI420Buffer(width, height);
        buffer.limit(n4);
        buffer.position(0);
        this.copyPlane(buffer.slice(), (int)var2_2, i420Buffer.getDataY(), i420Buffer.getStrideY(), width, height);
        buffer.limit(n6);
        buffer.position(n5);
        this.copyPlane(buffer.slice(), n3, i420Buffer.getDataU(), i420Buffer.getStrideU(), n, n2);
        if (sliceHeight % 2 == 1) {
            buffer.position(n5 + n3 * (n2 - 1));
            ByteBuffer byteBuffer = i420Buffer.getDataU();
            byteBuffer.position(i420Buffer.getStrideU() * n2);
            byteBuffer.put(buffer);
        }
        buffer.limit(n8);
        buffer.position(n7);
        this.copyPlane(buffer.slice(), n3, i420Buffer.getDataV(), i420Buffer.getStrideV(), n, n2);
        if (var3_5 % 2 == true) {
            void var1_1;
            buffer.position(n7 + n3 * (n2 - 1));
            ByteBuffer byteBuffer = i420Buffer.getDataV();
            byteBuffer.position(i420Buffer.getStrideV() * n2);
            byteBuffer.put((ByteBuffer)var1_1);
        }
        return i420Buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void reformat(MediaFormat format) {
        int n;
        int n2;
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Decoder format changed: " + format.toString());
        if (format.containsKey(MEDIA_FORMAT_KEY_CROP_LEFT) && format.containsKey(MEDIA_FORMAT_KEY_CROP_RIGHT) && format.containsKey(MEDIA_FORMAT_KEY_CROP_BOTTOM) && format.containsKey(MEDIA_FORMAT_KEY_CROP_TOP)) {
            n2 = 1 + format.getInteger(MEDIA_FORMAT_KEY_CROP_RIGHT) - format.getInteger(MEDIA_FORMAT_KEY_CROP_LEFT);
            n = 1 + format.getInteger(MEDIA_FORMAT_KEY_CROP_BOTTOM) - format.getInteger(MEDIA_FORMAT_KEY_CROP_TOP);
        } else {
            n2 = format.getInteger("width");
            n = format.getInteger("height");
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            if (this.hasDecodedFirstFrame && (this.width != n2 || this.height != n)) {
                this.stopOnOutputThread(new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n2 + "*" + n));
                return;
            }
            this.width = n2;
            this.height = n;
        }
        if (this.surfaceTextureHelper == null && format.containsKey("color-format")) {
            this.colorFormat = format.getInteger("color-format");
            Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
            AndroidVideoDecoder androidVideoDecoder = this;
            if (!androidVideoDecoder.isSupportedColorFormat(androidVideoDecoder.colorFormat)) {
                this.stopOnOutputThread(new IllegalStateException("Unsupported color format: " + this.colorFormat));
                return;
            }
        }
        object = this.dimensionLock;
        synchronized (object) {
            if (format.containsKey(MEDIA_FORMAT_KEY_STRIDE)) {
                this.stride = format.getInteger(MEDIA_FORMAT_KEY_STRIDE);
            }
            if (format.containsKey(MEDIA_FORMAT_KEY_SLICE_HEIGHT)) {
                void var1_1;
                this.sliceHeight = var1_1.getInteger(MEDIA_FORMAT_KEY_SLICE_HEIGHT);
            }
            Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
            this.stride = Math.max(this.width, this.stride);
            this.sliceHeight = Math.max(this.height, this.sliceHeight);
            return;
        }
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media decoder stop failed", exception);
        }
        try {
            this.codec.release();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media decoder release failed", exception);
            this.shutdownException = exception;
        }
        Logging.d(TAG, "Release on output thread done");
    }

    /*
     * WARNING - void declaration
     */
    private void stopOnOutputThread(Exception e2) {
        void var1_1;
        this.outputThreadChecker.checkIsOnValidThread();
        this.running = false;
        this.shutdownException = var1_1;
    }

    private boolean isSupportedColorFormat(int colorFormat) {
        int[] nArray = MediaCodecUtils.DECODER_COLOR_FORMATS;
        int n = MediaCodecUtils.DECODER_COLOR_FORMATS.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (nArray[i2] != colorFormat) continue;
            return true;
        }
        return false;
    }

    protected SurfaceTextureHelper createSurfaceTextureHelper() {
        return SurfaceTextureHelper.create("decoder-texture-thread", this.sharedContext);
    }

    protected void releaseSurface() {
        this.surface.release();
    }

    /*
     * WARNING - void declaration
     */
    protected VideoFrame.I420Buffer allocateI420Buffer(int width, int height) {
        void var2_2;
        return JavaI420Buffer.allocate(width, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void copyPlane(ByteBuffer src, int srcStride, ByteBuffer dst, int dstStride, int width, int height) {
        void var3_3;
        void var2_2;
        YuvHelper.copyPlane(src, (int)var2_2, (ByteBuffer)var3_3, dstStride, width, height);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ThreadUtils.ThreadChecker access$002(AndroidVideoDecoder x0, ThreadUtils.ThreadChecker x1) {
        void var1_1;
        x0.outputThreadChecker = var1_1;
        return x0.outputThreadChecker;
    }

    static class DecodedTextureMetadata {
        final long presentationTimestampUs;
        final Integer decodeTimeMs;

        /*
         * WARNING - void declaration
         */
        DecodedTextureMetadata(long presentationTimestampUs, Integer decodeTimeMs) {
            void var3_2;
            void var1_1;
            this.presentationTimestampUs = var1_1;
            this.decodeTimeMs = var3_2;
        }
    }

    static class FrameInfo {
        final long decodeStartTimeMs;
        final int rotation;

        /*
         * WARNING - void declaration
         */
        FrameInfo(long decodeStartTimeMs, int rotation) {
            void var3_2;
            void var1_1;
            this.decodeStartTimeMs = var1_1;
            this.rotation = var3_2;
        }
    }
}

