/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.hardware.Camera;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.qnwebrtc.Camera1Capturer;
import org.qnwebrtc.CameraEnumerationAndroid;
import org.qnwebrtc.CameraEnumerator;
import org.qnwebrtc.CameraVideoCapturer;
import org.qnwebrtc.Logging;
import org.qnwebrtc.Size;

public class Camera1Enumerator
implements CameraEnumerator {
    private static final String TAG = "Camera1Enumerator";
    private static List<List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats;
    private final boolean captureToTexture;
    private boolean needPreviewCallback;

    public Camera1Enumerator() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    public Camera1Enumerator(boolean captureToTexture) {
        void var1_1;
        this.captureToTexture = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setNeedPreviewCallback(boolean needPreviewCallback) {
        void var1_1;
        this.needPreviewCallback = var1_1;
    }

    @Override
    public String[] getDeviceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
            String string = Camera1Enumerator.getDeviceName(i2);
            if (string != null) {
                arrayList.add(string);
                Logging.d(TAG, "Index: " + i2 + ". " + string);
                continue;
            }
            Logging.e(TAG, "Index: " + i2 + ". Failed to query camera name.");
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    @Override
    public boolean isFrontFacing(String deviceName) {
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(deviceName));
        return cameraInfo != null && cameraInfo.facing == 1;
    }

    @Override
    public boolean isBackFacing(String deviceName) {
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(deviceName));
        return cameraInfo != null && cameraInfo.facing == 0;
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String deviceName) {
        return Camera1Enumerator.getSupportedFormats(Camera1Enumerator.getCameraIndex(deviceName));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CameraVideoCapturer createCapturer(String deviceName, CameraVideoCapturer.CameraEventsHandler eventsHandler) {
        void var2_2;
        void var1_1;
        return new Camera1Capturer((String)var1_1, (CameraVideoCapturer.CameraEventsHandler)var2_2, this.captureToTexture, this.needPreviewCallback);
    }

    @Nullable
    private static Camera.CameraInfo getCameraInfo(int index) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)index, (Camera.CameraInfo)cameraInfo);
        }
        catch (Exception exception) {
            int n;
            Logging.e(TAG, "getCameraInfo failed on index ".concat(String.valueOf(n)), exception);
            return null;
        }
        return cameraInfo;
    }

    static synchronized List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int cameraId) {
        int n;
        if (cachedSupportedFormats == null) {
            cachedSupportedFormats = new ArrayList<List<CameraEnumerationAndroid.CaptureFormat>>();
            for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
                cachedSupportedFormats.add(Camera1Enumerator.enumerateFormats(i2));
            }
        }
        return cachedSupportedFormats.get(n);
    }

    private static List<CameraEnumerationAndroid.CaptureFormat> enumerateFormats(int cameraId) {
        int n;
        Camera.Parameters parameters22;
        Logging.d(TAG, "Get supported formats for camera index " + cameraId + ".");
        long l2 = SystemClock.elapsedRealtime();
        Object object = null;
        try {
            Logging.d(TAG, "Opening camera with index ".concat(String.valueOf(cameraId)));
            object = Camera.open((int)cameraId);
            parameters22 = object.getParameters();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Open camera failed on camera index ".concat(String.valueOf(cameraId)), runtimeException);
            ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            return arrayList;
        }
        finally {
            if (object != null) {
                object.release();
            }
        }
        ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
        try {
            Camera camera;
            int n2 = 0;
            boolean n3 = false;
            object = parameters22.getSupportedPreviewFpsRange();
            if (object != null) {
                Camera camera2 = object;
                int[] nArray = (int[])camera2.get(camera2.size() - 1);
                object = nArray;
                n2 = nArray[0];
                camera = object[1];
            }
            for (Camera.Parameters parameters22 : parameters22.getSupportedPreviewSizes()) {
                arrayList.add(new CameraEnumerationAndroid.CaptureFormat(parameters22.width, parameters22.height, n2, (int)camera));
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "getSupportedFormats() failed on camera index ".concat(String.valueOf(cameraId)), exception);
        }
        long l3 = SystemClock.elapsedRealtime();
        Logging.d(TAG, "Get supported formats for camera index " + n + " done. Time spent: " + (l3 - l2) + " ms.");
        return arrayList;
    }

    static List<Size> convertSizes(List<Camera.Size> cameraSizes) {
        Iterator<Camera.Size> iterator;
        ArrayList<Size> arrayList = new ArrayList<Size>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Camera.Size size = (Camera.Size)iterator.next();
            arrayList.add(new Size(size.width, size.height));
        }
        return arrayList;
    }

    static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(List<int[]> arrayRanges) {
        Iterator<int[]> iterator;
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            int[] nArray = (int[])iterator.next();
            arrayList.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange(nArray[0], nArray[1]));
        }
        return arrayList;
    }

    static int getCameraIndex(String deviceName) {
        String string;
        Logging.d(TAG, "getCameraIndex: ".concat(String.valueOf(deviceName)));
        for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
            if (!deviceName.equals(Camera1Enumerator.getDeviceName(i2))) continue;
            return i2;
        }
        throw new IllegalArgumentException("No such camera: ".concat(String.valueOf(string)));
    }

    @Nullable
    static String getDeviceName(int index) {
        int n;
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(index);
        if (cameraInfo == null) {
            return null;
        }
        String string = cameraInfo.facing == 1 ? "front" : "back";
        return "Camera " + n + ", Facing " + string + ", Orientation " + cameraInfo.orientation;
    }
}

