/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.qnwebrtc.Camera1Enumerator;
import org.qnwebrtc.CameraEnumerationAndroid;
import org.qnwebrtc.CameraSession;
import org.qnwebrtc.Histogram;
import org.qnwebrtc.Logging;
import org.qnwebrtc.NV21Buffer;
import org.qnwebrtc.RefCounted;
import org.qnwebrtc.Size;
import org.qnwebrtc.SurfaceTextureHelper;
import org.qnwebrtc.TextureBufferImpl;
import org.qnwebrtc.VideoFrame;

class Camera1Session
implements CameraSession {
    private static final String TAG = "Camera1Session";
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static final Histogram camera1StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera1StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera1ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera1.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private static boolean sNeedPreviewCallback;
    private final Handler cameraThreadHandler;
    private final CameraSession.Events events;
    private final boolean captureToTexture;
    private final Context applicationContext;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int cameraId;
    private final Camera camera;
    private final Camera.CameraInfo info;
    private final CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final long constructionTimeNs;
    private SessionState state;
    private boolean firstFrameReported;
    private boolean isMirror;
    private boolean isCameraFrontFacing;

    /*
     * WARNING - void declaration
     */
    public static void create(CameraSession.CreateSessionCallback callback, CameraSession.Events events, boolean captureToTexture, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, int cameraId, int width, int height, int framerate, boolean needPreviewCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        CameraSession.CreateSessionCallback createSessionCallback;
        CameraEnumerationAndroid.CaptureFormat captureFormat;
        Camera camera;
        long l2 = System.nanoTime();
        Logging.d(TAG, "Open camera ".concat(String.valueOf(cameraId)));
        events.onCameraOpening();
        sNeedPreviewCallback = needPreviewCallback;
        try {
            camera = Camera.open((int)cameraId);
        }
        catch (RuntimeException runtimeException) {
            callback.onFailure(CameraSession.FailureType.ERROR, runtimeException.getMessage());
            return;
        }
        if (camera == null) {
            callback.onFailure(CameraSession.FailureType.ERROR, "android.hardware.Camera.open returned null for camera id = ".concat(String.valueOf(cameraId)));
            return;
        }
        try {
            camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
        }
        catch (IOException | RuntimeException exception) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, exception.getMessage());
            return;
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        try {
            int n;
            Camera.Parameters parameters = camera.getParameters();
            List<Size> list = Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes());
            Object object = parameters.getSupportedPreviewFpsRange();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            object = object.iterator();
            while (object.hasNext()) {
                int[] nArray = (int[])object.next();
                if (!arrayList.contains(nArray[0] / 1000)) {
                    arrayList.add(nArray[0] / 1000);
                }
                if (arrayList.contains(nArray[1] / 1000)) continue;
                arrayList.add(nArray[1] / 1000);
            }
            int n2 = width;
            int n3 = height;
            int[] nArray = events.onCameraOpened(list, arrayList);
            if (nArray != null && nArray.length == 2) {
                if (nArray[0] != -1 && nArray[0] < list.size()) {
                    n2 = list.get((int)nArray[0]).width;
                    n3 = list.get((int)nArray[0]).height;
                }
                if (nArray[1] != -1 && nArray[1] < arrayList.size()) {
                    n = (Integer)arrayList.get(nArray[1]);
                }
            }
            captureFormat = Camera1Session.findClosestCaptureFormat(parameters, n2, n3, n);
            Size size = Camera1Session.findClosestPictureSize(parameters, width, height);
            Camera1Session.updateCameraParameters(camera, parameters, captureFormat, size, captureToTexture);
        }
        catch (RuntimeException runtimeException) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, runtimeException.getMessage());
            return;
        }
        if (!captureToTexture || needPreviewCallback) {
            int n = captureFormat.frameSize();
            for (int i2 = 0; i2 < 3; ++i2) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
                camera.addCallbackBuffer(byteBuffer.array());
            }
        }
        camera.setDisplayOrientation(0);
        createSessionCallback.onDone(new Camera1Session((CameraSession.Events)var1_1, (boolean)var2_2, (Context)var3_3, surfaceTextureHelper, cameraId, camera, cameraInfo, captureFormat, l2));
    }

    /*
     * WARNING - void declaration
     */
    private static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraEnumerationAndroid.CaptureFormat captureFormat, Size pictureSize, boolean captureToTexture) {
        void var1_1;
        Camera camera2;
        void var2_2;
        void var3_3;
        List list = parameters.getSupportedFocusModes();
        parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        parameters.setPictureSize(pictureSize.width, var3_3.height);
        if (!captureToTexture || sNeedPreviewCallback) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (list.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        Logging.i(TAG, "updateCameraParameters " + var2_2.toString());
        camera2.setParameters((Camera.Parameters)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormat(Camera.Parameters parameters, int width, int height, int framerate) {
        void var2_2;
        void var1_1;
        Object object;
        void var3_3;
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> list = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        Logging.d(TAG, "Available fps ranges: ".concat(String.valueOf(list)));
        CameraEnumerationAndroid.CaptureFormat.FramerateRange framerateRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(list, (int)var3_3);
        object = Camera1Enumerator.convertSizes(object.getSupportedPreviewSizes());
        Logging.d(TAG, "Available sizes: ".concat(String.valueOf(object)));
        object = CameraEnumerationAndroid.getClosestSupportedSize((List<Size>)object, (int)var1_1, (int)var2_2);
        CameraEnumerationAndroid.reportCameraResolution(camera1ResolutionHistogram, (Size)object);
        return new CameraEnumerationAndroid.CaptureFormat(object.width, object.height, framerateRange);
    }

    /*
     * WARNING - void declaration
     */
    private static Size findClosestPictureSize(Camera.Parameters parameters, int width, int height) {
        void var2_2;
        void var1_1;
        return CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Camera1Session(CameraSession.Events events, boolean captureToTexture, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, int cameraId, Camera camera, Camera.CameraInfo info, CameraEnumerationAndroid.CaptureFormat captureFormat, long constructionTimeNs) {
        void var3_3;
        void var2_2;
        void var1_1;
        Logging.d(TAG, "Create new camera1 session on camera ".concat(String.valueOf(cameraId)));
        this.cameraThreadHandler = new Handler();
        this.events = var1_1;
        this.captureToTexture = var2_2;
        this.applicationContext = var3_3;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = cameraId;
        this.camera = camera;
        this.info = info;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = constructionTimeNs;
        surfaceTextureHelper.setTextureSize(captureFormat.width, captureFormat.height);
        this.startCapturing();
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera1 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long l2 = System.nanoTime();
            this.stopInternal();
            int n = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
            camera1StopTimeMsHistogram.addSample(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean turnLight(boolean isLightOn) {
        String string;
        void var1_1;
        this.checkIsOnCameraThread();
        if (this.state != SessionState.RUNNING) {
            Logging.e(TAG, "Camera is already stopped");
            return false;
        }
        Camera.Parameters parameters = this.camera.getParameters();
        if (parameters == null) {
            return false;
        }
        List list = parameters.getSupportedFlashModes();
        if (list == null) {
            Logging.e(TAG, "getSupportedFlashModes is null");
            return false;
        }
        String string2 = var1_1 != false ? "torch" : "off";
        if (!string2.equals(string = parameters.getFlashMode())) {
            if (list.contains(string2)) {
                parameters.setFlashMode(string2);
                this.camera.setParameters(parameters);
            } else {
                Logging.e(TAG, "FLASH_MODE_TORCH not supported");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void manualFocus(float x, float y, int previewWidth, int previewHeight) {
        void var3_6;
        void var2_3;
        void var1_1;
        this.checkIsOnCameraThread();
        if (this.state != SessionState.RUNNING) {
            Logging.e(TAG, "Camera is already stopped");
            return;
        }
        Camera.Parameters parameters = this.camera.getParameters();
        if (parameters == null) {
            return;
        }
        if (!parameters.getSupportedFocusModes().contains("auto")) {
            Logging.w(TAG, "No auto focus mode supported !");
            return;
        }
        Rect rect = this.calculateTapArea((float)var1_1, (float)var2_3, 1.0f, (int)var3_6, previewHeight);
        this.camera.cancelAutoFocus();
        if (parameters.getMaxNumFocusAreas() > 0) {
            ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
            arrayList.add(new Camera.Area(rect, 800));
            parameters.setFocusAreas(arrayList);
        } else {
            Logging.i(TAG, "focus areas not supported");
        }
        String string = parameters.getFocusMode();
        parameters.setFocusMode("auto");
        this.camera.setParameters(parameters);
        this.camera.autoFocus(new Camera.AutoFocusCallback(this, string){
            final /* synthetic */ String val$currentFocusMode;
            final /* synthetic */ Camera1Session this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$currentFocusMode = string;
            }

            /*
             * WARNING - void declaration
             */
            public void onAutoFocus(boolean success, Camera camera) {
                void var2_3;
                Camera.Parameters parameters = camera.getParameters();
                parameters.setFocusMode(this.val$currentFocusMode);
                var2_3.setParameters(parameters);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMirror(boolean mirror) {
        void var1_1;
        this.isMirror = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setExposureCompensation(int value) {
        void var1_1;
        this.checkIsOnCameraThread();
        if (this.camera == null) {
            Logging.w(TAG, "setExposureCompensation failed, camera == null");
            return;
        }
        if (!this.camera.getParameters().isAutoExposureLockSupported()) {
            Logging.w(TAG, "setExposureCompensation failed, AutoExposureLock is unsupported");
            return;
        }
        this.camera.getParameters().setAutoExposureLock(false);
        Camera.Parameters parameters = this.camera.getParameters();
        parameters.setExposureCompensation(value);
        this.camera.setParameters(parameters);
        Logging.d(TAG, "setExposure:" + (int)var1_1 + " Current exposure: " + this.camera.getParameters().getExposureCompensation());
    }

    @Override
    public int getMaxExposureCompensation() {
        if (this.camera == null) {
            Logging.w(TAG, "getMaxExposureCompensation failed, camera == null");
            return 0;
        }
        return this.camera.getParameters().getMaxExposureCompensation();
    }

    @Override
    public int getMinExposureCompensation() {
        if (this.camera == null) {
            Logging.w(TAG, "getMaxExposureCompensation failed, camera == null");
            return 0;
        }
        return this.camera.getParameters().getMinExposureCompensation();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setZoom(int zoomIndex) {
        this.checkIsOnCameraThread();
        if (this.camera == null) {
            Logging.w(TAG, "setZoom failed, camera == null");
            return;
        }
        Camera.Parameters parameters = this.camera.getParameters();
        if (zoomIndex >= 0 && zoomIndex <= parameters.getMaxZoom()) {
            void var1_1;
            Logging.d(TAG, "set zoom:" + zoomIndex + ", current zoom: " + parameters.getZoom());
            parameters.setZoom((int)var1_1);
            this.camera.setParameters(parameters);
            return;
        }
        Logging.w(TAG, "zoom index out of valid range.");
    }

    @Override
    @Nullable
    public List<Integer> getZoomRatios() {
        if (this.camera == null || !this.camera.getParameters().isZoomSupported()) {
            Logging.w(TAG, "getZoomRatios failed, camera == null or zoom not supported");
            return null;
        }
        return this.camera.getParameters().getZoomRatios();
    }

    /*
     * WARNING - void declaration
     */
    private Rect calculateTapArea(float x, float y, float coefficient, int width, int height) {
        void var2_4;
        void var1_1;
        void var3_6;
        int n = Float.valueOf(300.0f * var3_6).intValue();
        int n2 = (int)(var1_1 / (float)width * 2000.0f - 1000.0f);
        int n3 = (int)(var2_4 / (float)height * 2000.0f - 1000.0f);
        RectF rectF = new RectF((float)this.clamp(n2 - (n /= 2), -1000, 1000), (float)this.clamp(n3 - n, -1000, 1000), (float)this.clamp(n2 + n, -1000, 1000), (float)this.clamp(n3 + n, -1000, 1000));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    /*
     * WARNING - void declaration
     */
    private int clamp(int x, int min, int max) {
        void var1_1;
        if (x > max) {
            void var3_3;
            return (int)var3_3;
        }
        if (x < min) {
            void var2_2;
            return (int)var2_2;
        }
        return (int)var1_1;
    }

    private void startCapturing() {
        block5: {
            block4: {
                Logging.d(TAG, "Start capturing");
                this.checkIsOnCameraThread();
                this.state = SessionState.RUNNING;
                this.camera.setErrorCallback(new Camera.ErrorCallback(this){
                    final /* synthetic */ Camera1Session this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onError(int error, Camera camera) {
                        void var1_1;
                        String string = error == 100 ? "Camera server died!" : "Camera error: ".concat(String.valueOf(error));
                        Logging.e(Camera1Session.TAG, string);
                        this.this$0.stopInternal();
                        if (var1_1 == 2) {
                            this.this$0.events.onCameraDisconnected(this.this$0);
                            return;
                        }
                        this.this$0.events.onCameraError(this.this$0, string);
                    }
                });
                if (!this.captureToTexture) break block4;
                this.listenForTextureFrames();
                if (!sNeedPreviewCallback) break block5;
            }
            this.listenForBytebufferFrames();
        }
        this.isCameraFrontFacing = this.info.facing == 1;
        try {
            this.camera.startPreview();
            return;
        }
        catch (RuntimeException runtimeException) {
            this.stopInternal();
            this.events.onCameraError(this, runtimeException.getMessage());
            return;
        }
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        if (this.state == SessionState.STOPPED) {
            Logging.d(TAG, "Camera is already stopped");
            return;
        }
        this.state = SessionState.STOPPED;
        this.surfaceTextureHelper.stopListening();
        this.camera.stopPreview();
        this.camera.release();
        this.events.onCameraClosed(this);
        Logging.d(TAG, "Stop done");
    }

    private boolean isPortrait() {
        int n = this.getFrameOrientation();
        return n == 90 || n == 270;
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(frame -> {
            VideoFrame videoFrame;
            this.checkIsOnCameraThread();
            if (this.state != SessionState.RUNNING) {
                Logging.d(TAG, "Texture frame captured but camera is no longer running.");
                return;
            }
            if (!this.firstFrameReported) {
                int n = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTimeNs);
                camera1StartTimeMsHistogram.addSample(n);
                this.firstFrameReported = true;
            }
            CameraSession.MirrorFlag mirrorFlag = CameraSession.MirrorFlag.NONE;
            if (this.isPortrait()) {
                if (this.isMirror) {
                    mirrorFlag = this.isCameraFrontFacing ? CameraSession.MirrorFlag.HORIZONTAL : CameraSession.MirrorFlag.VERTICAL;
                } else if (this.isCameraFrontFacing) {
                    mirrorFlag = CameraSession.MirrorFlag.HORIZONTAL_VERTICAL;
                }
            } else if (this.isMirror) {
                mirrorFlag = CameraSession.MirrorFlag.HORIZONTAL;
            }
            videoFrame = new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)frame.getBuffer(), mirrorFlag, 0), this.getFrameOrientation(), videoFrame.getTimestampNs());
            this.events.onFrameCaptured(this, videoFrame);
            videoFrame.release();
        });
    }

    private void listenForBytebufferFrames() {
        this.camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(this){
            final /* synthetic */ Camera1Session this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void onPreviewFrame(byte[] data, Camera callbackCamera) {
                RefCounted refCounted;
                byte[] byArray;
                this.this$0.checkIsOnCameraThread();
                if (byArray != this.this$0.camera) {
                    Logging.e(Camera1Session.TAG, "Callback from a different camera. This should never happen.");
                    return;
                }
                if (this.this$0.state != SessionState.RUNNING) {
                    Logging.d(Camera1Session.TAG, "Bytebuffer frame captured but camera is no longer running.");
                    return;
                }
                long l2 = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                if (!this.this$0.firstFrameReported) {
                    int n = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.this$0.constructionTimeNs);
                    camera1StartTimeMsHistogram.addSample(n);
                    Camera1Session.access$502(this.this$0, true);
                }
                if (this.this$0.isCameraFrontFacing && !this.this$0.isMirror || !this.this$0.isCameraFrontFacing && this.this$0.isMirror) {
                    if (this.this$0.isPortrait()) {
                        byArray = new byte[data.length];
                        Camera1Session.access$1200(this.this$0, data, byArray, ((Camera1Session)this.this$0).captureFormat.width, ((Camera1Session)this.this$0).captureFormat.height);
                    } else {
                        byArray = Camera1Session.access$1300(this.this$0, data, ((Camera1Session)this.this$0).captureFormat.width, ((Camera1Session)this.this$0).captureFormat.height);
                    }
                } else {
                    byArray = refCounted;
                }
                refCounted = new NV21Buffer(byArray, ((Camera1Session)this.this$0).captureFormat.width, ((Camera1Session)this.this$0).captureFormat.height, () -> {
                    void var1_1;
                    this.this$0.cameraThreadHandler.post(() -> this.lambda$onPreviewFrame$0((byte[])var1_1));
                });
                refCounted = new VideoFrame((VideoFrame.Buffer)refCounted, this.this$0.getFrameOrientation(), l2);
                if (sNeedPreviewCallback) {
                    ((VideoFrame)refCounted).setIsForCallback(true);
                }
                this.this$0.events.onFrameCaptured(this.this$0, (VideoFrame)refCounted);
                ((VideoFrame)refCounted).release();
            }

            /*
             * WARNING - void declaration
             */
            private /* synthetic */ void lambda$onPreviewFrame$0(byte[] frameData) {
                if (this.this$0.state == SessionState.RUNNING) {
                    void var1_1;
                    this.this$0.camera.addCallbackBuffer((byte[])var1_1);
                }
            }
        });
    }

    private void verticalFlipData(byte[] src, byte[] dst, int width, int height) {
        int n;
        for (n = 0; n < height; ++n) {
            System.arraycopy(src, (height - 1 - n) * width, dst, n * width, width);
        }
        n = width * height;
        int n2 = height / 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            System.arraycopy(src, n + i2 * width, dst, n + (n2 - 1 - i2) * width, width);
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] horizontalFlipData(byte[] data, int width, int height) {
        void var1_1;
        byte by;
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < height; ++n3) {
            n2 = n3 * width;
            for (n = (n3 + 1) * width - 1; n2 < n; ++n2, --n) {
                by = data[n2];
                data[n2] = data[n];
                data[n] = by;
            }
        }
        int n4 = width * height;
        for (n3 = 0; n3 < height / 2; ++n3) {
            n2 = n3 * width;
            for (n = (n3 + 1) * width - 2; n2 < n; n2 += 2, n -= 2) {
                by = data[n2 + n4];
                data[n2 + n4] = data[n + n4];
                data[n + n4] = by;
                by = data[n2 + n4 + 1];
                data[n2 + n4 + 1] = data[n + n4 + 1];
                data[n + n4 + 1] = by;
            }
        }
        return var1_1;
    }

    private int getFrameOrientation() {
        int n = CameraSession.getDeviceOrientation(this.applicationContext);
        if (this.info.facing == 0) {
            n = 360 - n;
        }
        return (this.info.orientation + n) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$502(Camera1Session x0, boolean x1) {
        void var1_1;
        x0.firstFrameReported = var1_1;
        return x0.firstFrameReported;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1200(Camera1Session x0, byte[] x1, byte[] x2, int x3, int x4) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.verticalFlipData((byte[])var1_1, (byte[])var2_2, (int)var3_3, x4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte[] access$1300(Camera1Session x0, byte[] x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.horizontalFlipData((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

