/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.AndroidException;
import android.util.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.qnwebrtc.Camera2Capturer;
import org.qnwebrtc.CameraEnumerationAndroid;
import org.qnwebrtc.CameraEnumerator;
import org.qnwebrtc.CameraVideoCapturer;
import org.qnwebrtc.Logging;
import org.qnwebrtc.Size;

@TargetApi(value=21)
public class Camera2Enumerator
implements CameraEnumerator {
    private static final String TAG = "Camera2Enumerator";
    private static final double NANO_SECONDS_PER_SECOND = 1.0E9;
    private static final Map<String, List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats = new HashMap<String, List<CameraEnumerationAndroid.CaptureFormat>>();
    final Context context;
    @Nullable
    final CameraManager cameraManager;

    /*
     * WARNING - void declaration
     */
    public Camera2Enumerator(Context context) {
        void var1_1;
        this.context = context;
        this.cameraManager = (CameraManager)var1_1.getSystemService("camera");
    }

    @Override
    public String[] getDeviceNames() {
        try {
            return this.cameraManager.getCameraIdList();
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: ".concat(String.valueOf((Object)androidException)));
            return new String[0];
        }
    }

    @Override
    public boolean isFrontFacing(String deviceName) {
        CameraCharacteristics cameraCharacteristics;
        return (cameraCharacteristics = this.getCameraCharacteristics((String)cameraCharacteristics)) != null && (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
    }

    @Override
    public boolean isBackFacing(String deviceName) {
        CameraCharacteristics cameraCharacteristics;
        return (cameraCharacteristics = this.getCameraCharacteristics((String)cameraCharacteristics)) != null && (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String deviceName) {
        void var1_1;
        return Camera2Enumerator.getSupportedFormats(this.context, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CameraVideoCapturer createCapturer(String deviceName, CameraVideoCapturer.CameraEventsHandler eventsHandler) {
        void var2_2;
        void var1_1;
        return new Camera2Capturer(this.context, (String)var1_1, (CameraVideoCapturer.CameraEventsHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private CameraCharacteristics getCameraCharacteristics(String deviceName) {
        try {
            void var1_1;
            return this.cameraManager.getCameraCharacteristics((String)var1_1);
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: ".concat(String.valueOf((Object)androidException)));
            return null;
        }
    }

    public static boolean isSupported(Context context) {
        Context context2;
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        context2 = (CameraManager)context2.getSystemService("camera");
        try {
            for (String string : context2.getCameraIdList()) {
                if ((Integer)context2.getCameraCharacteristics(string).get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) != 2) continue;
                return false;
            }
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: ".concat(String.valueOf((Object)androidException)));
            return false;
        }
        return true;
    }

    static int getFpsUnitFactor(Range<Integer>[] fpsRanges) {
        Range<Integer>[] rangeArray;
        if (fpsRanges.length == 0) {
            return 1000;
        }
        if ((Integer)rangeArray[0].getUpper() < 1000) {
            return 1000;
        }
        return 1;
    }

    static List<Size> getSupportedSizes(CameraCharacteristics cameraCharacteristics) {
        Object object = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        int n = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        object = Camera2Enumerator.convertSizes(object.getOutputSizes(SurfaceTexture.class));
        if (Build.VERSION.SDK_INT < 22 && n == 2) {
            CameraCharacteristics cameraCharacteristics2;
            cameraCharacteristics2 = (Rect)cameraCharacteristics2.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            ArrayList<Size> arrayList = new ArrayList<Size>();
            object = object.iterator();
            while (object.hasNext()) {
                Size size = (Size)object.next();
                if (cameraCharacteristics2.width() * size.height != cameraCharacteristics2.height() * size.width) continue;
                arrayList.add(size);
            }
            return arrayList;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    static List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(Context context, String cameraId) {
        void var1_1;
        return Camera2Enumerator.getSupportedFormats((CameraManager)context.getSystemService("camera"), (String)var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(CameraManager cameraManager, String cameraId) {
        Map<String, List<CameraEnumerationAndroid.CaptureFormat>> map = cachedSupportedFormats;
        synchronized (map) {
            void var1_3;
            Object object2;
            if (cachedSupportedFormats.containsKey(cameraId)) {
                return cachedSupportedFormats.get(cameraId);
            }
            Logging.d(TAG, "Get supported formats for camera index " + cameraId + ".");
            long l2 = SystemClock.elapsedRealtime();
            try {
                object2 = object2.getCameraCharacteristics(cameraId);
            }
            catch (Exception exception) {
                Logging.e(TAG, "getCameraCharacteristics(): ".concat(String.valueOf(exception)));
                return new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            }
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)object2.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Range[] rangeArray = (Range[])object2.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = Camera2Enumerator.convertFramerates(rangeArray, Camera2Enumerator.getFpsUnitFactor(rangeArray));
            object2 = Camera2Enumerator.getSupportedSizes((CameraCharacteristics)object2);
            int n = 0;
            for (CameraEnumerationAndroid.CaptureFormat.FramerateRange object3 : arrayList) {
                n = Math.max(n, object3.max);
            }
            arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            Iterator l4 = object2.iterator();
            while (l4.hasNext()) {
                Size size = (Size)l4.next();
                long l3 = 0L;
                try {
                    l3 = streamConfigurationMap.getOutputMinFrameDuration(SurfaceTexture.class, new android.util.Size(size.width, size.height));
                }
                catch (Exception exception) {}
                int n2 = l3 == 0L ? n : (int)Math.round(1.0E9 / (double)l3) * 1000;
                arrayList.add(new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, 0, n2));
                Logging.d(TAG, "Format: " + size.width + "x" + size.height + "@" + n2);
            }
            cachedSupportedFormats.put(cameraId, arrayList);
            long l5 = SystemClock.elapsedRealtime();
            Logging.d(TAG, "Get supported formats for camera index " + (String)var1_3 + " done. Time spent: " + (l5 - l2) + " ms.");
            return arrayList;
        }
    }

    private static List<Size> convertSizes(android.util.Size[] cameraSizes) {
        android.util.Size[] sizeArray;
        ArrayList<Size> arrayList = new ArrayList<Size>();
        for (android.util.Size size : sizeArray) {
            arrayList.add(new Size(size.getWidth(), size.getHeight()));
        }
        return arrayList;
    }

    static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(Range<Integer>[] arrayRanges, int unitFactor) {
        Range<Integer>[] rangeArray;
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        for (Range<Integer> range : rangeArray) {
            arrayList.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange((Integer)range.getLower() * unitFactor, (Integer)range.getUpper() * unitFactor));
        }
        return arrayList;
    }
}

