/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.Range;
import android.view.Surface;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.qnwebrtc.Camera2Enumerator;
import org.qnwebrtc.CameraEnumerationAndroid;
import org.qnwebrtc.CameraSession;
import org.qnwebrtc.Histogram;
import org.qnwebrtc.Logging;
import org.qnwebrtc.Size;
import org.qnwebrtc.SurfaceTextureHelper;
import org.qnwebrtc.TextureBufferImpl;
import org.qnwebrtc.VideoFrame;

@TargetApi(value=21)
class Camera2Session
implements CameraSession {
    private static final String TAG = "Camera2Session";
    private static final Histogram camera2StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera2StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera2ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera2.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private final Handler cameraThreadHandler;
    private final CameraSession.CreateSessionCallback callback;
    private final CameraSession.Events events;
    private final Context applicationContext;
    private final CameraManager cameraManager;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final String cameraId;
    private final int width;
    private final int height;
    private final int framerate;
    private CameraCharacteristics cameraCharacteristics;
    private int cameraOrientation;
    private boolean isCameraFrontFacing;
    private int fpsUnitFactor;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    @Nullable
    private CameraDevice cameraDevice;
    @Nullable
    private Surface surface;
    @Nullable
    private CameraCaptureSession captureSession;
    private SessionState state = SessionState.RUNNING;
    private boolean firstFrameReported;
    private boolean isMirror;
    private final long constructionTimeNs;

    /*
     * WARNING - void declaration
     */
    public static void create(CameraSession.CreateSessionCallback callback, CameraSession.Events events, Context applicationContext, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String cameraId, int width, int height, int framerate) {
        void var3_3;
        void var2_2;
        void var1_1;
        CameraSession.CreateSessionCallback createSessionCallback;
        new Camera2Session(createSessionCallback, (CameraSession.Events)var1_1, (Context)var2_2, (CameraManager)var3_3, surfaceTextureHelper, cameraId, width, height, framerate);
    }

    /*
     * WARNING - void declaration
     */
    private Camera2Session(CameraSession.CreateSessionCallback callback, CameraSession.Events events, Context applicationContext, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String cameraId, int width, int height, int framerate) {
        void var3_3;
        void var2_2;
        void var1_1;
        Logging.d(TAG, "Create new camera2 session on camera ".concat(String.valueOf(cameraId)));
        this.constructionTimeNs = System.nanoTime();
        this.cameraThreadHandler = new Handler();
        this.callback = var1_1;
        this.events = var2_2;
        this.applicationContext = var3_3;
        this.cameraManager = cameraManager;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = cameraId;
        this.width = width;
        this.height = height;
        this.framerate = framerate;
        this.start();
    }

    private void start() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "start");
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("getCameraCharacteristics(): " + cameraAccessException.getMessage());
            return;
        }
        this.cameraOrientation = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.isCameraFrontFacing = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
        this.findCaptureFormat();
        this.openCamera();
    }

    private void findCaptureFormat() {
        this.checkIsOnCameraThread();
        Object object = (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.fpsUnitFactor = Camera2Enumerator.getFpsUnitFactor(object);
        object = Camera2Enumerator.convertFramerates(object, this.fpsUnitFactor);
        Object object2 = Camera2Enumerator.getSupportedSizes(this.cameraCharacteristics);
        Logging.d(TAG, "Available preview sizes: ".concat(String.valueOf(object2)));
        Logging.d(TAG, "Available fps ranges: ".concat(String.valueOf(object)));
        if (object.isEmpty() || object2.isEmpty()) {
            this.reportError("No supported capture formats.");
            return;
        }
        object = CameraEnumerationAndroid.getClosestSupportedFramerateRange((List<CameraEnumerationAndroid.CaptureFormat.FramerateRange>)object, this.framerate);
        object2 = CameraEnumerationAndroid.getClosestSupportedSize(object2, this.width, this.height);
        CameraEnumerationAndroid.reportCameraResolution(camera2ResolutionHistogram, (Size)object2);
        this.captureFormat = new CameraEnumerationAndroid.CaptureFormat(((Size)object2).width, ((Size)object2).height, (CameraEnumerationAndroid.CaptureFormat.FramerateRange)object);
        Logging.d(TAG, "Using capture format: " + this.captureFormat);
    }

    private void openCamera() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "Opening camera " + this.cameraId);
        this.events.onCameraOpening();
        try {
            this.cameraManager.openCamera(this.cameraId, (CameraDevice.StateCallback)new CameraStateCallback(), this.cameraThreadHandler);
            return;
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("Failed to open camera: ".concat(String.valueOf((Object)cameraAccessException)));
            return;
        }
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera2 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long l2 = System.nanoTime();
            this.state = SessionState.STOPPED;
            this.stopInternal();
            int n = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
            camera2StopTimeMsHistogram.addSample(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @TargetApi(value=23)
    public boolean turnLight(boolean isLightOn) {
        this.checkIsOnCameraThread();
        boolean bl = false;
        try {
            if (this.cameraManager != null && this.cameraId != null) {
                void var1_1;
                Logging.d(TAG, "turn light: " + isLightOn + ", camera id = " + this.cameraId);
                this.cameraManager.setTorchMode(this.cameraId, (boolean)var1_1);
                bl = true;
            }
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return bl;
    }

    @Override
    public void manualFocus(float x, float y, int previewWidth, int previewHeight) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMirror(boolean mirror) {
        void var1_1;
        this.isMirror = var1_1;
    }

    @Override
    public void setExposureCompensation(int value) {
        Logging.e(TAG, "not support for now.");
    }

    @Override
    public int getMaxExposureCompensation() {
        Logging.e(TAG, "not support for now.");
        return 0;
    }

    @Override
    public int getMinExposureCompensation() {
        Logging.e(TAG, "not support for now.");
        return 0;
    }

    @Override
    public void setZoom(int zoomIndex) {
        Logging.e(TAG, "not support for now.");
    }

    @Override
    @Nullable
    public List<Integer> getZoomRatios() {
        Logging.e(TAG, "not support for now.");
        return null;
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        this.surfaceTextureHelper.stopListening();
        if (this.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        Logging.d(TAG, "Stop done");
    }

    /*
     * WARNING - void declaration
     */
    private void reportError(String error) {
        void var1_1;
        this.checkIsOnCameraThread();
        Logging.e(TAG, "Error: ".concat(String.valueOf(error)));
        boolean bl = this.captureSession == null && this.state != SessionState.STOPPED;
        this.state = SessionState.STOPPED;
        this.stopInternal();
        if (bl) {
            this.callback.onFailure(CameraSession.FailureType.ERROR, error);
            return;
        }
        this.events.onCameraError(this, (String)var1_1);
    }

    private int getFrameOrientation() {
        int n = CameraSession.getDeviceOrientation(this.applicationContext);
        if (!this.isCameraFrontFacing) {
            n = 360 - n;
        }
        return (this.cameraOrientation + n) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SessionState access$202(Camera2Session x0, SessionState x1) {
        void var1_1;
        x0.state = var1_1;
        return x0.state;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(Camera2Session x0, String x1) {
        void var1_1;
        x0.reportError((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ CameraDevice access$702(Camera2Session x0, CameraDevice x1) {
        void var1_1;
        x0.cameraDevice = var1_1;
        return x0.cameraDevice;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Surface access$1002(Camera2Session x0, Surface x1) {
        void var1_1;
        x0.surface = var1_1;
        return x0.surface;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ CameraCaptureSession access$102(Camera2Session x0, CameraCaptureSession x1) {
        void var1_1;
        x0.captureSession = var1_1;
        return x0.captureSession;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1602(Camera2Session x0, boolean x1) {
        void var1_1;
        x0.firstFrameReported = var1_1;
        return x0.firstFrameReported;
    }

    static class CameraCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private CameraCaptureCallback() {
        }

        /*
         * WARNING - void declaration
         */
        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            void var3_3;
            Logging.d(Camera2Session.TAG, "Capture failed: ".concat(String.valueOf(var3_3)));
        }
    }

    class CaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionCallback() {
        }

        /*
         * WARNING - void declaration
         */
        public void onConfigureFailed(CameraCaptureSession session) {
            void var1_1;
            Camera2Session.this.checkIsOnCameraThread();
            var1_1.close();
            Camera2Session.access$600(Camera2Session.this, "Failed to configure capture session.");
        }

        /*
         * WARNING - void declaration
         */
        public void onConfigured(CameraCaptureSession session) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera capture session configured.");
            Camera2Session.access$102(Camera2Session.this, session);
            try {
                void var1_1;
                CaptureRequest.Builder builder = Camera2Session.this.cameraDevice.createCaptureRequest(3);
                builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.min / Camera2Session.this.fpsUnitFactor), (Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.max / Camera2Session.this.fpsUnitFactor)));
                builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                builder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)Boolean.FALSE);
                this.chooseStabilizationMode(builder);
                this.chooseFocusMode(builder);
                builder.addTarget(Camera2Session.this.surface);
                var1_1.setRepeatingRequest(builder.build(), (CameraCaptureSession.CaptureCallback)new CameraCaptureCallback(), Camera2Session.this.cameraThreadHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.access$600(Camera2Session.this, "Failed to start capture request. ".concat(String.valueOf((Object)cameraAccessException)));
                return;
            }
            Camera2Session.this.surfaceTextureHelper.startListening(frame -> {
                VideoFrame videoFrame;
                Camera2Session.this.checkIsOnCameraThread();
                if (Camera2Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera2Session.TAG, "Texture frame captured but camera is no longer running.");
                    return;
                }
                if (!Camera2Session.this.firstFrameReported) {
                    Camera2Session.access$1602(Camera2Session.this, true);
                    int n = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera2Session.this.constructionTimeNs);
                    camera2StartTimeMsHistogram.addSample(n);
                }
                CameraSession.MirrorFlag mirrorFlag = CameraSession.MirrorFlag.NONE;
                int n = Camera2Session.this.getFrameOrientation();
                if (n == 90 || n == 270) {
                    if (Camera2Session.this.isMirror) {
                        mirrorFlag = Camera2Session.this.isCameraFrontFacing ? CameraSession.MirrorFlag.HORIZONTAL : CameraSession.MirrorFlag.VERTICAL;
                    } else if (Camera2Session.this.isCameraFrontFacing) {
                        mirrorFlag = CameraSession.MirrorFlag.HORIZONTAL_VERTICAL;
                    }
                } else if (Camera2Session.this.isMirror) {
                    mirrorFlag = CameraSession.MirrorFlag.HORIZONTAL;
                }
                videoFrame = new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)frame.getBuffer(), mirrorFlag, -Camera2Session.this.cameraOrientation), Camera2Session.this.getFrameOrientation(), videoFrame.getTimestampNs());
                Camera2Session.this.events.onFrameCaptured(Camera2Session.this, videoFrame);
                videoFrame.release();
            });
            Logging.d(Camera2Session.TAG, "Camera device successfully started.");
            Camera2Session.this.callback.onDone(Camera2Session.this);
        }

        private void chooseStabilizationMode(CaptureRequest.Builder captureRequestBuilder) {
            int n;
            int[] nArray = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            if (nArray != null) {
                int n2 = nArray.length;
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] != 1) continue;
                    captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    Logging.d(Camera2Session.TAG, "Using optical stabilization.");
                    return;
                }
            }
            int[] nArray2 = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
            n = nArray2.length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (nArray2[i2] != 1) continue;
                captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                Logging.d(Camera2Session.TAG, "Using video stabilization.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Stabilization not available.");
        }

        private void chooseFocusMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] nArray = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            int n = nArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (nArray[i2] != 3) continue;
                captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                Logging.d(Camera2Session.TAG, "Using continuous video auto-focus.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Auto-focus is not available.");
        }
    }

    class CameraStateCallback
    extends CameraDevice.StateCallback {
        private CameraStateCallback() {
        }

        /*
         * WARNING - void declaration
         */
        private String getErrorDescription(int errorCode) {
            void var1_1;
            switch (errorCode) {
                case 4: {
                    return "Camera device has encountered a fatal error.";
                }
                case 3: {
                    return "Camera device could not be opened due to a device policy.";
                }
                case 1: {
                    return "Camera device is in use already.";
                }
                case 5: {
                    return "Camera service has encountered a fatal error.";
                }
                case 2: {
                    return "Camera device could not be opened because there are too many other open camera devices.";
                }
            }
            return "Unknown camera error: ".concat(String.valueOf((int)var1_1));
        }

        public void onDisconnected(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            boolean bl = Camera2Session.this.captureSession == null && Camera2Session.this.state != SessionState.STOPPED;
            Camera2Session.access$202(Camera2Session.this, SessionState.STOPPED);
            Camera2Session.this.stopInternal();
            if (bl) {
                Camera2Session.this.callback.onFailure(CameraSession.FailureType.DISCONNECTED, "Camera disconnected / evicted.");
                return;
            }
            Camera2Session.this.events.onCameraDisconnected(Camera2Session.this);
        }

        /*
         * WARNING - void declaration
         */
        public void onError(CameraDevice camera, int errorCode) {
            void var2_2;
            Camera2Session.this.checkIsOnCameraThread();
            Camera2Session.access$600(Camera2Session.this, this.getErrorDescription((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public void onOpened(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera opened.");
            Camera2Session.access$702(Camera2Session.this, camera);
            Camera2Session.this.surfaceTextureHelper.setTextureSize(((Camera2Session)Camera2Session.this).captureFormat.width, ((Camera2Session)Camera2Session.this).captureFormat.height);
            Camera2Session.access$1002(Camera2Session.this, new Surface(Camera2Session.this.surfaceTextureHelper.getSurfaceTexture()));
            try {
                void var1_1;
                var1_1.createCaptureSession(Arrays.asList(Camera2Session.this.surface), (CameraCaptureSession.StateCallback)new CaptureSessionCallback(), Camera2Session.this.cameraThreadHandler);
                return;
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.access$600(Camera2Session.this, "Failed to create capture session. ".concat(String.valueOf((Object)cameraAccessException)));
                return;
            }
        }

        public void onClosed(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera device closed.");
            Camera2Session.this.events.onCameraClosed(Camera2Session.this);
        }
    }

    static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

