/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import org.qnwebrtc.CameraEnumerator;
import org.qnwebrtc.CameraSession;
import org.qnwebrtc.CameraVideoCapturer;
import org.qnwebrtc.CapturerObserver;
import org.qnwebrtc.Logging;
import org.qnwebrtc.Size;
import org.qnwebrtc.SurfaceTextureHelper;
import org.qnwebrtc.VideoFrame;

abstract class CameraCapturer
implements CameraVideoCapturer {
    private static final String TAG = "CameraCapturer";
    private static final int MAX_DEVICE_NUM = 2;
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private static final int OPEN_CAMERA_TIMEOUT = 10000;
    private final CameraEnumerator cameraEnumerator;
    @Nullable
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    private final Handler uiThreadHandler;
    @Nullable
    private final CameraSession.CreateSessionCallback createSessionCallback = new CameraSession.CreateSessionCallback(this){
        final /* synthetic */ CameraCapturer this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void onDone(CameraSession session) {
            this.this$0.checkIsOnCameraThread();
            Logging.d(CameraCapturer.TAG, "Create session done. Switch state: " + (Object)((Object)this.this$0.switchState));
            this.this$0.uiThreadHandler.removeCallbacks(this.this$0.openCameraTimeoutRunnable);
            Object object = this.this$0.stateLock;
            synchronized (object) {
                void var1_1;
                this.this$0.capturerObserver.onCapturerStarted(true);
                CameraCapturer.access$602(this.this$0, false);
                CameraCapturer.access$702(this.this$0, (CameraSession)var1_1);
                this.this$0.capturerListener.onCapturerStarted(true);
                CameraCapturer.access$902(this.this$0, new CameraVideoCapturer.CameraStatistics(this.this$0.surfaceHelper, this.this$0.eventsHandler));
                CameraCapturer.access$1202(this.this$0, false);
                this.this$0.stateLock.notifyAll();
                if (this.this$0.switchState == SwitchState.IN_PROGRESS) {
                    CameraCapturer.access$102(this.this$0, SwitchState.IDLE);
                    if (this.this$0.switchEventsHandler != null) {
                        this.this$0.switchEventsHandler.onCameraSwitchDone(this.this$0.cameraEnumerator.isFrontFacing(this.this$0.cameraName));
                        CameraCapturer.access$1302(this.this$0, null);
                    }
                } else if (this.this$0.switchState == SwitchState.PENDING) {
                    CameraCapturer.access$102(this.this$0, SwitchState.IDLE);
                    CameraCapturer.access$1600(this.this$0, this.this$0.switchEventsHandler);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void onFailure(CameraSession.FailureType failureType, String error) {
            this.this$0.checkIsOnCameraThread();
            this.this$0.uiThreadHandler.removeCallbacks(this.this$0.openCameraTimeoutRunnable);
            Object object = this.this$0.stateLock;
            synchronized (object) {
                this.this$0.capturerObserver.onCapturerStarted(false);
                this.this$0.capturerListener.onCapturerStarted(false);
                this.this$0.openAttemptsRemaining--;
                if (this.this$0.openAttemptsRemaining <= 0) {
                    void var1_1;
                    Logging.w(CameraCapturer.TAG, "Opening camera failed, passing: ".concat(String.valueOf(error)));
                    CameraCapturer.access$602(this.this$0, false);
                    this.this$0.stateLock.notifyAll();
                    if (this.this$0.switchState != SwitchState.IDLE) {
                        if (this.this$0.switchEventsHandler != null) {
                            this.this$0.switchEventsHandler.onCameraSwitchError(error);
                            CameraCapturer.access$1302(this.this$0, null);
                        }
                        CameraCapturer.access$102(this.this$0, SwitchState.IDLE);
                    }
                    if (var1_1 == CameraSession.FailureType.DISCONNECTED) {
                        this.this$0.eventsHandler.onCameraDisconnected();
                    } else {
                        this.this$0.eventsHandler.onCameraError(error);
                    }
                } else {
                    void var2_3;
                    Logging.w(CameraCapturer.TAG, "Opening camera failed, retry: ".concat(String.valueOf(var2_3)));
                    CameraCapturer.access$1800(this.this$0, 500);
                }
                return;
            }
        }
    };
    @Nullable
    private final CameraSession.Events cameraSessionEventsHandler = new CameraSession.Events(this){
        final /* synthetic */ CameraCapturer this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraOpening() {
            this.this$0.checkIsOnCameraThread();
            Object object = this.this$0.stateLock;
            synchronized (object) {
                if (this.this$0.currentSession != null) {
                    Logging.w(CameraCapturer.TAG, "onCameraOpening while session was open.");
                    return;
                }
                this.this$0.eventsHandler.onCameraOpening(this.this$0.cameraName);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public int[] onCameraOpened(List<Size> sizes, List<Integer> fpsRanges) {
            this.this$0.checkIsOnCameraThread();
            Object object = this.this$0.stateLock;
            synchronized (object) {
                int[] nArray = this.this$0.eventsHandler.onCameraOpened(sizes, fpsRanges);
                if (nArray != null && nArray.length == 2) {
                    if (nArray[0] != -1 && nArray[0] < sizes.size()) {
                        void var1_1;
                        CameraCapturer.access$1902(this.this$0, sizes.get((int)nArray[0]).width);
                        CameraCapturer.access$2002(this.this$0, ((Size)var1_1.get((int)nArray[0])).height);
                        Logging.i(CameraCapturer.TAG, "reset res to  " + this.this$0.width + "x" + this.this$0.height);
                    }
                    if (nArray[1] != -1 && nArray[1] < fpsRanges.size()) {
                        void var2_3;
                        CameraCapturer.access$2102(this.this$0, (Integer)var2_3.get(nArray[1]));
                        Logging.i(CameraCapturer.TAG, "reset fps to  " + this.this$0.framerate);
                    }
                }
                return nArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void onCameraError(CameraSession session, String error) {
            this.this$0.checkIsOnCameraThread();
            Object object = this.this$0.stateLock;
            synchronized (object) {
                void var2_3;
                void var1_1;
                if (var1_1 != this.this$0.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraError from another session: ".concat(String.valueOf(error)));
                    return;
                }
                this.this$0.eventsHandler.onCameraError((String)var2_3);
                this.this$0.stopCapture();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void onCameraDisconnected(CameraSession session) {
            this.this$0.checkIsOnCameraThread();
            Object object = this.this$0.stateLock;
            synchronized (object) {
                void var1_1;
                if (var1_1 != this.this$0.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraDisconnected from another session.");
                    return;
                }
                this.this$0.eventsHandler.onCameraDisconnected();
                this.this$0.stopCapture();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void onCameraClosed(CameraSession session) {
            this.this$0.checkIsOnCameraThread();
            Object object = this.this$0.stateLock;
            synchronized (object) {
                void var1_1;
                if (var1_1 != this.this$0.currentSession && this.this$0.currentSession != null) {
                    Logging.d(CameraCapturer.TAG, "onCameraClosed from another session.");
                    return;
                }
                this.this$0.eventsHandler.onCameraClosed();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void onFrameCaptured(CameraSession session, VideoFrame frame) {
            this.this$0.checkIsOnCameraThread();
            Object object = this.this$0.stateLock;
            synchronized (object) {
                void var1_1;
                if (var1_1 != this.this$0.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onFrameCaptured from another session.");
                    return;
                }
                if (!this.this$0.firstFrameObserved) {
                    this.this$0.eventsHandler.onFirstFrameAvailable(new Size(frame.getBuffer().getWidth(), frame.getBuffer().getHeight()));
                    CameraCapturer.access$1202(this.this$0, true);
                }
                if (!frame.isForCallback()) {
                    this.this$0.cameraStatistics.addFrame();
                }
                if (this.this$0.capturerListener != null) {
                    this.this$0.capturerListener.onFrameCaptured(frame);
                } else {
                    void var2_3;
                    this.this$0.capturerObserver.onFrameCaptured((VideoFrame)var2_3);
                }
                return;
            }
        }
    };
    private final Runnable openCameraTimeoutRunnable = new Runnable(this){
        final /* synthetic */ CameraCapturer this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            this.this$0.eventsHandler.onCameraError("Camera failed to start within timeout.");
        }
    };
    @Nullable
    private Handler cameraThreadHandler;
    private Context applicationContext;
    private CapturerObserver capturerObserver;
    private CapturerObserver capturerListener;
    @Nullable
    private SurfaceTextureHelper surfaceHelper;
    private final Object stateLock = new Object();
    private boolean sessionOpening;
    @Nullable
    private CameraSession currentSession;
    private String cameraName;
    private int width;
    private int height;
    private int framerate;
    private int openAttemptsRemaining;
    private SwitchState switchState = SwitchState.IDLE;
    @Nullable
    private CameraVideoCapturer.CameraSwitchHandler switchEventsHandler;
    @Nullable
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private boolean firstFrameObserved;

    /*
     * WARNING - void declaration
     */
    public CameraCapturer(String cameraName, @Nullable CameraVideoCapturer.CameraEventsHandler eventsHandler, CameraEnumerator cameraEnumerator) {
        void var3_3;
        String[] stringArray;
        void var2_2;
        if (eventsHandler == null) {
            eventsHandler = new CameraVideoCapturer.CameraEventsHandler(this){
                final /* synthetic */ CameraCapturer this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void onCameraError(String errorDescription) {
                }

                @Override
                public void onCameraDisconnected() {
                }

                @Override
                public void onCameraFreezed(String errorDescription) {
                }

                @Override
                public void onCameraOpening(String cameraName) {
                }

                @Override
                public int[] onCameraOpened(List<Size> sizes, List<Integer> fpsRanges) {
                    return new int[]{-1, -1};
                }

                @Override
                public void onFirstFrameAvailable(Size size) {
                }

                @Override
                public void onCameraClosed() {
                }
            };
        }
        this.eventsHandler = var2_2;
        this.cameraEnumerator = cameraEnumerator;
        this.cameraName = stringArray;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        stringArray = var3_3.getDeviceNames();
        if (stringArray.length == 0) {
            throw new RuntimeException("No cameras attached.");
        }
        if (!Arrays.asList(stringArray).contains(this.cameraName)) {
            throw new IllegalArgumentException("Camera name " + this.cameraName + " does not match any known camera device.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCaptureListener(CapturerObserver listener) {
        void var1_1;
        this.capturerListener = var1_1;
    }

    @Override
    public CapturerObserver getCapturerObserver() {
        return this.capturerObserver;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(@Nullable SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.applicationContext = var2_2;
        this.capturerObserver = var3_3;
        this.surfaceHelper = surfaceTextureHelper;
        this.cameraThreadHandler = surfaceTextureHelper == null ? null : var1_1.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void startCapture(int width, int height, int framerate) {
        Logging.d(TAG, "startCapture: " + width + "x" + height + "@" + framerate);
        if (this.applicationContext == null) {
            throw new RuntimeException("CameraCapturer must be initialized before calling startCapture.");
        }
        Object object = this.stateLock;
        synchronized (object) {
            void var3_4;
            void var2_3;
            void var1_1;
            if (this.sessionOpening || this.currentSession != null) {
                Logging.w(TAG, "Session already open");
                return;
            }
            this.width = var1_1;
            this.height = var2_3;
            this.framerate = var3_4;
            this.sessionOpening = true;
            this.openAttemptsRemaining = 3;
            this.createSessionInternal(0);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createSessionInternal(int delayMs) {
        void var1_1;
        this.uiThreadHandler.postDelayed(this.openCameraTimeoutRunnable, (long)(delayMs + 10000));
        this.cameraThreadHandler.postDelayed(new Runnable(this){
            final /* synthetic */ CameraCapturer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.createCameraSession(this.this$0.createSessionCallback, this.this$0.cameraSessionEventsHandler, this.this$0.applicationContext, this.this$0.surfaceHelper, this.this$0.cameraName, this.this$0.width, this.this$0.height, this.this$0.framerate);
            }
        }, (long)var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCapture() {
        Logging.d(TAG, "Stop capture");
        Object object = this.stateLock;
        synchronized (object) {
            while (this.sessionOpening) {
                Logging.d(TAG, "Stop capture: Waiting for session to open");
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Logging.w(TAG, "Stop capture interrupted while waiting for the session to open.");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.currentSession != null) {
                Logging.d(TAG, "Stop capture: Nulling session");
                this.cameraStatistics.release();
                this.cameraStatistics = null;
                CameraSession cameraSession = this.currentSession;
                this.cameraThreadHandler.post(new Runnable(this, cameraSession){
                    final /* synthetic */ CameraSession val$oldSession;
                    final /* synthetic */ CameraCapturer this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$oldSession = cameraSession;
                    }

                    @Override
                    public void run() {
                        this.val$oldSession.stop();
                        if (this.this$0.capturerListener != null) {
                            this.this$0.capturerListener.onCapturerStoppedInCapturerThread();
                        }
                    }
                });
                this.currentSession = null;
                this.capturerObserver.onCapturerStopped();
                this.capturerListener.onCapturerStopped();
            } else {
                Logging.d(TAG, "Stop capture: No session open");
            }
        }
        Logging.d(TAG, "Stop capture done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void changeCaptureFormat(int width, int height, int framerate) {
        Logging.d(TAG, "changeCaptureFormat: " + width + "x" + height + "@" + framerate);
        Object object = this.stateLock;
        synchronized (object) {
            void var3_4;
            void var2_3;
            void var1_1;
            this.stopCapture();
            this.startCapture((int)var1_1, (int)var2_3, (int)var3_4);
            return;
        }
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose");
        this.stopCapture();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void switchCamera(CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        void var1_1;
        Logging.d(TAG, "switchCamera");
        this.cameraThreadHandler.post(new Runnable(this, (CameraVideoCapturer.CameraSwitchHandler)var1_1){
            final /* synthetic */ CameraVideoCapturer.CameraSwitchHandler val$switchEventsHandler;
            final /* synthetic */ CameraCapturer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$switchEventsHandler = cameraSwitchHandler;
            }

            @Override
            public void run() {
                CameraCapturer.access$1600(this.this$0, this.val$switchEventsHandler);
            }
        });
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean turnLight(boolean isLightOn) {
        void var1_1;
        if (this.currentSession == null) {
            return false;
        }
        this.cameraThreadHandler.post(new Runnable(this, (boolean)var1_1){
            final /* synthetic */ boolean val$isLightOn;
            final /* synthetic */ CameraCapturer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$isLightOn = bl;
            }

            @Override
            public void run() {
                this.this$0.currentSession.turnLight(this.val$isLightOn);
            }
        });
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void manualFocus(float x, float y, int previewWidth, int previewHeight) {
        if (this.currentSession != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.cameraThreadHandler.post(new Runnable(this, (float)var1_1, (float)var2_2, (int)var3_3, previewHeight){
                final /* synthetic */ float val$x;
                final /* synthetic */ float val$y;
                final /* synthetic */ int val$previewWidth;
                final /* synthetic */ int val$previewHeight;
                final /* synthetic */ CameraCapturer this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$x = f2;
                    this.val$y = f3;
                    this.val$previewWidth = n;
                    this.val$previewHeight = n2;
                }

                @Override
                public void run() {
                    this.this$0.currentSession.manualFocus(this.val$x, this.val$y, this.val$previewWidth, this.val$previewHeight);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setExposureCompensation(int value) {
        if (this.currentSession != null) {
            void var1_1;
            this.cameraThreadHandler.post(new Runnable(this, (int)var1_1){
                final /* synthetic */ int val$value;
                final /* synthetic */ CameraCapturer this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$value = n;
                }

                @Override
                public void run() {
                    this.this$0.currentSession.setExposureCompensation(this.val$value);
                }
            });
        }
    }

    @Override
    public int getMaxExposureCompensation() {
        if (this.currentSession != null) {
            return this.currentSession.getMaxExposureCompensation();
        }
        return 0;
    }

    @Override
    public int getMinExposureCompensation() {
        if (this.currentSession != null) {
            return this.currentSession.getMinExposureCompensation();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setZoom(int zoomIndex) {
        if (this.currentSession != null) {
            void var1_1;
            this.cameraThreadHandler.post(new Runnable(this, (int)var1_1){
                final /* synthetic */ int val$zoomIndex;
                final /* synthetic */ CameraCapturer this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$zoomIndex = n;
                }

                @Override
                public void run() {
                    this.this$0.currentSession.setZoom(this.val$zoomIndex);
                }
            });
        }
    }

    @Override
    @Nullable
    public List<Integer> getZoomRatios() {
        if (this.currentSession != null) {
            return this.currentSession.getZoomRatios();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMirror(boolean isMirror) {
        if (this.currentSession != null) {
            void var1_1;
            this.currentSession.setMirror((boolean)var1_1);
        }
    }

    public void printStackTrace() {
        StackTraceElement[] stackTraceElementArray = null;
        if (this.cameraThreadHandler != null) {
            stackTraceElementArray = this.cameraThreadHandler.getLooper().getThread();
        }
        if (stackTraceElementArray != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()).length > 0) {
            Logging.d(TAG, "CameraCapturer stack trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportCameraSwitchError(String error, @Nullable CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        Logging.e(TAG, error);
        if (switchEventsHandler != null) {
            void var1_1;
            void var2_2;
            var2_2.onCameraSwitchError((String)var1_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchCameraInternal(@Nullable CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        Logging.d(TAG, "switchCamera internal");
        String[] stringArray = this.cameraEnumerator.getDeviceNames();
        if (stringArray.length < 2) {
            if (switchEventsHandler != null) {
                switchEventsHandler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        String[] stringArray2 = null;
        if (stringArray.length > 2) {
            Logging.d(TAG, "switchCamera restrict num to 2");
            stringArray2 = Arrays.copyOfRange(stringArray, 0, 2);
        }
        Object object = this.stateLock;
        synchronized (object) {
            String[] stringArray3;
            if (this.switchState != SwitchState.IDLE) {
                this.reportCameraSwitchError("Camera switch already in progress.", switchEventsHandler);
                return;
            }
            if (!this.sessionOpening && this.currentSession == null) {
                this.reportCameraSwitchError("switchCamera: camera is not running.", switchEventsHandler);
                return;
            }
            this.switchEventsHandler = stringArray3;
            if (this.sessionOpening) {
                this.switchState = SwitchState.PENDING;
                return;
            }
            this.switchState = SwitchState.IN_PROGRESS;
            Logging.d(TAG, "switchCamera: Stopping session");
            this.cameraStatistics.release();
            this.cameraStatistics = null;
            stringArray3 = this.currentSession;
            this.cameraThreadHandler.post(new Runnable(this, (CameraSession)stringArray3){
                final /* synthetic */ CameraSession val$oldSession;
                final /* synthetic */ CameraCapturer this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$oldSession = cameraSession;
                }

                @Override
                public void run() {
                    this.val$oldSession.stop();
                }
            });
            this.currentSession = null;
            stringArray3 = stringArray2 != null ? stringArray2 : stringArray;
            int n = Arrays.asList(stringArray3).indexOf(this.cameraName);
            this.cameraName = stringArray3[(n + 1) % stringArray3.length];
            this.sessionOpening = true;
            this.openAttemptsRemaining = 1;
            this.createSessionInternal(0);
        }
        Logging.d(TAG, "switchCamera done");
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            Logging.e(TAG, "Check is on camera thread failed.");
            throw new RuntimeException("Not on camera thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCameraName() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.cameraName;
        }
    }

    protected abstract void createCameraSession(CameraSession.CreateSessionCallback var1, CameraSession.Events var2, Context var3, SurfaceTextureHelper var4, String var5, int var6, int var7, int var8);

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$602(CameraCapturer x0, boolean x1) {
        void var1_1;
        x0.sessionOpening = var1_1;
        return x0.sessionOpening;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ CameraSession access$702(CameraCapturer x0, CameraSession x1) {
        void var1_1;
        x0.currentSession = var1_1;
        return x0.currentSession;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ CameraVideoCapturer.CameraStatistics access$902(CameraCapturer x0, CameraVideoCapturer.CameraStatistics x1) {
        void var1_1;
        x0.cameraStatistics = var1_1;
        return x0.cameraStatistics;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1202(CameraCapturer x0, boolean x1) {
        void var1_1;
        x0.firstFrameObserved = var1_1;
        return x0.firstFrameObserved;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SwitchState access$102(CameraCapturer x0, SwitchState x1) {
        void var1_1;
        x0.switchState = var1_1;
        return x0.switchState;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ CameraVideoCapturer.CameraSwitchHandler access$1302(CameraCapturer x0, CameraVideoCapturer.CameraSwitchHandler x1) {
        void var1_1;
        x0.switchEventsHandler = var1_1;
        return x0.switchEventsHandler;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1600(CameraCapturer x0, CameraVideoCapturer.CameraSwitchHandler x1) {
        void var1_1;
        x0.switchCameraInternal((CameraVideoCapturer.CameraSwitchHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1800(CameraCapturer x0, int x1) {
        void var1_1;
        x0.createSessionInternal((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1902(CameraCapturer x0, int x1) {
        void var1_1;
        x0.width = var1_1;
        return x0.width;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$2002(CameraCapturer x0, int x1) {
        void var1_1;
        x0.height = var1_1;
        return x0.height;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$2102(CameraCapturer x0, int x1) {
        void var1_1;
        x0.framerate = var1_1;
        return x0.framerate;
    }

    static enum SwitchState {
        IDLE,
        PENDING,
        IN_PROGRESS;

    }
}

