/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.HardwareVideoDecoderFactory;
import org.qnwebrtc.PlatformSoftwareVideoDecoderFactory;
import org.qnwebrtc.SoftwareVideoDecoderFactory;
import org.qnwebrtc.VideoCodecInfo;
import org.qnwebrtc.VideoDecoder;
import org.qnwebrtc.VideoDecoderFactory;
import org.qnwebrtc.VideoDecoderFallback;

public class DefaultVideoDecoderFactory
implements VideoDecoderFactory {
    private final VideoDecoderFactory hardwareVideoDecoderFactory;
    private final VideoDecoderFactory softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();
    @Nullable
    private final VideoDecoderFactory platformSoftwareVideoDecoderFactory;

    /*
     * WARNING - void declaration
     */
    public DefaultVideoDecoderFactory(@Nullable EglBase.Context eglContext) {
        void var1_1;
        this.hardwareVideoDecoderFactory = new HardwareVideoDecoderFactory(eglContext);
        this.platformSoftwareVideoDecoderFactory = new PlatformSoftwareVideoDecoderFactory((EglBase.Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    DefaultVideoDecoderFactory(VideoDecoderFactory hardwareVideoDecoderFactory) {
        void var1_1;
        this.hardwareVideoDecoderFactory = var1_1;
        this.platformSoftwareVideoDecoderFactory = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        VideoDecoder videoDecoder = this.softwareVideoDecoderFactory.createDecoder(codecType);
        VideoDecoder videoDecoder2 = this.hardwareVideoDecoderFactory.createDecoder(codecType);
        if (videoDecoder == null && this.platformSoftwareVideoDecoderFactory != null) {
            void var1_1;
            videoDecoder = this.platformSoftwareVideoDecoderFactory.createDecoder((VideoCodecInfo)var1_1);
        }
        if (videoDecoder2 != null && videoDecoder != null) {
            return new VideoDecoderFallback(videoDecoder, videoDecoder2);
        }
        if (videoDecoder2 != null) {
            return videoDecoder2;
        }
        return videoDecoder;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> linkedHashSet = new LinkedHashSet<VideoCodecInfo>();
        linkedHashSet.addAll(Arrays.asList(this.softwareVideoDecoderFactory.getSupportedCodecs()));
        linkedHashSet.addAll(Arrays.asList(this.hardwareVideoDecoderFactory.getSupportedCodecs()));
        if (this.platformSoftwareVideoDecoderFactory != null) {
            linkedHashSet.addAll(Arrays.asList(this.platformSoftwareVideoDecoderFactory.getSupportedCodecs()));
        }
        LinkedHashSet<VideoCodecInfo> linkedHashSet2 = linkedHashSet;
        return linkedHashSet2.toArray(new VideoCodecInfo[linkedHashSet2.size()]);
    }
}

