/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.content.Context;
import android.os.SystemClock;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.qnwebrtc.CapturerObserver;
import org.qnwebrtc.JavaI420Buffer;
import org.qnwebrtc.Logging;
import org.qnwebrtc.SurfaceTextureHelper;
import org.qnwebrtc.VideoCapturer;
import org.qnwebrtc.VideoFrame;

public class FileVideoCapturer
implements VideoCapturer {
    private static final String TAG = "FileVideoCapturer";
    private final VideoReader videoReader;
    private CapturerObserver capturerObserver;
    private final Timer timer = new Timer();
    private final TimerTask tickTask = new TimerTask(this){
        final /* synthetic */ FileVideoCapturer this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            this.this$0.tick();
        }
    };

    /*
     * WARNING - void declaration
     */
    public FileVideoCapturer(String inputFile) throws IOException {
        try {
            this.videoReader = new VideoReaderY4M(inputFile);
            return;
        }
        catch (IOException iOException) {
            void var1_1;
            Logging.d(TAG, "Could not open video file: ".concat(String.valueOf(var1_1)));
            throw iOException;
        }
    }

    public void tick() {
        VideoFrame videoFrame = this.videoReader.getNextFrame();
        this.capturerObserver.onFrameCaptured(videoFrame);
        videoFrame.release();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        void var3_3;
        this.capturerObserver = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startCapture(int width, int height, int framerate) {
        void var3_3;
        this.timer.schedule(this.tickTask, 0L, (long)(1000 / var3_3));
    }

    @Override
    public void stopCapture() throws InterruptedException {
        this.timer.cancel();
    }

    @Override
    public void changeCaptureFormat(int width, int height, int framerate) {
    }

    @Override
    public void dispose() {
        this.videoReader.close();
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    static class VideoReaderY4M
    implements VideoReader {
        private static final String TAG = "VideoReaderY4M";
        private static final String Y4M_FRAME_DELIMETER = "FRAME";
        private static final int FRAME_DELIMETER_LENGTH = 6;
        private final int frameWidth;
        private final int frameHeight;
        private final long videoStart;
        private final RandomAccessFile mediaFile;
        private final FileChannel mediaFileChannel;

        public VideoReaderY4M(String file) throws IOException {
            int n;
            this.mediaFile = new RandomAccessFile(file, "r");
            this.mediaFileChannel = this.mediaFile.getChannel();
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                if ((n = this.mediaFile.read()) == -1) {
                    throw new RuntimeException("Found end of file before end of header for file: ".concat(String.valueOf(file)));
                }
                if (n == 10) break;
                stringBuilder.append((char)n);
            }
            this.videoStart = this.mediaFileChannel.position();
            String[] stringArray = stringBuilder.toString().split("[ ]");
            int n2 = 0;
            n = 0;
            String string = "";
            block6: for (String string2 : stringArray) {
                switch (string2.charAt(0)) {
                    case 'W': {
                        n2 = Integer.parseInt(string2.substring(1));
                        continue block6;
                    }
                    case 'H': {
                        n = Integer.parseInt(string2.substring(1));
                        continue block6;
                    }
                    case 'C': {
                        string = string2.substring(1);
                    }
                }
            }
            Logging.d(TAG, "Color space: ".concat(String.valueOf(string)));
            if (!string.equals("420") && !string.equals("420mpeg2")) {
                throw new IllegalArgumentException("Does not support any other color space than I420 or I420mpeg2");
            }
            if (n2 % 2 == 1 || n % 2 == 1) {
                throw new IllegalArgumentException("Does not support odd width or height");
            }
            this.frameWidth = n2;
            this.frameHeight = n;
            Logging.d(TAG, "frame dim: (" + n2 + ", " + n + ")");
        }

        @Override
        public VideoFrame getNextFrame() {
            long l2 = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
            JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(this.frameWidth, this.frameHeight);
            ByteBuffer byteBuffer = javaI420Buffer.getDataY();
            ByteBuffer byteBuffer2 = javaI420Buffer.getDataU();
            ByteBuffer byteBuffer3 = javaI420Buffer.getDataV();
            javaI420Buffer.getStrideY();
            javaI420Buffer.getStrideU();
            javaI420Buffer.getStrideV();
            try {
                Object object = ByteBuffer.allocate(FRAME_DELIMETER_LENGTH);
                if (this.mediaFileChannel.read((ByteBuffer)object) < FRAME_DELIMETER_LENGTH) {
                    this.mediaFileChannel.position(this.videoStart);
                    if (this.mediaFileChannel.read((ByteBuffer)object) < FRAME_DELIMETER_LENGTH) {
                        throw new RuntimeException("Error looping video");
                    }
                }
                if (!((String)(object = new String(((ByteBuffer)object).array(), Charset.forName("US-ASCII")))).equals("FRAME\n")) {
                    throw new RuntimeException("Frames should be delimited by FRAME plus newline, found delimter was: '" + (String)object + "'");
                }
                this.mediaFileChannel.read(byteBuffer);
                this.mediaFileChannel.read(byteBuffer2);
                this.mediaFileChannel.read(byteBuffer3);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return new VideoFrame(javaI420Buffer, 0, l2);
        }

        @Override
        public void close() {
            try {
                this.mediaFile.close();
                return;
            }
            catch (IOException iOException) {
                Logging.e(TAG, "Problem closing file", iOException);
                return;
            }
        }
    }

    static interface VideoReader {
        public VideoFrame getNextFrame();

        public void close();
    }
}

