/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.media.MediaCodecInfo;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.qnwebrtc.H264Utils;
import org.qnwebrtc.VideoCodecType;

class MediaCodecUtils {
    private static final String TAG = "MediaCodecUtils";
    static final String EXYNOS_PREFIX = "OMX.Exynos.";
    static final String INTEL_PREFIX = "OMX.Intel.";
    static final String NVIDIA_PREFIX = "OMX.Nvidia.";
    static final String QCOM_PREFIX = "OMX.qcom.";
    static final String MTK_PREFIX = "OMX.MTK.";
    static final String HISI_PREFIX = "OMX.hisi.";
    static final String IMG_PREFIX = "OMX.IMG.";
    static final String SPRD_PREFIX = "OMX.sprd.";
    static final String[] SOFTWARE_IMPLEMENTATION_PREFIXES = new String[]{"OMX.google.", "OMX.SEC."};
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    static final int[] DECODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876};
    static final int[] ENCODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391876};
    static final int[] TEXTURE_COLOR_FORMATS = MediaCodecUtils.getTextureColorFormats();

    private static int[] getTextureColorFormats() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new int[]{2130708361};
        }
        return new int[0];
    }

    @Nullable
    static Integer selectColorFormat(int[] supportedColorFormats, MediaCodecInfo.CodecCapabilities capabilities) {
        int n = supportedColorFormats.length;
        for (int i2 = 0; i2 < n; ++i2) {
            int[] nArray;
            int n2 = nArray[i2];
            int[] nArray2 = capabilities.colorFormats;
            int n3 = capabilities.colorFormats.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n4 = nArray2[i3];
                if (n4 != n2) continue;
                return n4;
            }
        }
        return null;
    }

    static boolean codecSupportsType(MediaCodecInfo info, VideoCodecType type) {
        for (String string : info.getSupportedTypes()) {
            if (!type.mimeType().equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static Map<String, String> getCodecProperties(VideoCodecType type, boolean highProfile) {
        VideoCodecType videoCodecType;
        switch (type) {
            case VP8: 
            case VP9: {
                return new HashMap<String, String>();
            }
            case H264: {
                void var1_1;
                return H264Utils.getDefaultH264Params((boolean)var1_1);
            }
        }
        throw new IllegalArgumentException("Unsupported codec: ".concat(String.valueOf((Object)videoCodecType)));
    }

    private MediaCodecUtils() {
    }
}

