/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.CalledByNativeUnchecked;
import org.qnwebrtc.DefaultVideoDecoderFactory;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.H264Utils;
import org.qnwebrtc.Logging;
import org.qnwebrtc.MediaCodecVideoEncoder;
import org.qnwebrtc.PeerConnectionFactory;
import org.qnwebrtc.SurfaceTextureHelper;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoCodecInfo;
import org.qnwebrtc.VideoDecoder;
import org.qnwebrtc.VideoDecoderFactory;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoSink;
import org.qnwebrtc.WrappedNativeVideoDecoder;

@Deprecated
public class MediaCodecVideoDecoder {
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final long MAX_DECODE_TIME_MS = 200L;
    private static final String FORMAT_KEY_STRIDE = "stride";
    private static final String FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    @Nullable
    private static MediaCodecVideoDecoder runningInstance;
    @Nullable
    private static MediaCodecVideoDecoderErrorCallback errorCallback;
    private static int codecErrors;
    private static Set<String> hwDecoderDisabledTypes;
    @Nullable
    private static EglBase eglBase;
    @Nullable
    private Thread mediaCodecThread;
    @Nullable
    private MediaCodec mediaCodec;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String[] supportedVp9HwCodecPrefixes;
    private static final String supportedQcomH264HighProfileHwCodecPrefix = "OMX.qcom.";
    private static final String supportedExynosH264HighProfileHwCodecPrefix = "OMX.Exynos.";
    private static final String supportedMediaTekH264HighProfileHwCodecPrefix = "OMX.MTK.";
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final List<Integer> supportedColorList;
    private int colorFormat;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private final Queue<TimeStamps> decodeStartTimeMs = new ArrayDeque<TimeStamps>();
    @Nullable
    private TextureListener textureListener;
    private int droppedFrames;
    @Nullable
    private Surface surface;
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers = new ArrayDeque<DecodedOutputBuffer>();

    public static VideoDecoderFactory createFactory() {
        return new DefaultVideoDecoderFactory(new HwDecoderFactory());
    }

    private static final String[] supportedVp8HwCodecPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(supportedQcomH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Nvidia.");
        arrayList.add(supportedExynosH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Intel.");
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekVP8").equals("Enabled") && Build.VERSION.SDK_INT >= 24) {
            arrayList.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    private static final String[] supportedH264HwCodecPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(supportedQcomH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Intel.");
        arrayList.add(supportedExynosH264HighProfileHwCodecPrefix);
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled") && Build.VERSION.SDK_INT >= 27) {
            arrayList.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    public static void setEglContext(EglBase.Context eglContext) {
        EglBase.Context context;
        if (eglBase != null) {
            Logging.w(TAG, "Egl context already set.");
            eglBase.release();
        }
        eglBase = EglBase.create(context);
    }

    public static void disposeEglContext() {
        if (eglBase != null) {
            eglBase.release();
            eglBase = null;
        }
    }

    static boolean useSurface() {
        return eglBase != null;
    }

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback errorCallback) {
        MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback;
        Logging.d(TAG, "Set error callback");
        MediaCodecVideoDecoder.errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes()) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, MediaCodecVideoDecoder.supportedH264HwCodecPrefixes()) != null;
    }

    public static boolean isH264HighProfileHwSupported() {
        if (hwDecoderDisabledTypes.contains(H264_MIME_TYPE)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedQcomH264HighProfileHwCodecPrefix}) != null) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedExynosH264HighProfileHwCodecPrefix}) != null) {
            return true;
        }
        return PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled") && Build.VERSION.SDK_INT >= 27 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedMediaTekH264HighProfileHwCodecPrefix}) != null;
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoDecoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoDecoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    @Nullable
    private static DecoderProperties findDecoder(String mime, String[] supportedCodecPrefixes) {
        String string;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Logging.d(TAG, "Trying to find HW decoder for mime ".concat(String.valueOf(mime)));
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            int n;
            int n2;
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
            String string2 = null;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            int n3 = stringArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                if (!stringArray[n2].equals(mime)) continue;
                string2 = mediaCodecInfo.getName();
                break;
            }
            if (string2 == null) continue;
            Logging.d(TAG, "Found candidate decoder ".concat(String.valueOf(string2)));
            int n4 = 0;
            MediaCodecInfo.CodecCapabilities codecCapabilities = supportedCodecPrefixes;
            n2 = ((String[])codecCapabilities).length;
            for (n = 0; n < n2; ++n) {
                String string3 = codecCapabilities[n];
                if (!string2.startsWith(string3)) continue;
                n4 = 1;
                break;
            }
            if (n4 == 0) continue;
            try {
                codecCapabilities = mediaCodecInfo.getCapabilitiesForType(mime);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder capabilities", illegalArgumentException);
                continue;
            }
            Object object = codecCapabilities.colorFormats;
            n = codecCapabilities.colorFormats.length;
            for (int i3 = 0; i3 < n; ++i3) {
                int n5 = object[i3];
                Logging.v(TAG, "   Color: 0x" + Integer.toHexString(n5));
            }
            object = supportedColorList.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                int[] nArray = codecCapabilities.colorFormats;
                int n6 = codecCapabilities.colorFormats.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    int n7 = nArray[n4];
                    if (n7 != n) continue;
                    Logging.d(TAG, "Found target decoder " + string2 + ". Color: 0x" + Integer.toHexString(n7));
                    return new DecoderProperties(string2, n7);
                }
            }
        }
        Logging.d(TAG, "No HW decoder found for mime ".concat(String.valueOf(string)));
        return null;
    }

    @CalledByNative
    MediaCodecVideoDecoder() {
    }

    private void checkOnMediaCodecThread() throws IllegalStateException {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new IllegalStateException("MediaCodecVideoDecoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNativeUnchecked
    private boolean initDecode(VideoCodecType type, int width, int height) {
        Object object;
        Object object2;
        String string;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("initDecode: Forgot to release()?");
        }
        if (type == VideoCodecType.VIDEO_CODEC_VP8) {
            string = VP8_MIME_TYPE;
            object2 = MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes();
        } else if (type == VideoCodecType.VIDEO_CODEC_VP9) {
            string = VP9_MIME_TYPE;
            object2 = supportedVp9HwCodecPrefixes;
        } else if (type == VideoCodecType.VIDEO_CODEC_H264) {
            string = H264_MIME_TYPE;
            object2 = MediaCodecVideoDecoder.supportedH264HwCodecPrefixes();
        } else {
            throw new RuntimeException("initDecode: Non-supported codec ".concat(String.valueOf((Object)type)));
        }
        object2 = MediaCodecVideoDecoder.findDecoder(string, object2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find HW decoder for ".concat(String.valueOf((Object)type)));
        }
        Logging.d(TAG, "Java initDecode: " + object + " : " + width + " x " + height + ". Color: 0x" + Integer.toHexString(object2.colorFormat) + ". Use Surface: " + MediaCodecVideoDecoder.useSurface());
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            void var3_4;
            void var2_3;
            this.width = width;
            this.height = height;
            this.stride = width;
            this.sliceHeight = height;
            if (MediaCodecVideoDecoder.useSurface() && (object = SurfaceTextureHelper.create("Decoder SurfaceTextureHelper", eglBase.getEglBaseContext())) != null) {
                this.textureListener = new TextureListener((SurfaceTextureHelper)object);
                this.textureListener.setSize(width, height);
                this.surface = new Surface(((SurfaceTextureHelper)object).getSurfaceTexture());
            }
            object = MediaFormat.createVideoFormat((String)string, (int)var2_3, (int)var3_4);
            if (!MediaCodecVideoDecoder.useSurface()) {
                object.setInteger("color-format", object2.colorFormat);
            }
            Logging.d(TAG, "  Format: ".concat(String.valueOf(object)));
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(object2.codecName);
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media decoder");
                return false;
            }
            this.mediaCodec.configure((MediaFormat)object, this.surface, null, 0);
            this.mediaCodec.start();
            this.colorFormat = object2.colorFormat;
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            this.inputBuffers = this.mediaCodec.getInputBuffers();
            this.decodeStartTimeMs.clear();
            this.hasDecodedFirstFrame = false;
            this.dequeuedSurfaceOutputBuffers.clear();
            this.droppedFrames = 0;
            Logging.d(TAG, "Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNativeUnchecked
    private void reset(int width, int height) {
        if (this.mediaCodecThread == null || this.mediaCodec == null) {
            throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
        }
        Logging.d(TAG, "Java reset: " + width + " x " + height);
        this.mediaCodec.flush();
        this.width = width;
        this.height = height;
        if (this.textureListener != null) {
            void var2_2;
            void var1_1;
            this.textureListener.setSize((int)var1_1, (int)var2_2);
        }
        this.decodeStartTimeMs.clear();
        this.dequeuedSurfaceOutputBuffers.clear();
        this.hasDecodedFirstFrame = false;
        this.droppedFrames = 0;
    }

    @CalledByNativeUnchecked
    private void release() {
        Logging.d(TAG, "Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames);
        this.checkOnMediaCodecThread();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable = new Runnable(this, countDownLatch){
            final /* synthetic */ CountDownLatch val$releaseDone;
            final /* synthetic */ MediaCodecVideoDecoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$releaseDone = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread");
                    this.this$0.mediaCodec.stop();
                    this.this$0.mediaCodec.release();
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread done");
                }
                catch (Exception exception) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Media decoder release failed", exception);
                }
                this.val$releaseDone.countDown();
            }
        };
        new Thread(runnable).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        if (MediaCodecVideoDecoder.useSurface()) {
            this.surface.release();
            this.surface = null;
            this.textureListener.release();
        }
        Logging.d(TAG, "Java releaseDecoder done");
    }

    @CalledByNativeUnchecked
    private int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNativeUnchecked
    private boolean queueInputBuffer(int inputBufferIndex, int size, long presentationTimeStamUs, long timeStampMs, long ntpTimeStamp) {
        this.checkOnMediaCodecThread();
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            this.inputBuffers[inputBufferIndex].position(0);
            this.inputBuffers[inputBufferIndex].limit(size);
            this.decodeStartTimeMs.add(new TimeStamps(SystemClock.elapsedRealtime(), timeStampMs, ntpTimeStamp));
            this.mediaCodec.queueInputBuffer((int)var1_1, 0, (int)var2_3, (long)var3_4, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "decode failed", illegalStateException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    @Nullable
    private DecodedOutputBuffer dequeueOutputBuffer(int dequeueTimeoutMs) {
        int n;
        this.checkOnMediaCodecThread();
        if (this.decodeStartTimeMs.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(dequeueTimeoutMs));
            switch (n) {
                case -3: {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    Logging.d(TAG, "Decoder output buffers changed: " + this.outputBuffers.length);
                    if (!this.hasDecodedFirstFrame) continue block5;
                    throw new RuntimeException("Unexpected output buffer change event.");
                }
                case -2: {
                    int n2;
                    int n3;
                    MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
                    Logging.d(TAG, "Decoder format changed: " + mediaFormat.toString());
                    if (mediaFormat.containsKey(FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(FORMAT_KEY_CROP_TOP)) {
                        n3 = 1 + mediaFormat.getInteger(FORMAT_KEY_CROP_RIGHT) - mediaFormat.getInteger(FORMAT_KEY_CROP_LEFT);
                        n2 = 1 + mediaFormat.getInteger(FORMAT_KEY_CROP_BOTTOM) - mediaFormat.getInteger(FORMAT_KEY_CROP_TOP);
                    } else {
                        n3 = mediaFormat.getInteger("width");
                        n2 = mediaFormat.getInteger("height");
                    }
                    if (this.hasDecodedFirstFrame && (n3 != this.width || n2 != this.height)) {
                        throw new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n3 + "*" + n2);
                    }
                    this.width = n3;
                    this.height = n2;
                    if (this.textureListener != null) {
                        this.textureListener.setSize(this.width, this.height);
                    }
                    if (!MediaCodecVideoDecoder.useSurface() && mediaFormat.containsKey("color-format")) {
                        this.colorFormat = mediaFormat.getInteger("color-format");
                        Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
                        if (!supportedColorList.contains(this.colorFormat)) {
                            throw new IllegalStateException("Non supported color format: " + this.colorFormat);
                        }
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_STRIDE)) {
                        this.stride = mediaFormat.getInteger(FORMAT_KEY_STRIDE);
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_SLICE_HEIGHT)) {
                        this.sliceHeight = mediaFormat.getInteger(FORMAT_KEY_SLICE_HEIGHT);
                    }
                    Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
                    this.stride = Math.max(this.width, this.stride);
                    this.sliceHeight = Math.max(this.height, this.sliceHeight);
                    continue block5;
                }
                case -1: {
                    return null;
                }
            }
            break;
        }
        this.hasDecodedFirstFrame = true;
        TimeStamps timeStamps = this.decodeStartTimeMs.remove();
        long l2 = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
        if (l2 > 200L) {
            Logging.e(TAG, "Very high decode time: " + l2 + "ms. Q size: " + this.decodeStartTimeMs.size() + ". Might be caused by resuming H264 decoding after a pause.");
            l2 = 200L;
        }
        return new DecodedOutputBuffer(n, bufferInfo.offset, bufferInfo.size, TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs), timeStamps.timeStampMs, timeStamps.ntpTimeStampMs, l2, SystemClock.elapsedRealtime());
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNativeUnchecked
    @Nullable
    private DecodedTextureBuffer dequeueTextureBuffer(int dequeueTimeoutMs) {
        this.checkOnMediaCodecThread();
        if (!MediaCodecVideoDecoder.useSurface()) {
            throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
        }
        Object object = this.dequeueOutputBuffer(dequeueTimeoutMs);
        if (object != null) {
            this.dequeuedSurfaceOutputBuffers.add((DecodedOutputBuffer)object);
        }
        this.MaybeRenderDecodedTextureBuffer();
        object = this.textureListener.dequeueTextureBuffer(dequeueTimeoutMs);
        if (object != null) {
            this.MaybeRenderDecodedTextureBuffer();
            return object;
        }
        if (this.dequeuedSurfaceOutputBuffers.size() >= Math.min(3, this.outputBuffers.length) || dequeueTimeoutMs > 0 && !this.dequeuedSurfaceOutputBuffers.isEmpty()) {
            void var1_1;
            ++this.droppedFrames;
            object = this.dequeuedSurfaceOutputBuffers.remove();
            if (var1_1 > 0) {
                Logging.w(TAG, "Draining decoder. Dropping frame with TS: " + ((DecodedOutputBuffer)object).presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
            } else {
                Logging.w(TAG, "Too many output buffers " + this.dequeuedSurfaceOutputBuffers.size() + ". Dropping frame with TS: " + ((DecodedOutputBuffer)object).presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
            }
            this.mediaCodec.releaseOutputBuffer(((DecodedOutputBuffer)object).index, false);
            return new DecodedTextureBuffer(null, ((DecodedOutputBuffer)object).presentationTimeStampMs, ((DecodedOutputBuffer)object).timeStampMs, ((DecodedOutputBuffer)object).ntpTimeStampMs, ((DecodedOutputBuffer)object).decodeTimeMs, SystemClock.elapsedRealtime() - ((DecodedOutputBuffer)object).endDecodeTimeMs);
        }
        return null;
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (this.dequeuedSurfaceOutputBuffers.isEmpty() || this.textureListener.isWaitingForTexture()) {
            return;
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeuedSurfaceOutputBuffers.remove();
        this.textureListener.addBufferToRender(decodedOutputBuffer);
        this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNativeUnchecked
    private void returnDecodedOutputBuffer(int index) throws IllegalStateException, MediaCodec.CodecException {
        void var1_1;
        this.checkOnMediaCodecThread();
        if (MediaCodecVideoDecoder.useSurface()) {
            throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
        }
        this.mediaCodec.releaseOutputBuffer((int)var1_1, false);
    }

    @CalledByNative
    ByteBuffer[] getInputBuffers() {
        return this.inputBuffers;
    }

    @CalledByNative
    ByteBuffer[] getOutputBuffers() {
        return this.outputBuffers;
    }

    @CalledByNative
    int getColorFormat() {
        return this.colorFormat;
    }

    @CalledByNative
    int getWidth() {
        return this.width;
    }

    @CalledByNative
    int getHeight() {
        return this.height;
    }

    @CalledByNative
    int getStride() {
        return this.stride;
    }

    @CalledByNative
    int getSliceHeight() {
        return this.sliceHeight;
    }

    private static native long nativeCreateDecoder(String var0, boolean var1);

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$000(String x0, boolean x1) {
        void var1_1;
        return MediaCodecVideoDecoder.nativeCreateDecoder(x0, (boolean)var1_1);
    }

    static {
        hwDecoderDisabledTypes = new HashSet<String>();
        supportedVp9HwCodecPrefixes = new String[]{supportedQcomH264HighProfileHwCodecPrefix, supportedExynosH264HighProfileHwCodecPrefix};
        supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876);
    }

    class TextureListener
    implements VideoSink {
        private final SurfaceTextureHelper surfaceTextureHelper;
        private final Object newFrameLock = new Object();
        @Nullable
        private DecodedOutputBuffer bufferToRender;
        @Nullable
        private DecodedTextureBuffer renderedBuffer;

        /*
         * WARNING - void declaration
         */
        public TextureListener(SurfaceTextureHelper surfaceTextureHelper) {
            void var2_2;
            this.surfaceTextureHelper = surfaceTextureHelper;
            var2_2.startListening(this);
        }

        /*
         * WARNING - void declaration
         */
        public void addBufferToRender(DecodedOutputBuffer buffer) {
            void var1_1;
            if (this.bufferToRender != null) {
                Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected addBufferToRender() called while waiting for a texture.");
                throw new IllegalStateException("Waiting for a texture.");
            }
            this.bufferToRender = var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWaitingForTexture() {
            Object object = this.newFrameLock;
            synchronized (object) {
                return this.bufferToRender != null;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setSize(int width, int height) {
            void var2_2;
            void var1_1;
            this.surfaceTextureHelper.setTextureSize((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrame(VideoFrame frame) {
            Object object = this.newFrameLock;
            synchronized (object) {
                VideoFrame.Buffer buffer;
                if (this.renderedBuffer != null) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected onFrame() called while already holding a texture.");
                    throw new IllegalStateException("Already holding a texture.");
                }
                buffer = ((VideoFrame)((Object)buffer)).getBuffer();
                buffer.retain();
                this.renderedBuffer = new DecodedTextureBuffer(buffer, this.bufferToRender.presentationTimeStampMs, this.bufferToRender.timeStampMs, this.bufferToRender.ntpTimeStampMs, this.bufferToRender.decodeTimeMs, SystemClock.elapsedRealtime() - this.bufferToRender.endDecodeTimeMs);
                this.bufferToRender = null;
                this.newFrameLock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        public DecodedTextureBuffer dequeueTextureBuffer(int timeoutMs) {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer == null && timeoutMs > 0 && this.isWaitingForTexture()) {
                    try {
                        void var1_1;
                        this.newFrameLock.wait((long)var1_1);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                DecodedTextureBuffer decodedTextureBuffer = this.renderedBuffer;
                this.renderedBuffer = null;
                return decodedTextureBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.surfaceTextureHelper.stopListening();
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    this.renderedBuffer.getVideoFrameBuffer().release();
                    this.renderedBuffer = null;
                }
            }
            this.surfaceTextureHelper.dispose();
        }
    }

    static class DecodedTextureBuffer {
        private final VideoFrame.Buffer videoFrameBuffer;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long frameDelayMs;

        /*
         * WARNING - void declaration
         */
        public DecodedTextureBuffer(VideoFrame.Buffer videoFrameBuffer, long presentationTimeStampMs, long timeStampMs, long ntpTimeStampMs, long decodeTimeMs, long frameDelay) {
            void var2_2;
            void var1_1;
            this.videoFrameBuffer = var1_1;
            this.presentationTimeStampMs = var2_2;
            this.timeStampMs = timeStampMs;
            this.ntpTimeStampMs = ntpTimeStampMs;
            this.decodeTimeMs = decodeTimeMs;
            this.frameDelayMs = frameDelay;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        VideoFrame.Buffer getVideoFrameBuffer() {
            return this.videoFrameBuffer;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getTimeStampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getFrameDelayMs() {
            return this.frameDelayMs;
        }
    }

    static class DecodedOutputBuffer {
        private final int index;
        private final int offset;
        private final int size;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;

        /*
         * WARNING - void declaration
         */
        public DecodedOutputBuffer(int index, int offset, int size, long presentationTimeStampMs, long timeStampMs, long ntpTimeStampMs, long decodeTime, long endDecodeTime) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.index = var1_1;
            this.offset = var2_2;
            this.size = var3_3;
            this.presentationTimeStampMs = presentationTimeStampMs;
            this.timeStampMs = timeStampMs;
            this.ntpTimeStampMs = ntpTimeStampMs;
            this.decodeTimeMs = decodeTime;
            this.endDecodeTimeMs = endDecodeTime;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getIndex() {
            return this.index;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getOffset() {
            return this.offset;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getSize() {
            return this.size;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getTimestampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }
    }

    static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;

        /*
         * WARNING - void declaration
         */
        public TimeStamps(long decodeStartTimeMs, long timeStampMs, long ntpTimeStampMs) {
            void var3_2;
            void var1_1;
            this.decodeStartTimeMs = var1_1;
            this.timeStampMs = var3_2;
            this.ntpTimeStampMs = ntpTimeStampMs;
        }
    }

    static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        /*
         * WARNING - void declaration
         */
        public DecoderProperties(String codecName, int colorFormat) {
            void var2_2;
            void var1_1;
            this.codecName = var1_1;
            this.colorFormat = var2_2;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_UNKNOWN,
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;


        @CalledByNative(value="VideoCodecType")
        static VideoCodecType fromNativeIndex(int nativeIndex) {
            int n;
            return VideoCodecType.values()[n];
        }
    }

    static class HwDecoderFactory
    implements VideoDecoderFactory {
        private final VideoCodecInfo[] supportedHardwareCodecs = HwDecoderFactory.getSupportedHardwareCodecs();

        HwDecoderFactory() {
        }

        /*
         * WARNING - void declaration
         */
        private static boolean isSameCodec(VideoCodecInfo codecA, VideoCodecInfo codecB) {
            if (!codecA.name.equalsIgnoreCase(codecB.name)) {
                return false;
            }
            if (codecA.name.equalsIgnoreCase("H264")) {
                void var1_1;
                VideoCodecInfo videoCodecInfo;
                return H264Utils.isSameH264Profile(videoCodecInfo.params, var1_1.params);
            }
            return true;
        }

        private static boolean isCodecSupported(VideoCodecInfo[] supportedCodecs, VideoCodecInfo codec) {
            int n = supportedCodecs.length;
            for (int i2 = 0; i2 < n; ++i2) {
                VideoCodecInfo[] videoCodecInfoArray;
                if (!HwDecoderFactory.isSameCodec(videoCodecInfoArray[i2], codec)) continue;
                return true;
            }
            return false;
        }

        private static VideoCodecInfo[] getSupportedHardwareCodecs() {
            ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
            if (MediaCodecVideoDecoder.isVp8HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "VP8 HW Decoder supported.");
                arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isVp9HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "VP9 HW Decoder supported.");
                arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isH264HighProfileHwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "H.264 High Profile HW Decoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_HIGH_PROFILE_CODEC);
            }
            if (MediaCodecVideoDecoder.isH264HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "H.264 HW Decoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_BASELINE_PROFILE_CODEC);
            }
            ArrayList<VideoCodecInfo> arrayList2 = arrayList;
            return arrayList2.toArray(new VideoCodecInfo[arrayList2.size()]);
        }

        @Override
        public VideoCodecInfo[] getSupportedCodecs() {
            return this.supportedHardwareCodecs;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public VideoDecoder createDecoder(VideoCodecInfo codec) {
            void var1_1;
            if (!HwDecoderFactory.isCodecSupported(this.supportedHardwareCodecs, codec)) {
                Logging.d(MediaCodecVideoDecoder.TAG, "No HW video decoder for codec " + codec.name);
                return null;
            }
            Logging.d(MediaCodecVideoDecoder.TAG, "Create HW video decoder for " + codec.name);
            return new WrappedNativeVideoDecoder(this, (VideoCodecInfo)var1_1){
                final /* synthetic */ VideoCodecInfo val$codec;
                final /* synthetic */ HwDecoderFactory this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$codec = videoCodecInfo;
                }

                @Override
                public long createNativeVideoDecoder() {
                    return MediaCodecVideoDecoder.access$000(this.val$codec.name, MediaCodecVideoDecoder.useSurface());
                }
            };
        }
    }
}

