/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import org.qnwebrtc.AndroidVideoDecoder;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.Logging;
import org.qnwebrtc.MediaCodecUtils;
import org.qnwebrtc.MediaCodecWrapperFactoryImpl;
import org.qnwebrtc.Predicate;
import org.qnwebrtc.VideoCodecInfo;
import org.qnwebrtc.VideoCodecType;
import org.qnwebrtc.VideoDecoder;
import org.qnwebrtc.VideoDecoderFactory;

class MediaCodecVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "MediaCodecVideoDecoderFactory";
    @Nullable
    private final EglBase.Context sharedContext;
    @Nullable
    private final Predicate<MediaCodecInfo> codecAllowedPredicate;

    /*
     * WARNING - void declaration
     */
    public MediaCodecVideoDecoderFactory(@Nullable EglBase.Context sharedContext, @Nullable Predicate<MediaCodecInfo> codecAllowedPredicate) {
        void var2_2;
        void var1_1;
        this.sharedContext = var1_1;
        this.codecAllowedPredicate = var2_2;
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        VideoCodecType videoCodecType = VideoCodecType.valueOf(codecType.getName());
        MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
        if (mediaCodecInfo == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType());
        return new AndroidVideoDecoder(new MediaCodecWrapperFactoryImpl(), mediaCodecInfo.getName(), videoCodecType, MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, codecCapabilities), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        VideoCodecType[] videoCodecTypeArray = new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264, VideoCodecType.H265};
        for (int i2 = 0; i2 < 4; ++i2) {
            VideoCodecType videoCodecType = videoCodecTypeArray[i2];
            MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
            if (mediaCodecInfo == null) continue;
            String string = videoCodecType.name();
            if (videoCodecType == VideoCodecType.H264 && this.isH264HighProfileSupported(mediaCodecInfo)) {
                arrayList.add(new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecType, true)));
            }
            arrayList.add(new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecType, false)));
        }
        ArrayList<VideoCodecInfo> arrayList2 = arrayList;
        return arrayList2.toArray(new VideoCodecInfo[arrayList2.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType type) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, type)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
        void var1_1;
        void var2_2;
        info.getName();
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, info.getCapabilitiesForType(var2_2.mimeType())) == null) {
            return false;
        }
        return this.isCodecAllowed((MediaCodecInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isCodecAllowed(MediaCodecInfo info) {
        void var1_1;
        if (this.codecAllowedPredicate == null) {
            return true;
        }
        return this.codecAllowedPredicate.test((MediaCodecInfo)var1_1);
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        String string = info.getName();
        if (Build.VERSION.SDK_INT >= 21 && string.startsWith("OMX.qcom.")) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && string.startsWith("OMX.Exynos.");
    }
}

