/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.qnwebrtc.AudioTrack;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.JniCommon;
import org.qnwebrtc.Logging;
import org.qnwebrtc.MediaStreamTrack;
import org.qnwebrtc.VideoTrack;

public class MediaStream {
    private static final String TAG = "MediaStream";
    public final List<AudioTrack> audioTracks = new ArrayList<AudioTrack>();
    public final List<VideoTrack> videoTracks = new ArrayList<VideoTrack>();
    public final List<VideoTrack> preservedVideoTracks = new ArrayList<VideoTrack>();
    private long nativeStream;

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    public MediaStream(long nativeStream) {
        void var1_1;
        this.nativeStream = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addTrack(AudioTrack track) {
        this.checkMediaStreamExists();
        if (MediaStream.nativeAddAudioTrackToNativeStream(this.nativeStream, track.getNativeAudioTrack())) {
            void var1_1;
            this.audioTracks.add((AudioTrack)var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addTrack(VideoTrack track) {
        this.checkMediaStreamExists();
        if (MediaStream.nativeAddVideoTrackToNativeStream(this.nativeStream, track.getNativeVideoTrack())) {
            void var1_1;
            this.videoTracks.add((VideoTrack)var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addPreservedTrack(VideoTrack track) {
        this.checkMediaStreamExists();
        if (MediaStream.nativeAddVideoTrackToNativeStream(this.nativeStream, track.getNativeVideoTrack())) {
            void var1_1;
            this.preservedVideoTracks.add((VideoTrack)var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeTrack(AudioTrack track) {
        void var1_1;
        this.checkMediaStreamExists();
        this.audioTracks.remove(track);
        return MediaStream.nativeRemoveAudioTrack(this.nativeStream, var1_1.getNativeAudioTrack());
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeTrack(VideoTrack track) {
        void var1_1;
        this.checkMediaStreamExists();
        this.videoTracks.remove(track);
        this.preservedVideoTracks.remove(track);
        return MediaStream.nativeRemoveVideoTrack(this.nativeStream, var1_1.getNativeVideoTrack());
    }

    @CalledByNative
    public void dispose() {
        MediaStreamTrack mediaStreamTrack;
        this.checkMediaStreamExists();
        while (!this.audioTracks.isEmpty()) {
            mediaStreamTrack = this.audioTracks.get(0);
            this.removeTrack((AudioTrack)mediaStreamTrack);
            mediaStreamTrack.dispose();
        }
        while (!this.videoTracks.isEmpty()) {
            mediaStreamTrack = this.videoTracks.get(0);
            this.removeTrack((VideoTrack)mediaStreamTrack);
            ((VideoTrack)mediaStreamTrack).dispose();
        }
        while (!this.preservedVideoTracks.isEmpty()) {
            MediaStream mediaStream = this;
            mediaStream.removeTrack(mediaStream.preservedVideoTracks.get(0));
        }
        JniCommon.nativeReleaseRef(this.nativeStream);
        this.nativeStream = 0L;
    }

    public String getId() {
        this.checkMediaStreamExists();
        return MediaStream.nativeGetId(this.nativeStream);
    }

    public String toString() {
        return "[" + this.getId() + ":A=" + this.audioTracks.size() + ":V=" + this.videoTracks.size() + "]";
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    void addNativeAudioTrack(long nativeTrack) {
        void var1_1;
        this.audioTracks.add(new AudioTrack((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    void addNativeVideoTrack(long nativeTrack) {
        void var1_1;
        this.videoTracks.add(new VideoTrack((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    void removeAudioTrack(long nativeTrack) {
        void var1_1;
        MediaStream.removeMediaStreamTrack(this.audioTracks, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    void removeVideoTrack(long nativeTrack) {
        void var1_1;
        MediaStream.removeMediaStreamTrack(this.videoTracks, (long)var1_1);
    }

    long getNativeMediaStream() {
        this.checkMediaStreamExists();
        return this.nativeStream;
    }

    private void checkMediaStreamExists() {
        if (this.nativeStream == 0L) {
            throw new IllegalStateException("MediaStream has been disposed.");
        }
    }

    private static void removeMediaStreamTrack(List<? extends MediaStreamTrack> tracks, long nativeTrack) {
        Iterator<? extends MediaStreamTrack> iterator = tracks.iterator();
        while (iterator.hasNext()) {
            MediaStreamTrack mediaStreamTrack = (MediaStreamTrack)iterator.next();
            if (mediaStreamTrack.getNativeMediaStreamTrack() != nativeTrack) continue;
            mediaStreamTrack.dispose();
            iterator.remove();
            return;
        }
        Logging.e(TAG, "Couldn't not find track");
    }

    private static native boolean nativeAddAudioTrackToNativeStream(long var0, long var2);

    private static native boolean nativeAddVideoTrackToNativeStream(long var0, long var2);

    private static native boolean nativeRemoveAudioTrack(long var0, long var2);

    private static native boolean nativeRemoveVideoTrack(long var0, long var2);

    private static native String nativeGetId(long var0);
}

