/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import org.qnwebrtc.AudioTrack;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.JniCommon;
import org.qnwebrtc.VideoTrack;

public class MediaStreamTrack {
    public static final String AUDIO_TRACK_KIND = "audio";
    public static final String VIDEO_TRACK_KIND = "video";
    long nativeTrack;

    @Nullable
    static MediaStreamTrack createMediaStreamTrack(long nativeTrack) {
        if (nativeTrack == 0L) {
            return null;
        }
        String string = MediaStreamTrack.nativeGetKind(nativeTrack);
        if (string.equals(AUDIO_TRACK_KIND)) {
            return new AudioTrack(nativeTrack);
        }
        if (string.equals(VIDEO_TRACK_KIND)) {
            long l2;
            return new VideoTrack(l2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public MediaStreamTrack(long nativeTrack) {
        void var1_1;
        if (nativeTrack == 0L) {
            throw new IllegalArgumentException("nativeTrack may not be null");
        }
        this.nativeTrack = var1_1;
    }

    public String id() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetId(this.nativeTrack);
    }

    public String kind() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetKind(this.nativeTrack);
    }

    public boolean enabled() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetEnabled(this.nativeTrack);
    }

    /*
     * WARNING - void declaration
     */
    public boolean setEnabled(boolean enable) {
        void var1_1;
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeSetEnabled(this.nativeTrack, (boolean)var1_1);
    }

    public State state() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetState(this.nativeTrack);
    }

    public void dispose() {
        this.checkMediaStreamTrackExists();
        JniCommon.nativeReleaseRef(this.nativeTrack);
        this.nativeTrack = 0L;
    }

    long getNativeMediaStreamTrack() {
        this.checkMediaStreamTrackExists();
        return this.nativeTrack;
    }

    private void checkMediaStreamTrackExists() {
        if (this.nativeTrack == 0L) {
            throw new IllegalStateException("MediaStreamTrack has been disposed.");
        }
    }

    private static native String nativeGetId(long var0);

    private static native String nativeGetKind(long var0);

    private static native boolean nativeGetEnabled(long var0);

    private static native boolean nativeSetEnabled(long var0, boolean var2);

    private static native State nativeGetState(long var0);

    public static enum MediaType {
        MEDIA_TYPE_AUDIO(0),
        MEDIA_TYPE_VIDEO(1);

        private final int nativeIndex;

        /*
         * WARNING - void declaration
         */
        private MediaType(int nativeIndex) {
            void var3_3;
            this.nativeIndex = var3_3;
        }

        @CalledByNative(value="MediaType")
        final int getNative() {
            return this.nativeIndex;
        }

        @CalledByNative(value="MediaType")
        static MediaType fromNativeIndex(int nativeIndex) {
            int n;
            for (MediaType mediaType : MediaType.values()) {
                if (mediaType.getNative() != nativeIndex) continue;
                return mediaType;
            }
            throw new IllegalArgumentException("Unknown native media type: ".concat(String.valueOf(n)));
        }
    }

    public static enum State {
        LIVE,
        ENDED;


        @CalledByNative(value="State")
        static State fromNativeIndex(int nativeIndex) {
            int n;
            return State.values()[n];
        }
    }
}

