/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.CapturerObserver;
import org.qnwebrtc.NativeAndroidVideoTrackSource;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoProcessor;

class NativeCapturerObserver
implements CapturerObserver {
    private final NativeAndroidVideoTrackSource nativeAndroidVideoTrackSource;

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    public NativeCapturerObserver(long nativeSource) {
        void var1_1;
        this.nativeAndroidVideoTrackSource = new NativeAndroidVideoTrackSource((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onCapturerStarted(boolean success) {
        void var1_1;
        this.nativeAndroidVideoTrackSource.setState((boolean)var1_1);
    }

    @Override
    public void onCapturerStoppedInCapturerThread() {
    }

    @Override
    public void onCapturerStopped() {
        this.nativeAndroidVideoTrackSource.setState(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFrameCaptured(VideoFrame frame) {
        void var1_1;
        VideoProcessor.FrameAdaptationParameters frameAdaptationParameters = this.nativeAndroidVideoTrackSource.adaptFrame(frame);
        if (frameAdaptationParameters == null) {
            return;
        }
        VideoFrame.Buffer buffer = frame.getBuffer().cropAndScale(frameAdaptationParameters.cropX, frameAdaptationParameters.cropY, frameAdaptationParameters.cropWidth, frameAdaptationParameters.cropHeight, frameAdaptationParameters.scaleWidth, frameAdaptationParameters.scaleHeight);
        this.nativeAndroidVideoTrackSource.onFrameCaptured(new VideoFrame(buffer, var1_1.getRotation(), frameAdaptationParameters.timestampNs));
        buffer.release();
    }
}

