/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.graphics.Point;
import android.opengl.Matrix;
import android.view.View;

public class RendererCommon {
    private static float BALANCED_VISIBLE_FRACTION = 0.5625f;

    /*
     * WARNING - void declaration
     */
    public static float[] getLayoutMatrix(boolean mirror, float videoAspectRatio, float displayAspectRatio) {
        boolean bl;
        float f2 = 1.0f;
        float f3 = 1.0f;
        if (displayAspectRatio > videoAspectRatio) {
            f3 = videoAspectRatio / displayAspectRatio;
        } else {
            void var1_2;
            void var2_3;
            f2 = var2_3 / var1_2;
        }
        if (bl) {
            f2 *= -1.0f;
        }
        float[] fArray = new float[16];
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)f2, (float)f3, (float)1.0f);
        RendererCommon.adjustOrigin(fArray);
        return fArray;
    }

    public static android.graphics.Matrix convertMatrixToAndroidGraphicsMatrix(float[] matrix4x4) {
        float[] fArray;
        fArray = new float[]{matrix4x4[0], matrix4x4[4], matrix4x4[12], matrix4x4[1], matrix4x4[5], matrix4x4[13], matrix4x4[3], matrix4x4[7], fArray[15]};
        android.graphics.Matrix matrix = new android.graphics.Matrix();
        matrix.setValues(fArray);
        return matrix;
    }

    public static float[] convertMatrixFromAndroidGraphicsMatrix(android.graphics.Matrix matrix) {
        android.graphics.Matrix matrix2;
        float[] fArray = new float[9];
        matrix2.getValues(fArray);
        return new float[]{fArray[0], fArray[3], 0.0f, fArray[6], fArray[1], fArray[4], 0.0f, fArray[7], 0.0f, 0.0f, 1.0f, 0.0f, fArray[2], fArray[5], 0.0f, fArray[8]};
    }

    /*
     * WARNING - void declaration
     */
    public static Point getDisplaySize(ScalingType scalingType, float videoAspectRatio, int maxDisplayWidth, int maxDisplayHeight) {
        void var3_3;
        void var2_2;
        void var1_1;
        return RendererCommon.getDisplaySize(RendererCommon.convertScalingTypeToVisibleFraction(scalingType), (float)var1_1, (int)var2_2, (int)var3_3);
    }

    private static void adjustOrigin(float[] matrix) {
        float[] fArray;
        matrix[12] = matrix[12] - 0.5f * (matrix[0] + matrix[4]);
        matrix[13] = matrix[13] - 0.5f * (matrix[1] + matrix[5]);
        matrix[12] = matrix[12] + 0.5f;
        fArray[13] = fArray[13] + 0.5f;
    }

    private static float convertScalingTypeToVisibleFraction(ScalingType scalingType) {
        ScalingType scalingType2;
        switch (scalingType2) {
            case SCALE_ASPECT_FIT: {
                return 1.0f;
            }
            case SCALE_ASPECT_FILL: {
                return 0.0f;
            }
            case SCALE_ASPECT_BALANCED: {
                return BALANCED_VISIBLE_FRACTION;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    private static Point getDisplaySize(float minVisibleFraction, float videoAspectRatio, int maxDisplayWidth, int maxDisplayHeight) {
        void var1_2;
        float f2;
        void var2_3;
        void var3_4;
        if (minVisibleFraction == 0.0f || videoAspectRatio == 0.0f) {
            return new Point(maxDisplayWidth, maxDisplayHeight);
        }
        int n = Math.min(maxDisplayWidth, Math.round((float)maxDisplayHeight / minVisibleFraction * videoAspectRatio));
        int n2 = Math.min((int)var3_4, Math.round((float)var2_3 / f2 / var1_2));
        return new Point(n, n2);
    }

    public static enum ScalingType {
        SCALE_ASPECT_FIT,
        SCALE_ASPECT_FILL,
        SCALE_ASPECT_BALANCED;

    }

    public static class VideoLayoutMeasure {
        private ScalingType scalingTypeMatchOrientation = ScalingType.SCALE_ASPECT_FILL;
        private ScalingType scalingTypeMismatchOrientation = ScalingType.SCALE_ASPECT_FILL;

        /*
         * WARNING - void declaration
         */
        public void setScalingType(ScalingType scalingType) {
            void var1_1;
            this.scalingTypeMatchOrientation = scalingType;
            this.scalingTypeMismatchOrientation = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setScalingType(ScalingType scalingTypeMatchOrientation, ScalingType scalingTypeMismatchOrientation) {
            void var2_2;
            void var1_1;
            this.scalingTypeMatchOrientation = var1_1;
            this.scalingTypeMismatchOrientation = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Point measure(int widthSpec, int heightSpec, int frameWidth, int frameHeight) {
            void var2_2;
            void var1_1;
            void var3_3;
            int n = View.getDefaultSize((int)Integer.MAX_VALUE, (int)widthSpec);
            int n2 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)heightSpec);
            if (frameWidth == 0 || frameHeight == 0 || n == 0 || n2 == 0) {
                return new Point(n, n2);
            }
            float f2 = (float)var3_3 / (float)frameHeight;
            float f3 = (float)n / (float)n2;
            Point point = RendererCommon.getDisplaySize(f2 > 1.0f == f3 > 1.0f ? this.scalingTypeMatchOrientation : this.scalingTypeMismatchOrientation, f2, n, n2);
            if (View.MeasureSpec.getMode((int)var1_1) == 0x40000000) {
                point.x = n;
            }
            if (View.MeasureSpec.getMode((int)var2_2) == 0x40000000) {
                point.y = n2;
            }
            return point;
        }
    }

    public static interface GlDrawer {
        public void drawOes(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawRgb(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawYuv(int[] var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void release();
    }

    public static interface RendererEvents {
        public void onFirstFrameRendered();

        public void onFrameResolutionChanged(int var1, int var2, int var3);
    }
}

